/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.mcMMO;
import java.io.File;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class WorldListener
implements Listener {
    private final mcMMO plugin;

    public WorldListener(mcMMO mcMMO2) {
        this.plugin = mcMMO2;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent structureGrowEvent) {
        if (WorldBlacklist.isWorldBlacklisted(structureGrowEvent.getWorld())) {
            return;
        }
        if (!mcMMO.getPlaceStore().isTrue(structureGrowEvent.getLocation().getBlock())) {
            return;
        }
        for (BlockState blockState : structureGrowEvent.getBlocks()) {
            mcMMO.getPlaceStore().setFalse(blockState);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldInit(WorldInitEvent worldInitEvent) {
        if (WorldBlacklist.isWorldBlacklisted(worldInitEvent.getWorld())) {
            return;
        }
        World world = worldInitEvent.getWorld();
        if (!new File(world.getWorldFolder(), "mcmmo_data").exists() || this.plugin == null) {
            return;
        }
        this.plugin.getLogger().info("Converting block storage for " + world.getName() + " to a new format.");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent worldUnloadEvent) {
        if (WorldBlacklist.isWorldBlacklisted(worldUnloadEvent.getWorld())) {
            return;
        }
        mcMMO.getPlaceStore().unloadWorld(worldUnloadEvent.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent chunkUnloadEvent) {
        if (WorldBlacklist.isWorldBlacklisted(chunkUnloadEvent.getWorld())) {
            return;
        }
        Chunk chunk = chunkUnloadEvent.getChunk();
        mcMMO.getPlaceStore().chunkUnloaded(chunk.getX(), chunk.getZ(), chunkUnloadEvent.getWorld());
    }
}

