/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.events.experience.McMMOPlayerLevelUpEvent;
import com.gmail.nossr50.events.experience.McMMOPlayerXpGainEvent;
import com.gmail.nossr50.events.skills.abilities.McMMOPlayerAbilityActivateEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.player.PlayerLevelUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class SelfListener
implements Listener {
    private final mcMMO plugin;

    public SelfListener(mcMMO mcMMO2) {
        this.plugin = mcMMO2;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLevelUp(McMMOPlayerLevelUpEvent mcMMOPlayerLevelUpEvent) {
        Player player = mcMMOPlayerLevelUpEvent.getPlayer();
        PrimarySkillType primarySkillType = mcMMOPlayerLevelUpEvent.getSkill();
        for (int i = 0; i < mcMMOPlayerLevelUpEvent.getLevelsGained(); ++i) {
            int n = mcMMOPlayerLevelUpEvent.getSkillLevel() - i;
            UserManager.getPlayer(player).processUnlockNotifications(this.plugin, mcMMOPlayerLevelUpEvent.getSkill(), n);
        }
        RankUtils.resetUnlockDelayTimer();
        if (Config.getInstance().getScoreboardsEnabled()) {
            ScoreboardManager.handleLevelUp(player, primarySkillType);
        }
        if (!Config.getInstance().getLevelUpEffectsEnabled()) {
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerXp(McMMOPlayerXpGainEvent mcMMOPlayerXpGainEvent) {
        if (Config.getInstance().getScoreboardsEnabled()) {
            ScoreboardManager.handleXp(mcMMOPlayerXpGainEvent.getPlayer(), mcMMOPlayerXpGainEvent.getSkill());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAbility(McMMOPlayerAbilityActivateEvent mcMMOPlayerAbilityActivateEvent) {
        if (Config.getInstance().getScoreboardsEnabled()) {
            ScoreboardManager.cooldownUpdate(mcMMOPlayerAbilityActivateEvent.getPlayer(), mcMMOPlayerAbilityActivateEvent.getSkill());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerXpGain(McMMOPlayerXpGainEvent mcMMOPlayerXpGainEvent) {
        int n;
        Player player = mcMMOPlayerXpGainEvent.getPlayer();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        PrimarySkillType primarySkillType = mcMMOPlayerXpGainEvent.getSkill();
        if (mcMMOPlayer.isDebugMode()) {
            mcMMOPlayer.getPlayer().sendMessage(mcMMOPlayerXpGainEvent.getSkill().toString() + " XP Gained");
            mcMMOPlayer.getPlayer().sendMessage("Incoming Raw XP: " + mcMMOPlayerXpGainEvent.getRawXpGained());
        }
        if ((mcMMOPlayerXpGainEvent.getXpGainReason() == XPGainReason.PVE || mcMMOPlayerXpGainEvent.getXpGainReason() == XPGainReason.PVP || mcMMOPlayerXpGainEvent.getXpGainReason() == XPGainReason.SHARED_PVE || mcMMOPlayerXpGainEvent.getXpGainReason() == XPGainReason.SHARED_PVP) && WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasXPFlag(player)) {
            mcMMOPlayerXpGainEvent.setRawXpGained(0.0f);
            mcMMOPlayerXpGainEvent.setCancelled(true);
            if (mcMMOPlayer.isDebugMode()) {
                mcMMOPlayer.getPlayer().sendMessage("No WG XP Flag - New Raw XP: " + mcMMOPlayerXpGainEvent.getRawXpGained());
            }
        }
        if (mcMMOPlayerXpGainEvent.getXpGainReason() == XPGainReason.COMMAND) {
            return;
        }
        if (ExperienceConfig.getInstance().isEarlyGameBoostEnabled()) {
            n = 0;
            if (PlayerLevelUtils.qualifiesForEarlyGameBoost(mcMMOPlayer, primarySkillType)) {
                n = (int)((double)n + (double)mcMMOPlayer.getXpToLevel(primarySkillType) * 0.05);
                mcMMOPlayerXpGainEvent.setRawXpGained(mcMMOPlayerXpGainEvent.getRawXpGained() + (float)n);
            }
        }
        if ((n = ExperienceConfig.getInstance().getDiminishedReturnsThreshold(primarySkillType)) <= 0 || !ExperienceConfig.getInstance().getDiminishedReturnsEnabled()) {
            if (mcMMOPlayer.isDebugMode()) {
                mcMMOPlayer.getPlayer().sendMessage("Final Raw XP: " + mcMMOPlayerXpGainEvent.getRawXpGained());
            }
            return;
        }
        if (mcMMOPlayerXpGainEvent.getRawXpGained() <= 0.0f) {
            return;
        }
        if (primarySkillType.isChildSkill()) {
            return;
        }
        float f = mcMMOPlayerXpGainEvent.getRawXpGained();
        float f2 = ExperienceConfig.getInstance().getDiminishedReturnsCap() * f;
        float f3 = (float)((double)n / primarySkillType.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier());
        float f4 = (mcMMOPlayer.getProfile().getRegisteredXpGain(primarySkillType) - f3) / f3;
        if (f4 > 0.0f) {
            float f5 = f - f * f4;
            if (f2 <= 0.0f || f5 > f2) {
                if (f5 > 0.0f) {
                    mcMMOPlayerXpGainEvent.setRawXpGained(f5);
                } else {
                    mcMMOPlayerXpGainEvent.setCancelled(true);
                }
            } else {
                mcMMOPlayerXpGainEvent.setRawXpGained(f2);
            }
        }
        if (mcMMOPlayer.isDebugMode()) {
            mcMMOPlayer.getPlayer().sendMessage("Final Raw XP: " + mcMMOPlayerXpGainEvent.getRawXpGained());
        }
    }
}

