/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.chat.ChatManager;
import com.gmail.nossr50.chat.ChatManagerFactory;
import com.gmail.nossr50.chat.PartyChatManager;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.chat.ChatMode;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.taming.CallOfTheWildType;
import com.gmail.nossr50.events.fake.FakePlayerAnimationEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.ShareHandler;
import com.gmail.nossr50.runnables.player.PlayerProfileLoadingTask;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.salvage.SalvageManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.ChimaeraWing;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.HardcoreManager;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.MobHealthbarUtils;
import com.gmail.nossr50.util.Motd;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final mcMMO plugin;

    public PlayerListener(mcMMO mcMMO2) {
        this.plugin = mcMMO2;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent playerTeleportEvent) {
        if (WorldBlacklist.isWorldBlacklisted(playerTeleportEvent.getPlayer().getWorld())) {
            ScoreboardManager.teardownPlayer(playerTeleportEvent.getPlayer());
            return;
        }
        if (WorldBlacklist.isWorldBlacklisted(playerTeleportEvent.getFrom().getWorld())) {
            ScoreboardManager.setupPlayer(playerTeleportEvent.getPlayer());
        }
        Player player = playerTeleportEvent.getPlayer();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player) || Config.getInstance().getXPAfterTeleportCooldown() <= 0 || playerTeleportEvent.getFrom().equals((Object)playerTeleportEvent.getTo())) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        UserManager.getPlayer(player).actualizeTeleportATS();
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDeathLowest(PlayerDeathEvent playerDeathEvent) {
        if (WorldBlacklist.isWorldBlacklisted(playerDeathEvent.getEntity().getWorld())) {
            return;
        }
        String string = playerDeathEvent.getDeathMessage();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(playerDeathEvent.getEntity())) {
            return;
        }
        if (string == null) {
            return;
        }
        Player player = playerDeathEvent.getEntity();
        playerDeathEvent.setDeathMessage(MobHealthbarUtils.fixDeathMessage(string, player));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeathMonitor(PlayerDeathEvent playerDeathEvent) {
        if (WorldBlacklist.isWorldBlacklisted(playerDeathEvent.getEntity().getWorld())) {
            return;
        }
        boolean bl = HardcoreManager.isStatLossEnabled();
        boolean bl2 = HardcoreManager.isVampirismEnabled();
        if (!bl && !bl2) {
            return;
        }
        Player player = playerDeathEvent.getEntity();
        if (!player.hasMetadata("mcMMO: Player Data") || Permissions.hardcoreBypass((Permissible)player)) {
            return;
        }
        Player player2 = player.getKiller();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (bl || player2 != null && bl2) {
            if (EventUtils.callPreDeathPenaltyEvent(player).isCancelled()) {
                return;
            }
            if (player2 != null && bl2) {
                HardcoreManager.invokeVampirism(player2, player);
            }
            if (bl) {
                HardcoreManager.invokeStatPenalty(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerWorldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        mcMMOPlayer.checkGodMode();
        mcMMOPlayer.checkParty();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent playerDropItemEvent) {
        if (WorldBlacklist.isWorldBlacklisted(playerDropItemEvent.getPlayer().getWorld())) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(playerDropItemEvent.getPlayer())) {
            return;
        }
        Item item = playerDropItemEvent.getItemDrop();
        ItemStack itemStack = item.getItemStack();
        if (ItemUtils.isSharable(itemStack)) {
            item.setMetadata("mcMMO: Tracked Item", (MetadataValue)mcMMO.metadataValue);
        }
        SkillUtils.removeAbilityBuff(itemStack);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerFishHighest(PlayerFishEvent playerFishEvent) {
        if (WorldBlacklist.isWorldBlacklisted(playerFishEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerFishEvent.getPlayer();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player) || !PrimarySkillType.FISHING.getPermissions(player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        FishingManager fishingManager = UserManager.getPlayer(player).getFishingManager();
        switch (playerFishEvent.getState()) {
            case CAUGHT_FISH: {
                Item item = (Item)playerFishEvent.getCaught();
                if (Config.getInstance().getFishingOverrideTreasures() && item.getItemStack().getType() != Material.SALMON && item.getItemStack().getType() != Material.COD && item.getItemStack().getType() != Material.TROPICAL_FISH && item.getItemStack().getType() != Material.PUFFERFISH) {
                    item.setItemStack(new ItemStack(Material.SALMON, 1));
                }
                if (Permissions.vanillaXpBoost((Permissible)player, PrimarySkillType.FISHING) && fishingManager.handleVanillaXpBoost(playerFishEvent.getExpToDrop()) > 1) {
                    playerFishEvent.setExpToDrop(fishingManager.handleVanillaXpBoost(playerFishEvent.getExpToDrop()));
                }
                return;
            }
            case IN_GROUND: {
                Block block = player.getTargetBlock(null, 100);
                if (fishingManager.canIceFish(block)) {
                    this.cancelFishingEventAndDropXp(playerFishEvent, player);
                    fishingManager.iceFishing(playerFishEvent.getHook(), block);
                }
                return;
            }
        }
    }

    private void cancelFishingEventAndDropXp(PlayerFishEvent playerFishEvent, Player player) {
        playerFishEvent.setCancelled(true);
        ExperienceOrb experienceOrb = (ExperienceOrb)player.getWorld().spawnEntity(player.getEyeLocation(), EntityType.EXPERIENCE_ORB);
        experienceOrb.setExperience(playerFishEvent.getExpToDrop());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFishMonitor(PlayerFishEvent playerFishEvent) {
        if (WorldBlacklist.isWorldBlacklisted(playerFishEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerFishEvent.getPlayer();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player) || !PrimarySkillType.FISHING.getPermissions(player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        Entity entity = playerFishEvent.getCaught();
        FishingManager fishingManager = UserManager.getPlayer(player).getFishingManager();
        if (ExperienceConfig.getInstance().isFishingExploitingPrevented()) {
            if (playerFishEvent.getHook().getMetadata("mcMMO: Fish Hook Tracker").size() == 0) {
                fishingManager.setFishHookReference(playerFishEvent.getHook());
            }
            if (playerFishEvent.getState() == PlayerFishEvent.State.CAUGHT_FISH && fishingManager.isFishingTooOften()) {
                playerFishEvent.setExpToDrop(0);
                if (entity instanceof Item) {
                    Item item = (Item)entity;
                    item.remove();
                }
                return;
            }
        }
        switch (playerFishEvent.getState()) {
            case FISHING: {
                if (fishingManager.canMasterAngler()) {
                    fishingManager.masterAngler(playerFishEvent.getHook());
                    fishingManager.setFishingTarget();
                }
                return;
            }
            case CAUGHT_FISH: {
                if (ExperienceConfig.getInstance().isFishingExploitingPrevented() && fishingManager.isExploitingFishing(playerFishEvent.getHook().getLocation().toVector())) {
                    player.sendMessage(LocaleLoader.getString("Fishing.ScarcityTip", 3));
                    playerFishEvent.setExpToDrop(0);
                    Item item = (Item)entity;
                    item.remove();
                    return;
                }
                fishingManager.handleFishing((Item)entity);
                fishingManager.setFishingTarget();
                return;
            }
            case CAUGHT_ENTITY: {
                if (fishingManager.canShake(entity)) {
                    fishingManager.shakeCheck((LivingEntity)entity);
                    fishingManager.setFishingTarget();
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupItem(EntityPickupItemEvent entityPickupItemEvent) {
        if (WorldBlacklist.isWorldBlacklisted(entityPickupItemEvent.getEntity().getWorld())) {
            return;
        }
        if (entityPickupItemEvent.getEntity() instanceof Player) {
            Player player = (Player)entityPickupItemEvent.getEntity();
            if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                return;
            }
            if (!UserManager.hasPlayerDataKey((Entity)player)) {
                return;
            }
            if (UserManager.getPlayer(player) == null) {
                return;
            }
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
            Item item = entityPickupItemEvent.getItem();
            ItemStack itemStack = item.getItemStack();
            if (item.hasMetadata("mcMMO: Tracked Arrow")) {
                item.removeMetadata("mcMMO: Tracked Arrow", (Plugin)mcMMO.p);
            }
            if (item.hasMetadata("mcMMO: Disarmed Item")) {
                if (!player.getName().equals(((MetadataValue)item.getMetadata("mcMMO: Disarmed Item").get(0)).asString())) {
                    entityPickupItemEvent.setCancelled(true);
                }
                return;
            }
            if (!item.hasMetadata("mcMMO: Tracked Item") && mcMMOPlayer.inParty() && ItemUtils.isSharable(itemStack)) {
                entityPickupItemEvent.setCancelled(ShareHandler.handleItemShare(item, mcMMOPlayer));
                if (entityPickupItemEvent.isCancelled()) {
                    SoundManager.sendSound(player, player.getLocation(), SoundType.POP);
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        mcMMOPlayer.logout(true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        new PlayerProfileLoadingTask(player).runTaskLaterAsynchronously((Plugin)mcMMO.p, 60L);
        if (Config.getInstance().getMOTDEnabled() && Permissions.motd((Permissible)player)) {
            Motd.displayAll(player);
        }
        if (this.plugin.isXPEventEnabled() && Config.getInstance().playerJoinEventInfo()) {
            player.sendMessage(LocaleLoader.getString("XPRate.Event", ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        UserManager.getPlayer(player).actualizeRespawnATS();
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractLowest(PlayerInteractEvent playerInteractEvent) {
        if (WorldBlacklist.isWorldBlacklisted(playerInteractEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (playerInteractEvent.getHand() != EquipmentSlot.HAND || !UserManager.hasPlayerDataKey((Entity)player) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        MiningManager miningManager = mcMMOPlayer.getMiningManager();
        Block block = playerInteractEvent.getClickedBlock();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        switch (playerInteractEvent.getAction()) {
            case RIGHT_CLICK_BLOCK: {
                Material material = block.getType();
                if (!Config.getInstance().getAbilitiesOnlyActivateWhenSneaking() || player.isSneaking()) {
                    if (material == Repair.anvilMaterial && PrimarySkillType.REPAIR.getPermissions(player) && mcMMO.getRepairableManager().isRepairable(itemStack) && itemStack.getAmount() <= 1) {
                        RepairManager repairManager = mcMMOPlayer.getRepairManager();
                        playerInteractEvent.setCancelled(true);
                        if (!repairManager.checkConfirmation(true)) break;
                        repairManager.handleRepair(itemStack);
                        player.updateInventory();
                        break;
                    }
                    if (material != Salvage.anvilMaterial || !PrimarySkillType.SALVAGE.getPermissions(player) || !RankUtils.hasUnlockedSubskill(player, SubSkillType.SALVAGE_SCRAP_COLLECTOR) || !mcMMO.getSalvageableManager().isSalvageable(itemStack) || itemStack.getAmount() > 1) break;
                    SalvageManager salvageManager = UserManager.getPlayer(player).getSalvageManager();
                    playerInteractEvent.setCancelled(true);
                    if (!salvageManager.checkConfirmation(true)) break;
                    SkillUtils.handleAbilitySpeedDecrease(player);
                    salvageManager.handleSalvage(block.getLocation(), itemStack);
                    player.updateInventory();
                    break;
                }
                if (!miningManager.canDetonate()) break;
                if (material == Material.TNT) {
                    playerInteractEvent.setCancelled(true);
                    break;
                }
                miningManager.remoteDetonation();
                break;
            }
            case LEFT_CLICK_BLOCK: {
                SalvageManager salvageManager;
                Material material = block.getType();
                if (Config.getInstance().getAbilitiesOnlyActivateWhenSneaking() && !player.isSneaking()) break;
                if (material == Repair.anvilMaterial && PrimarySkillType.REPAIR.getPermissions(player) && mcMMO.getRepairableManager().isRepairable(itemStack)) {
                    RepairManager repairManager = mcMMOPlayer.getRepairManager();
                    if (!repairManager.checkConfirmation(false)) break;
                    repairManager.setLastAnvilUse(0);
                    player.sendMessage(LocaleLoader.getString("Skills.Cancelled", LocaleLoader.getString("Repair.Pretty.Name")));
                    break;
                }
                if (material != Salvage.anvilMaterial || !PrimarySkillType.SALVAGE.getPermissions(player) || !mcMMO.getSalvageableManager().isSalvageable(itemStack) || !(salvageManager = mcMMOPlayer.getSalvageManager()).checkConfirmation(false)) break;
                salvageManager.setLastAnvilUse(0);
                player.sendMessage(LocaleLoader.getString("Skills.Cancelled", LocaleLoader.getString("Salvage.Pretty.Name")));
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteractMonitor(PlayerInteractEvent playerInteractEvent) {
        if (WorldBlacklist.isWorldBlacklisted(playerInteractEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (playerInteractEvent.getHand() != EquipmentSlot.HAND || !UserManager.hasPlayerDataKey((Entity)player) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (!(playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK && playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR || !ExperienceConfig.getInstance().isFishingExploitingPrevented() || itemStack.getType() != Material.FISHING_ROD && player.getInventory().getItemInOffHand().getType() != Material.FISHING_ROD)) {
            if (player.isInsideVehicle() && (player.getVehicle() instanceof Minecart || player.getVehicle() instanceof PoweredMinecart)) {
                player.getVehicle().eject();
                player.setVelocity(player.getEyeLocation().getDirection().multiply(10));
            }
            mcMMOPlayer.getFishingManager().setFishingRodCastTimestamp();
        }
        switch (playerInteractEvent.getAction()) {
            case RIGHT_CLICK_BLOCK: {
                if (player.getInventory().getItemInOffHand().getType() != Material.AIR && !player.isInsideVehicle() && !player.isSneaking()) break;
                Block block = playerInteractEvent.getClickedBlock();
                BlockState blockState = block.getState();
                if (BlockUtils.canActivateTools(blockState)) {
                    if (Config.getInstance().getAbilitiesEnabled()) {
                        if (BlockUtils.canActivateHerbalism(blockState)) {
                            mcMMOPlayer.processAbilityActivation(PrimarySkillType.HERBALISM);
                        }
                        mcMMOPlayer.processAbilityActivation(PrimarySkillType.AXES);
                        mcMMOPlayer.processAbilityActivation(PrimarySkillType.EXCAVATION);
                        mcMMOPlayer.processAbilityActivation(PrimarySkillType.MINING);
                        mcMMOPlayer.processAbilityActivation(PrimarySkillType.SWORDS);
                        mcMMOPlayer.processAbilityActivation(PrimarySkillType.UNARMED);
                        mcMMOPlayer.processAbilityActivation(PrimarySkillType.WOODCUTTING);
                    }
                    ChimaeraWing.activationCheck(player);
                }
                HerbalismManager herbalismManager = mcMMOPlayer.getHerbalismManager();
                if (itemStack.getType() == Material.BONE_MEAL) {
                    switch (blockState.getType()) {
                        case BEETROOTS: 
                        case CARROT: 
                        case COCOA: 
                        case WHEAT: 
                        case NETHER_WART_BLOCK: 
                        case POTATO: {
                            mcMMO.getPlaceStore().setFalse(blockState);
                        }
                    }
                }
                FakePlayerAnimationEvent fakePlayerAnimationEvent = new FakePlayerAnimationEvent(playerInteractEvent.getPlayer());
                if (herbalismManager.canGreenThumbBlock(blockState)) {
                    Bukkit.getPluginManager().callEvent((Event)fakePlayerAnimationEvent);
                    player.getInventory().setItemInMainHand(new ItemStack(Material.WHEAT_SEEDS, itemStack.getAmount() - 1));
                    if (!herbalismManager.processGreenThumbBlocks(blockState) || !EventUtils.simulateBlockBreak(block, player, false)) break;
                    blockState.update(true);
                    break;
                }
                if (!herbalismManager.canUseShroomThumb(blockState)) break;
                Bukkit.getPluginManager().callEvent((Event)fakePlayerAnimationEvent);
                playerInteractEvent.setCancelled(true);
                if (!herbalismManager.processShroomThumb(blockState) || !EventUtils.simulateBlockBreak(block, player, false)) break;
                blockState.update(true);
                break;
            }
            case RIGHT_CLICK_AIR: {
                if (player.getInventory().getItemInOffHand().getType() != Material.AIR && !player.isInsideVehicle() && !player.isSneaking()) break;
                if (Config.getInstance().getAbilitiesEnabled()) {
                    mcMMOPlayer.processAbilityActivation(PrimarySkillType.AXES);
                    mcMMOPlayer.processAbilityActivation(PrimarySkillType.EXCAVATION);
                    mcMMOPlayer.processAbilityActivation(PrimarySkillType.HERBALISM);
                    mcMMOPlayer.processAbilityActivation(PrimarySkillType.MINING);
                    mcMMOPlayer.processAbilityActivation(PrimarySkillType.SWORDS);
                    mcMMOPlayer.processAbilityActivation(PrimarySkillType.UNARMED);
                    mcMMOPlayer.processAbilityActivation(PrimarySkillType.WOODCUTTING);
                }
                ChimaeraWing.activationCheck(player);
                MiningManager miningManager = mcMMOPlayer.getMiningManager();
                if (!miningManager.canDetonate()) break;
                miningManager.remoteDetonation();
                break;
            }
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                if (!player.isSneaking()) break;
                Material material = itemStack.getType();
                TamingManager tamingManager = mcMMOPlayer.getTamingManager();
                if (material == Config.getInstance().getTamingCOTWMaterial(CallOfTheWildType.WOLF.getConfigEntityTypeEntry())) {
                    tamingManager.summonWolf();
                    break;
                }
                if (material == Config.getInstance().getTamingCOTWMaterial(CallOfTheWildType.CAT.getConfigEntityTypeEntry())) {
                    tamingManager.summonOcelot();
                    break;
                }
                if (material != Config.getInstance().getTamingCOTWMaterial(CallOfTheWildType.HORSE.getConfigEntityTypeEntry())) break;
                tamingManager.summonHorse();
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Player player = asyncPlayerChatEvent.getPlayer();
        if (Misc.isNPCEntityExcludingVillagers((Entity)player) || !UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer((OfflinePlayer)player);
        if (mcMMOPlayer == null) {
            mcMMO.p.debug(player.getName() + "is chatting, but is currently not logged in to the server.");
            mcMMO.p.debug("Party & Admin chat will not work properly for this player.");
            return;
        }
        ChatManager chatManager = null;
        if (mcMMOPlayer.isChatEnabled(ChatMode.PARTY)) {
            Party party = mcMMOPlayer.getParty();
            if (party == null) {
                mcMMOPlayer.disableChat(ChatMode.PARTY);
                player.sendMessage(LocaleLoader.getString("Commands.Party.None"));
                return;
            }
            chatManager = ChatManagerFactory.getChatManager((Plugin)this.plugin, ChatMode.PARTY);
            ((PartyChatManager)chatManager).setParty(party);
        } else if (mcMMOPlayer.isChatEnabled(ChatMode.ADMIN)) {
            chatManager = ChatManagerFactory.getChatManager((Plugin)this.plugin, ChatMode.ADMIN);
        }
        if (chatManager != null) {
            chatManager.handleChat(player, asyncPlayerChatEvent.getMessage(), asyncPlayerChatEvent.isAsynchronous());
            asyncPlayerChatEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        if (!Config.getInstance().getLocale().equalsIgnoreCase("en_US")) {
            String string = playerCommandPreprocessEvent.getMessage();
            String string2 = string.substring(1).split(" ")[0];
            String string3 = string2.toLowerCase();
            for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
                String string4 = primarySkillType.toString().toLowerCase();
                String string5 = primarySkillType.getName().toLowerCase();
                if (string3.equals(string5)) {
                    playerCommandPreprocessEvent.setMessage(string.replace(string2, string4));
                    break;
                }
                if (string3.equals(string4)) break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerStatisticIncrementEvent(PlayerStatisticIncrementEvent playerStatisticIncrementEvent) {
        if (WorldBlacklist.isWorldBlacklisted(playerStatisticIncrementEvent.getPlayer().getWorld())) {
            return;
        }
        if (!mcMMO.getHolidayManager().isAprilFirst()) {
            return;
        }
        mcMMO.getHolidayManager().handleStatisticEvent(playerStatisticIncrementEvent);
    }
}

