/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.events.fake.FakeBrewEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.player.PlayerUpdateInventoryTask;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.alchemy.AlchemyPotionBrewer;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Furnace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class InventoryListener
implements Listener {
    private final mcMMO plugin;

    public InventoryListener(mcMMO mcMMO2) {
        this.plugin = mcMMO2;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent inventoryOpenEvent) {
        if (WorldBlacklist.isWorldBlacklisted(inventoryOpenEvent.getPlayer().getWorld())) {
            return;
        }
        Block block = this.processInventoryOpenOrCloseEvent(inventoryOpenEvent.getInventory());
        if (block == null) {
            return;
        }
        HumanEntity humanEntity = inventoryOpenEvent.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)humanEntity)) {
            return;
        }
        if (UserManager.getPlayer((Player)humanEntity) == null) {
            return;
        }
        if (!block.hasMetadata("mcMMO: Tracked Furnace") && block.getMetadata("mcMMO: Tracked Furnace").size() == 0) {
            block.setMetadata("mcMMO: Tracked Furnace", (MetadataValue)UserManager.getPlayer((Player)humanEntity).getPlayerMetadata());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        if (WorldBlacklist.isWorldBlacklisted(inventoryCloseEvent.getPlayer().getWorld())) {
            return;
        }
        Block block = this.processInventoryOpenOrCloseEvent(inventoryCloseEvent.getInventory());
        if (block == null || block.hasMetadata("mcMMO: Tracked Furnace")) {
            return;
        }
        HumanEntity humanEntity = inventoryCloseEvent.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)humanEntity)) {
            return;
        }
        block.removeMetadata("mcMMO: Tracked Furnace", (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceBurnEvent(FurnaceBurnEvent furnaceBurnEvent) {
        ItemStack itemStack;
        if (WorldBlacklist.isWorldBlacklisted(furnaceBurnEvent.getBlock().getWorld())) {
            return;
        }
        Block block = furnaceBurnEvent.getBlock();
        BlockState blockState = block.getState();
        ItemStack itemStack2 = itemStack = blockState instanceof Furnace ? ((Furnace)blockState).getInventory().getSmelting() : null;
        if (!ItemUtils.isSmeltable(itemStack)) {
            return;
        }
        Player player = this.getPlayerFromFurnace(block);
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player) || !Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.SMELTING_FUEL_EFFICIENCY)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        furnaceBurnEvent.setBurnTime(UserManager.getPlayer(player).getSmeltingManager().fuelEfficiency(furnaceBurnEvent.getBurnTime()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceSmeltEvent(FurnaceSmeltEvent furnaceSmeltEvent) {
        if (WorldBlacklist.isWorldBlacklisted(furnaceSmeltEvent.getBlock().getWorld())) {
            return;
        }
        Block block = furnaceSmeltEvent.getBlock();
        ItemStack itemStack = furnaceSmeltEvent.getSource();
        if (!ItemUtils.isSmeltable(itemStack)) {
            return;
        }
        Player player = this.getPlayerFromFurnace(block);
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player) || !PrimarySkillType.SMELTING.getPermissions(player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        furnaceSmeltEvent.setResult(UserManager.getPlayer(player).getSmeltingManager().smeltProcessing(itemStack, furnaceSmeltEvent.getResult()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceExtractEvent(FurnaceExtractEvent furnaceExtractEvent) {
        if (WorldBlacklist.isWorldBlacklisted(furnaceExtractEvent.getPlayer().getWorld())) {
            return;
        }
        Block block = furnaceExtractEvent.getBlock();
        if (!ItemUtils.isSmelted(new ItemStack(furnaceExtractEvent.getItemType(), furnaceExtractEvent.getItemAmount()))) {
            return;
        }
        Player player = this.getPlayerFromFurnace(block);
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player) || !Permissions.vanillaXpBoost((Permissible)player, PrimarySkillType.SMELTING)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        int n = furnaceExtractEvent.getExpToDrop();
        int n2 = UserManager.getPlayer(player).getSmeltingManager().vanillaXPBoost(n);
        furnaceExtractEvent.setExpToDrop(n2);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryClickEventNormal(InventoryClickEvent inventoryClickEvent) {
        Block block;
        Player player;
        if (WorldBlacklist.isWorldBlacklisted(inventoryClickEvent.getWhoClicked().getWorld())) {
            return;
        }
        Inventory inventory = inventoryClickEvent.getInventory();
        if (inventoryClickEvent.getWhoClicked() instanceof Player) {
            player = ((Player)inventoryClickEvent.getWhoClicked()).getPlayer();
            block = this.processInventoryOpenOrCloseEvent(inventoryClickEvent.getInventory());
            if (block != null) {
                if (block.getMetadata("mcMMO: Tracked Furnace").size() > 0) {
                    block.removeMetadata("mcMMO: Tracked Furnace", (Plugin)mcMMO.p);
                }
                if (UserManager.getPlayer(player) == null) {
                    return;
                }
                block.setMetadata("mcMMO: Tracked Furnace", (MetadataValue)UserManager.getPlayer(player).getPlayerMetadata());
            }
        }
        if (!(inventory instanceof BrewerInventory)) {
            return;
        }
        player = inventory.getHolder();
        if (!(player instanceof BrewingStand)) {
            return;
        }
        block = inventoryClickEvent.getWhoClicked();
        if (!UserManager.hasPlayerDataKey((Entity)inventoryClickEvent.getWhoClicked()) || !Permissions.isSubSkillEnabled((Permissible)block, SubSkillType.ALCHEMY_CONCOCTIONS)) {
            return;
        }
        Player player2 = (Player)block;
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player2)) {
            return;
        }
        BrewingStand brewingStand = (BrewingStand)player;
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        ItemStack itemStack2 = inventoryClickEvent.getCursor();
        if (itemStack != null && (itemStack.getType() == Material.POTION || itemStack.getType() == Material.SPLASH_POTION || itemStack.getType() == Material.LINGERING_POTION) || itemStack2 != null && (itemStack2.getType() == Material.POTION || itemStack2.getType() == Material.SPLASH_POTION || itemStack2.getType() == Material.LINGERING_POTION)) {
            AlchemyPotionBrewer.scheduleCheck(player2, brewingStand);
            return;
        }
        ClickType clickType = inventoryClickEvent.getClick();
        InventoryType.SlotType slotType = inventoryClickEvent.getSlotType();
        if (clickType.isShiftClick()) {
            switch (slotType) {
                case FUEL: {
                    AlchemyPotionBrewer.scheduleCheck(player2, brewingStand);
                    return;
                }
                case CONTAINER: 
                case QUICKBAR: {
                    if (!AlchemyPotionBrewer.isValidIngredient(player2, itemStack)) {
                        return;
                    }
                    if (!AlchemyPotionBrewer.transferItems(inventoryClickEvent.getView(), inventoryClickEvent.getRawSlot(), clickType)) {
                        return;
                    }
                    inventoryClickEvent.setCancelled(true);
                    AlchemyPotionBrewer.scheduleUpdate(inventory);
                    AlchemyPotionBrewer.scheduleCheck(player2, brewingStand);
                    return;
                }
            }
            return;
        }
        if (slotType == InventoryType.SlotType.FUEL) {
            boolean bl = AlchemyPotionBrewer.isEmpty(itemStack);
            if (AlchemyPotionBrewer.isEmpty(itemStack2)) {
                if (bl && clickType == ClickType.NUMBER_KEY) {
                    AlchemyPotionBrewer.scheduleCheck(player2, brewingStand);
                    return;
                }
                AlchemyPotionBrewer.scheduleCheck(player2, brewingStand);
            } else if (bl && AlchemyPotionBrewer.isValidIngredient(player2, itemStack2)) {
                int n = itemStack2.getAmount();
                if (clickType == ClickType.LEFT || clickType == ClickType.RIGHT && n == 1) {
                    inventoryClickEvent.setCancelled(true);
                    inventoryClickEvent.setCurrentItem(itemStack2.clone());
                    inventoryClickEvent.setCursor(null);
                    AlchemyPotionBrewer.scheduleUpdate(inventory);
                    AlchemyPotionBrewer.scheduleCheck(player2, brewingStand);
                } else if (clickType == ClickType.RIGHT) {
                    inventoryClickEvent.setCancelled(true);
                    ItemStack itemStack3 = itemStack2.clone();
                    itemStack3.setAmount(1);
                    ItemStack itemStack4 = itemStack2.clone();
                    itemStack4.setAmount(n - 1);
                    inventoryClickEvent.setCurrentItem(itemStack3);
                    inventoryClickEvent.setCursor(itemStack4);
                    AlchemyPotionBrewer.scheduleUpdate(inventory);
                    AlchemyPotionBrewer.scheduleCheck(player2, brewingStand);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryDragEvent(InventoryDragEvent inventoryDragEvent) {
        if (WorldBlacklist.isWorldBlacklisted(inventoryDragEvent.getWhoClicked().getWorld())) {
            return;
        }
        Inventory inventory = inventoryDragEvent.getInventory();
        if (!(inventory instanceof BrewerInventory)) {
            return;
        }
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof BrewingStand)) {
            return;
        }
        HumanEntity humanEntity = inventoryDragEvent.getWhoClicked();
        if (!UserManager.hasPlayerDataKey((Entity)inventoryDragEvent.getWhoClicked()) || !Permissions.isSubSkillEnabled((Permissible)humanEntity, SubSkillType.ALCHEMY_CONCOCTIONS)) {
            return;
        }
        if (!inventoryDragEvent.getInventorySlots().contains(3)) {
            return;
        }
        ItemStack itemStack = inventoryDragEvent.getCursor();
        ItemStack itemStack2 = ((BrewerInventory)inventory).getIngredient();
        if (AlchemyPotionBrewer.isEmpty(itemStack2) || itemStack2.isSimilar(itemStack)) {
            Player player = (Player)humanEntity;
            if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                return;
            }
            if (AlchemyPotionBrewer.isValidIngredient(player, itemStack)) {
                AlchemyPotionBrewer.scheduleCheck(player, (BrewingStand)inventoryHolder);
                return;
            }
            inventoryDragEvent.setCancelled(true);
            AlchemyPotionBrewer.scheduleUpdate(inventory);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBrew(BrewEvent brewEvent) {
        if (WorldBlacklist.isWorldBlacklisted(brewEvent.getBlock().getWorld())) {
            return;
        }
        if (brewEvent instanceof FakeBrewEvent) {
            return;
        }
        Location location = brewEvent.getBlock().getLocation();
        if (Alchemy.brewingStandMap.containsKey(location)) {
            Alchemy.brewingStandMap.get(location).finishImmediately();
            brewEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryMoveItemEvent(InventoryMoveItemEvent inventoryMoveItemEvent) {
        if (inventoryMoveItemEvent.getSource().getLocation() != null && WorldBlacklist.isWorldBlacklisted(inventoryMoveItemEvent.getSource().getLocation().getWorld())) {
            return;
        }
        Inventory inventory = inventoryMoveItemEvent.getDestination();
        if (!(inventory instanceof BrewerInventory)) {
            return;
        }
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof BrewingStand)) {
            return;
        }
        ItemStack itemStack = inventoryMoveItemEvent.getItem();
        if (Config.getInstance().getPreventHopperTransferIngredients() && itemStack.getType() != Material.POTION && itemStack.getType() != Material.SPLASH_POTION && itemStack.getType() != Material.LINGERING_POTION) {
            inventoryMoveItemEvent.setCancelled(true);
            return;
        }
        if (Config.getInstance().getPreventHopperTransferBottles() && (itemStack.getType() == Material.POTION || itemStack.getType() == Material.SPLASH_POTION || itemStack.getType() == Material.LINGERING_POTION)) {
            inventoryMoveItemEvent.setCancelled(true);
            return;
        }
        if (Config.getInstance().getEnabledForHoppers() && AlchemyPotionBrewer.isValidIngredient(null, itemStack)) {
            AlchemyPotionBrewer.scheduleCheck(null, (BrewingStand)inventoryHolder);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClickEvent(InventoryClickEvent inventoryClickEvent) {
        SkillUtils.removeAbilityBuff(inventoryClickEvent.getCurrentItem());
        if (inventoryClickEvent.getAction() == InventoryAction.HOTBAR_SWAP) {
            SkillUtils.removeAbilityBuff(inventoryClickEvent.getWhoClicked().getInventory().getItem(inventoryClickEvent.getHotbarButton()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpenEvent(InventoryOpenEvent inventoryOpenEvent) {
        SkillUtils.removeAbilityBuff(inventoryOpenEvent.getPlayer().getInventory().getItemInMainHand());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCraftItem(CraftItemEvent craftItemEvent) {
        if (WorldBlacklist.isWorldBlacklisted(craftItemEvent.getWhoClicked().getWorld())) {
            return;
        }
        HumanEntity humanEntity = craftItemEvent.getWhoClicked();
        if (!humanEntity.hasMetadata("mcMMO: Player Data")) {
            return;
        }
        ItemStack itemStack = craftItemEvent.getRecipe().getResult();
        if (!ItemUtils.isMcMMOItem(itemStack)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        new PlayerUpdateInventoryTask((Player)humanEntity).runTaskLater((Plugin)this.plugin, 0L);
    }

    private Block processInventoryOpenOrCloseEvent(Inventory inventory) {
        if (!(inventory instanceof FurnaceInventory)) {
            return null;
        }
        Furnace furnace = (Furnace)inventory.getHolder();
        if (furnace == null) {
            return null;
        }
        return furnace.getBlock();
    }

    private Player getPlayerFromFurnace(Block block) {
        List list = block.getMetadata("mcMMO: Tracked Furnace");
        if (list.isEmpty()) {
            return null;
        }
        return this.plugin.getServer().getPlayerExact(((MetadataValue)list.get(0)).asString());
    }
}

