/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.interfaces.InteractType;
import com.gmail.nossr50.events.fake.FakeEntityDamageByEntityEvent;
import com.gmail.nossr50.events.fake.FakeEntityDamageEvent;
import com.gmail.nossr50.events.fake.FakeEntityTameEvent;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.skills.archery.Archery;
import com.gmail.nossr50.skills.mining.BlastMining;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.taming.Taming;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.unarmed.UnarmedManager;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EntityListener
implements Listener {
    private final mcMMO plugin;

    public EntityListener(mcMMO mcMMO2) {
        this.plugin = mcMMO2;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityTransform(EntityTransformEvent entityTransformEvent) {
        if (entityTransformEvent.getEntity().getMetadata("mcMMO: Spawned Entity") != null || entityTransformEvent.getEntity().getMetadata("mcMMO: Spawned Entity").size() >= 1) {
            for (Entity entity : entityTransformEvent.getTransformedEntities()) {
                entity.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityTargetEntity(EntityTargetLivingEntityEvent entityTargetLivingEntityEvent) {
        if (!ExperienceConfig.getInstance().isEndermanEndermiteFarmingPrevented()) {
            return;
        }
        if (entityTargetLivingEntityEvent.getTarget() == null) {
            return;
        }
        if (entityTargetLivingEntityEvent.getTarget() instanceof Endermite && entityTargetLivingEntityEvent.getEntity().hasMetadata("mcMMO: Spawned Entity")) {
            entityTargetLivingEntityEvent.getEntity().setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityShootBow(EntityShootBowEvent entityShootBowEvent) {
        Entity entity;
        if (WorldBlacklist.isWorldBlacklisted(entityShootBowEvent.getEntity().getWorld())) {
            return;
        }
        if (entityShootBowEvent.getEntity() instanceof Player) {
            entity = (Player)entityShootBowEvent.getEntity();
            if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag((Player)entity)) {
                return;
            }
        }
        if (!((entity = entityShootBowEvent.getProjectile()) instanceof Arrow)) {
            return;
        }
        ItemStack itemStack = entityShootBowEvent.getBow();
        if (itemStack != null && itemStack.containsEnchantment(Enchantment.ARROW_INFINITE)) {
            entity.setMetadata("mcMMO: Infinite Arrow", (MetadataValue)mcMMO.metadataValue);
        }
        entity.setMetadata("mcMMO: Bow Force", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)Math.min((double)entityShootBowEvent.getForce() * AdvancedConfig.getInstance().getForceMultiplier(), 1.0)));
        entity.setMetadata("mcMMO: Arrow Distance", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)entity.getLocation()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent projectileLaunchEvent) {
        if (WorldBlacklist.isWorldBlacklisted(projectileLaunchEvent.getEntity().getWorld())) {
            return;
        }
        if (projectileLaunchEvent.getEntity().getShooter() instanceof Player) {
            Player player = (Player)projectileLaunchEvent.getEntity().getShooter();
            if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                return;
            }
            Projectile projectile = projectileLaunchEvent.getEntity();
            if (!(projectile instanceof Arrow)) {
                return;
            }
            projectile.setMetadata("mcMMO: Bow Force", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)1.0));
            projectile.setMetadata("mcMMO: Arrow Distance", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)projectile.getLocation()));
            for (Enchantment enchantment : player.getInventory().getItemInMainHand().getEnchantments().keySet()) {
                if (!enchantment.getName().equalsIgnoreCase("piercing")) continue;
                return;
            }
            if (RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.ARCHERY_ARROW_RETRIEVAL, player)) {
                projectile.setMetadata("mcMMO: Tracked Arrow", (MetadataValue)mcMMO.metadataValue);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (WorldBlacklist.isWorldBlacklisted(entityChangeBlockEvent.getEntity().getWorld())) {
            return;
        }
        Block block = entityChangeBlockEvent.getBlock();
        if (!BlockUtils.shouldBeWatched(block.getState()) && block.getState().getType() != Material.WATER && block.getType() != Material.AIR) {
            return;
        }
        Entity entity = entityChangeBlockEvent.getEntity();
        if (entity instanceof FallingBlock || entity instanceof Enderman) {
            boolean bl = entity.hasMetadata("mcMMO: Spawned Entity");
            if (mcMMO.getPlaceStore().isTrue(block) && !bl) {
                mcMMO.getPlaceStore().setFalse(block);
                entity.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
            } else if (bl) {
                mcMMO.getPlaceStore().setTrue(block);
            }
        } else {
            if (block.getType() == Material.REDSTONE_ORE) {
                return;
            }
            if (mcMMO.getPlaceStore().isTrue(block)) {
                mcMMO.getPlaceStore().setFalse(block);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityCombustByEntityEvent(EntityCombustByEntityEvent entityCombustByEntityEvent) {
        if (entityCombustByEntityEvent.getEntity() instanceof Player) {
            Player player;
            Player player2;
            Projectile projectile;
            Player player3 = (Player)entityCombustByEntityEvent.getEntity();
            if (entityCombustByEntityEvent.getCombuster() instanceof Projectile ? (projectile = (Projectile)entityCombustByEntityEvent.getCombuster()).getShooter() instanceof Player && this.checkParties((Cancellable)entityCombustByEntityEvent, player3, player2 = (Player)projectile.getShooter()) : entityCombustByEntityEvent.getCombuster() instanceof Player && this.checkParties((Cancellable)entityCombustByEntityEvent, player3, player = (Player)entityCombustByEntityEvent.getCombuster())) {
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        AnimalTamer animalTamer;
        Projectile projectile;
        double d = entityDamageByEntityEvent.getFinalDamage();
        Entity entity = entityDamageByEntityEvent.getEntity();
        Entity entity2 = entityDamageByEntityEvent.getDamager();
        if (WorldGuardUtils.isWorldGuardLoaded() && (entity2 instanceof Player ? !WorldGuardManager.getInstance().hasMainFlag((Player)entity2) : entity2 instanceof Projectile && (projectile = (Projectile)entity2).getShooter() instanceof Player && !WorldGuardManager.getInstance().hasMainFlag((Player)projectile.getShooter()))) {
            return;
        }
        if (WorldBlacklist.isWorldBlacklisted(entityDamageByEntityEvent.getEntity().getWorld())) {
            return;
        }
        if (entityDamageByEntityEvent instanceof FakeEntityDamageByEntityEvent) {
            return;
        }
        if (entity.getMetadata("mcMMO: Custom Damage").size() > 0) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity() instanceof ArmorStand) {
            return;
        }
        if (entityDamageByEntityEvent.getDamager().hasMetadata("mcMMO: Funfetti")) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
        if (Misc.isNPCEntityExcludingVillagers(entity) || !entity.isValid() || !(entity instanceof LivingEntity)) {
            return;
        }
        projectile = (LivingEntity)entity;
        if (CombatUtils.isInvincible((LivingEntity)projectile, d)) {
            return;
        }
        if (Misc.isNPCEntityExcludingVillagers(entity2)) {
            return;
        }
        if (entity2 instanceof Tameable) {
            animalTamer = ((Tameable)entity2).getOwner();
            if (animalTamer != null && ((OfflinePlayer)animalTamer).isOnline()) {
                entity2 = (Entity)animalTamer;
            }
        } else if (entity2 instanceof TNTPrimed && entity instanceof Player && BlastMining.processBlastMiningExplosion(entityDamageByEntityEvent, (TNTPrimed)entity2, (Player)entity)) {
            return;
        }
        if (entity instanceof Player) {
            animalTamer = (Player)entity;
            if (entity2 instanceof Projectile || entity2 instanceof Player) {
                if (entity2 instanceof Projectile) {
                    Player player;
                    Projectile projectile2 = (Projectile)entity2;
                    if (((Projectile)entity2).getShooter() instanceof Player && this.checkParties((Cancellable)entityDamageByEntityEvent, (Player)animalTamer, player = (Player)projectile2.getShooter())) {
                        return;
                    }
                    UnarmedManager unarmedManager = UserManager.getPlayer((Player)animalTamer).getUnarmedManager();
                    if (unarmedManager.canDeflect() && unarmedManager.deflectCheck()) {
                        entityDamageByEntityEvent.setCancelled(true);
                        return;
                    }
                } else {
                    Player player = (Player)entity2;
                    if (this.checkParties((Cancellable)entityDamageByEntityEvent, (Player)animalTamer, player)) {
                        return;
                    }
                }
            }
        }
        if (entity2 instanceof Projectile && (animalTamer = ((Projectile)entity2).getShooter()) instanceof LivingEntity) {
            entity2 = (LivingEntity)animalTamer;
        }
        if (d <= 0.0) {
            return;
        }
        CombatUtils.processCombatAttack(entityDamageByEntityEvent, entity2, (LivingEntity)projectile);
        CombatUtils.handleHealthbars(entity2, (LivingEntity)projectile, entityDamageByEntityEvent.getFinalDamage(), this.plugin);
        if (entityDamageByEntityEvent.getFinalDamage() >= projectile.getHealth()) {
            if (entity2 instanceof LivingEntity) {
                CombatUtils.fixNames((LivingEntity)entity2);
            }
            CombatUtils.fixNames((LivingEntity)projectile);
        }
    }

    public boolean checkParties(Cancellable cancellable, Player player, Player player2) {
        if (!UserManager.hasPlayerDataKey((Entity)player) || !UserManager.hasPlayerDataKey((Entity)player2)) {
            return true;
        }
        if (player.equals(player2)) {
            return true;
        }
        if (!(Config.getInstance().getPartyFriendlyFire() || !PartyManager.inSameParty(player, player2) && !PartyManager.areAllies(player, player2) || Permissions.friendlyFire((Permissible)player2) && Permissions.friendlyFire((Permissible)player))) {
            cancellable.setCancelled(true);
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent entityDamageEvent) {
        if (WorldBlacklist.isWorldBlacklisted(entityDamageEvent.getEntity().getWorld())) {
            return;
        }
        if (entityDamageEvent.getEntity() instanceof Player) {
            Player player = (Player)entityDamageEvent.getEntity();
            if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                return;
            }
        }
        InteractionManager.processEvent((Event)entityDamageEvent, this.plugin, InteractType.ON_ENTITY_DAMAGE);
        if (entityDamageEvent instanceof FakeEntityDamageEvent) {
            return;
        }
        double d = entityDamageEvent.getFinalDamage();
        if (d <= 0.0) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (Misc.isNPCEntityExcludingVillagers(entity) || !entity.isValid() || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (CombatUtils.isInvincible(livingEntity, d)) {
            return;
        }
        EntityDamageEvent.DamageCause damageCause = entityDamageEvent.getCause();
        if (livingEntity instanceof Player) {
            Player player = (Player)entity;
            if (!UserManager.hasPlayerDataKey((Entity)player)) {
                return;
            }
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
            if (mcMMOPlayer == null) {
                return;
            }
            if (mcMMOPlayer.getGodMode()) {
                entityDamageEvent.setCancelled(true);
                return;
            }
            if (entityDamageEvent.getFinalDamage() >= 1.0) {
                mcMMOPlayer.actualizeRecentlyHurt();
            }
        } else if (livingEntity instanceof Tameable) {
            Player player;
            Tameable tameable = (Tameable)livingEntity;
            AnimalTamer animalTamer = tameable.getOwner();
            if (animalTamer instanceof Player) {
                player = (Player)animalTamer;
                if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                    return;
                }
            }
            if (Taming.canPreventDamage(tameable, animalTamer)) {
                player = (Player)animalTamer;
                Wolf wolf = (Wolf)tameable;
                if (UserManager.getPlayer(player) == null) {
                    return;
                }
                TamingManager tamingManager = UserManager.getPlayer(player).getTamingManager();
                switch (damageCause) {
                    case CONTACT: 
                    case FIRE: 
                    case LAVA: {
                        if (tamingManager.canUseEnvironmentallyAware()) {
                            tamingManager.processEnvironmentallyAware(wolf, entityDamageEvent.getDamage());
                        }
                        return;
                    }
                    case FALL: {
                        if (tamingManager.canUseEnvironmentallyAware()) {
                            entityDamageEvent.setCancelled(true);
                        }
                        return;
                    }
                    case ENTITY_ATTACK: 
                    case PROJECTILE: {
                        if (tamingManager.canUseThickFur()) {
                            entityDamageEvent.setDamage(Taming.processThickFur(wolf, entityDamageEvent.getDamage()));
                            if (entityDamageEvent.getFinalDamage() == 0.0) {
                                entityDamageEvent.setCancelled(true);
                            }
                        }
                        return;
                    }
                    case FIRE_TICK: {
                        if (tamingManager.canUseThickFur()) {
                            Taming.processThickFurFire(wolf);
                        }
                        return;
                    }
                    case MAGIC: 
                    case POISON: 
                    case WITHER: {
                        if (tamingManager.canUseHolyHound()) {
                            Taming.processHolyHound(wolf, entityDamageEvent.getDamage());
                        }
                        return;
                    }
                    case BLOCK_EXPLOSION: 
                    case ENTITY_EXPLOSION: 
                    case LIGHTNING: {
                        if (tamingManager.canUseShockProof()) {
                            entityDamageEvent.setDamage(Taming.processShockProof(wolf, entityDamageEvent.getDamage()));
                            if (entityDamageEvent.getFinalDamage() == 0.0) {
                                entityDamageEvent.setCancelled(true);
                            }
                        }
                        return;
                    }
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDeathLowest(EntityDeathEvent entityDeathEvent) {
        if (WorldBlacklist.isWorldBlacklisted(entityDeathEvent.getEntity().getWorld())) {
            return;
        }
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        if (Misc.isNPCEntityExcludingVillagers((Entity)livingEntity)) {
            return;
        }
        if (livingEntity.hasMetadata("mcMMO: Custom Name")) {
            livingEntity.setCustomName(((MetadataValue)livingEntity.getMetadata("mcMMO: Custom Name").get(0)).asString());
            livingEntity.removeMetadata("mcMMO: Custom Name", (Plugin)this.plugin);
        }
        if (livingEntity.hasMetadata("mcMMO: Name Visibility")) {
            livingEntity.setCustomNameVisible(((MetadataValue)livingEntity.getMetadata("mcMMO: Name Visibility").get(0)).asBoolean());
            livingEntity.removeMetadata("mcMMO: Name Visibility", (Plugin)this.plugin);
        }
        if (livingEntity.hasMetadata("mcMMO: Spawned Entity")) {
            livingEntity.removeMetadata("mcMMO: Spawned Entity", (Plugin)this.plugin);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
        if (WorldBlacklist.isWorldBlacklisted(entityDeathEvent.getEntity().getWorld())) {
            return;
        }
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        if (Misc.isNPCEntityExcludingVillagers((Entity)livingEntity)) {
            return;
        }
        Archery.arrowRetrievalCheck(livingEntity);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCreatureSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (WorldBlacklist.isWorldBlacklisted(creatureSpawnEvent.getEntity().getWorld())) {
            return;
        }
        LivingEntity livingEntity = creatureSpawnEvent.getEntity();
        switch (creatureSpawnEvent.getSpawnReason()) {
            case NETHER_PORTAL: 
            case SPAWNER: 
            case SPAWNER_EGG: {
                livingEntity.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
                Entity entity = livingEntity.getPassenger();
                if (entity != null) {
                    entity.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
                }
                return;
            }
            case BREEDING: {
                livingEntity.setMetadata("mcMMO: Bred Animal", (MetadataValue)mcMMO.metadataValue);
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityBreed(EntityBreedEvent entityBreedEvent) {
        if (ExperienceConfig.getInstance().isCOTWBreedingPrevented() && (entityBreedEvent.getFather().hasMetadata("mcMMO: COTW Entity") || entityBreedEvent.getMother().hasMetadata("mcMMO: COTW Entity"))) {
            entityBreedEvent.setCancelled(true);
            Animals animals = (Animals)entityBreedEvent.getMother();
            Animals animals2 = (Animals)entityBreedEvent.getFather();
            animals.setLoveModeTicks(0);
            animals2.setLoveModeTicks(0);
            if (entityBreedEvent.getBreeder() instanceof Player) {
                Player player = (Player)entityBreedEvent.getBreeder();
                NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.BreedingDisallowed", new String[0]);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent explosionPrimeEvent) {
        if (WorldBlacklist.isWorldBlacklisted(explosionPrimeEvent.getEntity().getWorld())) {
            return;
        }
        Entity entity = explosionPrimeEvent.getEntity();
        if (!(entity instanceof TNTPrimed) || !entity.hasMetadata("mcMMO: Tracked TNT")) {
            return;
        }
        Player player = this.plugin.getServer().getPlayerExact(((MetadataValue)entity.getMetadata("mcMMO: Tracked TNT").get(0)).asString());
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        MiningManager miningManager = UserManager.getPlayer(player).getMiningManager();
        if (miningManager.canUseBiggerBombs()) {
            explosionPrimeEvent.setRadius(miningManager.biggerBombs(explosionPrimeEvent.getRadius()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEnitityExplode(EntityExplodeEvent entityExplodeEvent) {
        if (WorldBlacklist.isWorldBlacklisted(entityExplodeEvent.getEntity().getWorld())) {
            return;
        }
        Entity entity = entityExplodeEvent.getEntity();
        if (!(entity instanceof TNTPrimed) || !entity.hasMetadata("mcMMO: Tracked TNT")) {
            return;
        }
        Player player = this.plugin.getServer().getPlayerExact(((MetadataValue)entity.getMetadata("mcMMO: Tracked TNT").get(0)).asString());
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        MiningManager miningManager = UserManager.getPlayer(player).getMiningManager();
        if (miningManager.canUseBlastMining()) {
            miningManager.blastMiningDropProcessing(entityExplodeEvent.getYield(), entityExplodeEvent.blockList());
            entityExplodeEvent.setYield(0.0f);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityExplodeMonitor(EntityExplodeEvent entityExplodeEvent) {
        if (WorldBlacklist.isWorldBlacklisted(entityExplodeEvent.getEntity().getWorld())) {
            return;
        }
        Entity entity = entityExplodeEvent.getEntity();
        if (!(entity instanceof TNTPrimed) || !entity.hasMetadata("mcMMO: Safe TNT")) {
            return;
        }
        entityExplodeEvent.blockList().clear();
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent foodLevelChangeEvent) {
        Material material;
        if (WorldBlacklist.isWorldBlacklisted(foodLevelChangeEvent.getEntity().getWorld())) {
            return;
        }
        HumanEntity humanEntity = foodLevelChangeEvent.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        int n = player.getFoodLevel();
        int n2 = foodLevelChangeEvent.getFoodLevel();
        int n3 = n2 - n;
        if (n3 <= 0) {
            return;
        }
        if (mcMMO.getMaterialMapStore().isFood(player.getInventory().getItemInMainHand().getType())) {
            material = player.getInventory().getItemInMainHand().getType();
        } else if (mcMMO.getMaterialMapStore().isFood(player.getInventory().getItemInOffHand().getType())) {
            material = player.getInventory().getItemInOffHand().getType();
        } else {
            return;
        }
        switch (material) {
            case BAKED_POTATO: 
            case BEETROOT: 
            case BREAD: 
            case CARROT: 
            case GOLDEN_CARROT: 
            case MUSHROOM_STEW: 
            case PUMPKIN_PIE: {
                if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.HERBALISM_FARMERS_DIET)) {
                    foodLevelChangeEvent.setFoodLevel(UserManager.getPlayer(player).getHerbalismManager().farmersDiet(n2));
                }
                return;
            }
            case COOKIE: 
            case MELON_SLICE: 
            case POISONOUS_POTATO: 
            case POTATO: {
                if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.HERBALISM_FARMERS_DIET)) {
                    foodLevelChangeEvent.setFoodLevel(UserManager.getPlayer(player).getHerbalismManager().farmersDiet(n2));
                }
                return;
            }
            case COD: 
            case SALMON: 
            case TROPICAL_FISH: 
            case COOKED_COD: 
            case COOKED_SALMON: {
                if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.FISHING_FISHERMANS_DIET)) {
                    foodLevelChangeEvent.setFoodLevel(UserManager.getPlayer(player).getFishingManager().handleFishermanDiet(n2));
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityTame(EntityTameEvent entityTameEvent) {
        if (WorldBlacklist.isWorldBlacklisted(entityTameEvent.getEntity().getWorld())) {
            return;
        }
        if (entityTameEvent instanceof FakeEntityTameEvent) {
            return;
        }
        Player player = (Player)entityTameEvent.getOwner();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        LivingEntity livingEntity = entityTameEvent.getEntity();
        if (!UserManager.hasPlayerDataKey((Entity)player) || Misc.isNPCEntityExcludingVillagers((Entity)livingEntity) || livingEntity.hasMetadata("mcMMO: Spawned Entity")) {
            return;
        }
        livingEntity.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        UserManager.getPlayer(player).getTamingManager().awardTamingXP(livingEntity);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent entityTargetEvent) {
        if (WorldBlacklist.isWorldBlacklisted(entityTargetEvent.getEntity().getWorld())) {
            return;
        }
        Entity entity = entityTargetEvent.getEntity();
        Entity entity2 = entityTargetEvent.getTarget();
        if (!(entity instanceof Tameable) || !(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        Tameable tameable = (Tameable)entity;
        if (!UserManager.hasPlayerDataKey((Entity)player) || !CombatUtils.isFriendlyPet(player, tameable)) {
            return;
        }
        if (!Permissions.friendlyFire((Permissible)player) || !Permissions.friendlyFire((Permissible)((Player)tameable.getOwner()))) {
            entityTargetEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent potionSplashEvent) {
        if (WorldBlacklist.isWorldBlacklisted(potionSplashEvent.getEntity().getWorld())) {
            return;
        }
        for (PotionEffect potionEffect : ((PotionMeta)potionSplashEvent.getPotion().getItem().getItemMeta()).getCustomEffects()) {
            if (!potionEffect.getType().equals((Object)PotionEffectType.SATURATION)) {
                return;
            }
            for (LivingEntity livingEntity : potionSplashEvent.getAffectedEntities()) {
                int n = (int)((double)potionEffect.getDuration() * potionSplashEvent.getIntensity(livingEntity));
                livingEntity.addPotionEffect(new PotionEffect(potionEffect.getType(), n, potionEffect.getAmplifier(), potionEffect.isAmbient()));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPigZapEvent(PigZapEvent pigZapEvent) {
        if (WorldBlacklist.isWorldBlacklisted(pigZapEvent.getEntity().getWorld())) {
            return;
        }
        if (pigZapEvent.getEntity().hasMetadata("mcMMO: Spawned Entity")) {
            pigZapEvent.getPigZombie().setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
        }
    }
}

