/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.meta.BonusDropMeta;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.events.fake.FakeBlockBreakEvent;
import com.gmail.nossr50.events.fake.FakeBlockDamageEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.excavation.ExcavationManager;
import com.gmail.nossr50.skills.herbalism.Herbalism;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.woodcutting.WoodcuttingManager;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Furnace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    private final mcMMO plugin;

    public BlockListener(mcMMO mcMMO2) {
        this.plugin = mcMMO2;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDropItemEvent(BlockDropItemEvent blockDropItemEvent) {
        for (Item item : blockDropItemEvent.getItems()) {
            ItemStack itemStack = new ItemStack(item.getItemStack());
            if (itemStack.getAmount() <= 0 || !Config.getInstance().getDoubleDropsEnabled(PrimarySkillType.MINING, itemStack.getType()) && !Config.getInstance().getDoubleDropsEnabled(PrimarySkillType.HERBALISM, itemStack.getType()) && !Config.getInstance().getDoubleDropsEnabled(PrimarySkillType.WOODCUTTING, itemStack.getType()) || blockDropItemEvent.getBlock().getMetadata("mcMMO: Double Drops").size() <= 0) continue;
            BonusDropMeta bonusDropMeta = (BonusDropMeta)((Object)blockDropItemEvent.getBlock().getMetadata("mcMMO: Double Drops").get(0));
            int n = bonusDropMeta.asInt();
            for (int i = 0; i < n; ++i) {
                blockDropItemEvent.getBlock().getWorld().dropItemNaturally(blockDropItemEvent.getBlockState().getLocation(), itemStack);
            }
        }
        if (blockDropItemEvent.getBlock().hasMetadata("mcMMO: Double Drops")) {
            blockDropItemEvent.getBlock().removeMetadata("mcMMO: Double Drops", (Plugin)this.plugin);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent blockPistonExtendEvent) {
        if (WorldBlacklist.isWorldBlacklisted(blockPistonExtendEvent.getBlock().getWorld())) {
            return;
        }
        if (!ExperienceConfig.getInstance().isPistonCheatingPrevented()) {
            return;
        }
        BlockFace blockFace = blockPistonExtendEvent.getDirection();
        Block block = blockPistonExtendEvent.getBlock();
        block = block.getRelative(blockFace, 2);
        for (Block block2 : blockPistonExtendEvent.getBlocks()) {
            if (!BlockUtils.shouldBeWatched(block2.getState())) continue;
            block = block2.getRelative(blockFace);
            mcMMO.getPlaceStore().setTrue(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent blockPistonRetractEvent) {
        if (WorldBlacklist.isWorldBlacklisted(blockPistonRetractEvent.getBlock().getWorld())) {
            return;
        }
        if (!ExperienceConfig.getInstance().isPistonCheatingPrevented()) {
            return;
        }
        BlockFace blockFace = blockPistonRetractEvent.getDirection();
        Block block = blockPistonRetractEvent.getBlock().getRelative(blockFace);
        mcMMO.getPlaceStore().setTrue(block);
        for (Block block2 : blockPistonRetractEvent.getBlocks()) {
            block = block2.getRelative(blockFace);
            mcMMO.getPlaceStore().setTrue(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityBlockFormEvent(EntityBlockFormEvent entityBlockFormEvent) {
        if (WorldBlacklist.isWorldBlacklisted(entityBlockFormEvent.getBlock().getWorld())) {
            return;
        }
        if (BlockUtils.shouldBeWatched(entityBlockFormEvent.getBlock().getState())) {
            mcMMO.getPlaceStore().setTrue(entityBlockFormEvent.getBlock());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFormEvent(BlockFormEvent blockFormEvent) {
        if (WorldBlacklist.isWorldBlacklisted(blockFormEvent.getBlock().getWorld())) {
            return;
        }
        if (ExperienceConfig.getInstance().preventStoneLavaFarming() && blockFormEvent.getNewState().getType() != Material.OBSIDIAN && BlockUtils.shouldBeWatched(blockFormEvent.getNewState()) && ExperienceConfig.getInstance().doesBlockGiveSkillXP(PrimarySkillType.MINING, blockFormEvent.getNewState().getBlockData())) {
            mcMMO.getPlaceStore().setTrue(blockFormEvent.getNewState());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        McMMOPlayer mcMMOPlayer;
        if (WorldBlacklist.isWorldBlacklisted(blockPlaceEvent.getBlock().getWorld())) {
            return;
        }
        Player player = blockPlaceEvent.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        BlockState blockState = blockPlaceEvent.getBlock().getState();
        if (!(!BlockUtils.shouldBeWatched(blockState) || Tag.LOGS.isTagged((Keyed)blockPlaceEvent.getBlockReplacedState().getType()) && Tag.LOGS.isTagged((Keyed)blockPlaceEvent.getBlockPlaced().getType()))) {
            mcMMO.getPlaceStore().setTrue(blockState);
        }
        if ((mcMMOPlayer = UserManager.getPlayer(player)) == null) {
            return;
        }
        if (blockState.getType() == Repair.anvilMaterial && PrimarySkillType.REPAIR.getPermissions(player)) {
            mcMMOPlayer.getRepairManager().placedAnvilCheck();
        } else if (blockState.getType() == Salvage.anvilMaterial && PrimarySkillType.SALVAGE.getPermissions(player)) {
            mcMMOPlayer.getSalvageManager().placedAnvilCheck();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockMultiPlace(BlockMultiPlaceEvent blockMultiPlaceEvent) {
        if (WorldBlacklist.isWorldBlacklisted(blockMultiPlaceEvent.getBlock().getWorld())) {
            return;
        }
        Player player = blockMultiPlaceEvent.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        for (BlockState blockState : blockMultiPlaceEvent.getReplacedBlockStates()) {
            BlockState blockState2 = blockState.getBlock().getState();
            if (!BlockUtils.shouldBeWatched(blockState2)) continue;
            mcMMO.getPlaceStore().setTrue(blockState2);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent blockGrowEvent) {
        if (WorldBlacklist.isWorldBlacklisted(blockGrowEvent.getBlock().getWorld())) {
            return;
        }
        BlockState blockState = blockGrowEvent.getBlock().getState();
        if (!BlockUtils.shouldBeWatched(blockState)) {
            return;
        }
        mcMMO.getPlaceStore().setFalse(blockState);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        Player player;
        if (WorldBlacklist.isWorldBlacklisted(blockBreakEvent.getBlock().getWorld())) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(blockBreakEvent.getPlayer())) {
            return;
        }
        if (blockBreakEvent instanceof FakeBlockBreakEvent) {
            return;
        }
        BlockState blockState = blockBreakEvent.getBlock().getState();
        Location location = blockState.getLocation();
        if (!BlockUtils.shouldBeWatched(blockState)) {
            return;
        }
        if (blockState instanceof BrewingStand && Alchemy.brewingStandMap.containsKey(location)) {
            Alchemy.brewingStandMap.get(location).cancelBrew();
        }
        if (!UserManager.hasPlayerDataKey((Entity)(player = blockBreakEvent.getPlayer())) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (BlockUtils.affectedByGreenTerra(blockState)) {
            HerbalismManager herbalismManager = mcMMOPlayer.getHerbalismManager();
            if (herbalismManager.canActivateAbility()) {
                mcMMOPlayer.checkAbilityActivation(PrimarySkillType.HERBALISM);
            }
            if (PrimarySkillType.HERBALISM.getPermissions(player)) {
                herbalismManager.processHerbalismBlockBreakEvent(blockBreakEvent);
            }
            return;
        }
        if (BlockUtils.affectedBySuperBreaker(blockState).booleanValue() && ItemUtils.isPickaxe(itemStack) && PrimarySkillType.MINING.getPermissions(player) && !mcMMO.getPlaceStore().isTrue(blockState)) {
            MiningManager miningManager = mcMMOPlayer.getMiningManager();
            miningManager.miningBlockCheck(blockState);
        } else if (BlockUtils.isLog(blockState) && ItemUtils.isAxe(itemStack) && PrimarySkillType.WOODCUTTING.getPermissions(player) && !mcMMO.getPlaceStore().isTrue(blockState)) {
            WoodcuttingManager woodcuttingManager = mcMMOPlayer.getWoodcuttingManager();
            if (woodcuttingManager.canUseTreeFeller(itemStack)) {
                woodcuttingManager.processTreeFeller(blockState);
            } else {
                woodcuttingManager.woodcuttingBlockCheck(blockState);
            }
        } else if (BlockUtils.affectedByGigaDrillBreaker(blockState) && ItemUtils.isShovel(itemStack) && PrimarySkillType.EXCAVATION.getPermissions(player) && !mcMMO.getPlaceStore().isTrue(blockState)) {
            ExcavationManager excavationManager = mcMMOPlayer.getExcavationManager();
            excavationManager.excavationBlockCheck(blockState);
            if (mcMMOPlayer.getAbilityMode(SuperAbilityType.GIGA_DRILL_BREAKER)) {
                excavationManager.gigaDrillBreaker(blockState);
            }
        }
        mcMMO.getPlaceStore().setFalse(blockState);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreakHigher(BlockBreakEvent blockBreakEvent) {
        HerbalismManager herbalismManager;
        if (WorldBlacklist.isWorldBlacklisted(blockBreakEvent.getBlock().getWorld())) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(blockBreakEvent.getPlayer())) {
            return;
        }
        if (blockBreakEvent instanceof FakeBlockBreakEvent) {
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        BlockState blockState = blockBreakEvent.getBlock().getState();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (Herbalism.isRecentlyRegrown(blockState)) {
            blockBreakEvent.setCancelled(true);
            return;
        }
        if (ItemUtils.isSword(itemStack) && (herbalismManager = UserManager.getPlayer(player).getHerbalismManager()).canUseHylianLuck()) {
            if (herbalismManager.processHylianLuck(blockState)) {
                blockState.update(true);
                blockBreakEvent.setCancelled(true);
            } else if (blockState.getType() == Material.FLOWER_POT) {
                blockState.setType(Material.AIR);
                blockState.update(true);
                blockBreakEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent blockDamageEvent) {
        Player player = blockDamageEvent.getPlayer();
        BlockState blockState = blockDamageEvent.getBlock().getState();
        if (WorldBlacklist.isWorldBlacklisted(blockDamageEvent.getBlock().getWorld())) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(blockDamageEvent.getPlayer())) {
            return;
        }
        if (blockDamageEvent instanceof FakeBlockDamageEvent) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        if (BlockUtils.canActivateAbilities(blockState)) {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (mcMMOPlayer.getToolPreparationMode(ToolType.HOE) && ItemUtils.isHoe(itemStack) && (BlockUtils.affectedByGreenTerra(blockState) || BlockUtils.canMakeMossy(blockState)) && Permissions.greenTerra((Permissible)player)) {
                mcMMOPlayer.checkAbilityActivation(PrimarySkillType.HERBALISM);
            } else if (mcMMOPlayer.getToolPreparationMode(ToolType.AXE) && ItemUtils.isAxe(itemStack) && BlockUtils.isLog(blockState) && Permissions.treeFeller((Permissible)player)) {
                mcMMOPlayer.checkAbilityActivation(PrimarySkillType.WOODCUTTING);
            } else if (mcMMOPlayer.getToolPreparationMode(ToolType.PICKAXE) && ItemUtils.isPickaxe(itemStack) && BlockUtils.affectedBySuperBreaker(blockState).booleanValue() && Permissions.superBreaker((Permissible)player)) {
                mcMMOPlayer.checkAbilityActivation(PrimarySkillType.MINING);
            } else if (mcMMOPlayer.getToolPreparationMode(ToolType.SHOVEL) && ItemUtils.isShovel(itemStack) && BlockUtils.affectedByGigaDrillBreaker(blockState) && Permissions.gigaDrillBreaker((Permissible)player)) {
                mcMMOPlayer.checkAbilityActivation(PrimarySkillType.EXCAVATION);
            } else if (mcMMOPlayer.getToolPreparationMode(ToolType.FISTS) && itemStack.getType() == Material.AIR && (BlockUtils.affectedByGigaDrillBreaker(blockState) || blockState.getType() == Material.SNOW || BlockUtils.affectedByBlockCracker(blockState) && Permissions.berserk((Permissible)player))) {
                mcMMOPlayer.checkAbilityActivation(PrimarySkillType.UNARMED);
            }
        }
        if (mcMMOPlayer.getAbilityMode(SuperAbilityType.TREE_FELLER) && BlockUtils.isLog(blockState) && Config.getInstance().getTreeFellerSoundsEnabled()) {
            SoundManager.sendSound(player, blockState.getLocation(), SoundType.FIZZ);
        }
    }

    private Player getPlayerFromFurnace(Block block) {
        List list = block.getMetadata("mcMMO: Tracked Furnace");
        if (list.isEmpty()) {
            return null;
        }
        return this.plugin.getServer().getPlayerExact(((MetadataValue)list.get(0)).asString());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDamageHigher(BlockDamageEvent blockDamageEvent) {
        if (WorldBlacklist.isWorldBlacklisted(blockDamageEvent.getBlock().getWorld())) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(blockDamageEvent.getPlayer())) {
            return;
        }
        if (blockDamageEvent instanceof FakeBlockDamageEvent) {
            return;
        }
        Player player = blockDamageEvent.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        Block block = blockDamageEvent.getBlock();
        BlockState blockState = block.getState();
        if (mcMMOPlayer.getAbilityMode(SuperAbilityType.GREEN_TERRA) && BlockUtils.canMakeMossy(blockState)) {
            if (mcMMOPlayer.getHerbalismManager().processGreenTerraBlockConversion(blockState)) {
                blockState.update(true);
            }
        } else if (mcMMOPlayer.getAbilityMode(SuperAbilityType.BERSERK) && itemStack.getType() == Material.AIR) {
            if (SuperAbilityType.BERSERK.blockCheck(block.getState()) && EventUtils.simulateBlockBreak(block, player, true)) {
                blockDamageEvent.setInstaBreak(true);
                SoundManager.sendSound(player, block.getLocation(), SoundType.POP);
            } else if (mcMMOPlayer.getUnarmedManager().canUseBlockCracker() && BlockUtils.affectedByBlockCracker(blockState) && EventUtils.simulateBlockBreak(block, player, true) && mcMMOPlayer.getUnarmedManager().blockCrackerCheck(blockState)) {
                blockState.update();
            }
        } else if (mcMMOPlayer.getWoodcuttingManager().canUseLeafBlower(itemStack) && BlockUtils.isLeaves(blockState) && EventUtils.simulateBlockBreak(block, player, true)) {
            blockDamageEvent.setInstaBreak(true);
            SoundManager.sendSound(player, block.getLocation(), SoundType.POP);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockDamageCleanup(BlockDamageEvent blockDamageEvent) {
        Player player = blockDamageEvent.getPlayer();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        BlockState blockState = blockDamageEvent.getBlock().getState();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        this.cleanupAbilityTools(player, mcMMOPlayer, blockState, itemStack);
        this.debugStickDump(player, blockState);
    }

    private void debugStickDump(Player player, BlockState blockState) {
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        if (UserManager.getPlayer(player).isDebugMode()) {
            if (mcMMO.getPlaceStore().isTrue(blockState)) {
                player.sendMessage("[mcMMO DEBUG] This block is not natural and does not reward treasures/XP");
            } else {
                player.sendMessage("[mcMMO DEBUG] This block is considered natural by mcMMO");
                UserManager.getPlayer(player).getExcavationManager().printExcavationDebug(player, blockState);
            }
            if (WorldGuardUtils.isWorldGuardLoaded()) {
                if (WorldGuardManager.getInstance().hasMainFlag(player)) {
                    player.sendMessage("[mcMMO DEBUG] World Guard main flag is permitted for this player in this region");
                } else {
                    player.sendMessage("[mcMMO DEBUG] World Guard main flag is DENIED for this player in this region");
                }
                if (WorldGuardManager.getInstance().hasXPFlag(player)) {
                    player.sendMessage("[mcMMO DEBUG] World Guard xp flag is permitted for this player in this region");
                } else {
                    player.sendMessage("[mcMMO DEBUG] World Guard xp flag is not permitted for this player in this region");
                }
            }
            if (blockState instanceof Furnace) {
                Furnace furnace = (Furnace)blockState;
                if (furnace.hasMetadata("mcMMO: Tracked Furnace")) {
                    player.sendMessage("[mcMMO DEBUG] This furnace has a registered owner");
                    Player player2 = this.getPlayerFromFurnace(furnace.getBlock());
                    if (player2 != null) {
                        player.sendMessage("[mcMMO DEBUG] This furnace is owned by player " + player2.getName());
                    }
                } else {
                    player.sendMessage("[mcMMO DEBUG] This furnace does not have a registered owner");
                }
            }
            if (ExperienceConfig.getInstance().isExperienceBarsEnabled()) {
                player.sendMessage("[mcMMO DEBUG] XP bars are enabled, however you should check per-skill settings to make sure those are enabled.");
            }
            player.sendMessage(ChatColor.RED + "You can turn this debug info off by typing " + ChatColor.GOLD + "/mmodebug");
        }
    }

    private void cleanupAbilityTools(Player player, McMMOPlayer mcMMOPlayer, BlockState blockState, ItemStack itemStack) {
        if (HiddenConfig.getInstance().useEnchantmentBuffs()) {
            if (ItemUtils.isPickaxe(itemStack) && !mcMMOPlayer.getAbilityMode(SuperAbilityType.SUPER_BREAKER) || ItemUtils.isShovel(itemStack) && !mcMMOPlayer.getAbilityMode(SuperAbilityType.GIGA_DRILL_BREAKER)) {
                SkillUtils.removeAbilityBuff(itemStack);
            }
        } else if (mcMMOPlayer.getAbilityMode(SuperAbilityType.SUPER_BREAKER) && !BlockUtils.affectedBySuperBreaker(blockState).booleanValue() || mcMMOPlayer.getAbilityMode(SuperAbilityType.GIGA_DRILL_BREAKER) && !BlockUtils.affectedByGigaDrillBreaker(blockState)) {
            SkillUtils.handleAbilitySpeedDecrease(player);
        }
    }
}

