/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills.subskills.acrobatics;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.acrobatics.AcrobaticsSubSkill;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.RandomChanceSkill;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class Roll
extends AcrobaticsSubSkill {
    public Roll() {
        super("Roll", EventPriority.HIGHEST, SubSkillType.ACROBATICS_ROLL);
    }

    @Override
    public boolean doInteraction(Event event, mcMMO mcMMO2) {
        EntityDamageEvent entityDamageEvent = (EntityDamageEvent)event;
        if (!EventUtils.isRealPlayerDamaged(entityDamageEvent)) {
            return false;
        }
        switch (entityDamageEvent.getCause()) {
            case FALL: {
                Player player;
                McMMOPlayer mcMMOPlayer = EventUtils.getMcMMOPlayer(entityDamageEvent.getEntity());
                if (mcMMOPlayer == null || !this.canRoll(player = (Player)((EntityDamageEvent)event).getEntity())) break;
                entityDamageEvent.setDamage(this.rollCheck(player, mcMMOPlayer, entityDamageEvent.getDamage()));
                if (entityDamageEvent.getFinalDamage() != 0.0) break;
                entityDamageEvent.setCancelled(true);
                return true;
            }
        }
        return false;
    }

    @Override
    public String getPermissionNode() {
        return ("mcmmo.ability." + this.getPrimaryKeyName() + "." + this.getConfigKeyName()).toLowerCase();
    }

    @Override
    public boolean hasPermission(Player player) {
        return Permissions.isSubSkillEnabled((Permissible)player, this);
    }

    @Override
    public void addStats(ComponentBuilder componentBuilder, Player player) {
        PlayerProfile playerProfile = UserManager.getPlayer(player).getProfile();
        float f = playerProfile.getSkillLevel(this.getPrimarySkill());
        boolean bl = Permissions.lucky((Permissible)player, this.getPrimarySkill());
        String[] stringArray = RandomChanceUtil.calculateAbilityDisplayValues(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.ACROBATICS_ROLL);
        String string = stringArray[0];
        String string2 = stringArray[1];
        String[] stringArray2 = RandomChanceUtil.calculateAbilityDisplayValuesCustom(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, player, SubSkillType.ACROBATICS_ROLL, 2.0);
        String string3 = stringArray2[0];
        String string4 = stringArray2[1];
        componentBuilder.append(LocaleLoader.getString("Acrobatics.SubSkill.Roll.Chance", string) + (bl ? LocaleLoader.getString("Perks.Lucky.Bonus", string2) : ""));
        componentBuilder.append("\n");
        componentBuilder.append(LocaleLoader.getString("Acrobatics.SubSkill.Roll.GraceChance", string3) + (bl ? LocaleLoader.getString("Perks.Lucky.Bonus", string4) : ""));
        componentBuilder.append("\n").append(LocaleLoader.getString("JSON.Hover.Tips")).append("\n");
        componentBuilder.append(this.getTips());
        componentBuilder.append("\n");
        if (bl) {
            componentBuilder.append(LocaleLoader.getString("JSON.JWrapper.Perks.Header"));
            componentBuilder.append("\n");
            componentBuilder.append(LocaleLoader.getString("JSON.JWrapper.Perks.Lucky", "33"));
        }
    }

    @Override
    public boolean isSuperAbility() {
        return false;
    }

    @Override
    public boolean isActiveUse() {
        return true;
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    private boolean canRoll(Player player) {
        return RankUtils.hasUnlockedSubskill(player, SubSkillType.ACROBATICS_ROLL) && Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.ACROBATICS_ROLL);
    }

    private double rollCheck(Player player, McMMOPlayer mcMMOPlayer, double d) {
        int n = mcMMOPlayer.getSkillLevel(this.getPrimarySkill());
        if (player.isSneaking()) {
            return this.gracefulRollCheck(player, mcMMOPlayer, d, n);
        }
        double d2 = Roll.calculateModifiedRollDamage(d, AdvancedConfig.getInstance().getRollDamageThreshold());
        if (!this.isFatal(player, d2) && RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.ACROBATICS_ROLL, player)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Acrobatics.Roll.Text");
            SoundManager.sendCategorizedSound(player, player.getLocation(), SoundType.ROLL_ACTIVATED, SoundCategory.PLAYERS);
            if (!this.isExploiting(player) && mcMMOPlayer.getAcrobaticsManager().canGainRollXP()) {
                SkillUtils.applyXpGain(mcMMOPlayer, this.getPrimarySkill(), this.calculateRollXP(player, d, true), XPGainReason.PVE);
            }
            this.addFallLocation(player);
            return d2;
        }
        if (!this.isFatal(player, d) && !this.isExploiting(player) && mcMMOPlayer.getAcrobaticsManager().canGainRollXP()) {
            SkillUtils.applyXpGain(mcMMOPlayer, this.getPrimarySkill(), this.calculateRollXP(player, d, false), XPGainReason.PVE);
        }
        this.addFallLocation(player);
        return d;
    }

    private int getActivationChance(McMMOPlayer mcMMOPlayer) {
        return PerksUtils.handleLuckyPerks(mcMMOPlayer.getPlayer(), this.getPrimarySkill());
    }

    private double gracefulRollCheck(Player player, McMMOPlayer mcMMOPlayer, double d, int n) {
        double d2 = Roll.calculateModifiedRollDamage(d, AdvancedConfig.getInstance().getRollDamageThreshold() * 2.0);
        RandomChanceSkill randomChanceSkill = new RandomChanceSkill(player, this.subSkillType);
        randomChanceSkill.setSkillLevel(randomChanceSkill.getSkillLevel() * 2);
        if (!this.isFatal(player, d2) && RandomChanceUtil.checkRandomChanceExecutionSuccess(randomChanceSkill)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Acrobatics.Ability.Proc");
            SoundManager.sendCategorizedSound(player, player.getLocation(), SoundType.ROLL_ACTIVATED, SoundCategory.PLAYERS, 0.5f);
            if (!this.isExploiting(player) && mcMMOPlayer.getAcrobaticsManager().canGainRollXP()) {
                SkillUtils.applyXpGain(mcMMOPlayer, this.getPrimarySkill(), this.calculateRollXP(player, d, true), XPGainReason.PVE);
            }
            this.addFallLocation(player);
            return d2;
        }
        if (!this.isFatal(player, d)) {
            if (!this.isExploiting(player) && mcMMOPlayer.getAcrobaticsManager().canGainRollXP()) {
                SkillUtils.applyXpGain(mcMMOPlayer, this.getPrimarySkill(), this.calculateRollXP(player, d, false), XPGainReason.PVE);
            }
            this.addFallLocation(player);
        }
        return d;
    }

    private boolean isExploiting(Player player) {
        if (!ExperienceConfig.getInstance().isAcrobaticsExploitingPrevented()) {
            return false;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (ItemUtils.hasItemInEitherHand(player, Material.ENDER_PEARL) || player.isInsideVehicle()) {
            if (mcMMOPlayer.isDebugMode()) {
                mcMMOPlayer.getPlayer().sendMessage("Acrobatics XP Prevented: Ender Pearl or Inside Vehicle");
            }
            return true;
        }
        if (UserManager.getPlayer(player).getAcrobaticsManager().hasFallenInLocationBefore(this.getBlockLocation(player))) {
            if (mcMMOPlayer.isDebugMode()) {
                mcMMOPlayer.getPlayer().sendMessage("Acrobatics XP Prevented: Fallen in location before");
            }
            return true;
        }
        return false;
    }

    private float calculateRollXP(Player player, double d, boolean bl) {
        d = Math.min(40.0, d);
        ItemStack itemStack = player.getInventory().getBoots();
        float f = (float)(d * (double)(bl ? ExperienceConfig.getInstance().getRollXPModifier() : ExperienceConfig.getInstance().getFallXPModifier()));
        if (itemStack != null && itemStack.containsEnchantment(Enchantment.PROTECTION_FALL)) {
            f = (float)((double)f * ExperienceConfig.getInstance().getFeatherFallXPModifier());
        }
        return f;
    }

    protected static double calculateModifiedRollDamage(double d, double d2) {
        return Math.max(d - d2, 0.0);
    }

    private boolean isFatal(Player player, double d) {
        return player.getHealth() - d <= 0.0;
    }

    @Override
    public int getNumRanks() {
        return 0;
    }

    @Override
    public void printInfo(Player player) {
        super.printInfo(player);
        player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.Stats", LocaleLoader.getString("Acrobatics.SubSkill.Roll.Stats", this.getStats(player)[0], this.getStats(player)[1])));
        player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.Mechanics"));
        player.sendMessage(this.getMechanics());
    }

    @Override
    public String getMechanics() {
        RandomChanceSkill randomChanceSkill = new RandomChanceSkill(null, this.subSkillType);
        int n = mcMMO.isRetroModeEnabled() ? 500 : 50;
        randomChanceSkill.setSkillLevel(n);
        RandomChanceSkill randomChanceSkill2 = new RandomChanceSkill(null, this.subSkillType);
        randomChanceSkill2.setSkillLevel(n * 2);
        RandomChanceSkill randomChanceSkill3 = new RandomChanceSkill(null, this.subSkillType);
        randomChanceSkill2.setSkillLevel(1);
        double d = RandomChanceUtil.getRandomChanceExecutionChance(randomChanceSkill);
        double d2 = RandomChanceUtil.getRandomChanceExecutionChance(randomChanceSkill2);
        double d3 = AdvancedConfig.getInstance().getRollDamageThreshold();
        double d4 = RandomChanceUtil.getRandomChanceExecutionChance(randomChanceSkill3);
        double d5 = AdvancedConfig.getInstance().getMaxBonusLevel(SubSkillType.ACROBATICS_ROLL);
        return LocaleLoader.getString("Acrobatics.SubSkill.Roll.Mechanics", d, d2, d5, d4, d3, d3 * 2.0);
    }

    @Override
    public Double[] getStats(Player player) {
        RandomChanceSkill randomChanceSkill = new RandomChanceSkill(player, this.getSubSkillType());
        RandomChanceSkill randomChanceSkill2 = new RandomChanceSkill(player, this.getSubSkillType());
        randomChanceSkill2.setSkillLevel(randomChanceSkill2.getSkillLevel() * 2);
        double d = RandomChanceUtil.getRandomChanceExecutionChance(randomChanceSkill);
        double d2 = RandomChanceUtil.getRandomChanceExecutionChance(randomChanceSkill2);
        Double[] doubleArray = new Double[]{d, d2};
        return doubleArray;
    }

    public void addFallLocation(Player player) {
        UserManager.getPlayer(player).getAcrobaticsManager().addLocationToFallMap(this.getBlockLocation(player));
    }

    public Location getBlockLocation(Player player) {
        return player.getLocation().getBlock().getLocation();
    }
}

