/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills.alchemy;

import com.gmail.nossr50.datatypes.skills.alchemy.AlchemyPotion;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public enum PotionStage {
    FIVE(5),
    FOUR(4),
    THREE(3),
    TWO(2),
    ONE(1);

    int numerical;

    private PotionStage(int n2) {
        this.numerical = n2;
    }

    public int toNumerical() {
        return this.numerical;
    }

    private static PotionStage getPotionStageNumerical(int n) {
        for (PotionStage potionStage : PotionStage.values()) {
            if (n < potionStage.toNumerical()) continue;
            return potionStage;
        }
        return ONE;
    }

    public static PotionStage getPotionStage(AlchemyPotion alchemyPotion, AlchemyPotion alchemyPotion2) {
        PotionStage potionStage = PotionStage.getPotionStage(alchemyPotion2);
        if (!PotionStage.isWaterBottle(alchemyPotion) && PotionStage.getPotionStage(alchemyPotion) == potionStage) {
            potionStage = FIVE;
        }
        return potionStage;
    }

    private static boolean isWaterBottle(AlchemyPotion alchemyPotion) {
        return alchemyPotion.getData().getType() == PotionType.WATER;
    }

    public static PotionStage getPotionStage(AlchemyPotion alchemyPotion) {
        PotionData potionData = alchemyPotion.getData();
        List<PotionEffect> list = alchemyPotion.getEffects();
        int n = 1;
        if (potionData.getType().getEffectType() != null || !list.isEmpty()) {
            ++n;
        }
        if (potionData.isUpgraded()) {
            ++n;
        } else if (!list.isEmpty()) {
            for (PotionEffect potionEffect : list) {
                if (potionEffect.getAmplifier() <= 0) continue;
                ++n;
                break;
            }
        }
        if (potionData.isExtended()) {
            ++n;
        }
        if (alchemyPotion.getMaterial() == Material.SPLASH_POTION || alchemyPotion.getMaterial() == Material.LINGERING_POTION) {
            ++n;
        }
        return PotionStage.getPotionStageNumerical(n);
    }
}

