/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills.alchemy;

import com.gmail.nossr50.config.skills.alchemy.PotionConfig;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;

public class AlchemyPotion {
    private Material material;
    private PotionData data;
    private String name;
    private List<String> lore;
    private List<PotionEffect> effects;
    private Color color;
    private Map<ItemStack, String> children;

    public AlchemyPotion(Material material, PotionData potionData, String string, List<String> list, List<PotionEffect> list2, Color color, Map<ItemStack, String> map) {
        this.material = material;
        this.data = potionData;
        this.lore = list;
        this.name = string;
        this.effects = list2;
        this.children = map;
        this.color = color;
    }

    public String toString() {
        return "AlchemyPotion{" + this.data + ", " + this.name + ", Effects[" + this.effects.size() + "], Children[" + this.children.size() + "]}";
    }

    public ItemStack toItemStack(int n) {
        ItemStack itemStack = new ItemStack(this.material, n);
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        potionMeta.setBasePotionData(this.data);
        if (this.getName() != null) {
            potionMeta.setDisplayName(this.getName());
        }
        if (this.getLore() != null && !this.getLore().isEmpty()) {
            potionMeta.setLore(this.getLore());
        }
        if (!this.getEffects().isEmpty()) {
            for (PotionEffect potionEffect : this.getEffects()) {
                potionMeta.addCustomEffect(potionEffect, true);
            }
        }
        if (this.getColor() != null) {
            potionMeta.setColor(this.getColor());
        }
        itemStack.setItemMeta((ItemMeta)potionMeta);
        return itemStack;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Potion toPotion(int n) {
        return Potion.fromItemStack((ItemStack)this.toItemStack(n));
    }

    public PotionData getData() {
        return this.data;
    }

    public void setData(PotionData potionData) {
        this.data = potionData;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setLore(List<String> list) {
        this.lore = list;
    }

    public List<PotionEffect> getEffects() {
        return this.effects;
    }

    public void setEffects(List<PotionEffect> list) {
        this.effects = list;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Map<ItemStack, String> getChildren() {
        return this.children;
    }

    public void setChildren(Map<ItemStack, String> map) {
        this.children = map;
    }

    public AlchemyPotion getChild(ItemStack itemStack) {
        if (!this.children.isEmpty()) {
            for (Map.Entry<ItemStack, String> entry : this.children.entrySet()) {
                if (!itemStack.isSimilar(entry.getKey())) continue;
                return PotionConfig.getInstance().getPotion(entry.getValue());
            }
        }
        return null;
    }

    public boolean isSimilar(ItemStack itemStack) {
        if (itemStack.getType() != this.material) {
            return false;
        }
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        PotionData potionData = potionMeta.getBasePotionData();
        if (this.data.getType() != potionData.getType()) {
            return false;
        }
        if (this.data.isExtended() != potionData.isExtended()) {
            return false;
        }
        if (this.data.isUpgraded() != potionData.isUpgraded()) {
            return false;
        }
        for (PotionEffect potionEffect : this.effects) {
            if (potionMeta.hasCustomEffect(potionEffect.getType())) continue;
            return false;
        }
        if (!potionMeta.hasLore() && !this.lore.isEmpty()) {
            return false;
        }
        if (!(this.lore.isEmpty() && !potionMeta.hasLore() || potionMeta.getLore().equals(this.lore))) {
            return false;
        }
        if (!potionMeta.hasDisplayName() && this.name != null) {
            return false;
        }
        return this.name == null && !potionMeta.hasDisplayName() || potionMeta.getDisplayName().equals(this.name);
    }
}

