/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public enum SuperAbilityType {
    BERSERK("Unarmed.Skills.Berserk.On", "Unarmed.Skills.Berserk.Off", "Unarmed.Skills.Berserk.Other.On", "Unarmed.Skills.Berserk.Refresh", "Unarmed.Skills.Berserk.Other.Off"),
    SUPER_BREAKER("Mining.Skills.SuperBreaker.On", "Mining.Skills.SuperBreaker.Off", "Mining.Skills.SuperBreaker.Other.On", "Mining.Skills.SuperBreaker.Refresh", "Mining.Skills.SuperBreaker.Other.Off"),
    GIGA_DRILL_BREAKER("Excavation.Skills.GigaDrillBreaker.On", "Excavation.Skills.GigaDrillBreaker.Off", "Excavation.Skills.GigaDrillBreaker.Other.On", "Excavation.Skills.GigaDrillBreaker.Refresh", "Excavation.Skills.GigaDrillBreaker.Other.Off"),
    GREEN_TERRA("Herbalism.Skills.GTe.On", "Herbalism.Skills.GTe.Off", "Herbalism.Skills.GTe.Other.On", "Herbalism.Skills.GTe.Refresh", "Herbalism.Skills.GTe.Other.Off"),
    SKULL_SPLITTER("Axes.Skills.SS.On", "Axes.Skills.SS.Off", "Axes.Skills.SS.Other.On", "Axes.Skills.SS.Refresh", "Axes.Skills.SS.Other.Off"),
    TREE_FELLER("Woodcutting.Skills.TreeFeller.On", "Woodcutting.Skills.TreeFeller.Off", "Woodcutting.Skills.TreeFeller.Other.On", "Woodcutting.Skills.TreeFeller.Refresh", "Woodcutting.Skills.TreeFeller.Other.Off"),
    SERRATED_STRIKES("Swords.Skills.SS.On", "Swords.Skills.SS.Off", "Swords.Skills.SS.Other.On", "Swords.Skills.SS.Refresh", "Swords.Skills.SS.Other.Off"),
    BLAST_MINING(null, null, "Mining.Blast.Other.On", "Mining.Blast.Refresh", null);

    private String abilityOn;
    private String abilityOff;
    private String abilityPlayer;
    private String abilityRefresh;
    private String abilityPlayerOff;
    private SubSkillType subSkillTypeDefinition;

    private SuperAbilityType(String string2, String string3, String string4, String string5, String string6) {
        this.abilityOn = string2;
        this.abilityOff = string3;
        this.abilityPlayer = string4;
        this.abilityRefresh = string5;
        this.abilityPlayerOff = string6;
    }

    public int getCooldown() {
        return Config.getInstance().getCooldown(this);
    }

    public int getMaxLength() {
        return Config.getInstance().getMaxLength(this);
    }

    public String getAbilityOn() {
        return this.abilityOn;
    }

    public String getAbilityOff() {
        return this.abilityOff;
    }

    public String getAbilityPlayer() {
        return this.abilityPlayer;
    }

    public String getAbilityPlayerOff() {
        return this.abilityPlayerOff;
    }

    public String getAbilityRefresh() {
        return this.abilityRefresh;
    }

    public String getName() {
        return StringUtils.getPrettyAbilityString(this);
    }

    public String toString() {
        String string = this.name();
        String[] stringArray = string.split("_");
        String string2 = "";
        int n = 1;
        for (String string3 : stringArray) {
            string2 = string2.concat(StringUtils.getCapitalized(string3));
            if (n < stringArray.length) {
                string2 = string2.concat("_");
            }
            ++n;
        }
        return string2;
    }

    public boolean getPermissions(Player player) {
        switch (this) {
            case BERSERK: {
                return Permissions.berserk((Permissible)player);
            }
            case BLAST_MINING: {
                return Permissions.remoteDetonation((Permissible)player);
            }
            case GIGA_DRILL_BREAKER: {
                return Permissions.gigaDrillBreaker((Permissible)player);
            }
            case GREEN_TERRA: {
                return Permissions.greenTerra((Permissible)player);
            }
            case SERRATED_STRIKES: {
                return Permissions.serratedStrikes((Permissible)player);
            }
            case SKULL_SPLITTER: {
                return Permissions.skullSplitter((Permissible)player);
            }
            case SUPER_BREAKER: {
                return Permissions.superBreaker((Permissible)player);
            }
            case TREE_FELLER: {
                return Permissions.treeFeller((Permissible)player);
            }
        }
        return false;
    }

    public boolean blockCheck(BlockState blockState) {
        switch (this) {
            case BERSERK: {
                return BlockUtils.affectedByGigaDrillBreaker(blockState) || blockState.getType() == Material.SNOW;
            }
            case GIGA_DRILL_BREAKER: {
                return BlockUtils.affectedByGigaDrillBreaker(blockState);
            }
            case GREEN_TERRA: {
                return BlockUtils.canMakeMossy(blockState);
            }
            case SUPER_BREAKER: {
                return BlockUtils.affectedBySuperBreaker(blockState);
            }
            case TREE_FELLER: {
                return BlockUtils.isLog(blockState);
            }
        }
        return false;
    }

    public SubSkillType getSubSkillTypeDefinition() {
        return this.subSkillTypeDefinition;
    }

    static {
        SuperAbilityType.BERSERK.subSkillTypeDefinition = SubSkillType.UNARMED_BERSERK;
        SuperAbilityType.SUPER_BREAKER.subSkillTypeDefinition = SubSkillType.MINING_SUPER_BREAKER;
        SuperAbilityType.GIGA_DRILL_BREAKER.subSkillTypeDefinition = SubSkillType.EXCAVATION_GIGA_DRILL_BREAKER;
        SuperAbilityType.GREEN_TERRA.subSkillTypeDefinition = SubSkillType.HERBALISM_GREEN_TERRA;
        SuperAbilityType.SKULL_SPLITTER.subSkillTypeDefinition = SubSkillType.AXES_SKULL_SPLITTER;
        SuperAbilityType.TREE_FELLER.subSkillTypeDefinition = SubSkillType.WOODCUTTING_TREE_FELLER;
        SuperAbilityType.SERRATED_STRIKES.subSkillTypeDefinition = SubSkillType.SWORDS_SERRATED_STRIKES;
        SuperAbilityType.BLAST_MINING.subSkillTypeDefinition = SubSkillType.MINING_BLAST_MINING;
    }
}

