/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills;

import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.StringUtils;

public enum SubSkillType {
    ACROBATICS_DODGE(1),
    ACROBATICS_ROLL,
    ALCHEMY_CATALYSIS(1),
    ALCHEMY_CONCOCTIONS(8),
    ARCHERY_ARROW_RETRIEVAL(1),
    ARCHERY_DAZE,
    ARCHERY_SKILL_SHOT(20),
    ARCHERY_ARCHERY_LIMIT_BREAK(10),
    AXES_ARMOR_IMPACT(20),
    AXES_AXE_MASTERY(4),
    AXES_AXES_LIMIT_BREAK(10),
    AXES_CRITICAL_STRIKES(1),
    AXES_GREATER_IMPACT(1),
    AXES_SKULL_SPLITTER(1),
    EXCAVATION_ARCHAEOLOGY(8),
    EXCAVATION_GIGA_DRILL_BREAKER(1),
    FISHING_FISHERMANS_DIET(5),
    FISHING_ICE_FISHING(1),
    FISHING_MAGIC_HUNTER(1),
    FISHING_MASTER_ANGLER(1),
    FISHING_TREASURE_HUNTER(8),
    FISHING_SHAKE(1),
    HERBALISM_DOUBLE_DROPS(1),
    HERBALISM_FARMERS_DIET(5),
    HERBALISM_GREEN_TERRA(1),
    HERBALISM_GREEN_THUMB(4),
    HERBALISM_HYLIAN_LUCK,
    HERBALISM_SHROOM_THUMB,
    MINING_BIGGER_BOMBS(1),
    MINING_BLAST_MINING(8),
    MINING_DEMOLITIONS_EXPERTISE(1),
    MINING_DOUBLE_DROPS(1),
    MINING_SUPER_BREAKER(1),
    REPAIR_ARCANE_FORGING(8),
    REPAIR_REPAIR_MASTERY(1),
    REPAIR_SUPER_REPAIR(1),
    SALVAGE_SCRAP_COLLECTOR(8),
    SALVAGE_ARCANE_SALVAGE(8),
    SMELTING_FUEL_EFFICIENCY(3),
    SMELTING_SECOND_SMELT,
    SMELTING_UNDERSTANDING_THE_ART(8),
    SWORDS_COUNTER_ATTACK(1),
    SWORDS_RUPTURE(4),
    SWORDS_SERRATED_STRIKES(1),
    SWORDS_STAB(2),
    SWORDS_SWORDS_LIMIT_BREAK(10),
    TAMING_BEAST_LORE(1),
    TAMING_CALL_OF_THE_WILD(1),
    TAMING_ENVIRONMENTALLY_AWARE(1),
    TAMING_FAST_FOOD_SERVICE(1),
    TAMING_GORE(1),
    TAMING_HOLY_HOUND(1),
    TAMING_PUMMEL(1),
    TAMING_SHARPENED_CLAWS(1),
    TAMING_SHOCK_PROOF(1),
    TAMING_THICK_FUR(1),
    UNARMED_ARROW_DEFLECT(1),
    UNARMED_BERSERK(1),
    UNARMED_BLOCK_CRACKER,
    UNARMED_DISARM(1),
    UNARMED_IRON_ARM_STYLE(5),
    UNARMED_IRON_GRIP(1),
    UNARMED_UNARMED_LIMIT_BREAK(10),
    WOODCUTTING_HARVEST_LUMBER(1),
    WOODCUTTING_LEAF_BLOWER(1),
    WOODCUTTING_TREE_FELLER(1);

    private final int numRanks;

    private SubSkillType(int n2) {
        this.numRanks = n2;
    }

    private SubSkillType() {
        this.numRanks = 0;
    }

    public int getNumRanks() {
        return this.numRanks;
    }

    public PrimarySkillType getParentSkill() {
        return PrimarySkillType.bySecondaryAbility(this);
    }

    public String getAdvConfigAddress() {
        return "Skills." + StringUtils.getCapitalized(this.getParentSkill().toString()) + "." + this.getConfigName(this.toString());
    }

    public String getRankConfigAddress() {
        return StringUtils.getCapitalized(this.getParentSkill().toString()) + "." + this.getConfigName(this.toString());
    }

    public String getPermissionNodeAddress() {
        return "mcmmo.ability." + this.getParentSkill().toString().toLowerCase() + "." + this.getConfigName(this.toString()).toLowerCase();
    }

    private String getConfigName(String string) {
        String string2 = "";
        int n = this.getSubStringIndex(string);
        String string3 = string.substring(n);
        if (string3.contains("_")) {
            String[] stringArray;
            for (String string4 : stringArray = string3.split("_")) {
                string2 = string2 + StringUtils.getCapitalized(string4);
            }
        } else {
            string2 = string2 + StringUtils.getCapitalized(string3);
        }
        return string2;
    }

    public String getWikiName(String string) {
        String string2 = "";
        int n = this.getSubStringIndex(string);
        String string3 = string.substring(n);
        if (string3.contains("_")) {
            String[] stringArray = string3.split("_");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i + 1 >= stringArray.length) {
                    string2 = string2 + StringUtils.getCapitalized(stringArray[i]);
                    continue;
                }
                string2 = string2 + StringUtils.getCapitalized(stringArray[i]);
                string2 = string2 + "_";
            }
        } else {
            string2 = string2 + StringUtils.getCapitalized(string3);
        }
        return string2;
    }

    public String getParentNiceNameLocale() {
        return LocaleLoader.getString(StringUtils.getCapitalized(this.getParentSkill().toString()) + ".SkillName");
    }

    public String getNiceNameNoSpaces(SubSkillType subSkillType) {
        return this.getConfigName(subSkillType.toString());
    }

    private int getSubStringIndex(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '_') continue;
            n = i + 1;
            break;
        }
        return n;
    }

    public String getLocaleKeyRoot() {
        return StringUtils.getCapitalized(this.getParentSkill().toString()) + ".SubSkill." + this.getConfigName(this.toString());
    }

    public String getLocaleName() {
        return this.getFromLocaleSubAddress(".Name");
    }

    public String getLocaleDescription() {
        return this.getFromLocaleSubAddress(".Description");
    }

    public String getLocaleStatDescription() {
        return this.getFromLocaleSubAddress(".Stat");
    }

    public String getLocaleKeyStatDescription() {
        return this.getLocaleKeyFromSubAddress(".Stat");
    }

    public String getLocaleStatExtraDescription() {
        return this.getFromLocaleSubAddress(".Stat.Extra");
    }

    public String getLocaleKeyStatExtraDescription() {
        return this.getLocaleKeyFromSubAddress(".Stat.Extra");
    }

    public String getLocaleStat(String ... stringArray) {
        String string = LocaleLoader.getString("Ability.Generic.Template", stringArray);
        return string;
    }

    public String getCustomLocaleStat(String ... stringArray) {
        String string = LocaleLoader.getString("Ability.Generic.Template.Custom", stringArray);
        return string;
    }

    private String getFromLocaleSubAddress(String string) {
        return LocaleLoader.getString(this.getLocaleKeyRoot() + string);
    }

    private String getLocaleKeyFromSubAddress(String string) {
        return this.getLocaleKeyRoot() + string;
    }
}

