/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.acrobatics.AcrobaticsManager;
import com.gmail.nossr50.skills.alchemy.AlchemyManager;
import com.gmail.nossr50.skills.archery.ArcheryManager;
import com.gmail.nossr50.skills.axes.AxesManager;
import com.gmail.nossr50.skills.excavation.ExcavationManager;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.salvage.SalvageManager;
import com.gmail.nossr50.skills.smelting.SmeltingManager;
import com.gmail.nossr50.skills.swords.SwordsManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.unarmed.UnarmedManager;
import com.gmail.nossr50.skills.woodcutting.WoodcuttingManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.permissions.Permissible;

public enum PrimarySkillType {
    ACROBATICS(AcrobaticsManager.class, Color.WHITE, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.ACROBATICS_DODGE), (Object)((Object)SubSkillType.ACROBATICS_ROLL))),
    ALCHEMY(AlchemyManager.class, Color.FUCHSIA, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.ALCHEMY_CATALYSIS), (Object)((Object)SubSkillType.ALCHEMY_CONCOCTIONS))),
    ARCHERY(ArcheryManager.class, Color.MAROON, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.ARCHERY_DAZE), (Object)((Object)SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK), (Object)((Object)SubSkillType.ARCHERY_ARROW_RETRIEVAL), (Object)((Object)SubSkillType.ARCHERY_SKILL_SHOT))),
    AXES(AxesManager.class, Color.AQUA, SuperAbilityType.SKULL_SPLITTER, ToolType.AXE, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.AXES_SKULL_SPLITTER), (Object)((Object)SubSkillType.AXES_AXES_LIMIT_BREAK), (Object)((Object)SubSkillType.AXES_ARMOR_IMPACT), (Object)((Object)SubSkillType.AXES_AXE_MASTERY), (Object)((Object)SubSkillType.AXES_CRITICAL_STRIKES), (Object)((Object)SubSkillType.AXES_GREATER_IMPACT))),
    EXCAVATION(ExcavationManager.class, Color.fromRGB((int)139, (int)69, (int)19), SuperAbilityType.GIGA_DRILL_BREAKER, ToolType.SHOVEL, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.EXCAVATION_GIGA_DRILL_BREAKER), (Object)((Object)SubSkillType.EXCAVATION_ARCHAEOLOGY))),
    FISHING(FishingManager.class, Color.NAVY, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.FISHING_FISHERMANS_DIET), (Object)((Object)SubSkillType.FISHING_TREASURE_HUNTER), (Object)((Object)SubSkillType.FISHING_ICE_FISHING), (Object)((Object)SubSkillType.FISHING_MAGIC_HUNTER), (Object)((Object)SubSkillType.FISHING_MASTER_ANGLER), (Object)((Object)SubSkillType.FISHING_SHAKE))),
    HERBALISM(HerbalismManager.class, Color.GREEN, SuperAbilityType.GREEN_TERRA, ToolType.HOE, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.HERBALISM_GREEN_TERRA), (Object)((Object)SubSkillType.HERBALISM_FARMERS_DIET), (Object)((Object)SubSkillType.HERBALISM_GREEN_THUMB), (Object)((Object)SubSkillType.HERBALISM_DOUBLE_DROPS), (Object)((Object)SubSkillType.HERBALISM_HYLIAN_LUCK), (Object)((Object)SubSkillType.HERBALISM_SHROOM_THUMB))),
    MINING(MiningManager.class, Color.GRAY, SuperAbilityType.SUPER_BREAKER, ToolType.PICKAXE, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.MINING_SUPER_BREAKER), (Object)((Object)SubSkillType.MINING_DEMOLITIONS_EXPERTISE), (Object)((Object)SubSkillType.MINING_BIGGER_BOMBS), (Object)((Object)SubSkillType.MINING_BLAST_MINING), (Object)((Object)SubSkillType.MINING_DOUBLE_DROPS))),
    REPAIR(RepairManager.class, Color.SILVER, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.REPAIR_ARCANE_FORGING), (Object)((Object)SubSkillType.REPAIR_REPAIR_MASTERY), (Object)((Object)SubSkillType.REPAIR_SUPER_REPAIR))),
    SALVAGE(SalvageManager.class, Color.ORANGE, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.SALVAGE_SCRAP_COLLECTOR), (Object)((Object)SubSkillType.SALVAGE_ARCANE_SALVAGE))),
    SMELTING(SmeltingManager.class, Color.YELLOW, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.SMELTING_UNDERSTANDING_THE_ART), (Object)((Object)SubSkillType.SMELTING_FUEL_EFFICIENCY), (Object)((Object)SubSkillType.SMELTING_SECOND_SMELT))),
    SWORDS(SwordsManager.class, Color.fromRGB((int)178, (int)34, (int)34), SuperAbilityType.SERRATED_STRIKES, ToolType.SWORD, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.SWORDS_SERRATED_STRIKES), (Object)((Object)SubSkillType.SWORDS_SWORDS_LIMIT_BREAK), (Object)((Object)SubSkillType.SWORDS_STAB), (Object)((Object)SubSkillType.SWORDS_RUPTURE), (Object)((Object)SubSkillType.SWORDS_COUNTER_ATTACK))),
    TAMING(TamingManager.class, Color.PURPLE, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.TAMING_BEAST_LORE), (Object)((Object)SubSkillType.TAMING_CALL_OF_THE_WILD), (Object)((Object)SubSkillType.TAMING_ENVIRONMENTALLY_AWARE), (Object)((Object)SubSkillType.TAMING_FAST_FOOD_SERVICE), (Object)((Object)SubSkillType.TAMING_GORE), (Object)((Object)SubSkillType.TAMING_HOLY_HOUND), (Object)((Object)SubSkillType.TAMING_SHARPENED_CLAWS), (Object)((Object)SubSkillType.TAMING_SHOCK_PROOF), (Object)((Object)SubSkillType.TAMING_THICK_FUR), (Object)((Object)SubSkillType.TAMING_PUMMEL))),
    UNARMED(UnarmedManager.class, Color.BLACK, SuperAbilityType.BERSERK, ToolType.FISTS, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.UNARMED_BERSERK), (Object)((Object)SubSkillType.UNARMED_UNARMED_LIMIT_BREAK), (Object)((Object)SubSkillType.UNARMED_BLOCK_CRACKER), (Object)((Object)SubSkillType.UNARMED_ARROW_DEFLECT), (Object)((Object)SubSkillType.UNARMED_DISARM), (Object)((Object)SubSkillType.UNARMED_IRON_ARM_STYLE), (Object)((Object)SubSkillType.UNARMED_IRON_GRIP))),
    WOODCUTTING(WoodcuttingManager.class, Color.OLIVE, SuperAbilityType.TREE_FELLER, ToolType.AXE, (List<SubSkillType>)ImmutableList.of((Object)((Object)SubSkillType.WOODCUTTING_LEAF_BLOWER), (Object)((Object)SubSkillType.WOODCUTTING_TREE_FELLER), (Object)((Object)SubSkillType.WOODCUTTING_HARVEST_LUMBER)));

    private Class<? extends SkillManager> managerClass;
    private Color skillColor;
    private SuperAbilityType ability;
    private ToolType tool;
    private List<SubSkillType> subSkillTypes;
    public static final List<String> SKILL_NAMES;
    public static final List<String> SUBSKILL_NAMES;
    public static final List<PrimarySkillType> CHILD_SKILLS;
    public static final List<PrimarySkillType> NON_CHILD_SKILLS;
    public static final List<PrimarySkillType> COMBAT_SKILLS;
    public static final List<PrimarySkillType> GATHERING_SKILLS;
    public static final List<PrimarySkillType> MISC_SKILLS;

    private PrimarySkillType(Class<? extends SkillManager> clazz, Color color, List<SubSkillType> list) {
        this(clazz, color, null, null, list);
    }

    private PrimarySkillType(Class<? extends SkillManager> clazz, Color color, SuperAbilityType superAbilityType, ToolType toolType, List<SubSkillType> list) {
        this.managerClass = clazz;
        this.skillColor = color;
        this.ability = superAbilityType;
        this.tool = toolType;
        this.subSkillTypes = list;
    }

    public Class<? extends SkillManager> getManagerClass() {
        return this.managerClass;
    }

    public SuperAbilityType getAbility() {
        return this.ability;
    }

    public int getMaxLevel() {
        return Config.getInstance().getLevelCap(this);
    }

    public boolean isSuperAbilityUnlocked(Player player) {
        return RankUtils.getRank(player, this.getAbility().getSubSkillTypeDefinition()) >= 1;
    }

    public boolean getPVPEnabled() {
        return Config.getInstance().getPVPEnabled(this);
    }

    public boolean getPVEEnabled() {
        return Config.getInstance().getPVEEnabled(this);
    }

    public boolean getDoubleDropsDisabled() {
        return Config.getInstance().getDoubleDropsDisabled(this);
    }

    public boolean getHardcoreStatLossEnabled() {
        return Config.getInstance().getHardcoreStatLossEnabled(this);
    }

    public void setHardcoreStatLossEnabled(boolean bl) {
        Config.getInstance().setHardcoreStatLossEnabled(this, bl);
    }

    public boolean getHardcoreVampirismEnabled() {
        return Config.getInstance().getHardcoreVampirismEnabled(this);
    }

    public void setHardcoreVampirismEnabled(boolean bl) {
        Config.getInstance().setHardcoreVampirismEnabled(this, bl);
    }

    public ToolType getTool() {
        return this.tool;
    }

    public List<SubSkillType> getSkillAbilities() {
        return this.subSkillTypes;
    }

    public double getXpModifier() {
        return ExperienceConfig.getInstance().getFormulaSkillModifier(this);
    }

    public static PrimarySkillType getSkill(String string) {
        if (!Config.getInstance().getLocale().equalsIgnoreCase("en_US")) {
            for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
                if (!string.equalsIgnoreCase(LocaleLoader.getString(StringUtils.getCapitalized(primarySkillType.name()) + ".SkillName"))) continue;
                return primarySkillType;
            }
        }
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (!primarySkillType.name().equalsIgnoreCase(string)) continue;
            return primarySkillType;
        }
        if (!string.equalsIgnoreCase("all")) {
            mcMMO.p.getLogger().warning("Invalid mcMMO skill (" + string + ")");
        }
        return null;
    }

    public boolean isChildSkill() {
        switch (this) {
            case SALVAGE: 
            case SMELTING: {
                return true;
            }
        }
        return false;
    }

    public static PrimarySkillType bySecondaryAbility(SubSkillType subSkillType) {
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (!primarySkillType.getSkillAbilities().contains((Object)subSkillType)) continue;
            return primarySkillType;
        }
        return null;
    }

    public static PrimarySkillType byAbility(SuperAbilityType superAbilityType) {
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (primarySkillType.getAbility() != superAbilityType) continue;
            return primarySkillType;
        }
        return null;
    }

    public String getName() {
        return Config.getInstance().getLocale().equalsIgnoreCase("en_US") ? StringUtils.getCapitalized(this.toString()) : StringUtils.getCapitalized(LocaleLoader.getString(StringUtils.getCapitalized(this.toString()) + ".SkillName"));
    }

    public boolean getPermissions(Player player) {
        return Permissions.skillEnabled((Permissible)player, this);
    }

    public boolean shouldProcess(Entity entity) {
        return entity instanceof Player || entity instanceof Tameable && ((Tameable)entity).isTamed() ? this.getPVPEnabled() : this.getPVEEnabled();
    }

    static {
        COMBAT_SKILLS = ImmutableList.of((Object)((Object)ARCHERY), (Object)((Object)AXES), (Object)((Object)SWORDS), (Object)((Object)TAMING), (Object)((Object)UNARMED));
        GATHERING_SKILLS = ImmutableList.of((Object)((Object)EXCAVATION), (Object)((Object)FISHING), (Object)((Object)HERBALISM), (Object)((Object)MINING), (Object)((Object)WOODCUTTING));
        MISC_SKILLS = ImmutableList.of((Object)((Object)ACROBATICS), (Object)((Object)ALCHEMY), (Object)((Object)REPAIR), (Object)((Object)SALVAGE), (Object)((Object)SMELTING));
        ArrayList<PrimarySkillType> arrayList = new ArrayList<PrimarySkillType>();
        ArrayList<PrimarySkillType> arrayList2 = new ArrayList<PrimarySkillType>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (primarySkillType.isChildSkill()) {
                arrayList.add(primarySkillType);
            } else {
                arrayList2.add(primarySkillType);
            }
            for (SubSkillType subSkillType : primarySkillType.subSkillTypes) {
                arrayList4.add(subSkillType.getNiceNameNoSpaces(subSkillType));
            }
            arrayList3.add(primarySkillType.getName());
        }
        Collections.sort(arrayList3);
        SKILL_NAMES = ImmutableList.copyOf(arrayList3);
        SUBSKILL_NAMES = ImmutableList.copyOf(arrayList4);
        CHILD_SKILLS = ImmutableList.copyOf(arrayList);
        NON_CHILD_SKILLS = ImmutableList.copyOf(arrayList2);
    }
}

