/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.player;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.experience.SkillXpGain;
import com.gmail.nossr50.datatypes.player.UniqueDataType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.player.PlayerProfileSaveTask;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.DelayQueue;
import org.bukkit.plugin.Plugin;

public class PlayerProfile {
    private final String playerName;
    private UUID uuid;
    private boolean loaded;
    private volatile boolean changed;
    private MobHealthbarType mobHealthbarType;
    private int scoreboardTipsShown;
    private int saveAttempts = 0;
    private final Map<PrimarySkillType, Integer> skills = new HashMap<PrimarySkillType, Integer>();
    private final Map<PrimarySkillType, Float> skillsXp = new HashMap<PrimarySkillType, Float>();
    private final Map<SuperAbilityType, Integer> abilityDATS = new HashMap<SuperAbilityType, Integer>();
    private final Map<UniqueDataType, Integer> uniquePlayerData = new HashMap<UniqueDataType, Integer>();
    private DelayQueue<SkillXpGain> gainedSkillsXp = new DelayQueue();
    private HashMap<PrimarySkillType, Float> rollingSkillsXp = new HashMap();

    @Deprecated
    public PlayerProfile(String string) {
        this(string, null);
    }

    public PlayerProfile(String string, UUID uUID) {
        this.uuid = uUID;
        this.playerName = string;
        this.mobHealthbarType = Config.getInstance().getMobHealthbarDefault();
        this.scoreboardTipsShown = 0;
        for (SuperAbilityType superAbilityType : SuperAbilityType.values()) {
            this.abilityDATS.put(superAbilityType, 0);
        }
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            this.skills.put(primarySkillType, AdvancedConfig.getInstance().getStartingLevel());
            this.skillsXp.put(primarySkillType, Float.valueOf(0.0f));
        }
        this.uniquePlayerData.put(UniqueDataType.CHIMAERA_WING_DATS, 0);
    }

    @Deprecated
    public PlayerProfile(String string, boolean bl) {
        this(string);
        this.loaded = bl;
    }

    public PlayerProfile(String string, UUID uUID, boolean bl) {
        this(string, uUID);
        this.loaded = bl;
    }

    public PlayerProfile(String string, UUID uUID, Map<PrimarySkillType, Integer> map, Map<PrimarySkillType, Float> map2, Map<SuperAbilityType, Integer> map3, MobHealthbarType mobHealthbarType, int n, Map<UniqueDataType, Integer> map4) {
        this.playerName = string;
        this.uuid = uUID;
        this.mobHealthbarType = mobHealthbarType;
        this.scoreboardTipsShown = n;
        this.skills.putAll(map);
        this.skillsXp.putAll(map2);
        this.abilityDATS.putAll(map3);
        this.uniquePlayerData.putAll(map4);
        this.loaded = true;
    }

    public void scheduleAsyncSave() {
        new PlayerProfileSaveTask(this, false).runTaskAsynchronously((Plugin)mcMMO.p);
    }

    public void scheduleSyncSave() {
        new PlayerProfileSaveTask(this, true).runTask((Plugin)mcMMO.p);
    }

    public void scheduleAsyncSaveDelay() {
        new PlayerProfileSaveTask(this, false).runTaskLaterAsynchronously((Plugin)mcMMO.p, 20L);
    }

    @Deprecated
    public void scheduleSyncSaveDelay() {
        new PlayerProfileSaveTask(this, true).runTaskLater((Plugin)mcMMO.p, 20L);
    }

    public void save(boolean bl) {
        if (!this.changed || !this.loaded) {
            this.saveAttempts = 0;
            return;
        }
        PlayerProfile playerProfile = new PlayerProfile(this.playerName, this.uuid, (Map<PrimarySkillType, Integer>)ImmutableMap.copyOf(this.skills), (Map<PrimarySkillType, Float>)ImmutableMap.copyOf(this.skillsXp), (Map<SuperAbilityType, Integer>)ImmutableMap.copyOf(this.abilityDATS), this.mobHealthbarType, this.scoreboardTipsShown, (Map<UniqueDataType, Integer>)ImmutableMap.copyOf(this.uniquePlayerData));
        boolean bl2 = this.changed = !mcMMO.getDatabaseManager().saveUser(playerProfile);
        if (this.changed) {
            mcMMO.p.getLogger().severe("PlayerProfile saving failed for player: " + this.playerName + " " + this.uuid);
            if (this.saveAttempts > 0) {
                mcMMO.p.getLogger().severe("Attempted to save profile for player " + this.getPlayerName() + " resulted in failure. " + this.saveAttempts + " have been made so far.");
            }
            if (this.saveAttempts < 10) {
                ++this.saveAttempts;
                if (bl) {
                    this.scheduleSyncSave();
                } else {
                    this.scheduleAsyncSaveDelay();
                }
                return;
            }
            mcMMO.p.getLogger().severe("mcMMO has failed to save the profile for " + this.getPlayerName() + " numerous times. mcMMO will now stop attempting to save this profile. Check your console for errors and inspect your DB for issues.");
        } else {
            this.saveAttempts = 0;
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public void setUniqueId(UUID uUID) {
        this.markProfileDirty();
        this.uuid = uUID;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public MobHealthbarType getMobHealthbarType() {
        return this.mobHealthbarType;
    }

    public void setMobHealthbarType(MobHealthbarType mobHealthbarType) {
        this.markProfileDirty();
        this.mobHealthbarType = mobHealthbarType;
    }

    public void markProfileDirty() {
        this.changed = true;
    }

    public int getScoreboardTipsShown() {
        return this.scoreboardTipsShown;
    }

    public void setScoreboardTipsShown(int n) {
        this.markProfileDirty();
        this.scoreboardTipsShown = n;
    }

    public void increaseTipsShown() {
        this.setScoreboardTipsShown(this.getScoreboardTipsShown() + 1);
    }

    public int getChimaerWingDATS() {
        return this.uniquePlayerData.get((Object)UniqueDataType.CHIMAERA_WING_DATS);
    }

    protected void setChimaeraWingDATS(int n) {
        this.markProfileDirty();
        this.uniquePlayerData.put(UniqueDataType.CHIMAERA_WING_DATS, n);
    }

    public void setUniqueData(UniqueDataType uniqueDataType, int n) {
        this.markProfileDirty();
        this.uniquePlayerData.put(uniqueDataType, n);
    }

    public long getUniqueData(UniqueDataType uniqueDataType) {
        return this.uniquePlayerData.get((Object)uniqueDataType).intValue();
    }

    public long getAbilityDATS(SuperAbilityType superAbilityType) {
        return this.abilityDATS.get((Object)superAbilityType).intValue();
    }

    protected void setAbilityDATS(SuperAbilityType superAbilityType, long l) {
        this.markProfileDirty();
        this.abilityDATS.put(superAbilityType, (int)((double)l * 0.001));
    }

    protected void resetCooldowns() {
        this.markProfileDirty();
        for (SuperAbilityType superAbilityType : this.abilityDATS.keySet()) {
            this.abilityDATS.put(superAbilityType, 0);
        }
    }

    public int getSkillLevel(PrimarySkillType primarySkillType) {
        return primarySkillType.isChildSkill() ? this.getChildSkillLevel(primarySkillType) : this.skills.get((Object)primarySkillType).intValue();
    }

    public float getSkillXpLevelRaw(PrimarySkillType primarySkillType) {
        return this.skillsXp.get((Object)primarySkillType).floatValue();
    }

    public int getSkillXpLevel(PrimarySkillType primarySkillType) {
        return (int)Math.floor(this.getSkillXpLevelRaw(primarySkillType));
    }

    public void setSkillXpLevel(PrimarySkillType primarySkillType, float f) {
        if (primarySkillType.isChildSkill()) {
            return;
        }
        this.markProfileDirty();
        this.skillsXp.put(primarySkillType, Float.valueOf(f));
    }

    protected float levelUp(PrimarySkillType primarySkillType) {
        float f = this.getXpToLevel(primarySkillType);
        this.markProfileDirty();
        this.skills.put(primarySkillType, this.skills.get((Object)primarySkillType) + 1);
        this.skillsXp.put(primarySkillType, Float.valueOf(this.skillsXp.get((Object)primarySkillType).floatValue() - f));
        return f;
    }

    public void removeXp(PrimarySkillType primarySkillType, int n) {
        if (primarySkillType.isChildSkill()) {
            return;
        }
        this.markProfileDirty();
        this.skillsXp.put(primarySkillType, Float.valueOf(this.skillsXp.get((Object)primarySkillType).floatValue() - (float)n));
    }

    public void removeXp(PrimarySkillType primarySkillType, float f) {
        if (primarySkillType.isChildSkill()) {
            return;
        }
        this.markProfileDirty();
        this.skillsXp.put(primarySkillType, Float.valueOf(this.skillsXp.get((Object)primarySkillType).floatValue() - f));
    }

    public void modifySkill(PrimarySkillType primarySkillType, int n) {
        if (primarySkillType.isChildSkill()) {
            return;
        }
        this.markProfileDirty();
        if (n < 0) {
            n = 0;
        }
        this.skills.put(primarySkillType, n);
        this.skillsXp.put(primarySkillType, Float.valueOf(0.0f));
    }

    public void addLevels(PrimarySkillType primarySkillType, int n) {
        this.modifySkill(primarySkillType, this.skills.get((Object)primarySkillType) + n);
    }

    public void addXp(PrimarySkillType primarySkillType, float f) {
        this.markProfileDirty();
        if (primarySkillType.isChildSkill()) {
            Set<PrimarySkillType> set = FamilyTree.getParents(primarySkillType);
            float f2 = f / (float)set.size();
            for (PrimarySkillType primarySkillType2 : set) {
                this.skillsXp.put(primarySkillType2, Float.valueOf(this.skillsXp.get((Object)primarySkillType2).floatValue() + f2));
            }
        } else {
            this.skillsXp.put(primarySkillType, Float.valueOf(this.skillsXp.get((Object)primarySkillType).floatValue() + f));
        }
    }

    public float getRegisteredXpGain(PrimarySkillType primarySkillType) {
        float f = 0.0f;
        if (this.rollingSkillsXp.get((Object)primarySkillType) != null) {
            f = this.rollingSkillsXp.get((Object)primarySkillType).floatValue();
        }
        return f;
    }

    public void registerXpGain(PrimarySkillType primarySkillType, float f) {
        this.gainedSkillsXp.add(new SkillXpGain(primarySkillType, f));
        this.rollingSkillsXp.put(primarySkillType, Float.valueOf(this.getRegisteredXpGain(primarySkillType) + f));
    }

    public void purgeExpiredXpGains() {
        SkillXpGain skillXpGain;
        while ((skillXpGain = (SkillXpGain)this.gainedSkillsXp.poll()) != null) {
            this.rollingSkillsXp.put(skillXpGain.getSkill(), Float.valueOf(this.getRegisteredXpGain(skillXpGain.getSkill()) - skillXpGain.getXp()));
        }
    }

    public int getXpToLevel(PrimarySkillType primarySkillType) {
        int n = ExperienceConfig.getInstance().getCumulativeCurveEnabled() ? UserManager.getPlayer(this.playerName).getPowerLevel() : this.skills.get((Object)primarySkillType).intValue();
        FormulaType formulaType = ExperienceConfig.getInstance().getFormulaType();
        return mcMMO.getFormulaManager().getXPtoNextLevel(n, formulaType);
    }

    private int getChildSkillLevel(PrimarySkillType primarySkillType) {
        Set<PrimarySkillType> set = FamilyTree.getParents(primarySkillType);
        int n = 0;
        for (PrimarySkillType primarySkillType2 : set) {
            n += Math.min(this.getSkillLevel(primarySkillType2), primarySkillType2.getMaxLevel());
        }
        return n / set.size();
    }
}

