/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.player;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.chat.ChatMode;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.mods.CustomTool;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyTeleportRecord;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.party.ShareHandler;
import com.gmail.nossr50.runnables.skills.AbilityDisableTask;
import com.gmail.nossr50.runnables.skills.BleedTimerTask;
import com.gmail.nossr50.runnables.skills.ToolLowerTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.acrobatics.AcrobaticsManager;
import com.gmail.nossr50.skills.alchemy.AlchemyManager;
import com.gmail.nossr50.skills.archery.ArcheryManager;
import com.gmail.nossr50.skills.axes.AxesManager;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.skills.excavation.ExcavationManager;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.salvage.SalvageManager;
import com.gmail.nossr50.skills.smelting.SmeltingManager;
import com.gmail.nossr50.skills.swords.SwordsManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.unarmed.UnarmedManager;
import com.gmail.nossr50.skills.woodcutting.WoodcuttingManager;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.experience.ExperienceBarManager;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class McMMOPlayer {
    private Player player;
    private PlayerProfile profile;
    private final Map<PrimarySkillType, SkillManager> skillManagers = new HashMap<PrimarySkillType, SkillManager>();
    private ExperienceBarManager experienceBarManager;
    private Party party;
    private Party invite;
    private Party allianceInvite;
    private int itemShareModifier;
    private PartyTeleportRecord ptpRecord;
    private boolean partyChatMode;
    private boolean adminChatMode;
    private boolean displaySkillNotifications = true;
    private boolean debugMode;
    private boolean abilityUse = true;
    private boolean godMode;
    private boolean chatSpy = false;
    private final Map<SuperAbilityType, Boolean> abilityMode = new HashMap<SuperAbilityType, Boolean>();
    private final Map<SuperAbilityType, Boolean> abilityInformed = new HashMap<SuperAbilityType, Boolean>();
    private final Map<ToolType, Boolean> toolMode = new HashMap<ToolType, Boolean>();
    private int recentlyHurt;
    private int respawnATS;
    private int teleportATS;
    private long databaseATS;
    private Location teleportCommence;
    private boolean isUsingUnarmed;
    private final FixedMetadataValue playerMetadata;
    private String playerName;

    public McMMOPlayer(Player player, PlayerProfile playerProfile) {
        this.playerName = player.getName();
        UUID uUID = player.getUniqueId();
        this.player = player;
        this.playerMetadata = new FixedMetadataValue((Plugin)mcMMO.p, (Object)this.playerName);
        this.profile = playerProfile;
        if (playerProfile.getUniqueId() == null) {
            playerProfile.setUniqueId(uUID);
        }
        try {
            for (Enum enum_ : PrimarySkillType.values()) {
                this.skillManagers.put((PrimarySkillType)enum_, ((PrimarySkillType)enum_).getManagerClass().getConstructor(McMMOPlayer.class).newInstance(this));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            mcMMO.p.getPluginLoader().disablePlugin((Plugin)mcMMO.p);
        }
        for (Enum enum_ : SuperAbilityType.values()) {
            this.abilityMode.put((SuperAbilityType)enum_, false);
            this.abilityInformed.put((SuperAbilityType)enum_, true);
        }
        for (Enum enum_ : ToolType.values()) {
            this.toolMode.put((ToolType)enum_, false);
        }
        this.experienceBarManager = new ExperienceBarManager(this);
        this.debugMode = false;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void processPostXpEvent(PrimarySkillType primarySkillType, Plugin plugin, XPGainSource xPGainSource) {
        if (this.hasReachedPowerLevelCap()) {
            NotificationManager.sendPlayerInformationChatOnly(this.player, "LevelCap.PowerLevel", String.valueOf(Config.getInstance().getPowerLevelCap()));
        } else if (this.hasReachedLevelCap(primarySkillType)) {
            NotificationManager.sendPlayerInformationChatOnly(this.player, "LevelCap.Skill", String.valueOf(Config.getInstance().getLevelCap(primarySkillType)), primarySkillType.getName());
        }
        if (xPGainSource == XPGainSource.PARTY_MEMBERS && !ExperienceConfig.getInstance().isPartyExperienceBarsEnabled()) {
            return;
        }
        if (xPGainSource == XPGainSource.PASSIVE && !ExperienceConfig.getInstance().isPassiveGainsExperienceBarsEnabled()) {
            return;
        }
        this.updateXPBar(primarySkillType, plugin);
    }

    public void processUnlockNotifications(mcMMO mcMMO2, PrimarySkillType primarySkillType, int n) {
        RankUtils.executeSkillUnlockNotifications((Plugin)mcMMO2, this, primarySkillType, n);
    }

    public void updateXPBar(PrimarySkillType primarySkillType, Plugin plugin) {
        if (primarySkillType.isChildSkill()) {
            return;
        }
        this.experienceBarManager.updateExperienceBar(primarySkillType, plugin);
    }

    public double getProgressInCurrentSkillLevel(PrimarySkillType primarySkillType) {
        double d = this.profile.getSkillXpLevel(primarySkillType);
        double d2 = this.profile.getXpToLevel(primarySkillType);
        return d / d2;
    }

    public AcrobaticsManager getAcrobaticsManager() {
        return (AcrobaticsManager)this.skillManagers.get((Object)PrimarySkillType.ACROBATICS);
    }

    public AlchemyManager getAlchemyManager() {
        return (AlchemyManager)this.skillManagers.get((Object)PrimarySkillType.ALCHEMY);
    }

    public ArcheryManager getArcheryManager() {
        return (ArcheryManager)this.skillManagers.get((Object)PrimarySkillType.ARCHERY);
    }

    public AxesManager getAxesManager() {
        return (AxesManager)this.skillManagers.get((Object)PrimarySkillType.AXES);
    }

    public ExcavationManager getExcavationManager() {
        return (ExcavationManager)this.skillManagers.get((Object)PrimarySkillType.EXCAVATION);
    }

    public FishingManager getFishingManager() {
        return (FishingManager)this.skillManagers.get((Object)PrimarySkillType.FISHING);
    }

    public HerbalismManager getHerbalismManager() {
        return (HerbalismManager)this.skillManagers.get((Object)PrimarySkillType.HERBALISM);
    }

    public MiningManager getMiningManager() {
        return (MiningManager)this.skillManagers.get((Object)PrimarySkillType.MINING);
    }

    public RepairManager getRepairManager() {
        return (RepairManager)this.skillManagers.get((Object)PrimarySkillType.REPAIR);
    }

    public SalvageManager getSalvageManager() {
        return (SalvageManager)this.skillManagers.get((Object)PrimarySkillType.SALVAGE);
    }

    public SmeltingManager getSmeltingManager() {
        return (SmeltingManager)this.skillManagers.get((Object)PrimarySkillType.SMELTING);
    }

    public SwordsManager getSwordsManager() {
        return (SwordsManager)this.skillManagers.get((Object)PrimarySkillType.SWORDS);
    }

    public TamingManager getTamingManager() {
        return (TamingManager)this.skillManagers.get((Object)PrimarySkillType.TAMING);
    }

    public UnarmedManager getUnarmedManager() {
        return (UnarmedManager)this.skillManagers.get((Object)PrimarySkillType.UNARMED);
    }

    public WoodcuttingManager getWoodcuttingManager() {
        return (WoodcuttingManager)this.skillManagers.get((Object)PrimarySkillType.WOODCUTTING);
    }

    public void resetAbilityMode() {
        for (SuperAbilityType superAbilityType : SuperAbilityType.values()) {
            new AbilityDisableTask(this, superAbilityType).run();
        }
    }

    public boolean getAbilityMode(SuperAbilityType superAbilityType) {
        return this.abilityMode.get((Object)superAbilityType);
    }

    public void setAbilityMode(SuperAbilityType superAbilityType, boolean bl) {
        this.abilityMode.put(superAbilityType, bl);
    }

    public boolean getAbilityInformed(SuperAbilityType superAbilityType) {
        return this.abilityInformed.get((Object)superAbilityType);
    }

    public void setAbilityInformed(SuperAbilityType superAbilityType, boolean bl) {
        this.abilityInformed.put(superAbilityType, bl);
    }

    public boolean getToolPreparationMode(ToolType toolType) {
        return this.toolMode.get((Object)toolType);
    }

    public boolean getAbilityUse() {
        return this.abilityUse;
    }

    public void toggleAbilityUse() {
        this.abilityUse = !this.abilityUse;
    }

    public void resetToolPrepMode() {
        for (ToolType toolType : ToolType.values()) {
            this.setToolPreparationMode(toolType, false);
        }
    }

    public void setToolPreparationMode(ToolType toolType, boolean bl) {
        this.toolMode.put(toolType, bl);
    }

    public int getRecentlyHurt() {
        return this.recentlyHurt;
    }

    public void setRecentlyHurt(int n) {
        this.recentlyHurt = n;
    }

    public void actualizeRecentlyHurt() {
        this.recentlyHurt = (int)(System.currentTimeMillis() / 1000L);
    }

    public int getChimeraWingLastUse() {
        return this.profile.getChimaerWingDATS();
    }

    public void actualizeChimeraWingLastUse() {
        this.profile.setChimaeraWingDATS((int)(System.currentTimeMillis() / 1000L));
    }

    public Location getTeleportCommenceLocation() {
        return this.teleportCommence;
    }

    public void setTeleportCommenceLocation(Location location) {
        this.teleportCommence = location;
    }

    public void actualizeTeleportCommenceLocation(Player player) {
        this.teleportCommence = player.getLocation();
    }

    public int getRespawnATS() {
        return this.respawnATS;
    }

    public void actualizeRespawnATS() {
        this.respawnATS = (int)(System.currentTimeMillis() / 1000L);
    }

    public int getTeleportATS() {
        return this.teleportATS;
    }

    public void actualizeTeleportATS() {
        this.teleportATS = (int)(System.currentTimeMillis() / 1000L);
    }

    public long getDatabaseATS() {
        return this.databaseATS;
    }

    public void actualizeDatabaseATS() {
        this.databaseATS = System.currentTimeMillis();
    }

    public boolean getGodMode() {
        return this.godMode;
    }

    public void toggleGodMode() {
        this.godMode = !this.godMode;
    }

    public boolean isPartyChatSpying() {
        return this.chatSpy;
    }

    public void togglePartyChatSpying() {
        this.chatSpy = !this.chatSpy;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void toggleDebugMode() {
        this.debugMode = !this.debugMode;
    }

    public boolean useChatNotifications() {
        return this.displaySkillNotifications;
    }

    public void toggleChatNotifications() {
        this.displaySkillNotifications = !this.displaySkillNotifications;
    }

    public int getPowerLevel() {
        int n = 0;
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            if (!primarySkillType.getPermissions(this.player)) continue;
            n += this.getSkillLevel(primarySkillType);
        }
        return n;
    }

    public boolean hasReachedLevelCap(PrimarySkillType primarySkillType) {
        if (this.hasReachedPowerLevelCap()) {
            return true;
        }
        return this.getSkillLevel(primarySkillType) >= Config.getInstance().getLevelCap(primarySkillType);
    }

    public boolean hasReachedPowerLevelCap() {
        return this.getPowerLevel() >= Config.getInstance().getPowerLevelCap();
    }

    public void beginXpGain(PrimarySkillType primarySkillType, float f, XPGainReason xPGainReason, XPGainSource xPGainSource) {
        Validate.isTrue(((double)f >= 0.0 ? 1 : 0) != 0, (String)"XP gained should be greater than or equal to zero.");
        if ((double)f <= 0.0) {
            return;
        }
        if (primarySkillType.isChildSkill()) {
            Set<PrimarySkillType> set = FamilyTree.getParents(primarySkillType);
            float f2 = f / (float)set.size();
            for (PrimarySkillType primarySkillType2 : set) {
                if (!primarySkillType2.getPermissions(this.player)) continue;
                this.beginXpGain(primarySkillType2, f2, xPGainReason, xPGainSource);
            }
            return;
        }
        if (this.party != null && ShareHandler.handleXpShare(f, this, primarySkillType, ShareHandler.getSharedXpGainReason(xPGainReason))) {
            return;
        }
        this.beginUnsharedXpGain(primarySkillType, f, xPGainReason, xPGainSource);
    }

    public void beginUnsharedXpGain(PrimarySkillType primarySkillType, float f, XPGainReason xPGainReason, XPGainSource xPGainSource) {
        if (this.player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        this.applyXpGain(primarySkillType, this.modifyXpGain(primarySkillType, f), xPGainReason, xPGainSource);
        if (this.party == null) {
            return;
        }
        if (!Config.getInstance().getPartyXpNearMembersNeeded() || !PartyManager.getNearMembers(this).isEmpty()) {
            this.party.applyXpGain(this.modifyXpGain(primarySkillType, f));
        }
    }

    public void applyXpGain(PrimarySkillType primarySkillType, float f, XPGainReason xPGainReason, XPGainSource xPGainSource) {
        if (!primarySkillType.getPermissions(this.player)) {
            return;
        }
        if (primarySkillType.isChildSkill()) {
            Set<PrimarySkillType> set = FamilyTree.getParents(primarySkillType);
            for (PrimarySkillType primarySkillType2 : set) {
                this.applyXpGain(primarySkillType2, f / (float)set.size(), xPGainReason, xPGainSource);
            }
            return;
        }
        if (!EventUtils.handleXpGainEvent(this.player, primarySkillType, f, xPGainReason)) {
            return;
        }
        this.isUsingUnarmed = primarySkillType == PrimarySkillType.UNARMED;
        this.checkXp(primarySkillType, xPGainReason, xPGainSource);
    }

    private void checkXp(PrimarySkillType primarySkillType, XPGainReason xPGainReason, XPGainSource xPGainSource) {
        if (this.hasReachedLevelCap(primarySkillType)) {
            return;
        }
        if (this.getSkillXpLevelRaw(primarySkillType) < (float)this.getXpToLevel(primarySkillType)) {
            this.processPostXpEvent(primarySkillType, (Plugin)mcMMO.p, xPGainSource);
            return;
        }
        int n = 0;
        float f = 0.0f;
        while (this.getSkillXpLevelRaw(primarySkillType) >= (float)this.getXpToLevel(primarySkillType)) {
            if (this.hasReachedLevelCap(primarySkillType)) {
                this.setSkillXpLevel(primarySkillType, 0.0f);
                break;
            }
            f += this.profile.levelUp(primarySkillType);
            ++n;
        }
        if (EventUtils.tryLevelChangeEvent(this.player, primarySkillType, n, f, true, xPGainReason)) {
            return;
        }
        if (Config.getInstance().getLevelUpSoundsEnabled()) {
            SoundManager.sendSound(this.player, this.player.getLocation(), SoundType.LEVEL_UP);
        }
        NotificationManager.sendPlayerLevelUpNotification(this, primarySkillType, n, this.profile.getSkillLevel(primarySkillType));
        this.processPostXpEvent(primarySkillType, (Plugin)mcMMO.p, xPGainSource);
    }

    public Player getPlayer() {
        return this.player;
    }

    public PlayerProfile getProfile() {
        return this.profile;
    }

    public void setupPartyData() {
        this.party = PartyManager.getPlayerParty(this.player.getName(), this.player.getUniqueId());
        this.ptpRecord = new PartyTeleportRecord();
        if (this.inParty()) {
            this.loginParty();
        }
    }

    public void setPartyInvite(Party party) {
        this.invite = party;
    }

    public Party getPartyInvite() {
        return this.invite;
    }

    public boolean hasPartyInvite() {
        return this.invite != null;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public Party getParty() {
        return this.party;
    }

    public boolean inParty() {
        return this.party != null;
    }

    public void removeParty() {
        this.party = null;
    }

    public void removePartyInvite() {
        this.invite = null;
    }

    public PartyTeleportRecord getPartyTeleportRecord() {
        return this.ptpRecord;
    }

    public void setPartyAllianceInvite(Party party) {
        this.allianceInvite = party;
    }

    public Party getPartyAllianceInvite() {
        return this.allianceInvite;
    }

    public boolean hasPartyAllianceInvite() {
        return this.allianceInvite != null;
    }

    public void removePartyAllianceInvite() {
        this.allianceInvite = null;
    }

    public void loginParty() {
        this.party.addOnlineMember(this.getPlayer());
    }

    public int getItemShareModifier() {
        if (this.itemShareModifier < 10) {
            this.setItemShareModifier(10);
        }
        return this.itemShareModifier;
    }

    public void setItemShareModifier(int n) {
        this.itemShareModifier = Math.max(10, n);
    }

    public boolean isChatEnabled(ChatMode chatMode) {
        switch (chatMode) {
            case ADMIN: {
                return this.adminChatMode;
            }
            case PARTY: {
                return this.partyChatMode;
            }
        }
        return false;
    }

    public void disableChat(ChatMode chatMode) {
        switch (chatMode) {
            case ADMIN: {
                this.adminChatMode = false;
                return;
            }
            case PARTY: {
                this.partyChatMode = false;
                return;
            }
        }
    }

    public void enableChat(ChatMode chatMode) {
        switch (chatMode) {
            case ADMIN: {
                this.adminChatMode = true;
                this.partyChatMode = false;
                return;
            }
            case PARTY: {
                this.partyChatMode = true;
                this.adminChatMode = false;
                return;
            }
        }
    }

    public void toggleChat(ChatMode chatMode) {
        switch (chatMode) {
            case ADMIN: {
                this.adminChatMode = !this.adminChatMode;
                this.partyChatMode = !this.adminChatMode && this.partyChatMode;
                return;
            }
            case PARTY: {
                this.partyChatMode = !this.partyChatMode;
                this.adminChatMode = !this.partyChatMode && this.adminChatMode;
                return;
            }
        }
    }

    public boolean isUsingUnarmed() {
        return this.isUsingUnarmed;
    }

    private float modifyXpGain(PrimarySkillType primarySkillType, float f) {
        CustomTool customTool;
        if (primarySkillType.getMaxLevel() <= this.getSkillLevel(primarySkillType) || Config.getInstance().getPowerLevelCap() <= this.getPowerLevel()) {
            return 0.0f;
        }
        f = (float)((double)f / primarySkillType.getXpModifier() * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier());
        if (Config.getInstance().getToolModsEnabled() && (customTool = mcMMO.getModManager().getTool(this.player.getInventory().getItemInMainHand())) != null) {
            f = (float)((double)f * customTool.getXpMultiplier());
        }
        return PerksUtils.handleXpPerks(this.player, f, primarySkillType);
    }

    public void checkGodMode() {
        if (this.godMode && !Permissions.mcgod((Permissible)this.player) || this.godMode && WorldBlacklist.isWorldBlacklisted(this.player.getWorld())) {
            this.toggleGodMode();
            this.player.sendMessage(LocaleLoader.getString("Commands.GodMode.Forbidden"));
        }
    }

    public void checkParty() {
        if (this.inParty() && !Permissions.party((Permissible)this.player)) {
            this.removeParty();
            this.player.sendMessage(LocaleLoader.getString("Party.Forbidden"));
        }
    }

    public void checkAbilityActivation(PrimarySkillType primarySkillType) {
        ToolType toolType = primarySkillType.getTool();
        SuperAbilityType superAbilityType = primarySkillType.getAbility();
        if (this.getAbilityMode(superAbilityType) || !superAbilityType.getPermissions(this.player)) {
            return;
        }
        if (!primarySkillType.isSuperAbilityUnlocked(this.getPlayer())) {
            int n = RankUtils.getSuperAbilityUnlockRequirement(primarySkillType.getAbility()) - this.getSkillLevel(primarySkillType);
            NotificationManager.sendPlayerInformation(this.player, NotificationType.ABILITY_COOLDOWN, "Skills.AbilityGateRequirementFail", String.valueOf(n), primarySkillType.getName());
            return;
        }
        int n = this.calculateTimeRemaining(superAbilityType);
        if (n > 0) {
            if (primarySkillType == PrimarySkillType.WOODCUTTING || primarySkillType == PrimarySkillType.AXES) {
                NotificationManager.sendPlayerInformation(this.player, NotificationType.ABILITY_COOLDOWN, "Skills.TooTired", String.valueOf(n));
            }
            return;
        }
        if (EventUtils.callPlayerAbilityActivateEvent(this.player, primarySkillType).isCancelled()) {
            return;
        }
        int n2 = AdvancedConfig.getInstance().getAbilityLength();
        int n3 = AdvancedConfig.getInstance().getAbilityLengthCap();
        int n4 = n3 > 0 ? PerksUtils.handleActivationPerks(this.player, 2 + Math.min(n3, this.getSkillLevel(primarySkillType)) / n2, superAbilityType.getMaxLength()) : PerksUtils.handleActivationPerks(this.player, 2 + this.getSkillLevel(primarySkillType) / n2, superAbilityType.getMaxLength());
        ParticleEffectUtils.playAbilityEnabledEffect(this.player);
        if (this.useChatNotifications()) {
            NotificationManager.sendPlayerInformation(this.player, NotificationType.SUPER_ABILITY, superAbilityType.getAbilityOn());
        }
        SkillUtils.sendSkillMessage(this.player, NotificationType.SUPER_ABILITY_ALERT_OTHERS, superAbilityType.getAbilityPlayer());
        SoundManager.worldSendSound(this.player.getWorld(), this.player.getLocation(), SoundType.ABILITY_ACTIVATED_GENERIC);
        this.profile.setAbilityDATS(superAbilityType, System.currentTimeMillis() + (long)(n4 * 1000));
        this.setAbilityMode(superAbilityType, true);
        if (superAbilityType == SuperAbilityType.SUPER_BREAKER || superAbilityType == SuperAbilityType.GIGA_DRILL_BREAKER) {
            SkillUtils.handleAbilitySpeedIncrease(this.player);
        }
        this.setToolPreparationMode(toolType, false);
        new AbilityDisableTask(this, superAbilityType).runTaskLater((Plugin)mcMMO.p, n4 * 20);
    }

    public void processAbilityActivation(PrimarySkillType primarySkillType) {
        if (Config.getInstance().getAbilitiesOnlyActivateWhenSneaking() && !this.player.isSneaking()) {
            return;
        }
        ItemStack itemStack = this.player.getInventory().getItemInMainHand();
        if (mcMMO.getModManager().isCustomTool(itemStack) && !mcMMO.getModManager().getTool(itemStack).isAbilityEnabled()) {
            return;
        }
        if (!this.getAbilityUse()) {
            return;
        }
        for (SuperAbilityType superAbilityType : SuperAbilityType.values()) {
            if (!this.getAbilityMode(superAbilityType)) continue;
            return;
        }
        SuperAbilityType superAbilityType = primarySkillType.getAbility();
        ToolType toolType = primarySkillType.getTool();
        if (toolType.inHand(itemStack) && !this.getToolPreparationMode(toolType)) {
            if (primarySkillType != PrimarySkillType.WOODCUTTING && primarySkillType != PrimarySkillType.AXES) {
                int n = this.calculateTimeRemaining(superAbilityType);
                if (!this.getAbilityMode(superAbilityType) && n > 0) {
                    NotificationManager.sendPlayerInformation(this.player, NotificationType.ABILITY_COOLDOWN, "Skills.TooTired", String.valueOf(n));
                    return;
                }
            }
            if (Config.getInstance().getAbilityMessagesEnabled()) {
                NotificationManager.sendPlayerInformation(this.player, NotificationType.TOOL, toolType.getRaiseTool());
                SoundManager.sendSound(this.player, this.player.getLocation(), SoundType.TOOL_READY);
            }
            this.setToolPreparationMode(toolType, true);
            new ToolLowerTask(this, toolType).runTaskLater((Plugin)mcMMO.p, 80L);
        }
    }

    public int calculateTimeRemaining(SuperAbilityType superAbilityType) {
        long l = this.profile.getAbilityDATS(superAbilityType) * 1000L;
        return (int)((l + (long)(PerksUtils.handleCooldownPerks(this.player, superAbilityType.getCooldown()) * 1000) - System.currentTimeMillis()) / 1000L);
    }

    public int getSkillLevel(PrimarySkillType primarySkillType) {
        return this.profile.getSkillLevel(primarySkillType);
    }

    public float getSkillXpLevelRaw(PrimarySkillType primarySkillType) {
        return this.profile.getSkillXpLevelRaw(primarySkillType);
    }

    public int getSkillXpLevel(PrimarySkillType primarySkillType) {
        return this.profile.getSkillXpLevel(primarySkillType);
    }

    public void setSkillXpLevel(PrimarySkillType primarySkillType, float f) {
        this.profile.setSkillXpLevel(primarySkillType, f);
    }

    public int getXpToLevel(PrimarySkillType primarySkillType) {
        return this.profile.getXpToLevel(primarySkillType);
    }

    public void removeXp(PrimarySkillType primarySkillType, int n) {
        this.profile.removeXp(primarySkillType, n);
    }

    public void modifySkill(PrimarySkillType primarySkillType, int n) {
        this.profile.modifySkill(primarySkillType, n);
    }

    public void addLevels(PrimarySkillType primarySkillType, int n) {
        this.profile.addLevels(primarySkillType, n);
    }

    public void addXp(PrimarySkillType primarySkillType, float f) {
        this.profile.addXp(primarySkillType, f);
    }

    public void setAbilityDATS(SuperAbilityType superAbilityType, long l) {
        this.profile.setAbilityDATS(superAbilityType, l);
    }

    public void resetCooldowns() {
        this.profile.resetCooldowns();
    }

    public FixedMetadataValue getPlayerMetadata() {
        return this.playerMetadata;
    }

    public void logout(boolean bl) {
        Player player = this.getPlayer();
        BleedTimerTask.bleedOut((LivingEntity)this.getPlayer());
        this.cleanup();
        if (bl) {
            this.getProfile().save(true);
        } else {
            this.getProfile().scheduleAsyncSave();
        }
        UserManager.remove(player);
        if (Config.getInstance().getScoreboardsEnabled()) {
            ScoreboardManager.teardownPlayer(player);
        }
        if (this.inParty()) {
            this.party.removeOnlineMember(player);
        }
        mcMMO.getDatabaseManager().cleanupUser(player.getUniqueId());
    }

    public void cleanup() {
        this.resetAbilityMode();
        this.getTamingManager().cleanupAllSummons();
    }
}

