/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.party;

import com.gmail.nossr50.commands.party.PartySubcommandType;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public enum PartyFeature {
    CHAT,
    TELEPORT,
    ALLIANCE,
    ITEM_SHARE,
    XP_SHARE;


    public String getLocaleString() {
        return LocaleLoader.getString("Party.Feature." + StringUtils.getPrettyPartyFeatureString(this).replace(" ", ""));
    }

    public String getFeatureLockedLocaleString() {
        return LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Party.Feature.Locked." + StringUtils.getPrettyPartyFeatureString(this).replace(" ", ""), Config.getInstance().getPartyFeatureUnlockLevel(this)));
    }

    public boolean hasPermission(Player player) {
        PartySubcommandType partySubcommandType;
        switch (this) {
            case CHAT: {
                partySubcommandType = PartySubcommandType.CHAT;
                break;
            }
            case TELEPORT: {
                partySubcommandType = PartySubcommandType.TELEPORT;
                break;
            }
            case ALLIANCE: {
                partySubcommandType = PartySubcommandType.ALLIANCE;
                break;
            }
            case ITEM_SHARE: {
                partySubcommandType = PartySubcommandType.ITEMSHARE;
                break;
            }
            case XP_SHARE: {
                partySubcommandType = PartySubcommandType.XPSHARE;
                break;
            }
            default: {
                return false;
            }
        }
        return Permissions.partySubcommand((Permissible)player, partySubcommandType);
    }
}

