/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.party;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.party.ItemShareType;
import com.gmail.nossr50.datatypes.party.PartyLeader;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Party {
    private static final String ONLINE_PLAYER_PREFIX = "\u2b24";
    private static final String OFFLINE_PLAYER_PREFIX = "\u25cb";
    private final LinkedHashMap<UUID, String> members = new LinkedHashMap();
    private final List<Player> onlineMembers = new ArrayList<Player>();
    private PartyLeader leader;
    private String name;
    private String password;
    private boolean locked;
    private Party ally;
    private int level;
    private float xp;
    private ShareMode xpShareMode = ShareMode.NONE;
    private ShareMode itemShareMode = ShareMode.NONE;
    private boolean shareLootDrops = true;
    private boolean shareMiningDrops = true;
    private boolean shareHerbalismDrops = true;
    private boolean shareWoodcuttingDrops = true;
    private boolean shareMiscDrops = true;

    public Party(String string) {
        this.name = string;
    }

    public Party(PartyLeader partyLeader, String string) {
        this.leader = partyLeader;
        this.name = string;
        this.locked = true;
        this.level = 0;
    }

    public Party(PartyLeader partyLeader, String string, String string2) {
        this.leader = partyLeader;
        this.name = string;
        this.password = string2;
        this.locked = true;
        this.level = 0;
    }

    public Party(PartyLeader partyLeader, String string, String string2, boolean bl) {
        this.leader = partyLeader;
        this.name = string;
        this.password = string2;
        this.locked = bl;
        this.level = 0;
    }

    public LinkedHashMap<UUID, String> getMembers() {
        return this.members;
    }

    public List<Player> getOnlineMembers() {
        return this.onlineMembers;
    }

    public List<Player> getVisibleMembers(Player player) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player2 : this.onlineMembers) {
            if (!player.canSee(player2)) continue;
            arrayList.add(player2);
        }
        return arrayList;
    }

    public List<String> getOnlinePlayerNames(CommandSender commandSender) {
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Player player2 : this.getOnlineMembers()) {
            if (player == null || !player.canSee(player2)) continue;
            arrayList.add(player2.getName());
        }
        return arrayList;
    }

    public boolean addOnlineMember(Player player) {
        return this.onlineMembers.add(player);
    }

    public boolean removeOnlineMember(Player player) {
        return this.onlineMembers.remove(player);
    }

    public String getName() {
        return this.name;
    }

    public PartyLeader getLeader() {
        return this.leader;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Party getAlly() {
        return this.ally;
    }

    public List<String> getItemShareCategories() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ItemShareType itemShareType : ItemShareType.values()) {
            if (!this.sharingDrops(itemShareType)) continue;
            arrayList.add(itemShareType.getLocaleString());
        }
        return arrayList;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setLeader(PartyLeader partyLeader) {
        this.leader = partyLeader;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public void setAlly(Party party) {
        this.ally = party;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public float getXp() {
        return this.xp;
    }

    public void setXp(float f) {
        this.xp = f;
    }

    public void addXp(float f) {
        this.setXp(this.getXp() + f);
    }

    protected float levelUp() {
        float f = this.getXpToLevel();
        this.setLevel(this.getLevel() + 1);
        this.setXp(this.getXp() - f);
        return f;
    }

    public int getXpToLevel() {
        FormulaType formulaType = ExperienceConfig.getInstance().getFormulaType();
        return mcMMO.getFormulaManager().getXPtoNextLevel(this.level, formulaType) * (this.getOnlineMembers().size() + Config.getInstance().getPartyXpCurveMultiplier());
    }

    public String getXpToLevelPercentage() {
        DecimalFormat decimalFormat = new DecimalFormat("##0.00%");
        return decimalFormat.format(this.getXp() / (float)this.getXpToLevel());
    }

    public void applyXpGain(float f) {
        if (!EventUtils.handlePartyXpGainEvent(this, f)) {
            return;
        }
        if (this.getXp() < (float)this.getXpToLevel()) {
            return;
        }
        int n = 0;
        float f2 = 0.0f;
        while (this.getXp() >= (float)this.getXpToLevel()) {
            if (this.hasReachedLevelCap()) {
                this.setXp(0.0f);
                return;
            }
            f2 += this.levelUp();
            ++n;
        }
        if (!EventUtils.handlePartyLevelChangeEvent(this, n, f2)) {
            return;
        }
        if (!Config.getInstance().getPartyInformAllMembers()) {
            Player player = mcMMO.p.getServer().getPlayer(this.leader.getUniqueId());
            if (player != null) {
                player.sendMessage(LocaleLoader.getString("Party.LevelUp", n, this.getLevel()));
                if (Config.getInstance().getLevelUpSoundsEnabled()) {
                    SoundManager.sendSound(player, player.getLocation(), SoundType.LEVEL_UP);
                }
            }
            return;
        }
        PartyManager.informPartyMembersLevelUp(this, n, this.getLevel());
    }

    public boolean hasReachedLevelCap() {
        return Config.getInstance().getPartyLevelCap() < this.getLevel() + 1;
    }

    public void setXpShareMode(ShareMode shareMode) {
        this.xpShareMode = shareMode;
    }

    public ShareMode getXpShareMode() {
        return this.xpShareMode;
    }

    public void setItemShareMode(ShareMode shareMode) {
        this.itemShareMode = shareMode;
    }

    public ShareMode getItemShareMode() {
        return this.itemShareMode;
    }

    public boolean sharingDrops(ItemShareType itemShareType) {
        switch (itemShareType) {
            case HERBALISM: {
                return this.shareHerbalismDrops;
            }
            case LOOT: {
                return this.shareLootDrops;
            }
            case MINING: {
                return this.shareMiningDrops;
            }
            case MISC: {
                return this.shareMiscDrops;
            }
            case WOODCUTTING: {
                return this.shareWoodcuttingDrops;
            }
        }
        return false;
    }

    public void setSharingDrops(ItemShareType itemShareType, boolean bl) {
        switch (itemShareType) {
            case HERBALISM: {
                this.shareHerbalismDrops = bl;
                break;
            }
            case LOOT: {
                this.shareLootDrops = bl;
                break;
            }
            case MINING: {
                this.shareMiningDrops = bl;
                break;
            }
            case MISC: {
                this.shareMiscDrops = bl;
                break;
            }
            case WOODCUTTING: {
                this.shareWoodcuttingDrops = bl;
                break;
            }
            default: {
                return;
            }
        }
    }

    public boolean hasMember(String string) {
        return this.getMembers().values().contains(string);
    }

    public boolean hasMember(UUID uUID) {
        return this.getMembers().keySet().contains(uUID);
    }

    public String createMembersList(Player player) {
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        List list = this.members.keySet().stream().filter(uUID -> Bukkit.getOfflinePlayer((UUID)uUID).isOnline()).collect(Collectors.toList());
        List list2 = this.members.keySet().stream().filter(uUID -> !Bukkit.getOfflinePlayer((UUID)uUID).isOnline()).collect(Collectors.toList());
        ArrayList<UUID> arrayList = new ArrayList<UUID>();
        boolean bl = false;
        ArrayList<UUID> arrayList2 = new ArrayList<UUID>();
        for (Object object2 : list) {
            Player player2 = Bukkit.getPlayer((UUID)object2);
            if (!this.isNotSamePerson(player.getUniqueId(), (UUID)object2) || player.canSee(player2)) {
                arrayList.add((UUID)object2);
                continue;
            }
            if (this.isNotSamePerson(this.leader.getUniqueId(), player.getUniqueId()) && object2 == this.leader.getUniqueId()) {
                bl = true;
            }
            arrayList2.add((UUID)object2);
        }
        if (list2.contains(this.leader.getUniqueId())) {
            bl = true;
        }
        arrayList2.addAll(list2);
        String string = ChatColor.GOLD + "\u2655" + ChatColor.RESET;
        stringBuilder.append(string);
        object2 = this.getNearMembers(UserManager.getPlayer(player));
        boolean bl2 = Config.getInstance().getPartyDisplayNames();
        if (bl) {
            if (this.isNotSamePerson(player.getUniqueId(), this.leader.getUniqueId())) {
                this.applyOnlineAndRangeFormatting(stringBuilder, false, false);
            }
            stringBuilder.append(ChatColor.GRAY).append(this.leader.getPlayerName());
        } else {
            if (this.isNotSamePerson(this.leader.getUniqueId(), player.getUniqueId())) {
                this.applyOnlineAndRangeFormatting(stringBuilder, true, object2.contains(Bukkit.getPlayer((UUID)this.leader.getUniqueId())));
            }
            if (bl2) {
                stringBuilder.append(this.leader.getPlayerName());
            } else {
                stringBuilder.append(ChatColor.GOLD).append(Bukkit.getOfflinePlayer((UUID)this.leader.getUniqueId()));
            }
        }
        stringBuilder.append(" ");
        for (UUID uUID2 : arrayList) {
            if (uUID2 == this.leader.getUniqueId()) continue;
            if (this.isNotSamePerson(uUID2, player.getUniqueId())) {
                this.applyOnlineAndRangeFormatting(stringBuilder, true, object2.contains(Bukkit.getPlayer((UUID)uUID2)));
            }
            if (bl2) {
                stringBuilder.append(Bukkit.getPlayer((UUID)uUID2).getDisplayName());
            } else {
                stringBuilder.append(ChatColor.GREEN).append(Bukkit.getPlayer((UUID)uUID2).getName());
            }
            stringBuilder.append(" ").append(ChatColor.RESET);
        }
        for (UUID uUID2 : arrayList2) {
            if (uUID2 == this.leader.getUniqueId()) continue;
            this.applyOnlineAndRangeFormatting(stringBuilder, false, false);
            stringBuilder.append(ChatColor.GRAY).append(Bukkit.getOfflinePlayer((UUID)uUID2).getName()).append(" ").append(ChatColor.RESET);
        }
        return stringBuilder.toString();
    }

    private boolean isNotSamePerson(UUID uUID, UUID uUID2) {
        return uUID != uUID2;
    }

    private void applyOnlineAndRangeFormatting(StringBuilder stringBuilder, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                stringBuilder.append(ChatColor.GREEN);
            } else {
                stringBuilder.append(ChatColor.GRAY);
            }
            stringBuilder.append(ONLINE_PLAYER_PREFIX);
        } else {
            stringBuilder.append(ChatColor.GRAY);
            stringBuilder.append(OFFLINE_PLAYER_PREFIX);
        }
        stringBuilder.append(ChatColor.RESET);
    }

    public List<Player> getNearMembers(McMMOPlayer mcMMOPlayer) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        Party party = mcMMOPlayer.getParty();
        if (party != null) {
            Player player = mcMMOPlayer.getPlayer();
            double d = Config.getInstance().getPartyShareRange();
            for (Player player2 : party.getOnlineMembers()) {
                if (player.equals(player2) || !player2.isValid() || !Misc.isNear(player.getLocation(), player2.getLocation(), d)) continue;
                arrayList.add(player2);
            }
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Party)) {
            return false;
        }
        Party party = (Party)object;
        if (this.getName() == null || party.getName() == null) {
            return false;
        }
        return this.getName().equals(party.getName());
    }
}

