/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.experience;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class SkillXpGain
implements Delayed {
    private final long expiryTime = System.currentTimeMillis() + SkillXpGain.getDuration();
    private final float xp;
    private final PrimarySkillType type;

    public SkillXpGain(PrimarySkillType primarySkillType, float f) {
        this.xp = f;
        this.type = primarySkillType;
    }

    public PrimarySkillType getSkill() {
        return this.type;
    }

    public float getXp() {
        return this.xp;
    }

    private static long getDuration() {
        return TimeUnit.MINUTES.toMillis(ExperienceConfig.getInstance().getDiminishedReturnsTimeInterval());
    }

    @Override
    public int compareTo(SkillXpGain skillXpGain) {
        if (this.expiryTime < skillXpGain.expiryTime) {
            return -1;
        }
        if (this.expiryTime > skillXpGain.expiryTime) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed instanceof SkillXpGain) {
            return this.compareTo((SkillXpGain)delayed);
        }
        return (int)(this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS));
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.expiryTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }
}

