/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.juli.logging;

import com.gmail.nossr50.database.tomcat.juli.logging.DirectJDKLog;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import java.util.Properties;
import java.util.logging.LogManager;

public class LogFactory {
    public static final String FACTORY_PROPERTY = "com.gmail.nossr50.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "com.gmail.nossr50.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "com.gmail.nossr50.commons.logging.LogFactory.HashtableImpl";
    private static LogFactory singleton = new LogFactory();
    Properties logConfig = new Properties();

    private LogFactory() {
    }

    void setLogConfig(Properties properties) {
        this.logConfig = properties;
    }

    public Log getInstance(String string) {
        return DirectJDKLog.getInstance(string);
    }

    public void release() {
        DirectJDKLog.release();
    }

    public Object getAttribute(String string) {
        return this.logConfig.get(string);
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[this.logConfig.size()];
        return this.logConfig.keySet().toArray(stringArray);
    }

    public void removeAttribute(String string) {
        this.logConfig.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.logConfig.put(string, object);
    }

    public Log getInstance(Class<?> clazz) {
        return this.getInstance(clazz.getName());
    }

    public static LogFactory getFactory() {
        return singleton;
    }

    public static Log getLog(Class<?> clazz) {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String string) {
        return LogFactory.getFactory().getInstance(string);
    }

    public static void release(ClassLoader classLoader) {
        if (!LogManager.getLogManager().getClass().getName().equals("java.util.logging.LogManager")) {
            LogManager.getLogManager().reset();
        }
    }

    public static void releaseAll() {
        singleton.release();
    }

    public static String objectId(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + "@" + System.identityHashCode(object);
    }
}

