/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.juli;

import com.gmail.nossr50.database.tomcat.juli.DateFormatCache;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class OneLineFormatter
extends Formatter {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ST_SEP = LINE_SEP + " ";
    private static final String timeFormat = "dd-MMM-yyyy HH:mm:ss";
    private static final int globalCacheSize = 30;
    private static final int localCacheSize = 5;
    private static final DateFormatCache globalDateCache = new DateFormatCache(30, "dd-MMM-yyyy HH:mm:ss", null);
    private static final ThreadLocal<DateFormatCache> localDateCache = new ThreadLocal<DateFormatCache>(){

        @Override
        protected DateFormatCache initialValue() {
            return new DateFormatCache(5, OneLineFormatter.timeFormat, globalDateCache);
        }
    };

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        this.addTimestamp(stringBuilder, logRecord.getMillis());
        stringBuilder.append(' ');
        stringBuilder.append(logRecord.getLevel());
        stringBuilder.append(' ');
        stringBuilder.append('[');
        stringBuilder.append(Thread.currentThread().getName());
        stringBuilder.append(']');
        stringBuilder.append(' ');
        stringBuilder.append(logRecord.getSourceClassName());
        stringBuilder.append('.');
        stringBuilder.append(logRecord.getSourceMethodName());
        stringBuilder.append(' ');
        stringBuilder.append(this.formatMessage(logRecord));
        if (logRecord.getThrown() != null) {
            stringBuilder.append(ST_SEP);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            logRecord.getThrown().printStackTrace(printWriter);
            printWriter.close();
            stringBuilder.append(stringWriter.getBuffer());
        }
        stringBuilder.append(LINE_SEP);
        return stringBuilder.toString();
    }

    protected void addTimestamp(StringBuilder stringBuilder, long l) {
        stringBuilder.append(localDateCache.get().getFormat(l));
        long l2 = l % 1000L;
        stringBuilder.append('.');
        if (l2 < 100L) {
            if (l2 < 10L) {
                stringBuilder.append('0');
                stringBuilder.append('0');
            } else {
                stringBuilder.append('0');
            }
        }
        stringBuilder.append(l2);
    }
}

