/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.juli;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class FileHandler
extends Handler {
    private volatile String date = "";
    private String directory = null;
    private String prefix = null;
    private String suffix = null;
    private boolean rotatable = true;
    private volatile PrintWriter writer = null;
    protected ReadWriteLock writerLock = new ReentrantReadWriteLock();
    private int bufferSize = -1;

    public FileHandler() {
        this(null, null, null);
    }

    public FileHandler(String string, String string2, String string3) {
        this.directory = string;
        this.prefix = string2;
        this.suffix = string3;
        this.configure();
        this.openWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String string = timestamp.toString().substring(0, 19);
        String string2 = string.substring(0, 10);
        try {
            this.writerLock.readLock().lock();
            if (this.rotatable && !this.date.equals(string2)) {
                try {
                    this.writerLock.readLock().unlock();
                    this.writerLock.writeLock().lock();
                    if (!this.date.equals(string2)) {
                        this.closeWriter();
                        this.date = string2;
                        this.openWriter();
                    }
                }
                finally {
                    this.writerLock.writeLock().unlock();
                    this.writerLock.readLock().lock();
                }
            }
            String string3 = null;
            try {
                string3 = this.getFormatter().format(logRecord);
            }
            catch (Exception exception) {
                this.reportError(null, exception, 5);
                this.writerLock.readLock().unlock();
                return;
            }
            try {
                if (this.writer != null) {
                    this.writer.write(string3);
                    if (this.bufferSize < 0) {
                        this.writer.flush();
                    }
                } else {
                    this.reportError("FileHandler is closed or not yet initialized, unable to log [" + string3 + "]", null, 1);
                }
            }
            catch (Exception exception) {
                this.reportError(null, exception, 1);
                this.writerLock.readLock().unlock();
                return;
            }
        }
        finally {
            this.writerLock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.closeWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeWriter() {
        this.writerLock.writeLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.write(this.getFormatter().getTail(this));
            this.writer.flush();
            this.writer.close();
            this.writer = null;
            this.date = "";
        }
        catch (Exception exception) {
            this.reportError(null, exception, 3);
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.writerLock.readLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.flush();
        }
        catch (Exception exception) {
            this.reportError(null, exception, 2);
        }
        finally {
            this.writerLock.readLock().unlock();
        }
    }

    private void configure() {
        String string;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String string2 = timestamp.toString().substring(0, 19);
        this.date = string2.substring(0, 10);
        String string3 = this.getClass().getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.rotatable = Boolean.parseBoolean(this.getProperty(string3 + ".rotatable", "true"));
        if (this.directory == null) {
            this.directory = this.getProperty(string3 + ".directory", "logs");
        }
        if (this.prefix == null) {
            this.prefix = this.getProperty(string3 + ".prefix", "juli.");
        }
        if (this.suffix == null) {
            this.suffix = this.getProperty(string3 + ".suffix", ".log");
        }
        String string4 = this.getProperty(string3 + ".bufferSize", String.valueOf(this.bufferSize));
        try {
            this.bufferSize = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string5 = this.getProperty(string3 + ".encoding", null);
        if (string5 != null && string5.length() > 0) {
            try {
                this.setEncoding(string5);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.setLevel(Level.parse(this.getProperty(string3 + ".level", "" + Level.ALL)));
        String string6 = this.getProperty(string3 + ".filter", null);
        if (string6 != null) {
            try {
                this.setFilter((Filter)classLoader.loadClass(string6).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.getProperty(string3 + ".formatter", null)) != null) {
            try {
                this.setFormatter((Formatter)classLoader.loadClass(string).newInstance());
            }
            catch (Exception exception) {
                this.setFormatter(new SimpleFormatter());
            }
        } else {
            this.setFormatter(new SimpleFormatter());
        }
        this.setErrorManager(new ErrorManager());
    }

    private String getProperty(String string, String string2) {
        String string3 = LogManager.getLogManager().getProperty(string);
        string3 = string3 == null ? string2 : string3.trim();
        return string3;
    }

    protected void open() {
        this.openWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openWriter() {
        File file = new File(this.directory);
        if (!file.mkdirs() && !file.isDirectory()) {
            this.reportError("Unable to create [" + file + "]", null, 4);
            this.writer = null;
            return;
        }
        this.writerLock.writeLock().lock();
        FileOutputStream fileOutputStream = null;
        OutputStream outputStream = null;
        try {
            File file2 = new File(file.getAbsoluteFile(), this.prefix + (this.rotatable ? this.date : "") + this.suffix);
            File file3 = file2.getParentFile();
            if (!file3.mkdirs() && !file3.isDirectory()) {
                this.reportError("Unable to create [" + file3 + "]", null, 4);
                this.writer = null;
                return;
            }
            String string = this.getEncoding();
            fileOutputStream = new FileOutputStream(file2, true);
            outputStream = this.bufferSize > 0 ? new BufferedOutputStream(fileOutputStream, this.bufferSize) : fileOutputStream;
            this.writer = new PrintWriter((Writer)(string != null ? new OutputStreamWriter(outputStream, string) : new OutputStreamWriter(outputStream)), false);
            this.writer.write(this.getFormatter().getHead(this));
        }
        catch (Exception exception) {
            this.reportError(null, exception, 4);
            this.writer = null;
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
    }
}

