/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.jmx;

import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolConfiguration;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolUtilities;
import com.gmail.nossr50.database.tomcat.jdbc.pool.Validator;
import com.gmail.nossr50.database.tomcat.jdbc.pool.jmx.ConnectionPoolMBean;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;

public class ConnectionPool
extends NotificationBroadcasterSupport
implements ConnectionPoolMBean {
    private static final Log log = LogFactory.getLog(ConnectionPool.class);
    protected com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool pool = null;
    protected AtomicInteger sequence = new AtomicInteger(0);
    protected ConcurrentLinkedQueue<NotificationListener> listeners = new ConcurrentLinkedQueue();
    public static final String NOTIFY_INIT = "INIT FAILED";
    public static final String NOTIFY_CONNECT = "CONNECTION FAILED";
    public static final String NOTIFY_ABANDON = "CONNECTION ABANDONED";
    public static final String SLOW_QUERY_NOTIFICATION = "SLOW QUERY";
    public static final String FAILED_QUERY_NOTIFICATION = "FAILED QUERY";
    public static final String SUSPECT_ABANDONED_NOTIFICATION = "SUSPECT CONNETION ABANDONED";
    public static final String POOL_EMPTY = "POOL EMPTY";

    public ConnectionPool(com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool connectionPool) {
        this.pool = connectionPool;
    }

    public com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool getPool() {
        return this.pool;
    }

    public PoolConfiguration getPoolProperties() {
        return this.pool.getPoolProperties();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = super.getNotificationInfo();
        MBeanNotificationInfo[] mBeanNotificationInfoArray2 = ConnectionPool.getDefaultNotificationInfo();
        MBeanNotificationInfo[] mBeanNotificationInfoArray3 = new MBeanNotificationInfo[mBeanNotificationInfoArray.length + mBeanNotificationInfoArray2.length];
        if (mBeanNotificationInfoArray.length > 0) {
            System.arraycopy(mBeanNotificationInfoArray, 0, mBeanNotificationInfoArray3, 0, mBeanNotificationInfoArray.length);
        }
        if (mBeanNotificationInfoArray2.length > 0) {
            System.arraycopy(mBeanNotificationInfoArray2, 0, mBeanNotificationInfoArray3, mBeanNotificationInfoArray.length, mBeanNotificationInfoArray2.length);
        }
        return mBeanNotificationInfoArray3;
    }

    public static MBeanNotificationInfo[] getDefaultNotificationInfo() {
        String[] stringArray = new String[]{NOTIFY_INIT, NOTIFY_CONNECT, NOTIFY_ABANDON, SLOW_QUERY_NOTIFICATION, FAILED_QUERY_NOTIFICATION, SUSPECT_ABANDONED_NOTIFICATION};
        String string = Notification.class.getName();
        String string2 = "A connection pool error condition was met.";
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(stringArray, string, string2);
        return new MBeanNotificationInfo[]{mBeanNotificationInfo};
    }

    public boolean notify(String string, String string2) {
        try {
            Notification notification = new Notification(string, this, this.sequence.incrementAndGet(), System.currentTimeMillis(), "[" + string + "] " + string2);
            this.sendNotification(notification);
            for (NotificationListener notificationListener : this.listeners) {
                notificationListener.handleNotification(notification, this);
            }
            return true;
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug("Notify failed. Type=" + string + "; Message=" + string2, exception);
            }
            return false;
        }
    }

    public void addListener(NotificationListener notificationListener) {
        this.listeners.add(notificationListener);
    }

    public boolean removeListener(NotificationListener notificationListener) {
        return this.listeners.remove(notificationListener);
    }

    public int getSize() {
        return this.pool.getSize();
    }

    public int getIdle() {
        return this.pool.getIdle();
    }

    public int getActive() {
        return this.pool.getActive();
    }

    public int getNumIdle() {
        return this.getIdle();
    }

    public int getNumActive() {
        return this.getActive();
    }

    public int getWaitCount() {
        return this.pool.getWaitCount();
    }

    public void checkIdle() {
        this.pool.checkIdle();
    }

    public void checkAbandoned() {
        this.pool.checkAbandoned();
    }

    public void testIdle() {
        this.pool.testAllIdle();
    }

    public String getConnectionProperties() {
        return this.getPoolProperties().getConnectionProperties();
    }

    public Properties getDbProperties() {
        return PoolUtilities.cloneWithoutPassword(this.getPoolProperties().getDbProperties());
    }

    public String getDefaultCatalog() {
        return this.getPoolProperties().getDefaultCatalog();
    }

    public int getDefaultTransactionIsolation() {
        return this.getPoolProperties().getDefaultTransactionIsolation();
    }

    public String getDriverClassName() {
        return this.getPoolProperties().getDriverClassName();
    }

    public int getInitialSize() {
        return this.getPoolProperties().getInitialSize();
    }

    public String getInitSQL() {
        return this.getPoolProperties().getInitSQL();
    }

    public String getJdbcInterceptors() {
        return this.getPoolProperties().getJdbcInterceptors();
    }

    public int getMaxActive() {
        return this.getPoolProperties().getMaxActive();
    }

    public int getMaxIdle() {
        return this.getPoolProperties().getMaxIdle();
    }

    public int getMaxWait() {
        return this.getPoolProperties().getMaxWait();
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.getPoolProperties().getMinEvictableIdleTimeMillis();
    }

    public int getMinIdle() {
        return this.getPoolProperties().getMinIdle();
    }

    public long getMaxAge() {
        return this.getPoolProperties().getMaxAge();
    }

    public String getName() {
        return this.getPoolName();
    }

    public int getNumTestsPerEvictionRun() {
        return this.getPoolProperties().getNumTestsPerEvictionRun();
    }

    public String getPassword() {
        return "Password not available as DataSource/JMX operation.";
    }

    public int getRemoveAbandonedTimeout() {
        return this.getPoolProperties().getRemoveAbandonedTimeout();
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.getPoolProperties().getTimeBetweenEvictionRunsMillis();
    }

    public String getUrl() {
        return this.getPoolProperties().getUrl();
    }

    public String getUsername() {
        return this.getPoolProperties().getUsername();
    }

    public long getValidationInterval() {
        return this.getPoolProperties().getValidationInterval();
    }

    public String getValidationQuery() {
        return this.getPoolProperties().getValidationQuery();
    }

    public int getValidationQueryTimeout() {
        return this.getPoolProperties().getValidationQueryTimeout();
    }

    public String getValidatorClassName() {
        return this.getPoolProperties().getValidatorClassName();
    }

    public Validator getValidator() {
        return this.getPoolProperties().getValidator();
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.getPoolProperties().isAccessToUnderlyingConnectionAllowed();
    }

    public Boolean isDefaultAutoCommit() {
        return this.getPoolProperties().isDefaultAutoCommit();
    }

    public Boolean isDefaultReadOnly() {
        return this.getPoolProperties().isDefaultReadOnly();
    }

    public boolean isLogAbandoned() {
        return this.getPoolProperties().isLogAbandoned();
    }

    public boolean isPoolSweeperEnabled() {
        return this.getPoolProperties().isPoolSweeperEnabled();
    }

    public boolean isRemoveAbandoned() {
        return this.getPoolProperties().isRemoveAbandoned();
    }

    public int getAbandonWhenPercentageFull() {
        return this.getPoolProperties().getAbandonWhenPercentageFull();
    }

    public boolean isTestOnBorrow() {
        return this.getPoolProperties().isTestOnBorrow();
    }

    public boolean isTestOnConnect() {
        return this.getPoolProperties().isTestOnConnect();
    }

    public boolean isTestOnReturn() {
        return this.getPoolProperties().isTestOnReturn();
    }

    public boolean isTestWhileIdle() {
        return this.getPoolProperties().isTestWhileIdle();
    }

    public Boolean getDefaultAutoCommit() {
        return this.getPoolProperties().getDefaultAutoCommit();
    }

    public Boolean getDefaultReadOnly() {
        return this.getPoolProperties().getDefaultReadOnly();
    }

    public PoolProperties.InterceptorDefinition[] getJdbcInterceptorsAsArray() {
        return this.getPoolProperties().getJdbcInterceptorsAsArray();
    }

    public boolean getUseLock() {
        return this.getPoolProperties().getUseLock();
    }

    public boolean isFairQueue() {
        return this.getPoolProperties().isFairQueue();
    }

    public boolean isJmxEnabled() {
        return this.getPoolProperties().isJmxEnabled();
    }

    public boolean isUseEquals() {
        return this.getPoolProperties().isUseEquals();
    }

    public void setAbandonWhenPercentageFull(int n) {
        this.getPoolProperties().setAbandonWhenPercentageFull(n);
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.getPoolProperties().setAccessToUnderlyingConnectionAllowed(bl);
    }

    public void setDbProperties(Properties properties) {
        this.getPoolProperties().setDbProperties(properties);
    }

    public void setDefaultReadOnly(Boolean bl) {
        this.getPoolProperties().setDefaultReadOnly(bl);
    }

    public void setMaxAge(long l) {
        this.getPoolProperties().setMaxAge(l);
    }

    public void setName(String string) {
        this.getPoolProperties().setName(string);
    }

    public String getPoolName() {
        return this.getPoolProperties().getName();
    }

    public void setConnectionProperties(String string) {
        this.getPoolProperties().setConnectionProperties(string);
    }

    public void setDefaultAutoCommit(Boolean bl) {
        this.getPoolProperties().setDefaultAutoCommit(bl);
    }

    public void setDefaultCatalog(String string) {
        this.getPoolProperties().setDefaultCatalog(string);
    }

    public void setDefaultTransactionIsolation(int n) {
        this.getPoolProperties().setDefaultTransactionIsolation(n);
    }

    public void setDriverClassName(String string) {
        this.getPoolProperties().setDriverClassName(string);
    }

    public void setFairQueue(boolean bl) {
        this.getPoolProperties().setFairQueue(bl);
    }

    public void setInitialSize(int n) {
        throw new UnsupportedOperationException();
    }

    public void setInitSQL(String string) {
        this.getPoolProperties().setInitSQL(string);
    }

    public void setJdbcInterceptors(String string) {
        throw new UnsupportedOperationException();
    }

    public void setJmxEnabled(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void setLogAbandoned(boolean bl) {
        this.getPoolProperties().setLogAbandoned(bl);
    }

    public void setMaxActive(int n) {
        this.getPoolProperties().setMaxActive(n);
    }

    public void setMaxIdle(int n) {
        this.getPoolProperties().setMaxIdle(n);
    }

    public void setMaxWait(int n) {
        this.getPoolProperties().setMaxWait(n);
    }

    public void setMinEvictableIdleTimeMillis(int n) {
        boolean bl = this.getPoolProperties().isPoolSweeperEnabled();
        this.getPoolProperties().setMinEvictableIdleTimeMillis(n);
        boolean bl2 = this.getPoolProperties().isPoolSweeperEnabled();
        if (!bl && bl2) {
            this.pool.initializePoolCleaner(this.getPoolProperties());
        }
    }

    public void setMinIdle(int n) {
        this.getPoolProperties().setMinIdle(n);
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.getPoolProperties().setNumTestsPerEvictionRun(n);
    }

    public void setPassword(String string) {
        this.getPoolProperties().setPassword(string);
    }

    public void setRemoveAbandoned(boolean bl) {
        boolean bl2 = this.getPoolProperties().isPoolSweeperEnabled();
        this.getPoolProperties().setRemoveAbandoned(bl);
        boolean bl3 = this.getPoolProperties().isPoolSweeperEnabled();
        if (!bl2 && bl3) {
            this.pool.initializePoolCleaner(this.getPoolProperties());
        }
    }

    public void setRemoveAbandonedTimeout(int n) {
        boolean bl = this.getPoolProperties().isPoolSweeperEnabled();
        this.getPoolProperties().setRemoveAbandonedTimeout(n);
        boolean bl2 = this.getPoolProperties().isPoolSweeperEnabled();
        if (!bl && bl2) {
            this.pool.initializePoolCleaner(this.getPoolProperties());
        }
    }

    public void setTestOnBorrow(boolean bl) {
        this.getPoolProperties().setTestOnBorrow(bl);
    }

    public void setTestOnConnect(boolean bl) {
        this.getPoolProperties().setTestOnConnect(bl);
    }

    public void setTestOnReturn(boolean bl) {
        this.getPoolProperties().setTestOnReturn(bl);
    }

    public void setTestWhileIdle(boolean bl) {
        boolean bl2 = this.getPoolProperties().isPoolSweeperEnabled();
        this.getPoolProperties().setTestWhileIdle(bl);
        boolean bl3 = this.getPoolProperties().isPoolSweeperEnabled();
        if (!bl2 && bl3) {
            this.pool.initializePoolCleaner(this.getPoolProperties());
        }
    }

    public void setTimeBetweenEvictionRunsMillis(int n) {
        boolean bl = this.getPoolProperties().isPoolSweeperEnabled();
        this.getPoolProperties().setTimeBetweenEvictionRunsMillis(n);
        boolean bl2 = this.getPoolProperties().isPoolSweeperEnabled();
        if (!bl && bl2) {
            this.pool.initializePoolCleaner(this.getPoolProperties());
        }
    }

    public void setUrl(String string) {
        this.getPoolProperties().setUrl(string);
    }

    public void setUseEquals(boolean bl) {
        this.getPoolProperties().setUseEquals(bl);
    }

    public void setUseLock(boolean bl) {
        this.getPoolProperties().setUseLock(bl);
    }

    public void setUsername(String string) {
        this.getPoolProperties().setUsername(string);
    }

    public void setValidationInterval(long l) {
        this.getPoolProperties().setValidationInterval(l);
    }

    public void setValidationQuery(String string) {
        this.getPoolProperties().setValidationQuery(string);
    }

    public void setValidationQueryTimeout(int n) {
        this.getPoolProperties().setValidationQueryTimeout(n);
    }

    public void setValidatorClassName(String string) {
        this.getPoolProperties().setValidatorClassName(string);
    }

    public int getSuspectTimeout() {
        return this.getPoolProperties().getSuspectTimeout();
    }

    public void setSuspectTimeout(int n) {
        this.getPoolProperties().setSuspectTimeout(n);
    }

    public void setDataSource(Object object) {
        this.getPoolProperties().setDataSource(object);
    }

    public Object getDataSource() {
        return this.getPoolProperties().getDataSource();
    }

    public void setDataSourceJNDI(String string) {
        this.getPoolProperties().setDataSourceJNDI(string);
    }

    public String getDataSourceJNDI() {
        return this.getPoolProperties().getDataSourceJNDI();
    }

    public boolean isAlternateUsernameAllowed() {
        return this.getPoolProperties().isAlternateUsernameAllowed();
    }

    public void setAlternateUsernameAllowed(boolean bl) {
        this.getPoolProperties().setAlternateUsernameAllowed(bl);
    }

    public void setValidator(Validator validator) {
        this.getPoolProperties().setValidator(validator);
    }

    public void setCommitOnReturn(boolean bl) {
        this.getPoolProperties().setCommitOnReturn(bl);
    }

    public boolean getCommitOnReturn() {
        return this.getPoolProperties().getCommitOnReturn();
    }

    public void setRollbackOnReturn(boolean bl) {
        this.getPoolProperties().setRollbackOnReturn(bl);
    }

    public boolean getRollbackOnReturn() {
        return this.getPoolProperties().getRollbackOnReturn();
    }

    public void setUseDisposableConnectionFacade(boolean bl) {
        this.getPoolProperties().setUseDisposableConnectionFacade(bl);
    }

    public boolean getUseDisposableConnectionFacade() {
        return this.getPoolProperties().getUseDisposableConnectionFacade();
    }

    public void setLogValidationErrors(boolean bl) {
        this.getPoolProperties().setLogValidationErrors(bl);
    }

    public boolean getLogValidationErrors() {
        return this.getPoolProperties().getLogValidationErrors();
    }

    public boolean getPropagateInterruptState() {
        return this.getPoolProperties().getPropagateInterruptState();
    }

    public void setPropagateInterruptState(boolean bl) {
        this.getPoolProperties().setPropagateInterruptState(bl);
    }

    public boolean isIgnoreExceptionOnPreLoad() {
        return this.getPoolProperties().isIgnoreExceptionOnPreLoad();
    }

    public void setIgnoreExceptionOnPreLoad(boolean bl) {
        this.getPoolProperties().setIgnoreExceptionOnPreLoad(bl);
    }

    public void purge() {
        this.pool.purge();
    }

    public void purgeOnReturn() {
        this.pool.purgeOnReturn();
    }
}

