/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor;

import com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PooledConnection;
import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.AbstractCreateStatementInterceptor;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.ArrayList;

public class StatementFinalizer
extends AbstractCreateStatementInterceptor {
    private static final Log log = LogFactory.getLog(StatementFinalizer.class);
    protected ArrayList<WeakReference<Statement>> statements = new ArrayList();

    public Object createStatement(Object object, Method method, Object[] objectArray, Object object2, long l) {
        try {
            if (object2 instanceof Statement) {
                this.statements.add(new WeakReference<Statement>((Statement)object2));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return object2;
    }

    public void closeInvoked() {
        while (this.statements.size() > 0) {
            WeakReference<Statement> weakReference = this.statements.remove(0);
            Statement statement = (Statement)weakReference.get();
            if (statement == null) continue;
            try {
                statement.close();
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Unable to closed statement upon connection close.", exception);
            }
        }
    }

    public void reset(ConnectionPool connectionPool, PooledConnection pooledConnection) {
        this.statements.clear();
        super.reset(connectionPool, pooledConnection);
    }
}

