/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor;

import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.AbstractCreateStatementInterceptor;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementDecoratorInterceptor
extends AbstractCreateStatementInterceptor {
    private static final Log logger = LogFactory.getLog(StatementDecoratorInterceptor.class);
    private static final String[] EXECUTE_QUERY_TYPES = new String[]{"executeQuery"};
    protected static final Constructor<?>[] constructors = new Constructor[AbstractCreateStatementInterceptor.STATEMENT_TYPE_COUNT];
    protected static Constructor<?> resultSetConstructor = null;

    @Override
    public void closeInvoked() {
    }

    protected Constructor<?> getConstructor(int n, Class<?> clazz) {
        if (constructors[n] == null) {
            Class<?> clazz2 = Proxy.getProxyClass(StatementDecoratorInterceptor.class.getClassLoader(), clazz);
            StatementDecoratorInterceptor.constructors[n] = clazz2.getConstructor(InvocationHandler.class);
        }
        return constructors[n];
    }

    protected Constructor<?> getResultSetConstructor() {
        if (resultSetConstructor == null) {
            Class<?> clazz = Proxy.getProxyClass(StatementDecoratorInterceptor.class.getClassLoader(), ResultSet.class);
            resultSetConstructor = clazz.getConstructor(InvocationHandler.class);
        }
        return resultSetConstructor;
    }

    @Override
    public Object createStatement(Object object, Method method, Object[] objectArray, Object object2, long l) {
        try {
            String string = method.getName();
            Constructor<?> constructor = null;
            String string2 = null;
            if (this.compare("createStatement", string)) {
                constructor = this.getConstructor(0, Statement.class);
            } else if (this.compare("prepareStatement", string)) {
                constructor = this.getConstructor(1, PreparedStatement.class);
                string2 = (String)objectArray[0];
            } else if (this.compare("prepareCall", string)) {
                constructor = this.getConstructor(2, CallableStatement.class);
                string2 = (String)objectArray[0];
            } else {
                return object2;
            }
            return this.createDecorator(object, method, objectArray, object2, constructor, string2);
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException) {
                Throwable throwable = exception.getCause();
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (throwable instanceof VirtualMachineError) {
                    throw (VirtualMachineError)throwable;
                }
            }
            logger.warn("Unable to create statement proxy for slow query report.", exception);
            return object2;
        }
    }

    protected Object createDecorator(Object object, Method method, Object[] objectArray, Object object2, Constructor<?> constructor, String string) {
        Object var7_7 = null;
        StatementProxy statementProxy = new StatementProxy(this, (Statement)object2, string);
        var7_7 = constructor.newInstance(statementProxy);
        statementProxy.setActualProxy(var7_7);
        statementProxy.setConnection(object);
        statementProxy.setConstructor(constructor);
        return var7_7;
    }

    protected boolean isExecuteQuery(String string) {
        return EXECUTE_QUERY_TYPES[0].equals(string);
    }

    protected boolean isExecuteQuery(Method method) {
        return this.isExecuteQuery(method.getName());
    }

    protected class ResultSetProxy
    implements InvocationHandler {
        private Object st;
        private Object delegate;

        public ResultSetProxy(Object object, Object object2) {
            this.st = object;
            this.delegate = object2;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) {
            if (method.getName().equals("getStatement")) {
                return this.st;
            }
            try {
                return method.invoke(this.delegate, objectArray);
            }
            catch (Throwable throwable) {
                if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                    throw throwable.getCause();
                }
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StatementProxy<T extends Statement>
    implements InvocationHandler {
        protected boolean closed = false;
        protected T delegate;
        private Object actualProxy;
        private Object connection;
        private String sql;
        private Constructor<?> constructor;
        final /* synthetic */ StatementDecoratorInterceptor this$0;

        public StatementProxy(T t, String string) {
            this.this$0 = var1_1;
            this.delegate = t;
            this.sql = string;
        }

        public T getDelegate() {
            return this.delegate;
        }

        public String getSql() {
            return this.sql;
        }

        public void setConnection(Object object) {
            this.connection = object;
        }

        public Object getConnection() {
            return this.connection;
        }

        public void setActualProxy(Object object) {
            this.actualProxy = object;
        }

        public Object getActualProxy() {
            return this.actualProxy;
        }

        public Constructor<?> getConstructor() {
            return this.constructor;
        }

        public void setConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        public void closeInvoked() {
            if (this.getDelegate() != null) {
                try {
                    this.getDelegate().close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.closed = true;
            this.delegate = null;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) {
            if (this.this$0.compare("toString", method)) {
                return this.toString();
            }
            boolean bl = this.this$0.compare("close", method);
            if (bl && this.closed) {
                return null;
            }
            if (this.this$0.compare("isClosed", method)) {
                return this.closed;
            }
            if (this.closed) {
                throw new SQLException("Statement closed.");
            }
            if (this.this$0.compare("getConnection", method)) {
                return this.connection;
            }
            boolean bl2 = this.this$0.isExecuteQuery(method);
            Object object2 = null;
            try {
                if (bl) {
                    this.closeInvoked();
                } else {
                    object2 = method.invoke(this.delegate, objectArray);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                    throw throwable.getCause();
                }
                throw throwable;
            }
            if (bl2) {
                Constructor<?> constructor = this.this$0.getResultSetConstructor();
                object2 = constructor.newInstance(this.this$0.new ResultSetProxy(this.actualProxy, object2));
            }
            return object2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(StatementProxy.class.getName());
            stringBuffer.append("[Proxy=");
            stringBuffer.append(System.identityHashCode(this));
            stringBuffer.append("; Sql=");
            stringBuffer.append(this.getSql());
            stringBuffer.append("; Delegate=");
            stringBuffer.append(this.getDelegate());
            stringBuffer.append("; Connection=");
            stringBuffer.append(this.getConnection());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

