/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor;

import com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PooledConnection;
import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.StatementDecoratorInterceptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementCache
extends StatementDecoratorInterceptor {
    protected static final String[] ALL_TYPES = new String[]{"prepareStatement", "prepareCall"};
    protected static final String[] CALLABLE_TYPE = new String[]{"prepareCall"};
    protected static final String[] PREPARED_TYPE = new String[]{"prepareStatement"};
    protected static final String[] NO_TYPE = new String[0];
    protected static final String STATEMENT_CACHE_ATTR = StatementCache.class.getName() + ".cache";
    private boolean cachePrepared = true;
    private boolean cacheCallable = false;
    private int maxCacheSize = 50;
    private PooledConnection pcon;
    private String[] types;
    private static ConcurrentHashMap<ConnectionPool, AtomicInteger> cacheSizeMap = new ConcurrentHashMap();
    private AtomicInteger cacheSize;

    public boolean isCachePrepared() {
        return this.cachePrepared;
    }

    public boolean isCacheCallable() {
        return this.cacheCallable;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public String[] getTypes() {
        return this.types;
    }

    public AtomicInteger getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setProperties(Map<String, PoolProperties.InterceptorProperty> map) {
        super.setProperties(map);
        PoolProperties.InterceptorProperty interceptorProperty = map.get("prepared");
        if (interceptorProperty != null) {
            this.cachePrepared = interceptorProperty.getValueAsBoolean(this.cachePrepared);
        }
        if ((interceptorProperty = map.get("callable")) != null) {
            this.cacheCallable = interceptorProperty.getValueAsBoolean(this.cacheCallable);
        }
        if ((interceptorProperty = map.get("max")) != null) {
            this.maxCacheSize = interceptorProperty.getValueAsInt(this.maxCacheSize);
        }
        this.types = this.cachePrepared && this.cacheCallable ? ALL_TYPES : (this.cachePrepared ? PREPARED_TYPE : (this.cacheCallable ? CALLABLE_TYPE : NO_TYPE));
    }

    @Override
    public void poolStarted(ConnectionPool connectionPool) {
        cacheSizeMap.putIfAbsent(connectionPool, new AtomicInteger(0));
        super.poolStarted(connectionPool);
    }

    @Override
    public void poolClosed(ConnectionPool connectionPool) {
        cacheSizeMap.remove(connectionPool);
        super.poolClosed(connectionPool);
    }

    @Override
    public void reset(ConnectionPool connectionPool, PooledConnection pooledConnection) {
        super.reset(connectionPool, pooledConnection);
        if (connectionPool == null) {
            this.cacheSize = null;
            this.pcon = null;
        } else {
            this.cacheSize = cacheSizeMap.get(connectionPool);
            this.pcon = pooledConnection;
            if (!this.pcon.getAttributes().containsKey(STATEMENT_CACHE_ATTR)) {
                ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
                this.pcon.getAttributes().put(STATEMENT_CACHE_ATTR, concurrentHashMap);
            }
        }
    }

    @Override
    public void disconnected(ConnectionPool connectionPool, PooledConnection pooledConnection, boolean bl) {
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)pooledConnection.getAttributes().get(STATEMENT_CACHE_ATTR);
        if (concurrentHashMap != null) {
            for (Map.Entry entry : concurrentHashMap.entrySet()) {
                this.closeStatement((CachedStatement)entry.getValue());
            }
            concurrentHashMap.clear();
        }
        super.disconnected(connectionPool, pooledConnection, bl);
    }

    public void closeStatement(CachedStatement cachedStatement) {
        if (cachedStatement == null) {
            return;
        }
        cachedStatement.forceClose();
    }

    @Override
    protected Object createDecorator(Object object, Method method, Object[] objectArray, Object object2, Constructor<?> constructor, String string) {
        boolean bl = this.process(this.types, method, false);
        if (bl) {
            Object var8_8 = null;
            CachedStatement cachedStatement = new CachedStatement((Statement)object2, string);
            var8_8 = constructor.newInstance(cachedStatement);
            cachedStatement.setActualProxy(var8_8);
            cachedStatement.setConnection(object);
            cachedStatement.setConstructor(constructor);
            return var8_8;
        }
        return super.createDecorator(object, method, objectArray, object2, constructor, string);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        boolean bl = this.process(this.types, method, false);
        if (bl && objectArray.length > 0 && objectArray[0] instanceof String) {
            CachedStatement cachedStatement = this.isCached((String)objectArray[0]);
            if (cachedStatement != null) {
                this.removeStatement(cachedStatement);
                return cachedStatement.getActualProxy();
            }
            return super.invoke(object, method, objectArray);
        }
        return super.invoke(object, method, objectArray);
    }

    public CachedStatement isCached(String string) {
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)this.pcon.getAttributes().get(STATEMENT_CACHE_ATTR);
        return (CachedStatement)concurrentHashMap.get(string);
    }

    public boolean cacheStatement(CachedStatement cachedStatement) {
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)this.pcon.getAttributes().get(STATEMENT_CACHE_ATTR);
        if (cachedStatement.getSql() == null) {
            return false;
        }
        if (concurrentHashMap.containsKey(cachedStatement.getSql())) {
            return false;
        }
        if (this.cacheSize.get() >= this.maxCacheSize) {
            return false;
        }
        if (this.cacheSize.incrementAndGet() > this.maxCacheSize) {
            this.cacheSize.decrementAndGet();
            return false;
        }
        concurrentHashMap.put(cachedStatement.getSql(), cachedStatement);
        return true;
    }

    public boolean removeStatement(CachedStatement cachedStatement) {
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)this.pcon.getAttributes().get(STATEMENT_CACHE_ATTR);
        if (concurrentHashMap.remove(cachedStatement.getSql()) != null) {
            this.cacheSize.decrementAndGet();
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CachedStatement
    extends StatementDecoratorInterceptor.StatementProxy<Statement> {
        boolean cached;

        public CachedStatement(Statement statement, String string) {
            super((StatementDecoratorInterceptor)StatementCache.this, statement, string);
            this.cached = false;
        }

        @Override
        public void closeInvoked() {
            boolean bl = true;
            if (StatementCache.this.cacheSize.get() < StatementCache.this.maxCacheSize) {
                CachedStatement cachedStatement = new CachedStatement((Statement)this.getDelegate(), this.getSql());
                try {
                    Object obj = this.getConstructor().newInstance(cachedStatement);
                    cachedStatement.setActualProxy(obj);
                    cachedStatement.setConnection(this.getConnection());
                    cachedStatement.setConstructor(this.getConstructor());
                    if (StatementCache.this.cacheStatement(cachedStatement)) {
                        cachedStatement.cached = true;
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    StatementCache.this.removeStatement(cachedStatement);
                }
            }
            if (bl) {
                super.closeInvoked();
            }
            this.closed = true;
            this.delegate = null;
        }

        public void forceClose() {
            StatementCache.this.removeStatement(this);
            super.closeInvoked();
        }
    }
}

