/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor;

import com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PooledConnection;
import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.SlowQueryReport;
import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.SlowQueryReportJmxMBean;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlowQueryReportJmx
extends SlowQueryReport
implements NotificationEmitter,
SlowQueryReportJmxMBean {
    public static final String SLOW_QUERY_NOTIFICATION = "SLOW QUERY";
    public static final String FAILED_QUERY_NOTIFICATION = "FAILED QUERY";
    public static final String objectNameAttribute = "objectName";
    protected static CompositeType SLOW_QUERY_TYPE;
    private static final Log log;
    protected static ConcurrentHashMap<String, SlowQueryReportJmxMBean> mbeans;
    protected volatile NotificationBroadcasterSupport notifier = new NotificationBroadcasterSupport();
    protected String poolName = null;
    protected static AtomicLong notifySequence;
    protected boolean notifyPool = true;
    protected ConnectionPool pool = null;

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.notifier.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notifier.getNotificationInfo();
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) {
        this.notifier.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.notifier.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    protected static CompositeType getCompositeType() {
        if (SLOW_QUERY_TYPE == null) {
            try {
                SLOW_QUERY_TYPE = new CompositeType(SlowQueryReportJmx.class.getName(), "Composite data type for query statistics", SlowQueryReport.QueryStats.getFieldNames(), SlowQueryReport.QueryStats.getFieldDescriptions(), SlowQueryReport.QueryStats.getFieldTypes());
            }
            catch (OpenDataException openDataException) {
                log.warn("Unable to initialize composite data type for JMX stats and notifications.", openDataException);
            }
        }
        return SLOW_QUERY_TYPE;
    }

    @Override
    public void reset(ConnectionPool connectionPool, PooledConnection pooledConnection) {
        super.reset(connectionPool, pooledConnection);
        if (connectionPool != null) {
            this.poolName = connectionPool.getName();
            this.pool = connectionPool;
            this.registerJmx();
        }
    }

    @Override
    public void poolClosed(ConnectionPool connectionPool) {
        this.poolName = connectionPool.getName();
        this.deregisterJmx();
        super.poolClosed(connectionPool);
    }

    @Override
    public void poolStarted(ConnectionPool connectionPool) {
        this.pool = connectionPool;
        super.poolStarted(connectionPool);
        this.poolName = connectionPool.getName();
    }

    @Override
    protected String reportFailedQuery(String string, Object[] objectArray, String string2, long l, Throwable throwable) {
        string = super.reportFailedQuery(string, objectArray, string2, l, throwable);
        this.notifyJmx(string, FAILED_QUERY_NOTIFICATION);
        return string;
    }

    protected void notifyJmx(String string, String string2) {
        block6: {
            try {
                long l = notifySequence.incrementAndGet();
                if (this.isNotifyPool()) {
                    if (this.pool != null && this.pool.getJmxPool() != null) {
                        this.pool.getJmxPool().notify(string2, string);
                    }
                } else if (this.notifier != null) {
                    Notification notification = new Notification(string2, this, l, System.currentTimeMillis(), string);
                    this.notifier.sendNotification(notification);
                }
            }
            catch (RuntimeOperationsException runtimeOperationsException) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("Unable to send failed query notification.", runtimeOperationsException);
            }
        }
    }

    @Override
    protected String reportSlowQuery(String string, Object[] objectArray, String string2, long l, long l2) {
        string = super.reportSlowQuery(string, objectArray, string2, l, l2);
        this.notifyJmx(string, SLOW_QUERY_NOTIFICATION);
        return string;
    }

    public String[] getPoolNames() {
        Set set = perPoolStats.keySet();
        return set.toArray(new String[0]);
    }

    public String getPoolName() {
        return this.poolName;
    }

    public boolean isNotifyPool() {
        return this.notifyPool;
    }

    public void setNotifyPool(boolean bl) {
        this.notifyPool = bl;
    }

    public void resetStats() {
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)perPoolStats.get(this.poolName);
        if (concurrentHashMap != null) {
            Iterator iterator = concurrentHashMap.keySet().iterator();
            while (iterator.hasNext()) {
                iterator.remove();
            }
        }
    }

    @Override
    public CompositeData[] getSlowQueriesCD() {
        Set set;
        CompositeDataSupport[] compositeDataSupportArray = null;
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)perPoolStats.get(this.poolName);
        if (concurrentHashMap != null && (set = concurrentHashMap.entrySet()) != null) {
            compositeDataSupportArray = new CompositeDataSupport[set.size()];
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SlowQueryReport.QueryStats queryStats = (SlowQueryReport.QueryStats)entry.getValue();
                compositeDataSupportArray[n++] = queryStats.getCompositeData(SlowQueryReportJmx.getCompositeType());
            }
        }
        return compositeDataSupportArray;
    }

    protected void deregisterJmx() {
        try {
            if (mbeans.remove(this.poolName) != null) {
                ObjectName objectName = this.getObjectName(this.getClass(), this.poolName);
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
            }
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            log.debug("Jmx deregistration failed.", mBeanRegistrationException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            log.debug("Jmx deregistration failed.", instanceNotFoundException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            log.warn("Jmx deregistration failed.", malformedObjectNameException);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            log.warn("Jmx deregistration failed.", runtimeOperationsException);
        }
    }

    public ObjectName getObjectName(Class<?> clazz, String string) {
        Map<String, PoolProperties.InterceptorProperty> map = this.getProperties();
        ObjectName objectName = map != null && map.containsKey(objectNameAttribute) ? new ObjectName(map.get(objectNameAttribute).getValue()) : new ObjectName("tomcat.jdbc:type=" + clazz.getName() + ",name=" + string);
        return objectName;
    }

    protected void registerJmx() {
        try {
            if (!this.isNotifyPool()) {
                if (SlowQueryReportJmx.getCompositeType() != null) {
                    ObjectName objectName = this.getObjectName(this.getClass(), this.poolName);
                    if (mbeans.putIfAbsent(this.poolName, this) == null) {
                        ManagementFactory.getPlatformMBeanServer().registerMBean(this, objectName);
                    }
                } else {
                    log.warn(SlowQueryReport.class.getName() + "- No JMX support, composite type was not found.");
                }
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            log.error("Jmx registration failed, no JMX data will be exposed for the query stats.", malformedObjectNameException);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            log.error("Jmx registration failed, no JMX data will be exposed for the query stats.", runtimeOperationsException);
        }
        catch (MBeanException mBeanException) {
            log.error("Jmx registration failed, no JMX data will be exposed for the query stats.", mBeanException);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            log.error("Jmx registration failed, no JMX data will be exposed for the query stats.", instanceAlreadyExistsException);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            log.error("Jmx registration failed, no JMX data will be exposed for the query stats.", notCompliantMBeanException);
        }
    }

    @Override
    public void setProperties(Map<String, PoolProperties.InterceptorProperty> map) {
        super.setProperties(map);
        String string = "notifyPool";
        PoolProperties.InterceptorProperty interceptorProperty = map.get("notifyPool");
        if (interceptorProperty != null) {
            this.setNotifyPool(Boolean.parseBoolean(interceptorProperty.getValue()));
        }
    }

    static {
        log = LogFactory.getLog(SlowQueryReportJmx.class);
        mbeans = new ConcurrentHashMap();
        notifySequence = new AtomicLong(0L);
    }
}

