/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor;

import com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PooledConnection;
import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.AbstractQueryReport;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlowQueryReport
extends AbstractQueryReport {
    private static final Log log = LogFactory.getLog(SlowQueryReport.class);
    protected static ConcurrentHashMap<String, ConcurrentHashMap<String, QueryStats>> perPoolStats = new ConcurrentHashMap();
    protected volatile ConcurrentHashMap<String, QueryStats> queries = null;
    protected int maxQueries = 1000;

    public static ConcurrentHashMap<String, QueryStats> getPoolStats(String string) {
        return perPoolStats.get(string);
    }

    public void setMaxQueries(int n) {
        this.maxQueries = n;
    }

    @Override
    protected String reportFailedQuery(String string, Object[] objectArray, String string2, long l, Throwable throwable) {
        String string3 = super.reportFailedQuery(string, objectArray, string2, l, throwable);
        if (this.maxQueries > 0) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            QueryStats queryStats = this.getQueryStats(string3);
            queryStats.failure(l3, l2);
            if (log.isWarnEnabled()) {
                log.warn("Failed Query Report SQL=" + string3 + "; time=" + l3 + " ms;");
            }
        }
        return string3;
    }

    @Override
    protected String reportSlowQuery(String string, Object[] objectArray, String string2, long l, long l2) {
        String string3 = super.reportSlowQuery(string, objectArray, string2, l, l2);
        if (this.maxQueries > 0) {
            QueryStats queryStats = this.getQueryStats(string3);
            queryStats.add(l2, l);
            if (log.isWarnEnabled()) {
                log.warn("Slow Query Report SQL=" + string3 + "; time=" + l2 + " ms;");
            }
        }
        return string3;
    }

    @Override
    public void closeInvoked() {
    }

    @Override
    public void prepareStatement(String string, long l) {
        QueryStats queryStats = this.getQueryStats(string);
        queryStats.prepare(l);
    }

    @Override
    public void prepareCall(String string, long l) {
        QueryStats queryStats = this.getQueryStats(string);
        queryStats.prepare(l);
    }

    @Override
    public void poolStarted(ConnectionPool connectionPool) {
        super.poolStarted(connectionPool);
        this.queries = perPoolStats.get(connectionPool.getName());
        if (this.queries == null) {
            this.queries = new ConcurrentHashMap();
            if (perPoolStats.putIfAbsent(connectionPool.getName(), this.queries) != null) {
                this.queries = perPoolStats.get(connectionPool.getName());
            }
        }
    }

    @Override
    public void poolClosed(ConnectionPool connectionPool) {
        perPoolStats.remove(connectionPool.getName());
        super.poolClosed(connectionPool);
    }

    protected QueryStats getQueryStats(String string) {
        ConcurrentHashMap<String, QueryStats> concurrentHashMap;
        if (string == null) {
            string = "";
        }
        if ((concurrentHashMap = this.queries) == null) {
            return null;
        }
        QueryStats queryStats = concurrentHashMap.get(string);
        if (queryStats == null) {
            queryStats = new QueryStats(string);
            if (concurrentHashMap.putIfAbsent(string, queryStats) != null) {
                queryStats = concurrentHashMap.get(string);
            } else if (concurrentHashMap.size() > this.maxQueries) {
                this.removeOldest(concurrentHashMap);
            }
        }
        return queryStats;
    }

    protected void removeOldest(ConcurrentHashMap<String, QueryStats> concurrentHashMap) {
        Iterator iterator = concurrentHashMap.keySet().iterator();
        while (concurrentHashMap.size() > this.maxQueries && iterator.hasNext()) {
            String string = (String)iterator.next();
            iterator.remove();
            if (!log.isDebugEnabled()) continue;
            log.debug("Removing slow query, capacity reached:" + string);
        }
    }

    @Override
    public void reset(ConnectionPool connectionPool, PooledConnection pooledConnection) {
        super.reset(connectionPool, pooledConnection);
        this.queries = connectionPool != null ? perPoolStats.get(connectionPool.getName()) : null;
    }

    @Override
    public void setProperties(Map<String, PoolProperties.InterceptorProperty> map) {
        super.setProperties(map);
        String string = "threshold";
        String string2 = "maxQueries";
        PoolProperties.InterceptorProperty interceptorProperty = map.get("threshold");
        PoolProperties.InterceptorProperty interceptorProperty2 = map.get("maxQueries");
        if (interceptorProperty != null) {
            this.setThreshold(Long.parseLong(interceptorProperty.getValue()));
        }
        if (interceptorProperty2 != null) {
            this.setMaxQueries(Integer.parseInt(interceptorProperty2.getValue()));
        }
    }

    public static class QueryStats {
        static final String[] FIELD_NAMES = new String[]{"query", "nrOfInvocations", "maxInvocationTime", "maxInvocationDate", "minInvocationTime", "minInvocationDate", "totalInvocationTime", "failures", "prepareCount", "prepareTime", "lastInvocation"};
        static final String[] FIELD_DESCRIPTIONS = new String[]{"The SQL query", "The number of query invocations, a call to executeXXX", "The longest time for this query in milliseconds", "The time and date for when the longest query took place", "The shortest time for this query in milliseconds", "The time and date for when the shortest query took place", "The total amount of milliseconds spent executing this query", "The number of failures for this query", "The number of times this query was prepared (prepareStatement/prepareCall)", "The total number of milliseconds spent preparing this query", "The date and time of the last invocation"};
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG};
        private final String query;
        private volatile int nrOfInvocations;
        private volatile long maxInvocationTime = Long.MIN_VALUE;
        private volatile long maxInvocationDate;
        private volatile long minInvocationTime = Long.MAX_VALUE;
        private volatile long minInvocationDate;
        private volatile long totalInvocationTime;
        private volatile long failures;
        private volatile int prepareCount;
        private volatile long prepareTime;
        private volatile long lastInvocation = 0L;

        public static String[] getFieldNames() {
            return FIELD_NAMES;
        }

        public static String[] getFieldDescriptions() {
            return FIELD_DESCRIPTIONS;
        }

        public static OpenType[] getFieldTypes() {
            return FIELD_TYPES;
        }

        public String toString() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss z", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            StringBuilder stringBuilder = new StringBuilder("QueryStats[query:");
            stringBuilder.append(this.query);
            stringBuilder.append(", nrOfInvocations:");
            stringBuilder.append(this.nrOfInvocations);
            stringBuilder.append(", maxInvocationTime:");
            stringBuilder.append(this.maxInvocationTime);
            stringBuilder.append(", maxInvocationDate:");
            stringBuilder.append(simpleDateFormat.format(new Date(this.maxInvocationDate)));
            stringBuilder.append(", minInvocationTime:");
            stringBuilder.append(this.minInvocationTime);
            stringBuilder.append(", minInvocationDate:");
            stringBuilder.append(simpleDateFormat.format(new Date(this.minInvocationDate)));
            stringBuilder.append(", totalInvocationTime:");
            stringBuilder.append(this.totalInvocationTime);
            stringBuilder.append(", averageInvocationTime:");
            stringBuilder.append((float)this.totalInvocationTime / (float)this.nrOfInvocations);
            stringBuilder.append(", failures:");
            stringBuilder.append(this.failures);
            stringBuilder.append(", prepareCount:");
            stringBuilder.append(this.prepareCount);
            stringBuilder.append(", prepareTime:");
            stringBuilder.append(this.prepareTime);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public CompositeDataSupport getCompositeData(CompositeType compositeType) {
            Object[] objectArray = new Object[]{this.query, this.nrOfInvocations, this.maxInvocationTime, this.maxInvocationDate, this.minInvocationTime, this.minInvocationDate, this.totalInvocationTime, this.failures, this.prepareCount, this.prepareTime, this.lastInvocation};
            return new CompositeDataSupport(compositeType, FIELD_NAMES, objectArray);
        }

        public QueryStats(String string) {
            this.query = string;
        }

        public void prepare(long l) {
            ++this.prepareCount;
            this.prepareTime += l;
        }

        public void add(long l, long l2) {
            this.maxInvocationTime = Math.max(l, this.maxInvocationTime);
            if (this.maxInvocationTime == l) {
                this.maxInvocationDate = l2;
            }
            this.minInvocationTime = Math.min(l, this.minInvocationTime);
            if (this.minInvocationTime == l) {
                this.minInvocationDate = l2;
            }
            ++this.nrOfInvocations;
            this.totalInvocationTime += l;
            this.lastInvocation = l2;
        }

        public void failure(long l, long l2) {
            this.add(l, l2);
            ++this.failures;
        }

        public String getQuery() {
            return this.query;
        }

        public int getNrOfInvocations() {
            return this.nrOfInvocations;
        }

        public long getMaxInvocationTime() {
            return this.maxInvocationTime;
        }

        public long getMaxInvocationDate() {
            return this.maxInvocationDate;
        }

        public long getMinInvocationTime() {
            return this.minInvocationTime;
        }

        public long getMinInvocationDate() {
            return this.minInvocationDate;
        }

        public long getTotalInvocationTime() {
            return this.totalInvocationTime;
        }

        public int hashCode() {
            return this.query.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof QueryStats) {
                QueryStats queryStats = (QueryStats)object;
                return queryStats.query.equals(this.query);
            }
            return false;
        }

        public boolean isOlderThan(QueryStats queryStats) {
            return this.lastInvocation < queryStats.lastInvocation;
        }
    }
}

