/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor;

import com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool;
import com.gmail.nossr50.database.tomcat.jdbc.pool.JdbcInterceptor;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolConfiguration;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PooledConnection;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.lang.reflect.Method;
import java.sql.SQLException;

public class ConnectionState
extends JdbcInterceptor {
    private static final Log log = LogFactory.getLog(ConnectionState.class);
    protected final String[] readState = new String[]{"getAutoCommit", "getTransactionIsolation", "isReadOnly", "getCatalog"};
    protected final String[] writeState = new String[]{"setAutoCommit", "setTransactionIsolation", "setReadOnly", "setCatalog"};
    protected Boolean autoCommit = null;
    protected Integer transactionIsolation = null;
    protected Boolean readOnly = null;
    protected String catalog = null;

    public void reset(ConnectionPool connectionPool, PooledConnection pooledConnection) {
        if (connectionPool == null || pooledConnection == null) {
            this.autoCommit = null;
            this.transactionIsolation = null;
            this.readOnly = null;
            this.catalog = null;
            return;
        }
        PoolConfiguration poolConfiguration = connectionPool.getPoolProperties();
        if (poolConfiguration.getDefaultTransactionIsolation() != -1) {
            try {
                if (this.transactionIsolation == null || this.transactionIsolation.intValue() != poolConfiguration.getDefaultTransactionIsolation()) {
                    pooledConnection.getConnection().setTransactionIsolation(poolConfiguration.getDefaultTransactionIsolation());
                    this.transactionIsolation = poolConfiguration.getDefaultTransactionIsolation();
                }
            }
            catch (SQLException sQLException) {
                this.transactionIsolation = null;
                log.error("Unable to reset transaction isolation state to connection.", sQLException);
            }
        }
        if (poolConfiguration.getDefaultReadOnly() != null) {
            try {
                if (this.readOnly == null || this.readOnly.booleanValue() != poolConfiguration.getDefaultReadOnly().booleanValue()) {
                    pooledConnection.getConnection().setReadOnly(poolConfiguration.getDefaultReadOnly());
                    this.readOnly = poolConfiguration.getDefaultReadOnly();
                }
            }
            catch (SQLException sQLException) {
                this.readOnly = null;
                log.error("Unable to reset readonly state to connection.", sQLException);
            }
        }
        if (poolConfiguration.getDefaultAutoCommit() != null) {
            try {
                if (this.autoCommit == null || this.autoCommit.booleanValue() != poolConfiguration.getDefaultAutoCommit().booleanValue()) {
                    pooledConnection.getConnection().setAutoCommit(poolConfiguration.getDefaultAutoCommit());
                    this.autoCommit = poolConfiguration.getDefaultAutoCommit();
                }
            }
            catch (SQLException sQLException) {
                this.autoCommit = null;
                log.error("Unable to reset autocommit state to connection.", sQLException);
            }
        }
        if (poolConfiguration.getDefaultCatalog() != null) {
            try {
                if (this.catalog == null || !this.catalog.equals(poolConfiguration.getDefaultCatalog())) {
                    pooledConnection.getConnection().setCatalog(poolConfiguration.getDefaultCatalog());
                    this.catalog = poolConfiguration.getDefaultCatalog();
                }
            }
            catch (SQLException sQLException) {
                this.catalog = null;
                log.error("Unable to reset default catalog state to connection.", sQLException);
            }
        }
    }

    public void disconnected(ConnectionPool connectionPool, PooledConnection pooledConnection, boolean bl) {
        this.autoCommit = null;
        this.transactionIsolation = null;
        this.readOnly = null;
        this.catalog = null;
        super.disconnected(connectionPool, pooledConnection, bl);
    }

    public Object invoke(Object object, Method method, Object[] objectArray) {
        int n;
        String string = method.getName();
        boolean bl = false;
        int n2 = -1;
        for (n = 0; !bl && n < this.readState.length; ++n) {
            bl = this.compare(string, this.readState[n]);
            if (!bl) continue;
            n2 = n;
        }
        n = 0;
        for (int i = 0; n == 0 && !bl && i < this.writeState.length; ++i) {
            n = this.compare(string, this.writeState[i]) ? 1 : 0;
            if (n == 0) continue;
            n2 = i;
        }
        Object object2 = null;
        if (bl) {
            switch (n2) {
                case 0: {
                    object2 = this.autoCommit;
                    break;
                }
                case 1: {
                    object2 = this.transactionIsolation;
                    break;
                }
                case 2: {
                    object2 = this.readOnly;
                    break;
                }
                case 3: {
                    object2 = this.catalog;
                    break;
                }
            }
            if (object2 != null) {
                return object2;
            }
        }
        object2 = super.invoke(object, method, objectArray);
        if (bl || n != 0) {
            switch (n2) {
                case 0: {
                    this.autoCommit = (Boolean)(bl ? object2 : objectArray[0]);
                    break;
                }
                case 1: {
                    this.transactionIsolation = (Integer)(bl ? object2 : objectArray[0]);
                    break;
                }
                case 2: {
                    this.readOnly = (Boolean)(bl ? object2 : objectArray[0]);
                    break;
                }
                case 3: {
                    this.catalog = (String)(bl ? object2 : objectArray[0]);
                }
            }
        }
        return object2;
    }
}

