/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor;

import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.AbstractCreateStatementInterceptor;
import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.SlowQueryReport;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryReport
extends AbstractCreateStatementInterceptor {
    private static final Log log = LogFactory.getLog(AbstractQueryReport.class);
    protected long threshold = 1000L;
    protected static final Constructor<?>[] constructors = new Constructor[AbstractCreateStatementInterceptor.STATEMENT_TYPE_COUNT];

    protected abstract void prepareStatement(String var1, long var2);

    protected abstract void prepareCall(String var1, long var2);

    protected String reportFailedQuery(String string, Object[] objectArray, String string2, long l, Throwable throwable) {
        String string3;
        String string4 = string3 = string == null && objectArray != null && objectArray.length > 0 ? (String)objectArray[0] : string;
        if (string3 == null && this.compare("executeBatch", string2)) {
            string3 = "batch";
        }
        return string3;
    }

    protected String reportQuery(String string, Object[] objectArray, String string2, long l, long l2) {
        String string3;
        String string4 = string3 = string == null && objectArray != null && objectArray.length > 0 ? (String)objectArray[0] : string;
        if (string3 == null && this.compare("executeBatch", string2)) {
            string3 = "batch";
        }
        return string3;
    }

    protected String reportSlowQuery(String string, Object[] objectArray, String string2, long l, long l2) {
        String string3;
        String string4 = string3 = string == null && objectArray != null && objectArray.length > 0 ? (String)objectArray[0] : string;
        if (string3 == null && this.compare("executeBatch", string2)) {
            string3 = "batch";
        }
        return string3;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(long l) {
        this.threshold = l;
    }

    protected Constructor<?> getConstructor(int n, Class<?> clazz) {
        if (constructors[n] == null) {
            Class<?> clazz2 = Proxy.getProxyClass(SlowQueryReport.class.getClassLoader(), clazz);
            AbstractQueryReport.constructors[n] = clazz2.getConstructor(InvocationHandler.class);
        }
        return constructors[n];
    }

    @Override
    public Object createStatement(Object object, Method method, Object[] objectArray, Object object2, long l) {
        try {
            Object var7_6 = null;
            String string = method.getName();
            String string2 = null;
            Constructor<?> constructor = null;
            if (this.compare("createStatement", string)) {
                constructor = this.getConstructor(0, Statement.class);
            } else if (this.compare("prepareStatement", string)) {
                string2 = (String)objectArray[0];
                constructor = this.getConstructor(1, PreparedStatement.class);
                if (string2 != null) {
                    this.prepareStatement(string2, l);
                }
            } else if (this.compare("prepareCall", string)) {
                string2 = (String)objectArray[0];
                constructor = this.getConstructor(2, CallableStatement.class);
                this.prepareCall(string2, l);
            } else {
                return object2;
            }
            var7_6 = constructor.newInstance(new StatementProxy(object2, string2));
            return var7_6;
        }
        catch (Exception exception) {
            log.warn("Unable to create statement proxy for slow query report.", exception);
            return object2;
        }
    }

    protected class StatementProxy
    implements InvocationHandler {
        protected boolean closed = false;
        protected Object delegate;
        protected final String query;

        public StatementProxy(Object object, String string) {
            this.delegate = object;
            this.query = string;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) {
            long l;
            String string = method.getName();
            boolean bl = AbstractQueryReport.this.compare("close", string);
            if (bl && this.closed) {
                return null;
            }
            if (AbstractQueryReport.this.compare("isClosed", string)) {
                return this.closed;
            }
            if (this.closed) {
                throw new SQLException("Statement closed.");
            }
            boolean bl2 = false;
            long l2 = (bl2 = AbstractQueryReport.this.isExecute(method, bl2)) ? System.currentTimeMillis() : 0L;
            Object object2 = null;
            try {
                object2 = method.invoke(this.delegate, objectArray);
            }
            catch (Throwable throwable) {
                AbstractQueryReport.this.reportFailedQuery(this.query, objectArray, string, l2, throwable);
                if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                    throw throwable.getCause();
                }
                throw throwable;
            }
            long l3 = l = bl2 ? System.currentTimeMillis() - l2 : Long.MIN_VALUE;
            if (l > AbstractQueryReport.this.threshold) {
                try {
                    AbstractQueryReport.this.reportSlowQuery(this.query, objectArray, string, l2, l);
                }
                catch (Exception exception) {
                    if (log.isWarnEnabled()) {
                        log.warn("Unable to process slow query", exception);
                    }
                }
            } else if (bl2) {
                AbstractQueryReport.this.reportQuery(this.query, objectArray, string, l2, l);
            }
            if (bl) {
                this.closed = true;
                this.delegate = null;
            }
            return object2;
        }
    }
}

