/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor;

import com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool;
import com.gmail.nossr50.database.tomcat.jdbc.pool.JdbcInterceptor;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PooledConnection;
import java.lang.reflect.Method;

public abstract class AbstractCreateStatementInterceptor
extends JdbcInterceptor {
    protected static final String CREATE_STATEMENT = "createStatement";
    protected static final int CREATE_STATEMENT_IDX = 0;
    protected static final String PREPARE_STATEMENT = "prepareStatement";
    protected static final int PREPARE_STATEMENT_IDX = 1;
    protected static final String PREPARE_CALL = "prepareCall";
    protected static final int PREPARE_CALL_IDX = 2;
    protected static final String[] STATEMENT_TYPES = new String[]{"createStatement", "prepareStatement", "prepareCall"};
    protected static final int STATEMENT_TYPE_COUNT = STATEMENT_TYPES.length;
    protected static final String EXECUTE = "execute";
    protected static final String EXECUTE_QUERY = "executeQuery";
    protected static final String EXECUTE_UPDATE = "executeUpdate";
    protected static final String EXECUTE_BATCH = "executeBatch";
    protected static final String[] EXECUTE_TYPES = new String[]{"execute", "executeQuery", "executeUpdate", "executeBatch"};

    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (this.compare("close", method)) {
            this.closeInvoked();
            return super.invoke(object, method, objectArray);
        }
        boolean bl = false;
        if (bl = this.isStatement(method, bl)) {
            long l = System.currentTimeMillis();
            Object object2 = super.invoke(object, method, objectArray);
            long l2 = System.currentTimeMillis() - l;
            return this.createStatement(object, method, objectArray, object2, l2);
        }
        return super.invoke(object, method, objectArray);
    }

    public abstract Object createStatement(Object var1, Method var2, Object[] var3, Object var4, long var5);

    public abstract void closeInvoked();

    protected boolean isStatement(Method method, boolean bl) {
        return this.process(STATEMENT_TYPES, method, bl);
    }

    protected boolean isExecute(Method method, boolean bl) {
        return this.process(EXECUTE_TYPES, method, bl);
    }

    protected boolean process(String[] stringArray, Method method, boolean bl) {
        String string = method.getName();
        for (int i = 0; !bl && i < stringArray.length; ++i) {
            bl = this.compare(stringArray[i], string);
        }
        return bl;
    }

    public void reset(ConnectionPool connectionPool, PooledConnection pooledConnection) {
    }
}

