/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool;

import com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool;
import com.gmail.nossr50.database.tomcat.jdbc.pool.JdbcInterceptor;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PooledConnection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.sql.XAConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyConnection
extends JdbcInterceptor {
    protected PooledConnection connection = null;
    protected ConnectionPool pool = null;

    public PooledConnection getConnection() {
        return this.connection;
    }

    public void setConnection(PooledConnection pooledConnection) {
        this.connection = pooledConnection;
    }

    public ConnectionPool getPool() {
        return this.pool;
    }

    public void setPool(ConnectionPool connectionPool) {
        this.pool = connectionPool;
    }

    protected ProxyConnection(ConnectionPool connectionPool, PooledConnection pooledConnection, boolean bl) {
        this.pool = connectionPool;
        this.connection = pooledConnection;
        this.setUseEquals(bl);
    }

    @Override
    public void reset(ConnectionPool connectionPool, PooledConnection pooledConnection) {
        this.pool = connectionPool;
        this.connection = pooledConnection;
    }

    public boolean isWrapperFor(Class<?> clazz) {
        if (clazz == XAConnection.class && this.connection.getXAConnection() != null) {
            return true;
        }
        return clazz.isInstance(this.connection.getConnection());
    }

    public Object unwrap(Class<?> clazz) {
        if (clazz == PooledConnection.class) {
            return this.connection;
        }
        if (clazz == XAConnection.class) {
            return this.connection.getXAConnection();
        }
        if (this.isWrapperFor(clazz)) {
            return this.connection.getConnection();
        }
        throw new SQLException("Not a wrapper of " + clazz.getName());
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (this.compare("isClosed", method)) {
            return this.isClosed();
        }
        if (this.compare("close", method)) {
            if (this.connection == null) {
                return null;
            }
            PooledConnection pooledConnection = this.connection;
            this.connection = null;
            this.pool.returnConnection(pooledConnection);
            return null;
        }
        if (this.compare("toString", method)) {
            return this.toString();
        }
        if (this.compare("getConnection", method) && this.connection != null) {
            return this.connection.getConnection();
        }
        if (method.getDeclaringClass().equals(XAConnection.class)) {
            try {
                return method.invoke((Object)this.connection.getXAConnection(), objectArray);
            }
            catch (Throwable throwable) {
                if (throwable instanceof InvocationTargetException) {
                    throw throwable.getCause() != null ? throwable.getCause() : throwable;
                }
                throw throwable;
            }
        }
        if (this.isClosed()) {
            throw new SQLException("Connection has already been closed.");
        }
        if (this.compare("unwrap", method)) {
            return this.unwrap((Class)objectArray[0]);
        }
        if (this.compare("isWrapperFor", method)) {
            return this.isWrapperFor((Class)objectArray[0]);
        }
        try {
            PooledConnection pooledConnection = this.connection;
            if (pooledConnection != null) {
                return method.invoke((Object)pooledConnection.getConnection(), objectArray);
            }
            throw new SQLException("Connection has already been closed.");
        }
        catch (Throwable throwable) {
            if (throwable instanceof InvocationTargetException) {
                throw throwable.getCause() != null ? throwable.getCause() : throwable;
            }
            throw throwable;
        }
    }

    public boolean isClosed() {
        return this.connection == null || this.connection.isDiscarded();
    }

    public PooledConnection getDelegateConnection() {
        return this.connection;
    }

    public ConnectionPool getParentPool() {
        return this.pool;
    }

    public String toString() {
        return "ProxyConnection[" + (this.connection != null ? this.connection.toString() : "null") + "]";
    }
}

