/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool;

import com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool;
import com.gmail.nossr50.database.tomcat.jdbc.pool.JdbcInterceptor;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolConfiguration;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolUtilities;
import com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor.ConnectionState;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PooledConnection {
    private static final Log log = LogFactory.getLog(PooledConnection.class);
    public static final String PROP_USER = "user";
    public static final String PROP_PASSWORD = "password";
    public static final int VALIDATE_BORROW = 1;
    public static final int VALIDATE_RETURN = 2;
    public static final int VALIDATE_IDLE = 3;
    public static final int VALIDATE_INIT = 4;
    protected PoolConfiguration poolProperties;
    private volatile Connection connection;
    protected volatile XAConnection xaConnection;
    private String abandonTrace = null;
    private volatile long timestamp;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    private volatile boolean discarded = false;
    private volatile long lastConnected = -1L;
    private volatile long lastValidated = System.currentTimeMillis();
    protected ConnectionPool parent;
    private HashMap<Object, Object> attributes = new HashMap();
    private volatile long connectionVersion = 0L;
    private volatile JdbcInterceptor handler = null;
    private AtomicBoolean released = new AtomicBoolean(false);
    private volatile boolean suspect = false;
    private Driver driver = null;

    public PooledConnection(PoolConfiguration poolConfiguration, ConnectionPool connectionPool) {
        this.poolProperties = poolConfiguration;
        this.parent = connectionPool;
        this.connectionVersion = connectionPool.getPoolVersion();
    }

    public long getConnectionVersion() {
        return this.connectionVersion;
    }

    public boolean checkUser(String string, String string2) {
        if (!this.getPoolProperties().isAlternateUsernameAllowed()) {
            return true;
        }
        if (string == null) {
            string = this.poolProperties.getUsername();
        }
        if (string2 == null) {
            string2 = this.poolProperties.getPassword();
        }
        String string3 = (String)this.getAttributes().get(PROP_USER);
        String string4 = (String)this.getAttributes().get(PROP_PASSWORD);
        boolean bl = string == null && string3 == null;
        bl = bl || string != null && string.equals(string3);
        boolean bl2 = bl = bl && (string2 == null && string4 == null || string2 != null && string2.equals(string4));
        if (string == null) {
            this.getAttributes().remove(PROP_USER);
        } else {
            this.getAttributes().put(PROP_USER, string);
        }
        if (string2 == null) {
            this.getAttributes().remove(PROP_PASSWORD);
        } else {
            this.getAttributes().put(PROP_PASSWORD, string2);
        }
        return bl;
    }

    public void connect() {
        if (this.released.get()) {
            throw new SQLException("A connection once released, can't be reestablished.");
        }
        if (this.connection != null) {
            try {
                this.disconnect(false);
            }
            catch (Exception exception) {
                log.debug("Unable to disconnect previous connection.", exception);
            }
        }
        if (this.poolProperties.getDataSource() != null || this.poolProperties.getDataSourceJNDI() != null) {
            // empty if block
        }
        if (this.poolProperties.getDataSource() != null) {
            this.connectUsingDataSource();
        } else {
            this.connectUsingDriver();
        }
        if (this.poolProperties.getJdbcInterceptors() == null || this.poolProperties.getJdbcInterceptors().indexOf(ConnectionState.class.getName()) < 0 || this.poolProperties.getJdbcInterceptors().indexOf(ConnectionState.class.getSimpleName()) < 0) {
            if (this.poolProperties.getDefaultTransactionIsolation() != -1) {
                this.connection.setTransactionIsolation(this.poolProperties.getDefaultTransactionIsolation());
            }
            if (this.poolProperties.getDefaultReadOnly() != null) {
                this.connection.setReadOnly(this.poolProperties.getDefaultReadOnly());
            }
            if (this.poolProperties.getDefaultAutoCommit() != null) {
                this.connection.setAutoCommit(this.poolProperties.getDefaultAutoCommit());
            }
            if (this.poolProperties.getDefaultCatalog() != null) {
                this.connection.setCatalog(this.poolProperties.getDefaultCatalog());
            }
        }
        this.discarded = false;
        this.lastConnected = System.currentTimeMillis();
    }

    protected void connectUsingDataSource() {
        String string = null;
        String string2 = null;
        if (this.getAttributes().containsKey(PROP_USER)) {
            string = (String)this.getAttributes().get(PROP_USER);
        } else {
            string = this.poolProperties.getUsername();
            this.getAttributes().put(PROP_USER, string);
        }
        if (this.getAttributes().containsKey(PROP_PASSWORD)) {
            string2 = (String)this.getAttributes().get(PROP_PASSWORD);
        } else {
            string2 = this.poolProperties.getPassword();
            this.getAttributes().put(PROP_PASSWORD, string2);
        }
        if (this.poolProperties.getDataSource() instanceof XADataSource) {
            XADataSource xADataSource = (XADataSource)this.poolProperties.getDataSource();
            if (string != null && string2 != null) {
                this.xaConnection = xADataSource.getXAConnection(string, string2);
                this.connection = this.xaConnection.getConnection();
            } else {
                this.xaConnection = xADataSource.getXAConnection();
                this.connection = this.xaConnection.getConnection();
            }
        } else if (this.poolProperties.getDataSource() instanceof DataSource) {
            DataSource dataSource = (DataSource)this.poolProperties.getDataSource();
            this.connection = string != null && string2 != null ? dataSource.getConnection(string, string2) : dataSource.getConnection();
        } else if (this.poolProperties.getDataSource() instanceof ConnectionPoolDataSource) {
            ConnectionPoolDataSource connectionPoolDataSource = (ConnectionPoolDataSource)this.poolProperties.getDataSource();
            this.connection = string != null && string2 != null ? connectionPoolDataSource.getPooledConnection(string, string2).getConnection() : connectionPoolDataSource.getPooledConnection().getConnection();
        } else {
            throw new SQLException("DataSource is of unknown class:" + (this.poolProperties.getDataSource() != null ? this.poolProperties.getDataSource().getClass() : "null"));
        }
    }

    protected void connectUsingDriver() {
        try {
            if (this.driver == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Instantiating driver using class: " + this.poolProperties.getDriverClassName() + " [url=" + this.poolProperties.getUrl() + "]");
                }
                this.driver = (Driver)Class.forName(this.poolProperties.getDriverClassName(), true, PooledConnection.class.getClassLoader()).newInstance();
            }
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to instantiate JDBC driver.", exception);
            }
            SQLException sQLException = new SQLException(exception.getMessage());
            sQLException.initCause(exception);
            throw sQLException;
        }
        String string = this.poolProperties.getUrl();
        String string2 = null;
        String string3 = null;
        if (this.getAttributes().containsKey(PROP_USER)) {
            string2 = (String)this.getAttributes().get(PROP_USER);
        } else {
            string2 = this.poolProperties.getUsername();
            this.getAttributes().put(PROP_USER, string2);
        }
        if (this.getAttributes().containsKey(PROP_PASSWORD)) {
            string3 = (String)this.getAttributes().get(PROP_PASSWORD);
        } else {
            string3 = this.poolProperties.getPassword();
            this.getAttributes().put(PROP_PASSWORD, string3);
        }
        Properties properties = PoolUtilities.clone(this.poolProperties.getDbProperties());
        if (string2 != null) {
            properties.setProperty(PROP_USER, string2);
        }
        if (string3 != null) {
            properties.setProperty(PROP_PASSWORD, string3);
        }
        try {
            this.connection = this.driver.connect(string, properties);
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to connect to database.", exception);
            }
            if (this.parent.jmxPool != null) {
                this.parent.jmxPool.notify("CONNECTION FAILED", ConnectionPool.getStackTrace(exception));
            }
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            SQLException sQLException = new SQLException(exception.getMessage());
            sQLException.initCause(exception);
            throw sQLException;
        }
        if (this.connection == null) {
            throw new SQLException("Driver:" + this.driver + " returned null for URL:" + string);
        }
    }

    public boolean isInitialized() {
        return this.connection != null;
    }

    public void reconnect() {
        this.disconnect(false);
        this.connect();
    }

    private void disconnect(boolean bl) {
        block7: {
            if (this.isDiscarded() && this.connection == null) {
                return;
            }
            this.setDiscarded(true);
            if (this.connection != null) {
                try {
                    this.parent.disconnectEvent(this, bl);
                    if (this.xaConnection == null) {
                        this.connection.close();
                    } else {
                        this.xaConnection.close();
                    }
                }
                catch (Exception exception) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug("Unable to close underlying SQL connection", exception);
                }
            }
        }
        this.connection = null;
        this.xaConnection = null;
        this.lastConnected = -1L;
        if (bl) {
            this.parent.finalize(this);
        }
    }

    public long getAbandonTimeout() {
        if (this.poolProperties.getRemoveAbandonedTimeout() <= 0) {
            return Long.MAX_VALUE;
        }
        return this.poolProperties.getRemoveAbandonedTimeout() * 1000;
    }

    private boolean doValidate(int n) {
        if (n == 1 && this.poolProperties.isTestOnBorrow()) {
            return true;
        }
        if (n == 2 && this.poolProperties.isTestOnReturn()) {
            return true;
        }
        if (n == 3 && this.poolProperties.isTestWhileIdle()) {
            return true;
        }
        if (n == 4 && this.poolProperties.isTestOnConnect()) {
            return true;
        }
        return n == 4 && this.poolProperties.getInitSQL() != null;
    }

    public boolean validate(int n) {
        return this.validate(n, null);
    }

    public boolean validate(int n, String string) {
        if (this.isDiscarded()) {
            return false;
        }
        if (!this.doValidate(n)) {
            return true;
        }
        long l = System.currentTimeMillis();
        if (n != 4 && this.poolProperties.getValidationInterval() > 0L && l - this.lastValidated < this.poolProperties.getValidationInterval()) {
            return true;
        }
        if (this.poolProperties.getValidator() != null) {
            if (this.poolProperties.getValidator().validate(this.connection, n)) {
                this.lastValidated = l;
                return true;
            }
            if (this.getPoolProperties().getLogValidationErrors()) {
                log.error("Custom validation through " + this.poolProperties.getValidator() + " failed.");
            }
            return false;
        }
        String string2 = string;
        if (n == 4 && this.poolProperties.getInitSQL() != null) {
            string2 = this.poolProperties.getInitSQL();
        }
        if (string2 == null) {
            string2 = this.poolProperties.getValidationQuery();
        }
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            int n2 = this.poolProperties.getValidationQueryTimeout();
            if (n2 > 0) {
                statement.setQueryTimeout(n2);
            }
            statement.execute(string2);
            statement.close();
            this.lastValidated = l;
            return true;
        }
        catch (Exception exception) {
            if (this.getPoolProperties().getLogValidationErrors()) {
                log.warn("SQL Validation error", exception);
            } else if (log.isDebugEnabled()) {
                log.debug("Unable to validate object:", exception);
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public long getReleaseTime() {
        return this.poolProperties.getMinEvictableIdleTimeMillis();
    }

    public boolean release() {
        block2: {
            try {
                this.disconnect(true);
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Unable to close SQL connection", exception);
            }
        }
        return this.released.compareAndSet(false, true);
    }

    public void setStackTrace(String string) {
        this.abandonTrace = string;
    }

    public String getStackTrace() {
        return this.abandonTrace;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
        this.setSuspect(false);
    }

    public boolean isSuspect() {
        return this.suspect;
    }

    public void setSuspect(boolean bl) {
        this.suspect = bl;
    }

    public void setDiscarded(boolean bl) {
        if (this.discarded && !bl) {
            throw new IllegalStateException("Unable to change the state once the connection has been discarded");
        }
        this.discarded = bl;
    }

    public void setLastValidated(long l) {
        this.lastValidated = l;
    }

    public void setPoolProperties(PoolConfiguration poolConfiguration) {
        this.poolProperties = poolConfiguration;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public long getLastValidated() {
        return this.lastValidated;
    }

    public PoolConfiguration getPoolProperties() {
        return this.poolProperties;
    }

    public void lock() {
        if (this.poolProperties.getUseLock() || this.poolProperties.isPoolSweeperEnabled()) {
            this.lock.writeLock().lock();
        }
    }

    public void unlock() {
        if (this.poolProperties.getUseLock() || this.poolProperties.isPoolSweeperEnabled()) {
            this.lock.writeLock().unlock();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public XAConnection getXAConnection() {
        return this.xaConnection;
    }

    public long getLastConnected() {
        return this.lastConnected;
    }

    public JdbcInterceptor getHandler() {
        return this.handler;
    }

    public void setHandler(JdbcInterceptor jdbcInterceptor) {
        if (this.handler != null && this.handler != jdbcInterceptor) {
            for (JdbcInterceptor jdbcInterceptor2 = this.handler; jdbcInterceptor2 != null; jdbcInterceptor2 = jdbcInterceptor2.getNext()) {
                jdbcInterceptor2.reset(null, null);
            }
        }
        this.handler = jdbcInterceptor;
    }

    public String toString() {
        return "PooledConnection[" + (this.connection != null ? this.connection.toString() : "null") + "]";
    }

    public boolean isReleased() {
        return this.released.get();
    }

    public HashMap<Object, Object> getAttributes() {
        return this.attributes;
    }
}

