/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool;

import com.gmail.nossr50.database.tomcat.jdbc.pool.DataSourceFactory;
import com.gmail.nossr50.database.tomcat.jdbc.pool.JdbcInterceptor;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolConfiguration;
import com.gmail.nossr50.database.tomcat.jdbc.pool.TrapException;
import com.gmail.nossr50.database.tomcat.jdbc.pool.Validator;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public class PoolProperties
implements PoolConfiguration,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8519283440854213745L;
    private static final Log log = LogFactory.getLog(PoolProperties.class);
    public static final int DEFAULT_MAX_ACTIVE = 100;
    protected static AtomicInteger poolCounter = new AtomicInteger(0);
    private volatile Properties dbProperties = new Properties();
    private volatile String url = null;
    private volatile String driverClassName = null;
    private volatile Boolean defaultAutoCommit = null;
    private volatile Boolean defaultReadOnly = null;
    private volatile int defaultTransactionIsolation = -1;
    private volatile String defaultCatalog = null;
    private volatile String connectionProperties;
    private volatile int initialSize = 10;
    private volatile int maxActive;
    private volatile int maxIdle = this.maxActive = 100;
    private volatile int minIdle = this.initialSize;
    private volatile int maxWait = 30000;
    private volatile String validationQuery;
    private volatile int validationQueryTimeout = -1;
    private volatile String validatorClassName;
    private volatile Validator validator;
    private volatile boolean testOnBorrow = false;
    private volatile boolean testOnReturn = false;
    private volatile boolean testWhileIdle = false;
    private volatile int timeBetweenEvictionRunsMillis = 5000;
    private volatile int numTestsPerEvictionRun;
    private volatile int minEvictableIdleTimeMillis = 60000;
    private volatile boolean accessToUnderlyingConnectionAllowed = true;
    private volatile boolean removeAbandoned = false;
    private volatile int removeAbandonedTimeout = 60;
    private volatile boolean logAbandoned = false;
    private volatile String name = "Tomcat Connection Pool[" + poolCounter.addAndGet(1) + "-" + System.identityHashCode(PoolProperties.class) + "]";
    private volatile String password;
    private volatile String username;
    private volatile long validationInterval = 30000L;
    private volatile boolean jmxEnabled = true;
    private volatile String initSQL;
    private volatile boolean testOnConnect = false;
    private volatile String jdbcInterceptors = null;
    private volatile boolean fairQueue = true;
    private volatile boolean useEquals = true;
    private volatile int abandonWhenPercentageFull = 0;
    private volatile long maxAge = 0L;
    private volatile boolean useLock = false;
    private volatile InterceptorDefinition[] interceptors = null;
    private volatile int suspectTimeout = 0;
    private volatile Object dataSource = null;
    private volatile String dataSourceJNDI = null;
    private volatile boolean alternateUsernameAllowed = false;
    private volatile boolean commitOnReturn = false;
    private volatile boolean rollbackOnReturn = false;
    private volatile boolean useDisposableConnectionFacade = true;
    private volatile boolean logValidationErrors = false;
    private volatile boolean propagateInterruptState = false;
    private volatile boolean ignoreExceptionOnPreLoad = false;

    public void setAbandonWhenPercentageFull(int n) {
        this.abandonWhenPercentageFull = n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    public int getAbandonWhenPercentageFull() {
        return this.abandonWhenPercentageFull;
    }

    public boolean isFairQueue() {
        return this.fairQueue;
    }

    public void setFairQueue(boolean bl) {
        this.fairQueue = bl;
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public Properties getDbProperties() {
        return this.dbProperties;
    }

    public Boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public Boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public String getName() {
        return this.name;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPoolName() {
        return this.getName();
    }

    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public int getRemoveAbandonedTimeout() {
        return this.removeAbandonedTimeout;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public int getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(int n) {
        this.validationQueryTimeout = n;
    }

    public String getValidatorClassName() {
        return this.validatorClassName;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
        this.validatorClassName = validator != null ? validator.getClass().getName() : null;
    }

    public long getValidationInterval() {
        return this.validationInterval;
    }

    public String getInitSQL() {
        return this.initSQL;
    }

    public boolean isTestOnConnect() {
        return this.testOnConnect;
    }

    public String getJdbcInterceptors() {
        return this.jdbcInterceptors;
    }

    public InterceptorDefinition[] getJdbcInterceptorsAsArray() {
        if (this.interceptors == null) {
            if (this.jdbcInterceptors == null) {
                this.interceptors = new InterceptorDefinition[0];
            } else {
                String[] stringArray = this.jdbcInterceptors.split(";");
                InterceptorDefinition[] interceptorDefinitionArray = new InterceptorDefinition[stringArray.length + 1];
                interceptorDefinitionArray[0] = new InterceptorDefinition(TrapException.class);
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].indexOf("(");
                    int n2 = stringArray[i].indexOf(")");
                    if (n < 0 || n2 < 0 || n2 <= n) {
                        interceptorDefinitionArray[i + 1] = new InterceptorDefinition(stringArray[i].trim());
                        continue;
                    }
                    String string = stringArray[i].substring(0, n).trim();
                    interceptorDefinitionArray[i + 1] = new InterceptorDefinition(string);
                    String string2 = stringArray[i].substring(n + 1, stringArray[i].length() - 1);
                    String[] stringArray2 = string2.split(",");
                    for (int j = 0; j < stringArray2.length; ++j) {
                        int n3 = stringArray2[j].indexOf("=");
                        String string3 = stringArray2[j].substring(0, n3).trim();
                        String string4 = stringArray2[j].substring(n3 + 1).trim();
                        interceptorDefinitionArray[i + 1].addProperty(new InterceptorProperty(string3, string4));
                    }
                }
                this.interceptors = interceptorDefinitionArray;
            }
        }
        return this.interceptors;
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean bl) {
    }

    public void setConnectionProperties(String string) {
        this.connectionProperties = string;
        PoolProperties.getProperties(string, this.getDbProperties());
    }

    public void setDbProperties(Properties properties) {
        this.dbProperties = properties;
    }

    public void setDefaultAutoCommit(Boolean bl) {
        this.defaultAutoCommit = bl;
    }

    public void setDefaultCatalog(String string) {
        this.defaultCatalog = string;
    }

    public void setDefaultReadOnly(Boolean bl) {
        this.defaultReadOnly = bl;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.defaultTransactionIsolation = n;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    public void setInitialSize(int n) {
        this.initialSize = n;
    }

    public void setLogAbandoned(boolean bl) {
        this.logAbandoned = bl;
    }

    public void setMaxActive(int n) {
        this.maxActive = n;
    }

    public void setMaxIdle(int n) {
        this.maxIdle = n;
    }

    public void setMaxWait(int n) {
        this.maxWait = n;
    }

    public void setMinEvictableIdleTimeMillis(int n) {
        this.minEvictableIdleTimeMillis = n;
    }

    public void setMinIdle(int n) {
        this.minIdle = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setRemoveAbandoned(boolean bl) {
        this.removeAbandoned = bl;
    }

    public void setRemoveAbandonedTimeout(int n) {
        this.removeAbandonedTimeout = n;
    }

    public void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
    }

    public void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
    }

    public void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
    }

    public void setTimeBetweenEvictionRunsMillis(int n) {
        this.timeBetweenEvictionRunsMillis = n;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setValidationInterval(long l) {
        this.validationInterval = l;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string;
    }

    public void setValidatorClassName(String string) {
        this.validatorClassName = string;
        this.validator = null;
        if (string == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(string);
            this.validator = (Validator)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.warn("The class " + string + " cannot be found.", classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            log.warn("The class " + string + " does not implement the Validator interface.", classCastException);
        }
        catch (InstantiationException instantiationException) {
            log.warn("An object of class " + string + " cannot be instantiated. Make sure that " + "it includes an implicit or explicit no-arg constructor.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn("The class " + string + " or its no-arg constructor are inaccessible.", illegalAccessException);
        }
    }

    public void setInitSQL(String string) {
        this.initSQL = string;
    }

    public void setTestOnConnect(boolean bl) {
        this.testOnConnect = bl;
    }

    public void setJdbcInterceptors(String string) {
        this.jdbcInterceptors = string;
        this.interceptors = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ConnectionPool[");
        try {
            String[] stringArray;
            block4: for (String string : stringArray = DataSourceFactory.ALL_PROPERTIES) {
                String[] stringArray2 = new String[]{"get", "is"};
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string2 = stringArray2[i] + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
                    Method method = null;
                    try {
                        method = this.getClass().getMethod(string2, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                    stringBuilder.append(string);
                    stringBuilder.append("=");
                    if ("password".equals(string)) {
                        stringBuilder.append("********");
                    } else {
                        stringBuilder.append(method.invoke((Object)this, new Object[0]));
                    }
                    stringBuilder.append("; ");
                    continue block4;
                }
            }
        }
        catch (Exception exception) {
            log.debug("toString() call failed", exception);
        }
        return stringBuilder.toString();
    }

    public static int getPoolCounter() {
        return poolCounter.get();
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean bl) {
        this.jmxEnabled = bl;
    }

    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public int getSuspectTimeout() {
        return this.suspectTimeout;
    }

    public void setSuspectTimeout(int n) {
        this.suspectTimeout = n;
    }

    public boolean isPoolSweeperEnabled() {
        boolean bl = this.getTimeBetweenEvictionRunsMillis() > 0;
        boolean bl2 = bl && this.isRemoveAbandoned() && this.getRemoveAbandonedTimeout() > 0;
        bl2 = bl2 || bl && this.getSuspectTimeout() > 0;
        bl2 = bl2 || bl && this.isTestWhileIdle() && this.getValidationQuery() != null;
        bl2 = bl2 || bl && this.getMinEvictableIdleTimeMillis() > 0;
        return bl2;
    }

    public boolean isUseEquals() {
        return this.useEquals;
    }

    public void setUseEquals(boolean bl) {
        this.useEquals = bl;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long l) {
        this.maxAge = l;
    }

    public boolean getUseLock() {
        return this.useLock;
    }

    public void setUseLock(boolean bl) {
        this.useLock = bl;
    }

    public void setDataSource(Object object) {
        this.dataSource = object;
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public void setDataSourceJNDI(String string) {
        this.dataSourceJNDI = string;
    }

    public String getDataSourceJNDI() {
        return this.dataSourceJNDI;
    }

    public static Properties getProperties(String string, Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        if (string != null) {
            try {
                properties.load(new ByteArrayInputStream(string.replace(';', '\n').getBytes()));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return properties;
    }

    public boolean isAlternateUsernameAllowed() {
        return this.alternateUsernameAllowed;
    }

    public void setAlternateUsernameAllowed(boolean bl) {
        this.alternateUsernameAllowed = bl;
    }

    public void setCommitOnReturn(boolean bl) {
        this.commitOnReturn = bl;
    }

    public boolean getCommitOnReturn() {
        return this.commitOnReturn;
    }

    public void setRollbackOnReturn(boolean bl) {
        this.rollbackOnReturn = bl;
    }

    public boolean getRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    public void setUseDisposableConnectionFacade(boolean bl) {
        this.useDisposableConnectionFacade = bl;
    }

    public boolean getUseDisposableConnectionFacade() {
        return this.useDisposableConnectionFacade;
    }

    public void setLogValidationErrors(boolean bl) {
        this.logValidationErrors = bl;
    }

    public boolean getLogValidationErrors() {
        return this.logValidationErrors;
    }

    public boolean getPropagateInterruptState() {
        return this.propagateInterruptState;
    }

    public void setPropagateInterruptState(boolean bl) {
        this.propagateInterruptState = bl;
    }

    public boolean isIgnoreExceptionOnPreLoad() {
        return this.ignoreExceptionOnPreLoad;
    }

    public void setIgnoreExceptionOnPreLoad(boolean bl) {
        this.ignoreExceptionOnPreLoad = bl;
    }

    protected Object clone() {
        return super.clone();
    }

    public static class InterceptorProperty {
        String name;
        String value;

        public InterceptorProperty(String string, String string2) {
            assert (string != null);
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean getValueAsBoolean(boolean bl) {
            if (this.value == null) {
                return bl;
            }
            if ("true".equals(this.value)) {
                return true;
            }
            if ("false".equals(this.value)) {
                return false;
            }
            return bl;
        }

        public int getValueAsInt(int n) {
            if (this.value == null) {
                return n;
            }
            try {
                int n2 = Integer.parseInt(this.value);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        public long getValueAsLong(long l) {
            if (this.value == null) {
                return l;
            }
            try {
                return Long.parseLong(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }

        public byte getValueAsByte(byte by) {
            if (this.value == null) {
                return by;
            }
            try {
                return Byte.parseByte(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                return by;
            }
        }

        public short getValueAsShort(short s) {
            if (this.value == null) {
                return s;
            }
            try {
                return Short.parseShort(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                return s;
            }
        }

        public float getValueAsFloat(float f) {
            if (this.value == null) {
                return f;
            }
            try {
                return Float.parseFloat(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }

        public double getValueAsDouble(double d) {
            if (this.value == null) {
                return d;
            }
            try {
                return Double.parseDouble(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                return d;
            }
        }

        public char getValueAschar(char c) {
            if (this.value == null) {
                return c;
            }
            try {
                return this.value.charAt(0);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return c;
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof InterceptorProperty) {
                InterceptorProperty interceptorProperty = (InterceptorProperty)object;
                return interceptorProperty.name.equals(this.name);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InterceptorDefinition {
        protected String className;
        protected Map<String, InterceptorProperty> properties = new HashMap<String, InterceptorProperty>();
        protected volatile Class<?> clazz = null;

        public InterceptorDefinition(String string) {
            this.className = string;
        }

        public InterceptorDefinition(Class<?> clazz) {
            this(clazz.getName());
            this.clazz = clazz;
        }

        public String getClassName() {
            return this.className;
        }

        public void addProperty(String string, String string2) {
            InterceptorProperty interceptorProperty = new InterceptorProperty(string, string2);
            this.addProperty(interceptorProperty);
        }

        public void addProperty(InterceptorProperty interceptorProperty) {
            this.properties.put(interceptorProperty.getName(), interceptorProperty);
        }

        public Map<String, InterceptorProperty> getProperties() {
            return this.properties;
        }

        public Class<? extends JdbcInterceptor> getInterceptorClass() {
            if (this.clazz == null) {
                if (this.getClassName().indexOf(".") < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Loading interceptor class:org.apache.tomcat.jdbc.pool.interceptor." + this.getClassName());
                    }
                    this.clazz = Class.forName("com.gmail.nossr50.database.tomcat.jdbc.pool.interceptor." + this.getClassName(), true, this.getClass().getClassLoader());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Loading interceptor class:" + this.getClassName());
                    }
                    this.clazz = Class.forName(this.getClassName(), true, this.getClass().getClassLoader());
                }
            }
            return this.clazz;
        }
    }
}

