/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLockFairBlockingQueue<E>
implements BlockingQueue<E> {
    final int LOCK_COUNT = Runtime.getRuntime().availableProcessors();
    final AtomicInteger putQueue = new AtomicInteger(0);
    final AtomicInteger pollQueue = new AtomicInteger(0);
    private final ReentrantLock[] locks = new ReentrantLock[this.LOCK_COUNT];
    final LinkedList<E>[] items = new LinkedList[this.LOCK_COUNT];
    final LinkedList<ExchangeCountDownLatch<E>>[] waiters = new LinkedList[this.LOCK_COUNT];

    public int getNextPut() {
        int n = Math.abs(this.putQueue.incrementAndGet()) % this.LOCK_COUNT;
        return n;
    }

    public int getNextPoll() {
        int n = Math.abs(this.pollQueue.incrementAndGet()) % this.LOCK_COUNT;
        return n;
    }

    public MultiLockFairBlockingQueue() {
        for (int i = 0; i < this.LOCK_COUNT; ++i) {
            this.items[i] = new LinkedList();
            this.waiters[i] = new LinkedList();
            this.locks[i] = new ReentrantLock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        int n = this.getNextPut();
        ReentrantLock reentrantLock = this.locks[n];
        reentrantLock.lock();
        ExchangeCountDownLatch<E> exchangeCountDownLatch = null;
        try {
            if (this.waiters[n].size() > 0) {
                exchangeCountDownLatch = this.waiters[n].poll();
                exchangeCountDownLatch.setItem(e);
            } else {
                this.items[n].addFirst(e);
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (exchangeCountDownLatch != null) {
            exchangeCountDownLatch.countDown();
        }
        return true;
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) {
        int n = this.getNextPoll();
        E e = null;
        ReentrantLock reentrantLock = this.locks[n];
        boolean bl = true;
        reentrantLock.lock();
        try {
            e = this.items[n].poll();
            if (e == null && l > 0L) {
                ExchangeCountDownLatch exchangeCountDownLatch = new ExchangeCountDownLatch(1);
                this.waiters[n].addLast(exchangeCountDownLatch);
                reentrantLock.unlock();
                if (!exchangeCountDownLatch.await(l, timeUnit)) {
                    reentrantLock.lock();
                    this.waiters[n].remove(exchangeCountDownLatch);
                    reentrantLock.unlock();
                }
                e = (E)exchangeCountDownLatch.getItem();
            } else {
                reentrantLock.unlock();
            }
            bl = false;
        }
        finally {
            if (bl && reentrantLock.isHeldByCurrentThread()) {
                reentrantLock.unlock();
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<E> pollAsync() {
        int n = this.getNextPoll();
        ItemFuture<Object> itemFuture = null;
        ReentrantLock reentrantLock = this.locks[n];
        boolean bl = true;
        reentrantLock.lock();
        try {
            E e = this.items[n].poll();
            if (e == null) {
                ExchangeCountDownLatch exchangeCountDownLatch = new ExchangeCountDownLatch(1);
                this.waiters[n].addLast(exchangeCountDownLatch);
                reentrantLock.unlock();
                itemFuture = new ItemFuture(exchangeCountDownLatch);
            } else {
                reentrantLock.unlock();
                itemFuture = new ItemFuture<E>(e);
            }
            bl = false;
        }
        finally {
            if (bl && reentrantLock.isHeldByCurrentThread()) {
                reentrantLock.unlock();
            }
        }
        return itemFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        for (int i = 0; i < this.LOCK_COUNT; ++i) {
            ReentrantLock reentrantLock = this.locks[i];
            reentrantLock.lock();
            try {
                boolean bl = this.items[i].remove(object);
                if (!bl) continue;
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                reentrantLock.unlock();
            }
        }
        return false;
    }

    @Override
    public int size() {
        int n = 0;
        for (int i = 0; i < this.LOCK_COUNT; ++i) {
            n += this.items[i].size();
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new FairIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        int n = this.getNextPoll();
        ReentrantLock reentrantLock = this.locks[n];
        reentrantLock.lock();
        try {
            E e = this.items[n].poll();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean contains(Object object) {
        for (int i = 0; i < this.LOCK_COUNT; ++i) {
            boolean bl = this.items[i].contains(object);
            if (!bl) continue;
            return bl;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        throw new UnsupportedOperationException("int drainTo(Collection<? super E> c, int maxElements)");
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE - this.size();
    }

    @Override
    public E take() {
        return this.poll(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        for (E e : collection) {
            this.offer(e);
        }
        return true;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("void clear()");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException("boolean containsAll(Collection<?> c)");
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("boolean removeAll(Collection<?> c)");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("boolean retainAll(Collection<?> c)");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Object[] toArray()");
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        throw new UnsupportedOperationException("<T> T[] toArray(T[] a)");
    }

    @Override
    public E element() {
        throw new UnsupportedOperationException("E element()");
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException("E peek()");
    }

    @Override
    public E remove() {
        throw new UnsupportedOperationException("E remove()");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FairIterator
    implements Iterator<E> {
        E[] elements = null;
        int index;
        E element = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FairIterator() {
            ArrayList arrayList = new ArrayList(MultiLockFairBlockingQueue.this.size());
            for (int i = 0; i < MultiLockFairBlockingQueue.this.LOCK_COUNT; ++i) {
                ReentrantLock reentrantLock = MultiLockFairBlockingQueue.this.locks[i];
                reentrantLock.lock();
                try {
                    this.elements = new Object[MultiLockFairBlockingQueue.this.items[i].size()];
                    MultiLockFairBlockingQueue.this.items[i].toArray(this.elements);
                    continue;
                }
                finally {
                    reentrantLock.unlock();
                }
            }
            this.index = 0;
            this.elements = new Object[arrayList.size()];
            arrayList.toArray(this.elements);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.elements.length;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element = this.elements[this.index++];
            return this.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            for (int i = 0; i < MultiLockFairBlockingQueue.this.LOCK_COUNT; ++i) {
                ReentrantLock reentrantLock = MultiLockFairBlockingQueue.this.locks[i];
                reentrantLock.lock();
                try {
                    boolean bl = MultiLockFairBlockingQueue.this.items[i].remove(this.elements[this.index]);
                    if (!bl) continue;
                    break;
                }
                finally {
                    reentrantLock.unlock();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExchangeCountDownLatch<T>
    extends CountDownLatch {
        protected volatile T item;

        public ExchangeCountDownLatch(int n) {
            super(n);
        }

        public T getItem() {
            return this.item;
        }

        public void setItem(T t) {
            this.item = t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ItemFuture<T>
    implements Future<T> {
        protected volatile T item = null;
        protected volatile ExchangeCountDownLatch<T> latch = null;
        protected volatile boolean canceled = false;

        public ItemFuture(T t) {
            this.item = t;
        }

        public ItemFuture(ExchangeCountDownLatch<T> exchangeCountDownLatch) {
            this.latch = exchangeCountDownLatch;
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public T get() {
            if (this.item != null) {
                return this.item;
            }
            if (this.latch != null) {
                this.latch.await();
                return this.latch.getItem();
            }
            throw new ExecutionException("ItemFuture incorrectly instantiated. Bug in the code?", new Exception());
        }

        @Override
        public T get(long l, TimeUnit timeUnit) {
            if (this.item != null) {
                return this.item;
            }
            if (this.latch != null) {
                boolean bl;
                boolean bl2 = bl = !this.latch.await(l, timeUnit);
                if (bl) {
                    throw new TimeoutException();
                }
                return this.latch.getItem();
            }
            throw new ExecutionException("ItemFuture incorrectly instantiated. Bug in the code?", new Exception());
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.item != null || this.latch.getItem() != null;
        }
    }
}

