/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FairBlockingQueue<E>
implements BlockingQueue<E> {
    static final boolean isLinux = "Linux".equals(System.getProperty("os.name")) && !Boolean.getBoolean(FairBlockingQueue.class.getName() + ".ignoreOS");
    final ReentrantLock lock = new ReentrantLock(false);
    final LinkedList<E> items = new LinkedList();
    final LinkedList<ExchangeCountDownLatch<E>> waiters = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        ExchangeCountDownLatch<E> exchangeCountDownLatch = null;
        try {
            if (this.waiters.size() > 0) {
                exchangeCountDownLatch = this.waiters.poll();
                exchangeCountDownLatch.setItem(e);
                if (isLinux) {
                    exchangeCountDownLatch.countDown();
                }
            } else {
                this.items.addFirst(e);
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (!isLinux && exchangeCountDownLatch != null) {
            exchangeCountDownLatch.countDown();
        }
        return true;
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) {
        E e = null;
        ReentrantLock reentrantLock = this.lock;
        boolean bl = true;
        reentrantLock.lock();
        try {
            e = this.items.poll();
            if (e == null && l > 0L) {
                ExchangeCountDownLatch exchangeCountDownLatch = new ExchangeCountDownLatch(1);
                this.waiters.addLast(exchangeCountDownLatch);
                reentrantLock.unlock();
                if (!exchangeCountDownLatch.await(l, timeUnit)) {
                    reentrantLock.lock();
                    this.waiters.remove(exchangeCountDownLatch);
                    reentrantLock.unlock();
                }
                e = (E)exchangeCountDownLatch.getItem();
            } else {
                reentrantLock.unlock();
            }
            bl = false;
        }
        finally {
            if (bl && reentrantLock.isHeldByCurrentThread()) {
                reentrantLock.unlock();
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<E> pollAsync() {
        ItemFuture<Object> itemFuture = null;
        ReentrantLock reentrantLock = this.lock;
        boolean bl = true;
        reentrantLock.lock();
        try {
            E e = this.items.poll();
            if (e == null) {
                ExchangeCountDownLatch exchangeCountDownLatch = new ExchangeCountDownLatch(1);
                this.waiters.addLast(exchangeCountDownLatch);
                reentrantLock.unlock();
                itemFuture = new ItemFuture(exchangeCountDownLatch);
            } else {
                reentrantLock.unlock();
                itemFuture = new ItemFuture<E>(e);
            }
            bl = false;
        }
        finally {
            if (bl && reentrantLock.isHeldByCurrentThread()) {
                reentrantLock.unlock();
            }
        }
        return itemFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.items.remove(object);
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public Iterator<E> iterator() {
        return new FairIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.items.poll();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.items.contains(object);
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        throw new UnsupportedOperationException("int drainTo(Collection<? super E> c, int maxElements)");
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE - this.size();
    }

    @Override
    public E take() {
        return this.poll(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        for (E e : collection) {
            this.offer(e);
        }
        return true;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("void clear()");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException("boolean containsAll(Collection<?> c)");
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("boolean removeAll(Collection<?> c)");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("boolean retainAll(Collection<?> c)");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Object[] toArray()");
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        throw new UnsupportedOperationException("<T> T[] toArray(T[] a)");
    }

    @Override
    public E element() {
        throw new UnsupportedOperationException("E element()");
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException("E peek()");
    }

    @Override
    public E remove() {
        throw new UnsupportedOperationException("E remove()");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FairIterator
    implements Iterator<E> {
        E[] elements = null;
        int index;
        E element = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FairIterator() {
            ReentrantLock reentrantLock = FairBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                this.elements = new Object[FairBlockingQueue.this.items.size()];
                FairBlockingQueue.this.items.toArray(this.elements);
                this.index = 0;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.elements.length;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element = this.elements[this.index++];
            return this.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock reentrantLock = FairBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                if (this.element != null) {
                    FairBlockingQueue.this.items.remove(this.element);
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExchangeCountDownLatch<T>
    extends CountDownLatch {
        protected volatile T item;

        public ExchangeCountDownLatch(int n) {
            super(n);
        }

        public T getItem() {
            return this.item;
        }

        public void setItem(T t) {
            this.item = t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ItemFuture<T>
    implements Future<T> {
        protected volatile T item = null;
        protected volatile ExchangeCountDownLatch<T> latch = null;
        protected volatile boolean canceled = false;

        public ItemFuture(T t) {
            this.item = t;
        }

        public ItemFuture(ExchangeCountDownLatch<T> exchangeCountDownLatch) {
            this.latch = exchangeCountDownLatch;
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public T get() {
            if (this.item != null) {
                return this.item;
            }
            if (this.latch != null) {
                this.latch.await();
                return this.latch.getItem();
            }
            throw new ExecutionException("ItemFuture incorrectly instantiated. Bug in the code?", new Exception());
        }

        @Override
        public T get(long l, TimeUnit timeUnit) {
            if (this.item != null) {
                return this.item;
            }
            if (this.latch != null) {
                boolean bl;
                boolean bl2 = bl = !this.latch.await(l, timeUnit);
                if (bl) {
                    throw new TimeoutException();
                }
                return this.latch.getItem();
            }
            throw new ExecutionException("ItemFuture incorrectly instantiated. Bug in the code?", new Exception());
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.item != null || this.latch.getItem() != null;
        }
    }
}

