/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool;

import com.gmail.nossr50.database.tomcat.jdbc.pool.ConnectionPool;
import com.gmail.nossr50.database.tomcat.jdbc.pool.DataSourceFactory;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolConfiguration;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.database.tomcat.jdbc.pool.Validator;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceProxy
implements PoolConfiguration {
    private static final Log log = LogFactory.getLog(DataSourceProxy.class);
    protected volatile ConnectionPool pool = null;
    protected volatile PoolConfiguration poolProperties = null;

    public DataSourceProxy() {
        this(new PoolProperties());
    }

    public DataSourceProxy(PoolConfiguration poolConfiguration) {
        if (poolConfiguration == null) {
            throw new NullPointerException("PoolConfiguration can not be null.");
        }
        this.poolProperties = poolConfiguration;
    }

    public boolean isWrapperFor(Class<?> clazz) {
        return false;
    }

    public <T> T unwrap(Class<T> clazz) {
        return null;
    }

    public Connection getConnection(String string, String string2) {
        if (this.getPoolProperties().isAlternateUsernameAllowed()) {
            if (this.pool == null) {
                return this.createPool().getConnection(string, string2);
            }
            return this.pool.getConnection(string, string2);
        }
        return this.getConnection();
    }

    public PoolConfiguration getPoolProperties() {
        return this.poolProperties;
    }

    public ConnectionPool createPool() {
        if (this.pool != null) {
            return this.pool;
        }
        return this.pCreatePool();
    }

    private synchronized ConnectionPool pCreatePool() {
        if (this.pool != null) {
            return this.pool;
        }
        this.pool = new ConnectionPool(this.poolProperties);
        return this.pool;
    }

    public Connection getConnection() {
        if (this.pool == null) {
            return this.createPool().getConnection();
        }
        return this.pool.getConnection();
    }

    public Future<Connection> getConnectionAsync() {
        if (this.pool == null) {
            return this.createPool().getConnectionAsync();
        }
        return this.pool.getConnectionAsync();
    }

    public XAConnection getXAConnection() {
        Connection connection = this.getConnection();
        if (connection instanceof XAConnection) {
            return (XAConnection)((Object)connection);
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SQLException("Connection from pool does not implement javax.sql.XAConnection");
    }

    public XAConnection getXAConnection(String string, String string2) {
        Connection connection = this.getConnection(string, string2);
        if (connection instanceof XAConnection) {
            return (XAConnection)((Object)connection);
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SQLException("Connection from pool does not implement javax.sql.XAConnection");
    }

    public PooledConnection getPooledConnection() {
        return (PooledConnection)((Object)this.getConnection());
    }

    public PooledConnection getPooledConnection(String string, String string2) {
        return (PooledConnection)((Object)this.getConnection());
    }

    public ConnectionPool getPool() {
        return this.pool;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean bl) {
        try {
            if (this.pool != null) {
                ConnectionPool connectionPool = this.pool;
                this.pool = null;
                if (connectionPool != null) {
                    connectionPool.close(bl);
                }
            }
        }
        catch (Exception exception) {
            log.warn("Error duing connection pool closure.", exception);
        }
    }

    public int getPoolSize() {
        ConnectionPool connectionPool = this.pool;
        if (connectionPool == null) {
            return 0;
        }
        return connectionPool.getSize();
    }

    public String toString() {
        return super.toString() + "{" + this.getPoolProperties() + "}";
    }

    @Override
    public String getPoolName() {
        return this.pool.getName();
    }

    public void setPoolProperties(PoolConfiguration poolConfiguration) {
        this.poolProperties = poolConfiguration;
    }

    @Override
    public void setDriverClassName(String string) {
        this.poolProperties.setDriverClassName(string);
    }

    @Override
    public void setInitialSize(int n) {
        this.poolProperties.setInitialSize(n);
    }

    @Override
    public void setInitSQL(String string) {
        this.poolProperties.setInitSQL(string);
    }

    @Override
    public void setLogAbandoned(boolean bl) {
        this.poolProperties.setLogAbandoned(bl);
    }

    @Override
    public void setMaxActive(int n) {
        this.poolProperties.setMaxActive(n);
    }

    @Override
    public void setMaxIdle(int n) {
        this.poolProperties.setMaxIdle(n);
    }

    @Override
    public void setMaxWait(int n) {
        this.poolProperties.setMaxWait(n);
    }

    @Override
    public void setMinEvictableIdleTimeMillis(int n) {
        this.poolProperties.setMinEvictableIdleTimeMillis(n);
    }

    @Override
    public void setMinIdle(int n) {
        this.poolProperties.setMinIdle(n);
    }

    @Override
    public void setNumTestsPerEvictionRun(int n) {
        this.poolProperties.setNumTestsPerEvictionRun(n);
    }

    @Override
    public void setPassword(String string) {
        this.poolProperties.setPassword(string);
        this.poolProperties.getDbProperties().setProperty("password", this.poolProperties.getPassword());
    }

    @Override
    public void setRemoveAbandoned(boolean bl) {
        this.poolProperties.setRemoveAbandoned(bl);
    }

    @Override
    public void setRemoveAbandonedTimeout(int n) {
        this.poolProperties.setRemoveAbandonedTimeout(n);
    }

    @Override
    public void setTestOnBorrow(boolean bl) {
        this.poolProperties.setTestOnBorrow(bl);
    }

    @Override
    public void setTestOnConnect(boolean bl) {
        this.poolProperties.setTestOnConnect(bl);
    }

    @Override
    public void setTestOnReturn(boolean bl) {
        this.poolProperties.setTestOnReturn(bl);
    }

    @Override
    public void setTestWhileIdle(boolean bl) {
        this.poolProperties.setTestWhileIdle(bl);
    }

    @Override
    public void setTimeBetweenEvictionRunsMillis(int n) {
        this.poolProperties.setTimeBetweenEvictionRunsMillis(n);
    }

    @Override
    public void setUrl(String string) {
        this.poolProperties.setUrl(string);
    }

    @Override
    public void setUsername(String string) {
        this.poolProperties.setUsername(string);
        this.poolProperties.getDbProperties().setProperty("user", this.getPoolProperties().getUsername());
    }

    @Override
    public void setValidationInterval(long l) {
        this.poolProperties.setValidationInterval(l);
    }

    @Override
    public void setValidationQuery(String string) {
        this.poolProperties.setValidationQuery(string);
    }

    @Override
    public void setValidatorClassName(String string) {
        this.poolProperties.setValidatorClassName(string);
    }

    @Override
    public void setValidationQueryTimeout(int n) {
        this.poolProperties.setValidationQueryTimeout(n);
    }

    @Override
    public void setJdbcInterceptors(String string) {
        this.getPoolProperties().setJdbcInterceptors(string);
    }

    @Override
    public void setJmxEnabled(boolean bl) {
        this.getPoolProperties().setJmxEnabled(bl);
    }

    @Override
    public void setFairQueue(boolean bl) {
        this.getPoolProperties().setFairQueue(bl);
    }

    @Override
    public void setUseLock(boolean bl) {
        this.getPoolProperties().setUseLock(bl);
    }

    @Override
    public void setDefaultCatalog(String string) {
        this.getPoolProperties().setDefaultCatalog(string);
    }

    @Override
    public void setDefaultAutoCommit(Boolean bl) {
        this.getPoolProperties().setDefaultAutoCommit(bl);
    }

    @Override
    public void setDefaultTransactionIsolation(int n) {
        this.getPoolProperties().setDefaultTransactionIsolation(n);
    }

    @Override
    public void setConnectionProperties(String string) {
        try {
            Properties properties = DataSourceFactory.getProperties(string);
            for (String string2 : properties.keySet()) {
                String string3 = properties.getProperty(string2);
                this.getPoolProperties().getDbProperties().setProperty(string2, string3);
            }
        }
        catch (Exception exception) {
            log.error("Unable to parse connection properties.", exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void setUseEquals(boolean bl) {
        this.getPoolProperties().setUseEquals(bl);
    }

    public Logger getParentLogger() {
        throw new SQLFeatureNotSupportedException();
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) {
    }

    public int getLoginTimeout() {
        if (this.poolProperties == null) {
            return 0;
        }
        return this.poolProperties.getMaxWait() / 1000;
    }

    public void setLoginTimeout(int n) {
        if (this.poolProperties == null) {
            return;
        }
        this.poolProperties.setMaxWait(1000 * n);
    }

    @Override
    public int getSuspectTimeout() {
        return this.getPoolProperties().getSuspectTimeout();
    }

    @Override
    public void setSuspectTimeout(int n) {
        this.getPoolProperties().setSuspectTimeout(n);
    }

    public int getIdle() {
        try {
            return this.createPool().getIdle();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public int getNumIdle() {
        return this.getIdle();
    }

    public void checkAbandoned() {
        try {
            this.createPool().checkAbandoned();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public void checkIdle() {
        try {
            this.createPool().checkIdle();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public int getActive() {
        try {
            return this.createPool().getActive();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public int getNumActive() {
        return this.getActive();
    }

    public int getWaitCount() {
        try {
            return this.createPool().getWaitCount();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public int getSize() {
        try {
            return this.createPool().getSize();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public void testIdle() {
        try {
            this.createPool().testAllIdle();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    @Override
    public String getConnectionProperties() {
        return this.getPoolProperties().getConnectionProperties();
    }

    @Override
    public Properties getDbProperties() {
        return this.getPoolProperties().getDbProperties();
    }

    @Override
    public String getDefaultCatalog() {
        return this.getPoolProperties().getDefaultCatalog();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.getPoolProperties().getDefaultTransactionIsolation();
    }

    @Override
    public String getDriverClassName() {
        return this.getPoolProperties().getDriverClassName();
    }

    @Override
    public int getInitialSize() {
        return this.getPoolProperties().getInitialSize();
    }

    @Override
    public String getInitSQL() {
        return this.getPoolProperties().getInitSQL();
    }

    @Override
    public String getJdbcInterceptors() {
        return this.getPoolProperties().getJdbcInterceptors();
    }

    @Override
    public int getMaxActive() {
        return this.getPoolProperties().getMaxActive();
    }

    @Override
    public int getMaxIdle() {
        return this.getPoolProperties().getMaxIdle();
    }

    @Override
    public int getMaxWait() {
        return this.getPoolProperties().getMaxWait();
    }

    @Override
    public int getMinEvictableIdleTimeMillis() {
        return this.getPoolProperties().getMinEvictableIdleTimeMillis();
    }

    @Override
    public int getMinIdle() {
        return this.getPoolProperties().getMinIdle();
    }

    @Override
    public long getMaxAge() {
        return this.getPoolProperties().getMaxAge();
    }

    @Override
    public String getName() {
        return this.getPoolProperties().getName();
    }

    @Override
    public int getNumTestsPerEvictionRun() {
        return this.getPoolProperties().getNumTestsPerEvictionRun();
    }

    @Override
    public String getPassword() {
        return "Password not available as DataSource/JMX operation.";
    }

    @Override
    public int getRemoveAbandonedTimeout() {
        return this.getPoolProperties().getRemoveAbandonedTimeout();
    }

    @Override
    public int getTimeBetweenEvictionRunsMillis() {
        return this.getPoolProperties().getTimeBetweenEvictionRunsMillis();
    }

    @Override
    public String getUrl() {
        return this.getPoolProperties().getUrl();
    }

    @Override
    public String getUsername() {
        return this.getPoolProperties().getUsername();
    }

    @Override
    public long getValidationInterval() {
        return this.getPoolProperties().getValidationInterval();
    }

    @Override
    public String getValidationQuery() {
        return this.getPoolProperties().getValidationQuery();
    }

    @Override
    public int getValidationQueryTimeout() {
        return this.getPoolProperties().getValidationQueryTimeout();
    }

    @Override
    public String getValidatorClassName() {
        return this.getPoolProperties().getValidatorClassName();
    }

    @Override
    public Validator getValidator() {
        return this.getPoolProperties().getValidator();
    }

    @Override
    public void setValidator(Validator validator) {
        this.getPoolProperties().setValidator(validator);
    }

    @Override
    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.getPoolProperties().isAccessToUnderlyingConnectionAllowed();
    }

    @Override
    public Boolean isDefaultAutoCommit() {
        return this.getPoolProperties().isDefaultAutoCommit();
    }

    @Override
    public Boolean isDefaultReadOnly() {
        return this.getPoolProperties().isDefaultReadOnly();
    }

    @Override
    public boolean isLogAbandoned() {
        return this.getPoolProperties().isLogAbandoned();
    }

    @Override
    public boolean isPoolSweeperEnabled() {
        return this.getPoolProperties().isPoolSweeperEnabled();
    }

    @Override
    public boolean isRemoveAbandoned() {
        return this.getPoolProperties().isRemoveAbandoned();
    }

    @Override
    public int getAbandonWhenPercentageFull() {
        return this.getPoolProperties().getAbandonWhenPercentageFull();
    }

    @Override
    public boolean isTestOnBorrow() {
        return this.getPoolProperties().isTestOnBorrow();
    }

    @Override
    public boolean isTestOnConnect() {
        return this.getPoolProperties().isTestOnConnect();
    }

    @Override
    public boolean isTestOnReturn() {
        return this.getPoolProperties().isTestOnReturn();
    }

    @Override
    public boolean isTestWhileIdle() {
        return this.getPoolProperties().isTestWhileIdle();
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return this.getPoolProperties().getDefaultAutoCommit();
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.getPoolProperties().getDefaultReadOnly();
    }

    @Override
    public PoolProperties.InterceptorDefinition[] getJdbcInterceptorsAsArray() {
        return this.getPoolProperties().getJdbcInterceptorsAsArray();
    }

    @Override
    public boolean getUseLock() {
        return this.getPoolProperties().getUseLock();
    }

    @Override
    public boolean isFairQueue() {
        return this.getPoolProperties().isFairQueue();
    }

    @Override
    public boolean isJmxEnabled() {
        return this.getPoolProperties().isJmxEnabled();
    }

    @Override
    public boolean isUseEquals() {
        return this.getPoolProperties().isUseEquals();
    }

    @Override
    public void setAbandonWhenPercentageFull(int n) {
        this.getPoolProperties().setAbandonWhenPercentageFull(n);
    }

    @Override
    public void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.getPoolProperties().setAccessToUnderlyingConnectionAllowed(bl);
    }

    @Override
    public void setDbProperties(Properties properties) {
        this.getPoolProperties().setDbProperties(properties);
    }

    @Override
    public void setDefaultReadOnly(Boolean bl) {
        this.getPoolProperties().setDefaultReadOnly(bl);
    }

    @Override
    public void setMaxAge(long l) {
        this.getPoolProperties().setMaxAge(l);
    }

    @Override
    public void setName(String string) {
        this.getPoolProperties().setName(string);
    }

    @Override
    public void setDataSource(Object object) {
        this.getPoolProperties().setDataSource(object);
    }

    @Override
    public Object getDataSource() {
        return this.getPoolProperties().getDataSource();
    }

    @Override
    public void setDataSourceJNDI(String string) {
        this.getPoolProperties().setDataSourceJNDI(string);
    }

    @Override
    public String getDataSourceJNDI() {
        return this.getPoolProperties().getDataSourceJNDI();
    }

    @Override
    public boolean isAlternateUsernameAllowed() {
        return this.getPoolProperties().isAlternateUsernameAllowed();
    }

    @Override
    public void setAlternateUsernameAllowed(boolean bl) {
        this.getPoolProperties().setAlternateUsernameAllowed(bl);
    }

    @Override
    public void setCommitOnReturn(boolean bl) {
        this.getPoolProperties().setCommitOnReturn(bl);
    }

    @Override
    public boolean getCommitOnReturn() {
        return this.getPoolProperties().getCommitOnReturn();
    }

    @Override
    public void setRollbackOnReturn(boolean bl) {
        this.getPoolProperties().setRollbackOnReturn(bl);
    }

    @Override
    public boolean getRollbackOnReturn() {
        return this.getPoolProperties().getRollbackOnReturn();
    }

    @Override
    public void setUseDisposableConnectionFacade(boolean bl) {
        this.getPoolProperties().setUseDisposableConnectionFacade(bl);
    }

    @Override
    public boolean getUseDisposableConnectionFacade() {
        return this.getPoolProperties().getUseDisposableConnectionFacade();
    }

    @Override
    public void setLogValidationErrors(boolean bl) {
        this.getPoolProperties().setLogValidationErrors(bl);
    }

    @Override
    public boolean getLogValidationErrors() {
        return this.getPoolProperties().getLogValidationErrors();
    }

    @Override
    public boolean getPropagateInterruptState() {
        return this.getPoolProperties().getPropagateInterruptState();
    }

    @Override
    public void setPropagateInterruptState(boolean bl) {
        this.getPoolProperties().setPropagateInterruptState(bl);
    }

    @Override
    public boolean isIgnoreExceptionOnPreLoad() {
        return this.getPoolProperties().isIgnoreExceptionOnPreLoad();
    }

    @Override
    public void setIgnoreExceptionOnPreLoad(boolean bl) {
        this.getPoolProperties().setIgnoreExceptionOnPreLoad(bl);
    }

    public void purge() {
        try {
            this.createPool().purge();
        }
        catch (SQLException sQLException) {
            log.error("Unable to purge pool.", sQLException);
        }
    }

    public void purgeOnReturn() {
        try {
            this.createPool().purgeOnReturn();
        }
        catch (SQLException sQLException) {
            log.error("Unable to purge pool.", sQLException);
        }
    }
}

