/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool;

import com.gmail.nossr50.database.tomcat.jdbc.pool.DataSource;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolConfiguration;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.database.tomcat.jdbc.pool.XADataSource;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(DataSourceFactory.class);
    protected static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    protected static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    protected static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    protected static final String PROP_DEFAULTCATALOG = "defaultCatalog";
    protected static final String PROP_DRIVERCLASSNAME = "driverClassName";
    protected static final String PROP_PASSWORD = "password";
    protected static final String PROP_URL = "url";
    protected static final String PROP_USERNAME = "username";
    protected static final String PROP_MAXACTIVE = "maxActive";
    protected static final String PROP_MAXIDLE = "maxIdle";
    protected static final String PROP_MINIDLE = "minIdle";
    protected static final String PROP_INITIALSIZE = "initialSize";
    protected static final String PROP_MAXWAIT = "maxWait";
    protected static final String PROP_MAXAGE = "maxAge";
    protected static final String PROP_TESTONBORROW = "testOnBorrow";
    protected static final String PROP_TESTONRETURN = "testOnReturn";
    protected static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    protected static final String PROP_TESTONCONNECT = "testOnConnect";
    protected static final String PROP_VALIDATIONQUERY = "validationQuery";
    protected static final String PROP_VALIDATIONQUERY_TIMEOUT = "validationQueryTimeout";
    protected static final String PROP_VALIDATOR_CLASS_NAME = "validatorClassName";
    protected static final String PROP_NUMTESTSPEREVICTIONRUN = "numTestsPerEvictionRun";
    protected static final String PROP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    protected static final String PROP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    protected static final String PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED = "accessToUnderlyingConnectionAllowed";
    protected static final String PROP_REMOVEABANDONED = "removeAbandoned";
    protected static final String PROP_REMOVEABANDONEDTIMEOUT = "removeAbandonedTimeout";
    protected static final String PROP_LOGABANDONED = "logAbandoned";
    protected static final String PROP_ABANDONWHENPERCENTAGEFULL = "abandonWhenPercentageFull";
    protected static final String PROP_POOLPREPAREDSTATEMENTS = "poolPreparedStatements";
    protected static final String PROP_MAXOPENPREPAREDSTATEMENTS = "maxOpenPreparedStatements";
    protected static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";
    protected static final String PROP_INITSQL = "initSQL";
    protected static final String PROP_INTERCEPTORS = "jdbcInterceptors";
    protected static final String PROP_VALIDATIONINTERVAL = "validationInterval";
    protected static final String PROP_JMX_ENABLED = "jmxEnabled";
    protected static final String PROP_FAIR_QUEUE = "fairQueue";
    protected static final String PROP_USE_EQUALS = "useEquals";
    protected static final String PROP_USE_CON_LOCK = "useLock";
    protected static final String PROP_DATASOURCE = "dataSource";
    protected static final String PROP_DATASOURCE_JNDI = "dataSourceJNDI";
    protected static final String PROP_SUSPECT_TIMEOUT = "suspectTimeout";
    protected static final String PROP_ALTERNATE_USERNAME_ALLOWED = "alternateUsernameAllowed";
    protected static final String PROP_COMMITONRETURN = "commitOnReturn";
    protected static final String PROP_ROLLBACKONRETURN = "rollbackOnReturn";
    protected static final String PROP_USEDISPOSABLECONNECTIONFACADE = "useDisposableConnectionFacade";
    protected static final String PROP_LOGVALIDATIONERRORS = "logValidationErrors";
    protected static final String PROP_PROPAGATEINTERRUPTSTATE = "propagateInterruptState";
    protected static final String PROP_IGNOREEXCEPTIONONPRELOAD = "ignoreExceptionOnPreLoad";
    public static final int UNKNOWN_TRANSACTIONISOLATION = -1;
    public static final String OBJECT_NAME = "object_name";
    protected static final String[] ALL_PROPERTIES = new String[]{"defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "driverClassName", "maxActive", "maxIdle", "minIdle", "initialSize", "maxWait", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "testWhileIdle", "testOnConnect", "password", "url", "username", "validationQuery", "validationQueryTimeout", "validatorClassName", "validationInterval", "accessToUnderlyingConnectionAllowed", "removeAbandoned", "removeAbandonedTimeout", "logAbandoned", "poolPreparedStatements", "maxOpenPreparedStatements", "connectionProperties", "initSQL", "jdbcInterceptors", "jmxEnabled", "fairQueue", "useEquals", "object_name", "abandonWhenPercentageFull", "maxAge", "useLock", "dataSource", "dataSourceJNDI", "suspectTimeout", "alternateUsernameAllowed", "commitOnReturn", "rollbackOnReturn", "useDisposableConnectionFacade", "logValidationErrors", "propagateInterruptState", "ignoreExceptionOnPreLoad"};

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) {
        if (object == null || !(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        boolean bl = false;
        boolean bl2 = false;
        if ("javax.sql.DataSource".equals(reference.getClassName())) {
            bl2 = true;
        }
        if ("javax.sql.XADataSource".equals(reference.getClassName())) {
            bl2 = true;
            bl = true;
        }
        if (DataSource.class.getName().equals(reference.getClassName())) {
            bl2 = true;
        }
        if (!bl2) {
            log.warn(reference.getClassName() + " is not a valid class name/type for this JNDI factory.");
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < ALL_PROPERTIES.length; ++i) {
            String string = ALL_PROPERTIES[i];
            RefAddr refAddr = reference.get(string);
            if (refAddr == null) continue;
            String string2 = refAddr.getContent().toString();
            properties.setProperty(string, string2);
        }
        return this.createDataSource(properties, context, bl);
    }

    public static PoolConfiguration parsePoolProperties(Properties properties) {
        PoolProperties poolProperties = new PoolProperties();
        String string = null;
        string = properties.getProperty(PROP_DEFAULTAUTOCOMMIT);
        if (string != null) {
            poolProperties.setDefaultAutoCommit(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_DEFAULTREADONLY)) != null) {
            poolProperties.setDefaultReadOnly(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_DEFAULTTRANSACTIONISOLATION)) != null) {
            int n = -1;
            if ("NONE".equalsIgnoreCase(string)) {
                n = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(string)) {
                n = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(string)) {
                n = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(string)) {
                n = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(string)) {
                n = 8;
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Could not parse defaultTransactionIsolation: " + string);
                    System.err.println("WARNING: defaultTransactionIsolation not set");
                    System.err.println("using default value of database driver");
                    n = -1;
                }
            }
            poolProperties.setDefaultTransactionIsolation(n);
        }
        if ((string = properties.getProperty(PROP_DEFAULTCATALOG)) != null) {
            poolProperties.setDefaultCatalog(string);
        }
        if ((string = properties.getProperty(PROP_DRIVERCLASSNAME)) != null) {
            poolProperties.setDriverClassName(string);
        }
        if ((string = properties.getProperty(PROP_MAXACTIVE)) != null) {
            poolProperties.setMaxActive(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MAXIDLE)) != null) {
            poolProperties.setMaxIdle(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MINIDLE)) != null) {
            poolProperties.setMinIdle(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_INITIALSIZE)) != null) {
            poolProperties.setInitialSize(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MAXWAIT)) != null) {
            poolProperties.setMaxWait(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_TESTONBORROW)) != null) {
            poolProperties.setTestOnBorrow(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_TESTONRETURN)) != null) {
            poolProperties.setTestOnReturn(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_TESTONCONNECT)) != null) {
            poolProperties.setTestOnConnect(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_TIMEBETWEENEVICTIONRUNSMILLIS)) != null) {
            poolProperties.setTimeBetweenEvictionRunsMillis(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_NUMTESTSPEREVICTIONRUN)) != null) {
            poolProperties.setNumTestsPerEvictionRun(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MINEVICTABLEIDLETIMEMILLIS)) != null) {
            poolProperties.setMinEvictableIdleTimeMillis(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_TESTWHILEIDLE)) != null) {
            poolProperties.setTestWhileIdle(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_PASSWORD)) != null) {
            poolProperties.setPassword(string);
        }
        if ((string = properties.getProperty(PROP_URL)) != null) {
            poolProperties.setUrl(string);
        }
        if ((string = properties.getProperty(PROP_USERNAME)) != null) {
            poolProperties.setUsername(string);
        }
        if ((string = properties.getProperty(PROP_VALIDATIONQUERY)) != null) {
            poolProperties.setValidationQuery(string);
        }
        if ((string = properties.getProperty(PROP_VALIDATIONQUERY_TIMEOUT)) != null) {
            poolProperties.setValidationQueryTimeout(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_VALIDATOR_CLASS_NAME)) != null) {
            poolProperties.setValidatorClassName(string);
        }
        if ((string = properties.getProperty(PROP_VALIDATIONINTERVAL)) != null) {
            poolProperties.setValidationInterval(Long.parseLong(string));
        }
        if ((string = properties.getProperty(PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED)) != null) {
            poolProperties.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_REMOVEABANDONED)) != null) {
            poolProperties.setRemoveAbandoned(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_REMOVEABANDONEDTIMEOUT)) != null) {
            poolProperties.setRemoveAbandonedTimeout(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_LOGABANDONED)) != null) {
            poolProperties.setLogAbandoned(Boolean.valueOf(string));
        }
        if ((string = properties.getProperty(PROP_POOLPREPAREDSTATEMENTS)) != null) {
            log.warn("poolPreparedStatements is not a valid setting, it will have no effect.");
        }
        if ((string = properties.getProperty(PROP_MAXOPENPREPAREDSTATEMENTS)) != null) {
            log.warn("maxOpenPreparedStatements is not a valid setting, it will have no effect.");
        }
        if ((string = properties.getProperty(PROP_CONNECTIONPROPERTIES)) != null) {
            Properties properties2 = DataSourceFactory.getProperties(string);
            poolProperties.setDbProperties(properties2);
        } else {
            poolProperties.setDbProperties(new Properties());
        }
        if (poolProperties.getUsername() != null) {
            poolProperties.getDbProperties().setProperty("user", poolProperties.getUsername());
        }
        if (poolProperties.getPassword() != null) {
            poolProperties.getDbProperties().setProperty(PROP_PASSWORD, poolProperties.getPassword());
        }
        if ((string = properties.getProperty(PROP_INITSQL)) != null) {
            poolProperties.setInitSQL(string);
        }
        if ((string = properties.getProperty(PROP_INTERCEPTORS)) != null) {
            poolProperties.setJdbcInterceptors(string);
        }
        if ((string = properties.getProperty(PROP_JMX_ENABLED)) != null) {
            poolProperties.setJmxEnabled(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_FAIR_QUEUE)) != null) {
            poolProperties.setFairQueue(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_USE_EQUALS)) != null) {
            poolProperties.setUseEquals(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(OBJECT_NAME)) != null) {
            poolProperties.setName(ObjectName.quote(string));
        }
        if ((string = properties.getProperty(PROP_ABANDONWHENPERCENTAGEFULL)) != null) {
            poolProperties.setAbandonWhenPercentageFull(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_MAXAGE)) != null) {
            poolProperties.setMaxAge(Long.parseLong(string));
        }
        if ((string = properties.getProperty(PROP_USE_CON_LOCK)) != null) {
            poolProperties.setUseLock(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_DATASOURCE)) != null) {
            throw new IllegalArgumentException("Can't set dataSource property as a string, this must be a javax.sql.DataSource object.");
        }
        string = properties.getProperty(PROP_DATASOURCE_JNDI);
        if (string != null) {
            poolProperties.setDataSourceJNDI(string);
        }
        if ((string = properties.getProperty(PROP_SUSPECT_TIMEOUT)) != null) {
            poolProperties.setSuspectTimeout(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(PROP_ALTERNATE_USERNAME_ALLOWED)) != null) {
            poolProperties.setAlternateUsernameAllowed(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_COMMITONRETURN)) != null) {
            poolProperties.setCommitOnReturn(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_ROLLBACKONRETURN)) != null) {
            poolProperties.setRollbackOnReturn(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_USEDISPOSABLECONNECTIONFACADE)) != null) {
            poolProperties.setUseDisposableConnectionFacade(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_LOGVALIDATIONERRORS)) != null) {
            poolProperties.setLogValidationErrors(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_PROPAGATEINTERRUPTSTATE)) != null) {
            poolProperties.setPropagateInterruptState(Boolean.parseBoolean(string));
        }
        if ((string = properties.getProperty(PROP_IGNOREEXCEPTIONONPRELOAD)) != null) {
            poolProperties.setIgnoreExceptionOnPreLoad(Boolean.parseBoolean(string));
        }
        return poolProperties;
    }

    public javax.sql.DataSource createDataSource(Properties properties) {
        return this.createDataSource(properties, null, false);
    }

    public javax.sql.DataSource createDataSource(Properties properties, Context context, boolean bl) {
        PoolConfiguration poolConfiguration = DataSourceFactory.parsePoolProperties(properties);
        if (poolConfiguration.getDataSourceJNDI() != null && poolConfiguration.getDataSource() == null) {
            this.performJNDILookup(context, poolConfiguration);
        }
        DataSource dataSource = bl ? new XADataSource(poolConfiguration) : new DataSource(poolConfiguration);
        dataSource.createPool();
        return dataSource;
    }

    public void performJNDILookup(Context context, PoolConfiguration poolConfiguration) {
        Object object = null;
        try {
            if (context != null) {
                object = context.lookup(poolConfiguration.getDataSourceJNDI());
            } else {
                log.warn("dataSourceJNDI property is configued, but local JNDI context is null.");
            }
        }
        catch (NamingException namingException) {
            log.debug("The name \"" + poolConfiguration.getDataSourceJNDI() + "\" can not be found in the local context.");
        }
        if (object == null) {
            try {
                context = new InitialContext();
                object = context.lookup(poolConfiguration.getDataSourceJNDI());
            }
            catch (NamingException namingException) {
                log.warn("The name \"" + poolConfiguration.getDataSourceJNDI() + "\" can not be found in the InitialContext.");
            }
        }
        if (object != null) {
            poolConfiguration.setDataSource(object);
        }
    }

    protected static Properties getProperties(String string) {
        return PoolProperties.getProperties(string, null);
    }
}

