/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool;

import com.gmail.nossr50.database.tomcat.jdbc.pool.DataSourceProxy;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolConfiguration;
import com.gmail.nossr50.database.tomcat.jdbc.pool.jmx.ConnectionPoolMBean;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.ConnectionPoolDataSource;

public class DataSource
extends DataSourceProxy
implements javax.sql.DataSource,
MBeanRegistration,
ConnectionPoolMBean,
ConnectionPoolDataSource {
    private static final Log log = LogFactory.getLog(DataSource.class);
    protected volatile ObjectName oname = null;

    public DataSource() {
    }

    public DataSource(PoolConfiguration poolConfiguration) {
        super(poolConfiguration);
    }

    public void postDeregister() {
        if (this.oname != null) {
            this.unregisterJmx();
        }
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        try {
            if (this.isJmxEnabled()) {
                this.oname = this.createObjectName(objectName);
                if (this.oname != null) {
                    this.registerJmx();
                }
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            log.error("Unable to create object name for JDBC pool.", malformedObjectNameException);
        }
        return objectName;
    }

    public ObjectName createObjectName(ObjectName objectName) {
        String string = "tomcat.jdbc";
        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
        String string2 = objectName.getDomain();
        hashtable.put("type", "ConnectionPool");
        hashtable.put("class", this.getClass().getName());
        if (objectName.getKeyProperty("path") != null || hashtable.get("context") != null) {
            hashtable.put("engine", string2);
        }
        ObjectName objectName2 = new ObjectName(string, hashtable);
        return objectName2;
    }

    protected void registerJmx() {
        try {
            if (this.pool.getJmxPool() != null) {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanServer.registerMBean(this.pool.getJmxPool(), this.oname);
            }
        }
        catch (Exception exception) {
            log.error("Unable to register JDBC pool with JMX", exception);
        }
    }

    protected void unregisterJmx() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.unregisterMBean(this.oname);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception exception) {
            log.error("Unable to unregister JDBC pool with JMX", exception);
        }
    }
}

