/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool;

import com.gmail.nossr50.database.tomcat.jdbc.pool.DisposableConnectionFacade;
import com.gmail.nossr50.database.tomcat.jdbc.pool.FairBlockingQueue;
import com.gmail.nossr50.database.tomcat.jdbc.pool.JdbcInterceptor;
import com.gmail.nossr50.database.tomcat.jdbc.pool.MultiLockFairBlockingQueue;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolConfiguration;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolExhaustedException;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PooledConnection;
import com.gmail.nossr50.database.tomcat.jdbc.pool.ProxyConnection;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.XAConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPool {
    public static final String POOL_JMX_DOMAIN = "tomcat.jdbc";
    public static final String POOL_JMX_TYPE_PREFIX = "tomcat.jdbc:type=";
    private static final Log log = LogFactory.getLog(ConnectionPool.class);
    private AtomicInteger size = new AtomicInteger(0);
    private PoolConfiguration poolProperties;
    private BlockingQueue<PooledConnection> busy;
    private BlockingQueue<PooledConnection> idle;
    private volatile PoolCleaner poolCleaner;
    private volatile boolean closed = false;
    private Constructor<?> proxyClassConstructor;
    private ThreadPoolExecutor cancellator = new ThreadPoolExecutor(0, 1, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    protected com.gmail.nossr50.database.tomcat.jdbc.pool.jmx.ConnectionPool jmxPool = null;
    private AtomicInteger waitcount = new AtomicInteger(0);
    private AtomicLong poolVersion = new AtomicLong(Long.MIN_VALUE);
    private static volatile Timer poolCleanTimer = null;
    private static HashSet<PoolCleaner> cleaners = new HashSet();

    public ConnectionPool(PoolConfiguration poolConfiguration) {
        this.init(poolConfiguration);
    }

    public Future<Connection> getConnectionAsync() {
        Future<PooledConnection> future;
        block5: {
            try {
                future = this.borrowConnection(0, null, null);
                if (future != null) {
                    return new ConnectionFuture((PooledConnection)((Object)future));
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().indexOf("NoWait") >= 0) break block5;
                throw sQLException;
            }
        }
        if (this.idle instanceof FairBlockingQueue) {
            future = ((FairBlockingQueue)this.idle).pollAsync();
            return new ConnectionFuture(future);
        }
        if (this.idle instanceof MultiLockFairBlockingQueue) {
            future = ((MultiLockFairBlockingQueue)this.idle).pollAsync();
            return new ConnectionFuture(future);
        }
        throw new SQLException("Connection pool is misconfigured, doesn't support async retrieval. Set the 'fair' property to 'true'");
    }

    public Connection getConnection() {
        PooledConnection pooledConnection = this.borrowConnection(-1, null, null);
        return this.setupConnection(pooledConnection);
    }

    public Connection getConnection(String string, String string2) {
        PooledConnection pooledConnection = this.borrowConnection(-1, string, string2);
        return this.setupConnection(pooledConnection);
    }

    public String getName() {
        return this.getPoolProperties().getPoolName();
    }

    public int getWaitCount() {
        return this.waitcount.get();
    }

    public PoolConfiguration getPoolProperties() {
        return this.poolProperties;
    }

    public int getSize() {
        return this.size.get();
    }

    public int getActive() {
        return this.busy.size();
    }

    public int getIdle() {
        return this.idle.size();
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected Connection setupConnection(PooledConnection pooledConnection) {
        Object object;
        Object object2 = pooledConnection.getHandler();
        if (object2 == null) {
            object2 = new ProxyConnection(this, pooledConnection, this.getPoolProperties().isUseEquals());
            object = this.getPoolProperties().getJdbcInterceptorsAsArray();
            for (int i = ((PoolProperties.InterceptorDefinition[])object).length - 1; i >= 0; --i) {
                try {
                    JdbcInterceptor jdbcInterceptor = object[i].getInterceptorClass().newInstance();
                    jdbcInterceptor.setProperties(object[i].getProperties());
                    jdbcInterceptor.setNext((JdbcInterceptor)object2);
                    jdbcInterceptor.reset(this, pooledConnection);
                    object2 = jdbcInterceptor;
                    continue;
                }
                catch (Exception exception) {
                    SQLException sQLException = new SQLException("Unable to instantiate interceptor chain.");
                    sQLException.initCause(exception);
                    throw sQLException;
                }
            }
            pooledConnection.setHandler((JdbcInterceptor)object2);
        } else {
            for (object = object2; object != null; object = object.getNext()) {
                object.reset(this, pooledConnection);
            }
        }
        try {
            this.getProxyConstructor(pooledConnection.getXAConnection() != null);
            object = null;
            object = this.getPoolProperties().getUseDisposableConnectionFacade() ? (Connection)this.proxyClassConstructor.newInstance(new DisposableConnectionFacade((JdbcInterceptor)object2)) : (Connection)this.proxyClassConstructor.newInstance(object2);
            return object;
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException();
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    public Constructor<?> getProxyConstructor(boolean bl) {
        if (this.proxyClassConstructor == null) {
            Class<?> clazz = bl ? Proxy.getProxyClass(ConnectionPool.class.getClassLoader(), Connection.class, javax.sql.PooledConnection.class, XAConnection.class) : Proxy.getProxyClass(ConnectionPool.class.getClassLoader(), Connection.class, javax.sql.PooledConnection.class);
            this.proxyClassConstructor = clazz.getConstructor(InvocationHandler.class);
        }
        return this.proxyClassConstructor;
    }

    protected void close(boolean bl) {
        Object object;
        BlockingQueue<PooledConnection> blockingQueue;
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.poolCleaner != null) {
            this.poolCleaner.stopRunning();
        }
        BlockingQueue<PooledConnection> blockingQueue2 = this.idle.size() > 0 ? this.idle : (blockingQueue = bl ? this.busy : this.idle);
        while (blockingQueue.size() > 0) {
            block13: {
                try {
                    object = blockingQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    while (object != null) {
                        if (blockingQueue == this.idle) {
                            this.release((PooledConnection)object);
                        } else {
                            this.abandon((PooledConnection)object);
                        }
                        if (blockingQueue.size() > 0) {
                            object = blockingQueue.poll(1000L, TimeUnit.MILLISECONDS);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!this.getPoolProperties().getPropagateInterruptState()) break block13;
                    Thread.currentThread().interrupt();
                }
            }
            if (blockingQueue.size() != 0 || !bl || blockingQueue == this.busy) continue;
            blockingQueue = this.busy;
        }
        if (this.getPoolProperties().isJmxEnabled()) {
            this.jmxPool = null;
        }
        object = this.getPoolProperties().getJdbcInterceptorsAsArray();
        for (int i = 0; i < ((PoolProperties.InterceptorDefinition[])object).length; ++i) {
            try {
                JdbcInterceptor jdbcInterceptor = object[i].getInterceptorClass().newInstance();
                jdbcInterceptor.setProperties(object[i].getProperties());
                jdbcInterceptor.poolClosed(this);
                continue;
            }
            catch (Exception exception) {
                log.debug("Unable to inform interceptor of pool closure.", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(PoolConfiguration poolConfiguration) {
        this.poolProperties = poolConfiguration;
        if (poolConfiguration.getMaxActive() < 1) {
            log.warn("maxActive is smaller than 1, setting maxActive to: 100");
            poolConfiguration.setMaxActive(100);
        }
        if (poolConfiguration.getMaxActive() < poolConfiguration.getInitialSize()) {
            log.warn("initialSize is larger than maxActive, setting initialSize to: " + poolConfiguration.getMaxActive());
            poolConfiguration.setInitialSize(poolConfiguration.getMaxActive());
        }
        if (poolConfiguration.getMinIdle() > poolConfiguration.getMaxActive()) {
            log.warn("minIdle is larger than maxActive, setting minIdle to: " + poolConfiguration.getMaxActive());
            poolConfiguration.setMinIdle(poolConfiguration.getMaxActive());
        }
        if (poolConfiguration.getMaxIdle() > poolConfiguration.getMaxActive()) {
            log.warn("maxIdle is larger than maxActive, setting maxIdle to: " + poolConfiguration.getMaxActive());
            poolConfiguration.setMaxIdle(poolConfiguration.getMaxActive());
        }
        if (poolConfiguration.getMaxIdle() < poolConfiguration.getMinIdle()) {
            log.warn("maxIdle is smaller than minIdle, setting maxIdle to: " + poolConfiguration.getMinIdle());
            poolConfiguration.setMaxIdle(poolConfiguration.getMinIdle());
        }
        this.busy = new ArrayBlockingQueue<PooledConnection>(poolConfiguration.getMaxActive(), false);
        this.idle = poolConfiguration.isFairQueue() ? new FairBlockingQueue<PooledConnection>() : new ArrayBlockingQueue<PooledConnection>(poolConfiguration.getMaxActive(), poolConfiguration.isFairQueue());
        this.initializePoolCleaner(poolConfiguration);
        if (this.getPoolProperties().isJmxEnabled()) {
            this.createMBean();
        }
        PoolProperties.InterceptorDefinition[] interceptorDefinitionArray = this.getPoolProperties().getJdbcInterceptorsAsArray();
        for (int i = 0; i < interceptorDefinitionArray.length; ++i) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Creating interceptor instance of class:" + interceptorDefinitionArray[i].getInterceptorClass());
                }
                JdbcInterceptor jdbcInterceptor = interceptorDefinitionArray[i].getInterceptorClass().newInstance();
                jdbcInterceptor.setProperties(interceptorDefinitionArray[i].getProperties());
                jdbcInterceptor.poolStarted(this);
                continue;
            }
            catch (Exception exception) {
                log.error("Unable to inform interceptor of pool start.", exception);
                if (this.jmxPool != null) {
                    this.jmxPool.notify("INIT FAILED", ConnectionPool.getStackTrace(exception));
                }
                this.close(true);
                SQLException sQLException = new SQLException();
                sQLException.initCause(exception);
                throw sQLException;
            }
        }
        PooledConnection[] pooledConnectionArray = new PooledConnection[this.poolProperties.getInitialSize()];
        try {
            for (int i = 0; i < pooledConnectionArray.length; ++i) {
                pooledConnectionArray[i] = this.borrowConnection(0, null, null);
            }
        }
        catch (SQLException sQLException) {
            log.error("Unable to create initial connections of pool.", sQLException);
            if (!this.poolProperties.isIgnoreExceptionOnPreLoad()) {
                if (this.jmxPool != null) {
                    this.jmxPool.notify("INIT FAILED", ConnectionPool.getStackTrace(sQLException));
                }
                this.close(true);
                throw sQLException;
            }
        }
        finally {
            for (int i = 0; i < pooledConnectionArray.length; ++i) {
                if (pooledConnectionArray[i] == null) continue;
                try {
                    this.returnConnection(pooledConnectionArray[i]);
                    continue;
                }
                catch (Exception exception) {}
            }
        }
        this.closed = false;
    }

    public void initializePoolCleaner(PoolConfiguration poolConfiguration) {
        if (poolConfiguration.isPoolSweeperEnabled()) {
            this.poolCleaner = new PoolCleaner(this, poolConfiguration.getTimeBetweenEvictionRunsMillis());
            this.poolCleaner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abandon(PooledConnection pooledConnection) {
        if (pooledConnection == null) {
            return;
        }
        try {
            pooledConnection.lock();
            String string = pooledConnection.getStackTrace();
            if (this.getPoolProperties().isLogAbandoned()) {
                log.warn("Connection has been abandoned " + pooledConnection + ":" + string);
            }
            if (this.jmxPool != null) {
                this.jmxPool.notify("CONNECTION ABANDONED", string);
            }
            this.release(pooledConnection);
        }
        finally {
            pooledConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspect(PooledConnection pooledConnection) {
        if (pooledConnection == null) {
            return;
        }
        if (pooledConnection.isSuspect()) {
            return;
        }
        try {
            pooledConnection.lock();
            String string = pooledConnection.getStackTrace();
            if (this.getPoolProperties().isLogAbandoned()) {
                log.warn("Connection has been marked suspect, possibly abandoned " + pooledConnection + "[" + (System.currentTimeMillis() - pooledConnection.getTimestamp()) + " ms.]:" + string);
            }
            if (this.jmxPool != null) {
                this.jmxPool.notify("SUSPECT CONNETION ABANDONED", string);
            }
            pooledConnection.setSuspect(true);
        }
        finally {
            pooledConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(PooledConnection pooledConnection) {
        if (pooledConnection == null) {
            return;
        }
        try {
            pooledConnection.lock();
            if (pooledConnection.release()) {
                this.size.addAndGet(-1);
                pooledConnection.setHandler(null);
            }
        }
        finally {
            pooledConnection.unlock();
        }
        if (this.waitcount.get() > 0) {
            this.idle.offer(this.create(true));
        }
    }

    private PooledConnection borrowConnection(int n, String string, String string2) {
        long l;
        long l2;
        if (this.isClosed()) {
            throw new SQLException("Connection pool closed.");
        }
        long l3 = System.currentTimeMillis();
        PooledConnection pooledConnection = (PooledConnection)this.idle.poll();
        do {
            PooledConnection pooledConnection2;
            if (pooledConnection != null && (pooledConnection2 = this.borrowConnection(l3, pooledConnection, string, string2)) != null) {
                return pooledConnection2;
            }
            if (this.size.get() < this.getPoolProperties().getMaxActive()) {
                if (this.size.addAndGet(1) > this.getPoolProperties().getMaxActive()) {
                    this.size.decrementAndGet();
                } else {
                    return this.createConnection(l3, pooledConnection, string, string2);
                }
            }
            l2 = n;
            if (n == -1) {
                l2 = this.getPoolProperties().getMaxWait() <= 0 ? Long.MAX_VALUE : (long)this.getPoolProperties().getMaxWait();
            }
            l = Math.max(0L, l2 - (System.currentTimeMillis() - l3));
            this.waitcount.incrementAndGet();
            try {
                pooledConnection = this.idle.poll(l, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                if (this.getPoolProperties().getPropagateInterruptState()) {
                    Thread.currentThread().interrupt();
                }
                SQLException sQLException = new SQLException("Pool wait interrupted.");
                sQLException.initCause(interruptedException);
                throw sQLException;
            }
            finally {
                this.waitcount.decrementAndGet();
            }
            if (l2 != 0L || pooledConnection != null) continue;
            if (this.jmxPool != null) {
                this.jmxPool.notify("POOL EMPTY", "Pool empty - no wait.");
            }
            throw new PoolExhaustedException("[" + Thread.currentThread().getName() + "] " + "NoWait: Pool empty. Unable to fetch a connection, none available[" + this.busy.size() + " in use].");
        } while (pooledConnection != null || System.currentTimeMillis() - l3 < l2);
        if (this.jmxPool != null) {
            this.jmxPool.notify("POOL EMPTY", "Pool empty - timeout.");
        }
        throw new PoolExhaustedException("[" + Thread.currentThread().getName() + "] " + "Timeout: Pool empty. Unable to fetch a connection in " + l2 / 1000L + " seconds, none available[size:" + this.size.get() + "; busy:" + this.busy.size() + "; idle:" + this.idle.size() + "; lastwait:" + l + "].");
    }

    protected PooledConnection createConnection(long l, PooledConnection pooledConnection, String string, String string2) {
        PooledConnection pooledConnection2 = this.create(false);
        if (string != null) {
            pooledConnection2.getAttributes().put("user", string);
        }
        if (string2 != null) {
            pooledConnection2.getAttributes().put("password", string2);
        }
        boolean bl = false;
        try {
            pooledConnection2.lock();
            pooledConnection2.connect();
            if (pooledConnection2.validate(4)) {
                pooledConnection2.setTimestamp(l);
                if (this.getPoolProperties().isLogAbandoned()) {
                    pooledConnection2.setStackTrace(ConnectionPool.getThreadDump());
                }
                if (!this.busy.offer(pooledConnection2)) {
                    log.debug("Connection doesn't fit into busy array, connection will not be traceable.");
                }
                PooledConnection pooledConnection3 = pooledConnection2;
                return pooledConnection3;
            }
            try {
                throw new SQLException("Validation Query Failed, enable logValidationErrors for more details.");
            }
            catch (Exception exception) {
                bl = true;
                if (log.isDebugEnabled()) {
                    log.debug("Unable to create a new JDBC connection.", exception);
                }
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                SQLException sQLException = new SQLException(exception.getMessage());
                sQLException.initCause(exception);
                throw sQLException;
            }
        }
        finally {
            if (bl) {
                this.release(pooledConnection2);
            }
            pooledConnection2.unlock();
        }
    }

    protected PooledConnection borrowConnection(long l, PooledConnection pooledConnection, String string, String string2) {
        boolean bl = false;
        try {
            pooledConnection.lock();
            boolean bl2 = pooledConnection.checkUser(string, string2);
            if (pooledConnection.isReleased()) {
                PooledConnection pooledConnection2 = null;
                return pooledConnection2;
            }
            if (!pooledConnection.isDiscarded() && !pooledConnection.isInitialized()) {
                try {
                    pooledConnection.connect();
                }
                catch (Exception exception) {
                    this.release(pooledConnection);
                    bl = true;
                    if (exception instanceof SQLException) {
                        throw (SQLException)exception;
                    }
                    SQLException sQLException = new SQLException(exception.getMessage());
                    sQLException.initCause(exception);
                    throw sQLException;
                }
            }
            if (bl2 && !pooledConnection.isDiscarded() && pooledConnection.validate(1)) {
                pooledConnection.setTimestamp(l);
                if (this.getPoolProperties().isLogAbandoned()) {
                    pooledConnection.setStackTrace(ConnectionPool.getThreadDump());
                }
                if (!this.busy.offer(pooledConnection)) {
                    log.debug("Connection doesn't fit into busy array, connection will not be traceable.");
                }
                PooledConnection pooledConnection3 = pooledConnection;
                return pooledConnection3;
            }
            pooledConnection.reconnect();
            if (pooledConnection.validate(4)) {
                pooledConnection.setTimestamp(l);
                if (this.getPoolProperties().isLogAbandoned()) {
                    pooledConnection.setStackTrace(ConnectionPool.getThreadDump());
                }
                if (!this.busy.offer(pooledConnection)) {
                    log.debug("Connection doesn't fit into busy array, connection will not be traceable.");
                }
                PooledConnection pooledConnection4 = pooledConnection;
                return pooledConnection4;
            }
            try {
                this.release(pooledConnection);
                bl = true;
                throw new SQLException("Failed to validate a newly established connection.");
            }
            catch (Exception exception) {
                this.release(pooledConnection);
                bl = true;
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                SQLException sQLException = new SQLException(exception.getMessage());
                sQLException.initCause(exception);
                throw sQLException;
            }
        }
        finally {
            pooledConnection.unlock();
            if (bl) {
                pooledConnection = null;
            }
        }
    }

    protected boolean terminateTransaction(PooledConnection pooledConnection) {
        try {
            if (Boolean.FALSE.equals(pooledConnection.getPoolProperties().getDefaultAutoCommit())) {
                boolean bl;
                if (this.getPoolProperties().getRollbackOnReturn()) {
                    boolean bl2 = pooledConnection.getConnection().getAutoCommit();
                    if (!bl2) {
                        pooledConnection.getConnection().rollback();
                    }
                } else if (this.getPoolProperties().getCommitOnReturn() && !(bl = pooledConnection.getConnection().getAutoCommit())) {
                    pooledConnection.getConnection().commit();
                }
            }
            return true;
        }
        catch (SQLException sQLException) {
            log.warn("Unable to terminate transaction, connection will be closed.", sQLException);
            return false;
        }
    }

    protected boolean shouldClose(PooledConnection pooledConnection, int n) {
        if (pooledConnection.getConnectionVersion() < this.getPoolVersion()) {
            return true;
        }
        if (pooledConnection.isDiscarded()) {
            return true;
        }
        if (this.isClosed()) {
            return true;
        }
        if (!pooledConnection.validate(n)) {
            return true;
        }
        if (!this.terminateTransaction(pooledConnection)) {
            return true;
        }
        if (this.getPoolProperties().getMaxAge() > 0L) {
            return System.currentTimeMillis() - pooledConnection.getLastConnected() > this.getPoolProperties().getMaxAge();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(PooledConnection pooledConnection) {
        if (this.isClosed()) {
            this.release(pooledConnection);
            return;
        }
        if (pooledConnection != null) {
            try {
                pooledConnection.lock();
                if (this.busy.remove(pooledConnection)) {
                    if (!this.shouldClose(pooledConnection, 2)) {
                        pooledConnection.setStackTrace(null);
                        pooledConnection.setTimestamp(System.currentTimeMillis());
                        if (this.idle.size() >= this.poolProperties.getMaxIdle() && !this.poolProperties.isPoolSweeperEnabled() || !this.idle.offer(pooledConnection)) {
                            if (log.isDebugEnabled()) {
                                log.debug("Connection [" + pooledConnection + "] will be closed and not returned to the pool, idle[" + this.idle.size() + "]>=maxIdle[" + this.poolProperties.getMaxIdle() + "] idle.offer failed.");
                            }
                            this.release(pooledConnection);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Connection [" + pooledConnection + "] will be closed and not returned to the pool.");
                        }
                        this.release(pooledConnection);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Connection [" + pooledConnection + "] will be closed and not returned to the pool, busy.remove failed.");
                    }
                    this.release(pooledConnection);
                }
            }
            finally {
                pooledConnection.unlock();
            }
        }
    }

    protected boolean shouldAbandon() {
        float f;
        float f2;
        if (this.poolProperties.getAbandonWhenPercentageFull() == 0) {
            return true;
        }
        float f3 = this.busy.size();
        return f3 / (f2 = (float)this.poolProperties.getMaxActive()) * 100.0f >= (f = (float)this.poolProperties.getAbandonWhenPercentageFull());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAbandoned() {
        try {
            if (this.busy.size() == 0) {
                return;
            }
            Iterator iterator = this.busy.iterator();
            int n = this.getPoolProperties().getSuspectTimeout();
            while (iterator.hasNext()) {
                PooledConnection pooledConnection = (PooledConnection)iterator.next();
                boolean bl = false;
                try {
                    pooledConnection.lock();
                    if (this.idle.contains(pooledConnection)) continue;
                    long l = pooledConnection.getTimestamp();
                    long l2 = System.currentTimeMillis();
                    if (this.shouldAbandon() && l2 - l > pooledConnection.getAbandonTimeout()) {
                        this.busy.remove(pooledConnection);
                        this.abandon(pooledConnection);
                        bl = true;
                        continue;
                    }
                    if (n <= 0 || l2 - l <= (long)(n * 1000)) continue;
                    this.suspect(pooledConnection);
                }
                finally {
                    pooledConnection.unlock();
                    if (!bl) continue;
                    pooledConnection = null;
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            log.debug("checkAbandoned failed.", concurrentModificationException);
        }
        catch (Exception exception) {
            log.warn("checkAbandoned failed, it will be retried.", exception);
        }
    }

    public void checkIdle() {
        this.checkIdle(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIdle(boolean bl) {
        try {
            if (this.idle.size() == 0) {
                return;
            }
            long l = System.currentTimeMillis();
            Iterator iterator = this.idle.iterator();
            while ((bl || this.idle.size() >= this.getPoolProperties().getMinIdle()) && iterator.hasNext()) {
                PooledConnection pooledConnection = (PooledConnection)iterator.next();
                boolean bl2 = false;
                try {
                    long l2;
                    pooledConnection.lock();
                    if (this.busy.contains(pooledConnection) || !this.shouldReleaseIdle(l, pooledConnection, l2 = pooledConnection.getTimestamp())) continue;
                    this.release(pooledConnection);
                    this.idle.remove(pooledConnection);
                    bl2 = true;
                }
                finally {
                    pooledConnection.unlock();
                    if (!bl2) continue;
                    pooledConnection = null;
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            log.debug("checkIdle failed.", concurrentModificationException);
        }
        catch (Exception exception) {
            log.warn("checkIdle failed, it will be retried.", exception);
        }
    }

    protected boolean shouldReleaseIdle(long l, PooledConnection pooledConnection, long l2) {
        if (pooledConnection.getConnectionVersion() < this.getPoolVersion()) {
            return true;
        }
        return pooledConnection.getReleaseTime() > 0L && l - l2 > pooledConnection.getReleaseTime() && this.getSize() > this.getPoolProperties().getMinIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllIdle() {
        try {
            if (this.idle.size() == 0) {
                return;
            }
            for (PooledConnection pooledConnection : this.idle) {
                try {
                    pooledConnection.lock();
                    if (this.busy.contains(pooledConnection) || pooledConnection.validate(3)) continue;
                    this.idle.remove(pooledConnection);
                    this.release(pooledConnection);
                }
                finally {
                    pooledConnection.unlock();
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            log.debug("testAllIdle failed.", concurrentModificationException);
        }
        catch (Exception exception) {
            log.warn("testAllIdle failed, it will be retried.", exception);
        }
    }

    protected static String getThreadDump() {
        Exception exception = new Exception();
        exception.fillInStackTrace();
        return ConnectionPool.getStackTrace(exception);
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        String string = byteArrayOutputStream.toString();
        return throwable.getMessage() != null && throwable.getMessage().length() > 0 ? throwable.getMessage() + ";" + string : string;
    }

    protected PooledConnection create(boolean bl) {
        if (bl) {
            this.size.incrementAndGet();
        }
        PooledConnection pooledConnection = new PooledConnection(this.getPoolProperties(), this);
        return pooledConnection;
    }

    public void purge() {
        this.purgeOnReturn();
        this.checkIdle(true);
    }

    public void purgeOnReturn() {
        this.poolVersion.incrementAndGet();
    }

    protected void finalize(PooledConnection pooledConnection) {
        for (JdbcInterceptor jdbcInterceptor = pooledConnection.getHandler(); jdbcInterceptor != null; jdbcInterceptor = jdbcInterceptor.getNext()) {
            jdbcInterceptor.reset(null, null);
        }
    }

    protected void disconnectEvent(PooledConnection pooledConnection, boolean bl) {
        for (JdbcInterceptor jdbcInterceptor = pooledConnection.getHandler(); jdbcInterceptor != null; jdbcInterceptor = jdbcInterceptor.getNext()) {
            jdbcInterceptor.disconnected(this, pooledConnection, bl);
        }
    }

    public com.gmail.nossr50.database.tomcat.jdbc.pool.jmx.ConnectionPool getJmxPool() {
        return this.jmxPool;
    }

    protected void createMBean() {
        try {
            this.jmxPool = new com.gmail.nossr50.database.tomcat.jdbc.pool.jmx.ConnectionPool(this);
        }
        catch (Exception exception) {
            log.warn("Unable to start JMX integration for connection pool. Instance[" + this.getName() + "] can't be monitored.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void registerCleaner(PoolCleaner poolCleaner) {
        ConnectionPool.unregisterCleaner(poolCleaner);
        cleaners.add(poolCleaner);
        if (poolCleanTimer == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ConnectionPool.class.getClassLoader());
                poolCleanTimer = new Timer("PoolCleaner[" + System.identityHashCode(ConnectionPool.class.getClassLoader()) + ":" + System.currentTimeMillis() + "]", true);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        poolCleanTimer.scheduleAtFixedRate((TimerTask)poolCleaner, poolCleaner.sleepTime, poolCleaner.sleepTime);
    }

    private static synchronized void unregisterCleaner(PoolCleaner poolCleaner) {
        boolean bl = cleaners.remove(poolCleaner);
        if (bl) {
            poolCleaner.cancel();
            if (poolCleanTimer != null) {
                poolCleanTimer.purge();
                if (cleaners.size() == 0) {
                    poolCleanTimer.cancel();
                    poolCleanTimer = null;
                }
            }
        }
    }

    public static Set<TimerTask> getPoolCleaners() {
        return Collections.unmodifiableSet(cleaners);
    }

    public long getPoolVersion() {
        return this.poolVersion.get();
    }

    public static Timer getPoolTimer() {
        return poolCleanTimer;
    }

    protected static class PoolCleaner
    extends TimerTask {
        protected WeakReference<ConnectionPool> pool;
        protected long sleepTime;
        protected volatile long lastRun = 0L;

        PoolCleaner(ConnectionPool connectionPool, long l) {
            this.pool = new WeakReference<ConnectionPool>(connectionPool);
            this.sleepTime = l;
            if (l <= 0L) {
                log.warn("Database connection pool evicter thread interval is set to 0, defaulting to 30 seconds");
                this.sleepTime = 30000L;
            } else if (l < 1000L) {
                log.warn("Database connection pool evicter thread interval is set to lower than 1 second.");
            }
        }

        public void run() {
            ConnectionPool connectionPool = (ConnectionPool)this.pool.get();
            if (connectionPool == null) {
                this.stopRunning();
            } else if (!connectionPool.isClosed() && System.currentTimeMillis() - this.lastRun > this.sleepTime) {
                this.lastRun = System.currentTimeMillis();
                try {
                    if (connectionPool.getPoolProperties().isRemoveAbandoned()) {
                        connectionPool.checkAbandoned();
                    }
                    if (connectionPool.getPoolProperties().getMinIdle() < connectionPool.idle.size()) {
                        connectionPool.checkIdle();
                    }
                    if (connectionPool.getPoolProperties().isTestWhileIdle()) {
                        connectionPool.testAllIdle();
                    }
                }
                catch (Exception exception) {
                    log.error("", exception);
                }
            }
        }

        public void start() {
            ConnectionPool.registerCleaner(this);
        }

        public void stopRunning() {
            ConnectionPool.unregisterCleaner(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConnectionFuture
    implements Future<Connection>,
    Runnable {
        Future<PooledConnection> pcFuture = null;
        AtomicBoolean configured = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        volatile Connection result = null;
        SQLException cause = null;
        AtomicBoolean cancelled = new AtomicBoolean(false);
        volatile PooledConnection pc = null;

        public ConnectionFuture(Future<PooledConnection> future) {
            this.pcFuture = future;
        }

        public ConnectionFuture(PooledConnection pooledConnection) {
            this.pc = pooledConnection;
            this.result = ConnectionPool.this.setupConnection(pooledConnection);
            this.configured.set(true);
        }

        @Override
        public boolean cancel(boolean bl) {
            if (this.pc != null) {
                return false;
            }
            if (!this.cancelled.get() && this.cancelled.compareAndSet(false, true)) {
                ConnectionPool.this.cancellator.execute(this);
            }
            return true;
        }

        @Override
        public Connection get() {
            try {
                return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw new ExecutionException(timeoutException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection get(long l, TimeUnit timeUnit) {
            PooledConnection pooledConnection;
            PooledConnection pooledConnection2 = pooledConnection = this.pc != null ? this.pc : this.pcFuture.get(l, timeUnit);
            if (pooledConnection != null) {
                if (this.result != null) {
                    return this.result;
                }
                if (this.configured.compareAndSet(false, true)) {
                    try {
                        pooledConnection = ConnectionPool.this.borrowConnection(System.currentTimeMillis(), pooledConnection, null, null);
                        this.result = ConnectionPool.this.setupConnection(pooledConnection);
                    }
                    catch (SQLException sQLException) {
                        this.cause = sQLException;
                    }
                    finally {
                        this.latch.countDown();
                    }
                } else {
                    this.latch.await(l, timeUnit);
                }
                if (this.result == null) {
                    throw new ExecutionException(this.cause);
                }
                return this.result;
            }
            return null;
        }

        @Override
        public boolean isCancelled() {
            return this.pc == null && (this.pcFuture.isCancelled() || this.cancelled.get());
        }

        @Override
        public boolean isDone() {
            return this.pc != null || this.pcFuture.isDone();
        }

        @Override
        public void run() {
            try {
                Connection connection = this.get();
                connection.close();
            }
            catch (ExecutionException executionException) {
            }
            catch (Exception exception) {
                log.error("Unable to cancel ConnectionFuture.", exception);
            }
        }
    }
}

