/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.database.tomcat.jdbc.pool.DataSource;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolProperties;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.player.UniqueDataType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.database.UUIDUpdateAsyncTask;
import com.gmail.nossr50.util.Misc;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class SQLDatabaseManager
implements DatabaseManager {
    private static final String ALL_QUERY_VERSION = "total";
    private String tablePrefix = Config.getInstance().getMySQLTablePrefix();
    private final Map<UUID, Integer> cachedUserIDs = new HashMap<UUID, Integer>();
    private DataSource miscPool;
    private DataSource loadPool;
    private DataSource savePool;
    private ReentrantLock massUpdateLock = new ReentrantLock();

    protected SQLDatabaseManager() {
        String string = "jdbc:mysql://" + Config.getInstance().getMySQLServerName() + ":" + Config.getInstance().getMySQLServerPort() + "/" + Config.getInstance().getMySQLDatabaseName();
        string = Config.getInstance().getMySQLSSL() ? string + "?verifyServerCertificate=false&useSSL=true&requireSSL=true" : string + "?useSSL=false";
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return;
        }
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setDriverClassName("com.mysql.jdbc.Driver");
        poolProperties.setUrl(string);
        poolProperties.setUsername(Config.getInstance().getMySQLUserName());
        poolProperties.setPassword(Config.getInstance().getMySQLUserPassword());
        poolProperties.setMaxIdle(Config.getInstance().getMySQLMaxPoolSize(PoolIdentifier.MISC));
        poolProperties.setMaxActive(Config.getInstance().getMySQLMaxConnections(PoolIdentifier.MISC));
        poolProperties.setInitialSize(0);
        poolProperties.setMaxWait(-1);
        poolProperties.setRemoveAbandoned(true);
        poolProperties.setRemoveAbandonedTimeout(60);
        poolProperties.setTestOnBorrow(true);
        poolProperties.setValidationQuery("SELECT 1");
        poolProperties.setValidationInterval(30000L);
        this.miscPool = new DataSource(poolProperties);
        poolProperties = new PoolProperties();
        poolProperties.setDriverClassName("com.mysql.jdbc.Driver");
        poolProperties.setUrl(string);
        poolProperties.setUsername(Config.getInstance().getMySQLUserName());
        poolProperties.setPassword(Config.getInstance().getMySQLUserPassword());
        poolProperties.setInitialSize(0);
        poolProperties.setMaxIdle(Config.getInstance().getMySQLMaxPoolSize(PoolIdentifier.SAVE));
        poolProperties.setMaxActive(Config.getInstance().getMySQLMaxConnections(PoolIdentifier.SAVE));
        poolProperties.setMaxWait(-1);
        poolProperties.setRemoveAbandoned(true);
        poolProperties.setRemoveAbandonedTimeout(60);
        poolProperties.setTestOnBorrow(true);
        poolProperties.setValidationQuery("SELECT 1");
        poolProperties.setValidationInterval(30000L);
        this.savePool = new DataSource(poolProperties);
        poolProperties = new PoolProperties();
        poolProperties.setDriverClassName("com.mysql.jdbc.Driver");
        poolProperties.setUrl(string);
        poolProperties.setUsername(Config.getInstance().getMySQLUserName());
        poolProperties.setPassword(Config.getInstance().getMySQLUserPassword());
        poolProperties.setInitialSize(0);
        poolProperties.setMaxIdle(Config.getInstance().getMySQLMaxPoolSize(PoolIdentifier.LOAD));
        poolProperties.setMaxActive(Config.getInstance().getMySQLMaxConnections(PoolIdentifier.LOAD));
        poolProperties.setMaxWait(-1);
        poolProperties.setRemoveAbandoned(true);
        poolProperties.setRemoveAbandonedTimeout(60);
        poolProperties.setTestOnBorrow(true);
        poolProperties.setValidationQuery("SELECT 1");
        poolProperties.setValidationInterval(30000L);
        this.loadPool = new DataSource(poolProperties);
        this.checkStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgePowerlessUsers() {
        this.massUpdateLock.lock();
        mcMMO.p.getLogger().info("Purging powerless users...");
        Connection connection = null;
        Statement statement = null;
        int n = 0;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.createStatement();
            n = statement.executeUpdate("DELETE FROM " + this.tablePrefix + "skills WHERE taming = 0 AND mining = 0 AND woodcutting = 0 AND repair = 0 AND unarmed = 0 AND herbalism = 0 AND excavation = 0 AND archery = 0 AND swords = 0 AND axes = 0 AND acrobatics = 0 AND fishing = 0 AND alchemy = 0;");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "experience` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "experience`.`user_id` = `s`.`user_id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "huds` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "huds`.`user_id` = `s`.`user_id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "cooldowns` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "cooldowns`.`user_id` = `s`.`user_id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "users` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "skills` `s` WHERE `" + this.tablePrefix + "users`.`id` = `s`.`user_id`)");
            this.tryClose(statement);
            this.tryClose(connection);
            this.massUpdateLock.unlock();
        }
        catch (SQLException sQLException) {
            try {
                this.printErrors(sQLException);
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
            }
            catch (Throwable throwable) {
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
                throw throwable;
            }
        }
        mcMMO.p.getLogger().info("Purged " + n + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeOldUsers() {
        this.massUpdateLock.lock();
        mcMMO.p.getLogger().info("Purging inactive users older than " + PURGE_TIME / 2630000000L + " months...");
        Connection connection = null;
        Statement statement = null;
        int n = 0;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.createStatement();
            n = statement.executeUpdate("DELETE FROM u, e, h, s, c USING " + this.tablePrefix + "users u JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) WHERE ((UNIX_TIMESTAMP() - lastlogin) > " + PURGE_TIME + ")");
            this.tryClose(statement);
            this.tryClose(connection);
            this.massUpdateLock.unlock();
        }
        catch (SQLException sQLException) {
            try {
                this.printErrors(sQLException);
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
            }
            catch (Throwable throwable) {
                this.tryClose(statement);
                this.tryClose(connection);
                this.massUpdateLock.unlock();
                throw throwable;
            }
        }
        mcMMO.p.getLogger().info("Purged " + n + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(String string, UUID uUID) {
        boolean bl = false;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            preparedStatement = connection.prepareStatement("DELETE FROM u, e, h, s, c USING " + this.tablePrefix + "users u JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) WHERE u.user = ?");
            preparedStatement.setString(1, string);
            bl = preparedStatement.executeUpdate() != 0;
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
        if (bl) {
            if (uUID != null) {
                this.cleanupUser(uUID);
            }
            Misc.profileCleanup(string);
        }
        return bl;
    }

    @Override
    public void cleanupUser(UUID uUID) {
        if (this.cachedUserIDs.containsKey(uUID)) {
            this.cachedUserIDs.remove(uUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveUser(PlayerProfile playerProfile) {
        Connection connection;
        PreparedStatement preparedStatement;
        boolean bl;
        block22: {
            boolean bl2;
            block21: {
                boolean bl3;
                block20: {
                    boolean bl4;
                    block19: {
                        boolean bl5;
                        block18: {
                            boolean bl6;
                            block17: {
                                bl = true;
                                preparedStatement = null;
                                connection = null;
                                try {
                                    connection = this.getConnection(PoolIdentifier.SAVE);
                                    int n = this.getUserID(connection, playerProfile.getPlayerName(), playerProfile.getUniqueId());
                                    if (n == -1 && (n = this.newUser(connection, playerProfile.getPlayerName(), playerProfile.getUniqueId())) == -1) {
                                        mcMMO.p.getLogger().severe("Failed to create new account for " + playerProfile.getPlayerName());
                                        boolean bl7 = false;
                                        this.tryClose(preparedStatement);
                                        this.tryClose(connection);
                                        return bl7;
                                    }
                                    preparedStatement = connection.prepareStatement("UPDATE " + this.tablePrefix + "users SET lastlogin = UNIX_TIMESTAMP() WHERE id = ?");
                                    preparedStatement.setInt(1, n);
                                    boolean bl8 = preparedStatement.executeUpdate() != 0;
                                    preparedStatement.close();
                                    if (!(bl &= bl8)) {
                                        mcMMO.p.getLogger().severe("Failed to update last login for " + playerProfile.getPlayerName());
                                        bl6 = false;
                                        this.tryClose(preparedStatement);
                                        break block17;
                                    }
                                    preparedStatement = connection.prepareStatement("UPDATE " + this.tablePrefix + "skills SET  taming = ?, mining = ?, repair = ?, woodcutting = ?, unarmed = ?, herbalism = ?, excavation = ?, archery = ?, swords = ?, axes = ?, acrobatics = ?, fishing = ?, alchemy = ?, total = ? WHERE user_id = ?");
                                    preparedStatement.setInt(1, playerProfile.getSkillLevel(PrimarySkillType.TAMING));
                                    preparedStatement.setInt(2, playerProfile.getSkillLevel(PrimarySkillType.MINING));
                                    preparedStatement.setInt(3, playerProfile.getSkillLevel(PrimarySkillType.REPAIR));
                                    preparedStatement.setInt(4, playerProfile.getSkillLevel(PrimarySkillType.WOODCUTTING));
                                    preparedStatement.setInt(5, playerProfile.getSkillLevel(PrimarySkillType.UNARMED));
                                    preparedStatement.setInt(6, playerProfile.getSkillLevel(PrimarySkillType.HERBALISM));
                                    preparedStatement.setInt(7, playerProfile.getSkillLevel(PrimarySkillType.EXCAVATION));
                                    preparedStatement.setInt(8, playerProfile.getSkillLevel(PrimarySkillType.ARCHERY));
                                    preparedStatement.setInt(9, playerProfile.getSkillLevel(PrimarySkillType.SWORDS));
                                    preparedStatement.setInt(10, playerProfile.getSkillLevel(PrimarySkillType.AXES));
                                    preparedStatement.setInt(11, playerProfile.getSkillLevel(PrimarySkillType.ACROBATICS));
                                    preparedStatement.setInt(12, playerProfile.getSkillLevel(PrimarySkillType.FISHING));
                                    preparedStatement.setInt(13, playerProfile.getSkillLevel(PrimarySkillType.ALCHEMY));
                                    int n2 = 0;
                                    for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
                                        n2 += playerProfile.getSkillLevel(primarySkillType);
                                    }
                                    preparedStatement.setInt(14, n2);
                                    preparedStatement.setInt(15, n);
                                    boolean bl9 = preparedStatement.executeUpdate() != 0;
                                    preparedStatement.close();
                                    if (!(bl &= bl9)) {
                                        mcMMO.p.getLogger().severe("Failed to update skills for " + playerProfile.getPlayerName());
                                        bl5 = false;
                                        this.tryClose(preparedStatement);
                                        break block18;
                                    }
                                    preparedStatement = connection.prepareStatement("UPDATE " + this.tablePrefix + "experience SET  taming = ?, mining = ?, repair = ?, woodcutting = ?, unarmed = ?, herbalism = ?, excavation = ?, archery = ?, swords = ?, axes = ?, acrobatics = ?, fishing = ?, alchemy = ? WHERE user_id = ?");
                                    preparedStatement.setInt(1, playerProfile.getSkillXpLevel(PrimarySkillType.TAMING));
                                    preparedStatement.setInt(2, playerProfile.getSkillXpLevel(PrimarySkillType.MINING));
                                    preparedStatement.setInt(3, playerProfile.getSkillXpLevel(PrimarySkillType.REPAIR));
                                    preparedStatement.setInt(4, playerProfile.getSkillXpLevel(PrimarySkillType.WOODCUTTING));
                                    preparedStatement.setInt(5, playerProfile.getSkillXpLevel(PrimarySkillType.UNARMED));
                                    preparedStatement.setInt(6, playerProfile.getSkillXpLevel(PrimarySkillType.HERBALISM));
                                    preparedStatement.setInt(7, playerProfile.getSkillXpLevel(PrimarySkillType.EXCAVATION));
                                    preparedStatement.setInt(8, playerProfile.getSkillXpLevel(PrimarySkillType.ARCHERY));
                                    preparedStatement.setInt(9, playerProfile.getSkillXpLevel(PrimarySkillType.SWORDS));
                                    preparedStatement.setInt(10, playerProfile.getSkillXpLevel(PrimarySkillType.AXES));
                                    preparedStatement.setInt(11, playerProfile.getSkillXpLevel(PrimarySkillType.ACROBATICS));
                                    preparedStatement.setInt(12, playerProfile.getSkillXpLevel(PrimarySkillType.FISHING));
                                    preparedStatement.setInt(13, playerProfile.getSkillXpLevel(PrimarySkillType.ALCHEMY));
                                    preparedStatement.setInt(14, n);
                                    boolean bl10 = preparedStatement.executeUpdate() != 0;
                                    preparedStatement.close();
                                    if (!(bl &= bl10)) {
                                        mcMMO.p.getLogger().severe("Failed to update experience for " + playerProfile.getPlayerName());
                                        bl4 = false;
                                        this.tryClose(preparedStatement);
                                        break block19;
                                    }
                                    preparedStatement = connection.prepareStatement("UPDATE " + this.tablePrefix + "cooldowns SET   mining = ?, woodcutting = ?, unarmed = ?, herbalism = ?, excavation = ?, swords = ?, axes = ?, blast_mining = ?, chimaera_wing = ? WHERE user_id = ?");
                                    preparedStatement.setLong(1, playerProfile.getAbilityDATS(SuperAbilityType.SUPER_BREAKER));
                                    preparedStatement.setLong(2, playerProfile.getAbilityDATS(SuperAbilityType.TREE_FELLER));
                                    preparedStatement.setLong(3, playerProfile.getAbilityDATS(SuperAbilityType.BERSERK));
                                    preparedStatement.setLong(4, playerProfile.getAbilityDATS(SuperAbilityType.GREEN_TERRA));
                                    preparedStatement.setLong(5, playerProfile.getAbilityDATS(SuperAbilityType.GIGA_DRILL_BREAKER));
                                    preparedStatement.setLong(6, playerProfile.getAbilityDATS(SuperAbilityType.SERRATED_STRIKES));
                                    preparedStatement.setLong(7, playerProfile.getAbilityDATS(SuperAbilityType.SKULL_SPLITTER));
                                    preparedStatement.setLong(8, playerProfile.getAbilityDATS(SuperAbilityType.BLAST_MINING));
                                    preparedStatement.setLong(9, playerProfile.getUniqueData(UniqueDataType.CHIMAERA_WING_DATS));
                                    preparedStatement.setInt(10, n);
                                    bl = preparedStatement.executeUpdate() != 0;
                                    preparedStatement.close();
                                    if (!bl) {
                                        mcMMO.p.getLogger().severe("Failed to update cooldowns for " + playerProfile.getPlayerName());
                                        bl3 = false;
                                        this.tryClose(preparedStatement);
                                        break block20;
                                    }
                                    preparedStatement = connection.prepareStatement("UPDATE " + this.tablePrefix + "huds SET mobhealthbar = ?, scoreboardtips = ? WHERE user_id = ?");
                                    preparedStatement.setString(1, playerProfile.getMobHealthbarType() == null ? Config.getInstance().getMobHealthbarDefault().name() : playerProfile.getMobHealthbarType().name());
                                    preparedStatement.setInt(2, playerProfile.getScoreboardTipsShown());
                                    preparedStatement.setInt(3, n);
                                    bl = preparedStatement.executeUpdate() != 0;
                                    preparedStatement.close();
                                    if (!bl) {
                                        mcMMO.p.getLogger().severe("Failed to update hud settings for " + playerProfile.getPlayerName());
                                        bl2 = false;
                                        this.tryClose(preparedStatement);
                                        break block21;
                                    }
                                    this.tryClose(preparedStatement);
                                    break block22;
                                }
                                catch (SQLException sQLException) {
                                    this.printErrors(sQLException);
                                    return bl;
                                }
                            }
                            this.tryClose(connection);
                            return bl6;
                        }
                        this.tryClose(connection);
                        return bl5;
                    }
                    this.tryClose(connection);
                    return bl4;
                }
                this.tryClose(connection);
                return bl3;
            }
            this.tryClose(connection);
            return bl2;
        }
        this.tryClose(connection);
        return bl;
        finally {
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PlayerStat> readLeaderboard(PrimarySkillType primarySkillType, int n, int n2) {
        ArrayList<PlayerStat> arrayList = new ArrayList<PlayerStat>();
        String string = primarySkillType == null ? ALL_QUERY_VERSION : primarySkillType.name().toLowerCase();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            preparedStatement = connection.prepareStatement("SELECT " + string + ", user FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON (user_id = id) WHERE " + string + " > 0 AND NOT user = '\\_INVALID\\_OLD\\_USERNAME\\_' ORDER BY " + string + " DESC, user LIMIT ?, ?");
            preparedStatement.setInt(1, n * n2 - n2);
            preparedStatement.setInt(2, n2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    arrayList2.add(resultSet.getString(i));
                }
                arrayList.add(new PlayerStat((String)arrayList2.get(1), Integer.valueOf((String)arrayList2.get(0))));
            }
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<PrimarySkillType, Integer> readRank(String string) {
        HashMap<PrimarySkillType, Integer> hashMap = new HashMap<PrimarySkillType, Integer>();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
                String string2 = primarySkillType.name().toLowerCase();
                String string3 = "SELECT COUNT(*) AS rank FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE " + string2 + " > 0 AND " + string2 + " > (SELECT " + string2 + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE user = ?)";
                preparedStatement = connection.prepareStatement(string3);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                int n = resultSet.getInt("rank");
                string3 = "SELECT user, " + string2 + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE " + string2 + " > 0 AND " + string2 + " = (SELECT " + string2 + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE user = '" + string + "') ORDER BY user";
                resultSet.close();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement(string3);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    if (!resultSet.getString("user").equalsIgnoreCase(string)) continue;
                    hashMap.put(primarySkillType, n + resultSet.getRow());
                    break;
                }
                resultSet.close();
                preparedStatement.close();
            }
            Object object = "SELECT COUNT(*) AS rank FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE " + ALL_QUERY_VERSION + " > 0 AND " + ALL_QUERY_VERSION + " > (SELECT " + ALL_QUERY_VERSION + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE user = ?)";
            preparedStatement = connection.prepareStatement((String)object);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n = resultSet.getInt("rank");
            resultSet.close();
            preparedStatement.close();
            object = "SELECT user, total FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE " + ALL_QUERY_VERSION + " > 0 AND " + ALL_QUERY_VERSION + " = (SELECT " + ALL_QUERY_VERSION + " FROM " + this.tablePrefix + "users JOIN " + this.tablePrefix + "skills ON user_id = id WHERE user = ?) ORDER BY user";
            preparedStatement = connection.prepareStatement((String)object);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (!resultSet.getString("user").equalsIgnoreCase(string)) continue;
                hashMap.put(null, n + resultSet.getRow());
                break;
            }
            resultSet.close();
            preparedStatement.close();
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newUser(String string, UUID uUID) {
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            this.newUser(connection, string, uUID);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int newUser(Connection connection, String string, UUID uUID) {
        block7: {
            int n;
            ResultSet resultSet = null;
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("UPDATE `" + this.tablePrefix + "users` SET user = ? WHERE user = ?");
                preparedStatement.setString(1, "_INVALID_OLD_USERNAME_");
                preparedStatement.setString(2, string);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("INSERT INTO " + this.tablePrefix + "users (user, uuid, lastlogin) VALUES (?, ?, UNIX_TIMESTAMP())", 1);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, uUID != null ? uUID.toString() : null);
                preparedStatement.executeUpdate();
                resultSet = preparedStatement.getGeneratedKeys();
                if (!resultSet.next()) {
                    mcMMO.p.getLogger().severe("Unable to create new user account in DB");
                    int n2 = -1;
                    this.tryClose(resultSet);
                    this.tryClose(preparedStatement);
                    return n2;
                }
                this.writeMissingRows(connection, resultSet.getInt(1));
                n = resultSet.getInt(1);
                this.tryClose(resultSet);
            }
            catch (SQLException sQLException) {
                this.printErrors(sQLException);
                break block7;
            }
            finally {
                this.tryClose(resultSet);
                this.tryClose(preparedStatement);
            }
            this.tryClose(preparedStatement);
            return n;
        }
        return -1;
    }

    @Override
    @Deprecated
    public PlayerProfile loadPlayerProfile(String string, boolean bl) {
        return this.loadPlayerProfile(string, null, false, true);
    }

    @Override
    public PlayerProfile loadPlayerProfile(UUID uUID) {
        return this.loadPlayerProfile("", uUID, false, true);
    }

    @Override
    public PlayerProfile loadPlayerProfile(String string, UUID uUID, boolean bl) {
        return this.loadPlayerProfile(string, uUID, bl, true);
    }

    /*
     * Exception decompiling
     */
    private PlayerProfile loadPlayerProfile(String var1_1, UUID var2_2, boolean var3_3, boolean var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertUsers(DatabaseManager databaseManager) {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            preparedStatement = connection.prepareStatement("SELECT s.taming, s.mining, s.repair, s.woodcutting, s.unarmed, s.herbalism, s.excavation, s.archery, s.swords, s.axes, s.acrobatics, s.fishing, s.alchemy, e.taming, e.mining, e.repair, e.woodcutting, e.unarmed, e.herbalism, e.excavation, e.archery, e.swords, e.axes, e.acrobatics, e.fishing, e.alchemy, c.taming, c.mining, c.repair, c.woodcutting, c.unarmed, c.herbalism, c.excavation, c.archery, c.swords, c.axes, c.acrobatics, c.blast_mining, c.chimaera_wing, h.mobhealthbar, h.scoreboardtips, u.uuid FROM " + this.tablePrefix + "users u JOIN " + this.tablePrefix + "skills s ON (u.id = s.user_id) JOIN " + this.tablePrefix + "experience e ON (u.id = e.user_id) JOIN " + this.tablePrefix + "cooldowns c ON (u.id = c.user_id) JOIN " + this.tablePrefix + "huds h ON (u.id = h.user_id) WHERE u.user = ?");
            List<String> list = this.getStoredUsers();
            int n = 0;
            long l = System.currentTimeMillis();
            for (String string : list) {
                preparedStatement.setString(1, string);
                try {
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    databaseManager.saveUser(this.loadFromResult(string, resultSet));
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    this.printErrors(sQLException);
                }
                Misc.printProgress(++n, 200, l);
            }
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUID(String string, UUID uUID) {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            preparedStatement = connection.prepareStatement("UPDATE `" + this.tablePrefix + "users` SET   uuid = ? WHERE user = ?");
            preparedStatement.setString(1, uUID.toString());
            preparedStatement.setString(2, string);
            preparedStatement.execute();
            boolean bl = true;
            this.tryClose(preparedStatement);
            this.tryClose(connection);
            return bl;
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUIDs(Map<String, UUID> map) {
        PreparedStatement preparedStatement = null;
        int n = 0;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            preparedStatement = connection.prepareStatement("UPDATE " + this.tablePrefix + "users SET uuid = ? WHERE user = ?");
            for (Map.Entry<String, UUID> entry : map.entrySet()) {
                preparedStatement.setString(1, entry.getValue().toString());
                preparedStatement.setString(2, entry.getKey());
                preparedStatement.addBatch();
                if (++n % 500 != 0) continue;
                preparedStatement.executeBatch();
                n = 0;
            }
            if (n != 0) {
                preparedStatement.executeBatch();
            }
            boolean bl = true;
            this.tryClose(preparedStatement);
            this.tryClose(connection);
            return bl;
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStoredUsers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT user FROM " + this.tablePrefix + "users");
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("user"));
            }
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStructure() {
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            preparedStatement = connection.prepareStatement("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = ? AND table_name = ?");
            preparedStatement.setString(1, Config.getInstance().getMySQLDatabaseName());
            preparedStatement.setString(2, this.tablePrefix + "users");
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                statement = connection.createStatement();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "users` (`id` int(10) unsigned NOT NULL AUTO_INCREMENT,`user` varchar(40) NOT NULL,`uuid` varchar(36) NULL DEFAULT NULL,`lastlogin` int(32) unsigned NOT NULL,PRIMARY KEY (`id`),INDEX(`user`(20) ASC),UNIQUE KEY `uuid` (`uuid`)) DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;");
                this.tryClose(statement);
            }
            this.tryClose(resultSet);
            preparedStatement.setString(1, Config.getInstance().getMySQLDatabaseName());
            preparedStatement.setString(2, this.tablePrefix + "huds");
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                statement = connection.createStatement();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "huds` (`user_id` int(10) unsigned NOT NULL,`mobhealthbar` varchar(50) NOT NULL DEFAULT '" + (Object)((Object)Config.getInstance().getMobHealthbarDefault()) + "',`scoreboardtips` int(10) NOT NULL DEFAULT '0',PRIMARY KEY (`user_id`)) DEFAULT CHARSET=latin1;");
                this.tryClose(statement);
            }
            this.tryClose(resultSet);
            preparedStatement.setString(1, Config.getInstance().getMySQLDatabaseName());
            preparedStatement.setString(2, this.tablePrefix + "cooldowns");
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                statement = connection.createStatement();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "cooldowns` (`user_id` int(10) unsigned NOT NULL,`taming` int(32) unsigned NOT NULL DEFAULT '0',`mining` int(32) unsigned NOT NULL DEFAULT '0',`woodcutting` int(32) unsigned NOT NULL DEFAULT '0',`repair` int(32) unsigned NOT NULL DEFAULT '0',`unarmed` int(32) unsigned NOT NULL DEFAULT '0',`herbalism` int(32) unsigned NOT NULL DEFAULT '0',`excavation` int(32) unsigned NOT NULL DEFAULT '0',`archery` int(32) unsigned NOT NULL DEFAULT '0',`swords` int(32) unsigned NOT NULL DEFAULT '0',`axes` int(32) unsigned NOT NULL DEFAULT '0',`acrobatics` int(32) unsigned NOT NULL DEFAULT '0',`blast_mining` int(32) unsigned NOT NULL DEFAULT '0',`chimaera_wing` int(32) unsigned NOT NULL DEFAULT '0',PRIMARY KEY (`user_id`)) DEFAULT CHARSET=latin1;");
                this.tryClose(statement);
            }
            this.tryClose(resultSet);
            preparedStatement.setString(1, Config.getInstance().getMySQLDatabaseName());
            preparedStatement.setString(2, this.tablePrefix + "skills");
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                String string = "'" + AdvancedConfig.getInstance().getStartingLevel() + "'";
                String string2 = "'" + AdvancedConfig.getInstance().getStartingLevel() * (PrimarySkillType.values().length - PrimarySkillType.CHILD_SKILLS.size()) + "'";
                statement = connection.createStatement();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "skills` (`user_id` int(10) unsigned NOT NULL,`taming` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`mining` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`woodcutting` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`repair` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`unarmed` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`herbalism` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`excavation` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`archery` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`swords` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`axes` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`acrobatics` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`fishing` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`alchemy` int(10) unsigned NOT NULL DEFAULT " + (String)string + ",`total` int(10) unsigned NOT NULL DEFAULT " + string2 + ",PRIMARY KEY (`user_id`)) DEFAULT CHARSET=latin1;");
                this.tryClose(statement);
            }
            this.tryClose(resultSet);
            preparedStatement.setString(1, Config.getInstance().getMySQLDatabaseName());
            preparedStatement.setString(2, this.tablePrefix + "experience");
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                statement = connection.createStatement();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "experience` (`user_id` int(10) unsigned NOT NULL,`taming` int(10) unsigned NOT NULL DEFAULT '0',`mining` int(10) unsigned NOT NULL DEFAULT '0',`woodcutting` int(10) unsigned NOT NULL DEFAULT '0',`repair` int(10) unsigned NOT NULL DEFAULT '0',`unarmed` int(10) unsigned NOT NULL DEFAULT '0',`herbalism` int(10) unsigned NOT NULL DEFAULT '0',`excavation` int(10) unsigned NOT NULL DEFAULT '0',`archery` int(10) unsigned NOT NULL DEFAULT '0',`swords` int(10) unsigned NOT NULL DEFAULT '0',`axes` int(10) unsigned NOT NULL DEFAULT '0',`acrobatics` int(10) unsigned NOT NULL DEFAULT '0',`fishing` int(10) unsigned NOT NULL DEFAULT '0',`alchemy` int(10) unsigned NOT NULL DEFAULT '0',PRIMARY KEY (`user_id`)) DEFAULT CHARSET=latin1;");
                this.tryClose(statement);
            }
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
            for (UpgradeType upgradeType : UpgradeType.values()) {
                this.checkDatabaseStructure(connection, upgradeType);
            }
            if (Config.getInstance().getTruncateSkills()) {
                for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
                    int n = Config.getInstance().getLevelCap(primarySkillType);
                    if (n == Integer.MAX_VALUE) continue;
                    preparedStatement = connection.prepareStatement("UPDATE `" + this.tablePrefix + "skills` SET `" + primarySkillType.name().toLowerCase() + "` = " + n + " WHERE `" + primarySkillType.name().toLowerCase() + "` > " + n);
                    preparedStatement.executeUpdate();
                    this.tryClose(preparedStatement);
                }
            }
            mcMMO.p.getLogger().info("Killing orphans");
            statement = connection.createStatement();
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "experience` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "experience`.`user_id` = `u`.`id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "huds` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "huds`.`user_id` = `u`.`id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "cooldowns` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "cooldowns`.`user_id` = `u`.`id`)");
            statement.executeUpdate("DELETE FROM `" + this.tablePrefix + "skills` WHERE NOT EXISTS (SELECT * FROM `" + this.tablePrefix + "users` `u` WHERE `" + this.tablePrefix + "skills`.`user_id` = `u`.`id`)");
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
            this.tryClose(statement);
            this.tryClose(connection);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
            this.tryClose(statement);
            this.tryClose(connection);
        }
    }

    private Connection getConnection(PoolIdentifier poolIdentifier) {
        Connection connection = null;
        switch (poolIdentifier) {
            case LOAD: {
                connection = this.loadPool.getConnection();
                break;
            }
            case MISC: {
                connection = this.miscPool.getConnection();
                break;
            }
            case SAVE: {
                connection = this.savePool.getConnection();
            }
        }
        if (connection == null) {
            throw new RuntimeException("getConnection() for " + poolIdentifier.name().toLowerCase() + " pool timed out.  Increase max connections settings.");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatabaseStructure(Connection connection, UpgradeType upgradeType) {
        if (!mcMMO.getUpgradeManager().shouldUpgrade(upgradeType)) {
            mcMMO.p.debug("Skipping " + upgradeType.name() + " upgrade (unneeded)");
            return;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            switch (upgradeType) {
                case ADD_FISHING: {
                    this.checkUpgradeAddFishing(statement);
                    break;
                }
                case ADD_BLAST_MINING_COOLDOWN: {
                    this.checkUpgradeAddBlastMiningCooldown(statement);
                    break;
                }
                case ADD_SQL_INDEXES: {
                    this.checkUpgradeAddSQLIndexes(statement);
                    break;
                }
                case ADD_MOB_HEALTHBARS: {
                    this.checkUpgradeAddMobHealthbars(statement);
                    break;
                }
                case DROP_SQL_PARTY_NAMES: {
                    this.checkUpgradeDropPartyNames(statement);
                    break;
                }
                case DROP_SPOUT: {
                    this.checkUpgradeDropSpout(statement);
                    break;
                }
                case ADD_ALCHEMY: {
                    this.checkUpgradeAddAlchemy(statement);
                    break;
                }
                case ADD_UUIDS: {
                    this.checkUpgradeAddUUIDs(statement);
                    return;
                }
                case ADD_SCOREBOARD_TIPS: {
                    this.checkUpgradeAddScoreboardTips(statement);
                    return;
                }
                case DROP_NAME_UNIQUENESS: {
                    this.checkNameUniqueness(statement);
                    return;
                }
                case ADD_SKILL_TOTAL: {
                    this.checkUpgradeSkillTotal(connection);
                    break;
                }
                case ADD_UNIQUE_PLAYER_DATA: {
                    this.checkUpgradeAddUniqueChimaeraWing(statement);
                    break;
                }
            }
            mcMMO.getUpgradeManager().setUpgradeCompleted(upgradeType);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMissingRows(Connection connection, int n) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "experience (user_id) VALUES (?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "skills (user_id) VALUES (?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "cooldowns (user_id) VALUES (?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("INSERT IGNORE INTO " + this.tablePrefix + "huds (user_id, mobhealthbar, scoreboardtips) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, Config.getInstance().getMobHealthbarDefault().name());
            preparedStatement.setInt(3, 0);
            preparedStatement.execute();
            preparedStatement.close();
            this.tryClose(preparedStatement);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(preparedStatement);
        }
    }

    private PlayerProfile loadFromResult(String string, ResultSet resultSet) {
        UUID uUID;
        int n;
        MobHealthbarType mobHealthbarType;
        EnumMap<PrimarySkillType, Integer> enumMap = new EnumMap<PrimarySkillType, Integer>(PrimarySkillType.class);
        EnumMap<PrimarySkillType, Float> enumMap2 = new EnumMap<PrimarySkillType, Float>(PrimarySkillType.class);
        EnumMap<SuperAbilityType, Integer> enumMap3 = new EnumMap<SuperAbilityType, Integer>(SuperAbilityType.class);
        EnumMap<UniqueDataType, Integer> enumMap4 = new EnumMap<UniqueDataType, Integer>(UniqueDataType.class);
        boolean bl = false;
        int n2 = 13;
        int n3 = 26;
        int n4 = 39;
        enumMap.put(PrimarySkillType.TAMING, resultSet.getInt(1));
        enumMap.put(PrimarySkillType.MINING, resultSet.getInt(2));
        enumMap.put(PrimarySkillType.REPAIR, resultSet.getInt(3));
        enumMap.put(PrimarySkillType.WOODCUTTING, resultSet.getInt(4));
        enumMap.put(PrimarySkillType.UNARMED, resultSet.getInt(5));
        enumMap.put(PrimarySkillType.HERBALISM, resultSet.getInt(6));
        enumMap.put(PrimarySkillType.EXCAVATION, resultSet.getInt(7));
        enumMap.put(PrimarySkillType.ARCHERY, resultSet.getInt(8));
        enumMap.put(PrimarySkillType.SWORDS, resultSet.getInt(9));
        enumMap.put(PrimarySkillType.AXES, resultSet.getInt(10));
        enumMap.put(PrimarySkillType.ACROBATICS, resultSet.getInt(11));
        enumMap.put(PrimarySkillType.FISHING, resultSet.getInt(12));
        enumMap.put(PrimarySkillType.ALCHEMY, resultSet.getInt(13));
        enumMap2.put(PrimarySkillType.TAMING, Float.valueOf(resultSet.getFloat(14)));
        enumMap2.put(PrimarySkillType.MINING, Float.valueOf(resultSet.getFloat(15)));
        enumMap2.put(PrimarySkillType.REPAIR, Float.valueOf(resultSet.getFloat(16)));
        enumMap2.put(PrimarySkillType.WOODCUTTING, Float.valueOf(resultSet.getFloat(17)));
        enumMap2.put(PrimarySkillType.UNARMED, Float.valueOf(resultSet.getFloat(18)));
        enumMap2.put(PrimarySkillType.HERBALISM, Float.valueOf(resultSet.getFloat(19)));
        enumMap2.put(PrimarySkillType.EXCAVATION, Float.valueOf(resultSet.getFloat(20)));
        enumMap2.put(PrimarySkillType.ARCHERY, Float.valueOf(resultSet.getFloat(21)));
        enumMap2.put(PrimarySkillType.SWORDS, Float.valueOf(resultSet.getFloat(22)));
        enumMap2.put(PrimarySkillType.AXES, Float.valueOf(resultSet.getFloat(23)));
        enumMap2.put(PrimarySkillType.ACROBATICS, Float.valueOf(resultSet.getFloat(24)));
        enumMap2.put(PrimarySkillType.FISHING, Float.valueOf(resultSet.getFloat(25)));
        enumMap2.put(PrimarySkillType.ALCHEMY, Float.valueOf(resultSet.getFloat(26)));
        enumMap3.put(SuperAbilityType.SUPER_BREAKER, resultSet.getInt(28));
        enumMap3.put(SuperAbilityType.TREE_FELLER, resultSet.getInt(30));
        enumMap3.put(SuperAbilityType.BERSERK, resultSet.getInt(31));
        enumMap3.put(SuperAbilityType.GREEN_TERRA, resultSet.getInt(32));
        enumMap3.put(SuperAbilityType.GIGA_DRILL_BREAKER, resultSet.getInt(33));
        enumMap3.put(SuperAbilityType.SERRATED_STRIKES, resultSet.getInt(35));
        enumMap3.put(SuperAbilityType.SKULL_SPLITTER, resultSet.getInt(36));
        enumMap3.put(SuperAbilityType.BLAST_MINING, resultSet.getInt(38));
        enumMap4.put(UniqueDataType.CHIMAERA_WING_DATS, resultSet.getInt(39));
        try {
            mobHealthbarType = MobHealthbarType.valueOf(resultSet.getString(40));
        }
        catch (Exception exception) {
            mobHealthbarType = Config.getInstance().getMobHealthbarDefault();
        }
        try {
            n = resultSet.getInt(41);
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            uUID = UUID.fromString(resultSet.getString(42));
        }
        catch (Exception exception) {
            uUID = null;
        }
        return new PlayerProfile(string, uUID, enumMap, enumMap2, enumMap3, mobHealthbarType, n, enumMap4);
    }

    private void printErrors(SQLException sQLException) {
        StackTraceElement stackTraceElement = sQLException.getStackTrace()[0];
        mcMMO.p.getLogger().severe("Location: " + stackTraceElement.getClassName() + " " + stackTraceElement.getMethodName() + " " + stackTraceElement.getLineNumber());
        mcMMO.p.getLogger().severe("SQLException: " + sQLException.getMessage());
        mcMMO.p.getLogger().severe("SQLState: " + sQLException.getSQLState());
        mcMMO.p.getLogger().severe("VendorError: " + sQLException.getErrorCode());
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNameUniqueness(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SHOW INDEXES FROM `" + this.tablePrefix + "users` WHERE Column_name='user'  AND NOT Non_unique");
            if (!resultSet.next()) {
                this.tryClose(resultSet);
                return;
            }
            resultSet.close();
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables to drop name uniqueness...");
            statement.execute("ALTER TABLE `" + this.tablePrefix + "users` DROP INDEX `user`,ADD INDEX `user` (`user`(20) ASC)");
            this.tryClose(resultSet);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            this.tryClose(resultSet);
        }
    }

    private void checkUpgradeAddAlchemy(Statement statement) {
        try {
            statement.executeQuery("SELECT `alchemy` FROM `" + this.tablePrefix + "skills` LIMIT 1");
        }
        catch (SQLException sQLException) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for Alchemy...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD `alchemy` int(10) NOT NULL DEFAULT '0'");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "experience` ADD `alchemy` int(10) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddBlastMiningCooldown(Statement statement) {
        try {
            statement.executeQuery("SELECT `blast_mining` FROM `" + this.tablePrefix + "cooldowns` LIMIT 1");
        }
        catch (SQLException sQLException) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for Blast Mining...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "cooldowns` ADD `blast_mining` int(32) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddUniqueChimaeraWing(Statement statement) {
        try {
            statement.executeQuery("SELECT `chimaera_wing` FROM `" + this.tablePrefix + "cooldowns` LIMIT 1");
        }
        catch (SQLException sQLException) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for Chimaera Wing...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "cooldowns` ADD `chimaera_wing` int(32) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddFishing(Statement statement) {
        try {
            statement.executeQuery("SELECT `fishing` FROM `" + this.tablePrefix + "skills` LIMIT 1");
        }
        catch (SQLException sQLException) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for Fishing...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD `fishing` int(10) NOT NULL DEFAULT '0'");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "experience` ADD `fishing` int(10) NOT NULL DEFAULT '0'");
        }
    }

    private void checkUpgradeAddMobHealthbars(Statement statement) {
        try {
            statement.executeQuery("SELECT `mobhealthbar` FROM `" + this.tablePrefix + "huds` LIMIT 1");
        }
        catch (SQLException sQLException) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for mob healthbars...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "huds` ADD `mobhealthbar` varchar(50) NOT NULL DEFAULT '" + (Object)((Object)Config.getInstance().getMobHealthbarDefault()) + "'");
        }
    }

    private void checkUpgradeAddScoreboardTips(Statement statement) {
        try {
            statement.executeQuery("SELECT `scoreboardtips` FROM `" + this.tablePrefix + "huds` LIMIT 1");
        }
        catch (SQLException sQLException) {
            mcMMO.p.getLogger().info("Updating mcMMO MySQL tables for scoreboard tips...");
            statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "huds` ADD `scoreboardtips` int(10) NOT NULL DEFAULT '0' ;");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeAddSQLIndexes(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SHOW INDEX FROM `" + this.tablePrefix + "skills` WHERE `Key_name` LIKE 'idx\\_%'");
            resultSet.last();
            if (resultSet.getRow() != PrimarySkillType.NON_CHILD_SKILLS.size()) {
                mcMMO.p.getLogger().info("Indexing tables, this may take a while on larger databases");
                for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
                    String string = primarySkillType.name().toLowerCase();
                    try {
                        statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD INDEX `idx_" + string + "` (`" + string + "`) USING BTREE");
                    }
                    catch (SQLException sQLException) {}
                }
            }
            this.tryClose(resultSet);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeAddUUIDs(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "users` LIMIT 1");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            boolean bl = false;
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                if (!resultSetMetaData.getColumnName(i).equalsIgnoreCase("uuid")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                mcMMO.p.getLogger().info("Adding UUIDs to mcMMO MySQL user table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "users` ADD `uuid` varchar(36) NULL DEFAULT NULL");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "users` ADD UNIQUE INDEX `uuid` (`uuid`) USING BTREE");
            }
            this.tryClose(resultSet);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
        }
        new GetUUIDUpdatesRequired().runTaskLaterAsynchronously((Plugin)mcMMO.p, 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeDropPartyNames(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "users` LIMIT 1");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            boolean bl = false;
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                if (!resultSetMetaData.getColumnName(i).equalsIgnoreCase("party")) continue;
                bl = true;
                break;
            }
            if (bl) {
                mcMMO.p.getLogger().info("Removing party name from users table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "users` DROP COLUMN `party`");
            }
            this.tryClose(resultSet);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeSkillTotal(Connection connection) {
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "skills` LIMIT 1");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            boolean bl = false;
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                if (!resultSetMetaData.getColumnName(i).equalsIgnoreCase(ALL_QUERY_VERSION)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                mcMMO.p.getLogger().info("Adding skill total column to skills table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD COLUMN `total` int NOT NULL DEFAULT '0'");
                statement.executeUpdate("UPDATE `" + this.tablePrefix + "skills` SET `total` = (taming+mining+woodcutting+repair+unarmed+herbalism+excavation+archery+swords+axes+acrobatics+fishing+alchemy)");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "skills` ADD INDEX `idx_total` (`total`) USING BTREE");
                connection.commit();
            }
            connection.setAutoCommit(true);
            this.tryClose(resultSet);
            this.tryClose(statement);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            connection.setAutoCommit(true);
            this.tryClose(resultSet);
            this.tryClose(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpgradeDropSpout(Statement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT * FROM `" + this.tablePrefix + "huds` LIMIT 1");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            boolean bl = false;
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                if (!resultSetMetaData.getColumnName(i).equalsIgnoreCase("hudtype")) continue;
                bl = true;
                break;
            }
            if (bl) {
                mcMMO.p.getLogger().info("Removing Spout HUD type from huds table...");
                statement.executeUpdate("ALTER TABLE `" + this.tablePrefix + "huds` DROP COLUMN `hudtype`");
            }
            this.tryClose(resultSet);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserID(Connection connection, String string, UUID uUID) {
        if (uUID == null) {
            return this.getUserIDByName(connection, string);
        }
        if (this.cachedUserIDs.containsKey(uUID)) {
            return this.cachedUserIDs.get(uUID);
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT id, user FROM " + this.tablePrefix + "users WHERE uuid = ? OR (uuid IS NULL AND user = ?)");
            preparedStatement.setString(1, uUID.toString());
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt("id");
                this.cachedUserIDs.put(uUID, n);
                int n2 = n;
                this.tryClose(resultSet);
                this.tryClose(preparedStatement);
                return n2;
            }
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserIDByName(Connection connection, String string) {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT id, user FROM " + this.tablePrefix + "users WHERE user = ?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n;
                int n2 = n = resultSet.getInt("id");
                this.tryClose(resultSet);
                this.tryClose(preparedStatement);
                return n2;
            }
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(resultSet);
            this.tryClose(preparedStatement);
        }
        return -1;
    }

    private void tryClose(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onDisable() {
        mcMMO.p.debug("Releasing connection pool resource...");
        this.miscPool.close();
        this.loadPool.close();
        this.savePool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMobHealthSettings() {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.getConnection(PoolIdentifier.MISC);
            preparedStatement = connection.prepareStatement("UPDATE " + this.tablePrefix + "huds SET mobhealthbar = ?");
            preparedStatement.setString(1, Config.getInstance().getMobHealthbarDefault().toString());
            preparedStatement.executeUpdate();
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
        catch (SQLException sQLException) {
            this.printErrors(sQLException);
        }
        finally {
            this.tryClose(preparedStatement);
            this.tryClose(connection);
        }
    }

    public static enum PoolIdentifier {
        MISC,
        LOAD,
        SAVE;

    }

    private class GetUUIDUpdatesRequired
    extends BukkitRunnable {
        private GetUUIDUpdatesRequired() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SQLDatabaseManager.this.massUpdateLock.lock();
            ArrayList<String> arrayList = new ArrayList<String>();
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                block10: {
                    try {
                        connection = SQLDatabaseManager.this.miscPool.getConnection();
                        statement = connection.createStatement();
                        resultSet = statement.executeQuery("SELECT `user` FROM `" + SQLDatabaseManager.this.tablePrefix + "users` WHERE `uuid` IS NULL");
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("user"));
                        }
                        SQLDatabaseManager.this.tryClose(resultSet);
                    }
                    catch (SQLException sQLException) {
                        SQLDatabaseManager.this.printErrors(sQLException);
                        break block10;
                    }
                    finally {
                        SQLDatabaseManager.this.tryClose(resultSet);
                        SQLDatabaseManager.this.tryClose(statement);
                        SQLDatabaseManager.this.tryClose(connection);
                    }
                    SQLDatabaseManager.this.tryClose(statement);
                    SQLDatabaseManager.this.tryClose(connection);
                }
                if (!arrayList.isEmpty()) {
                    new UUIDUpdateAsyncTask(mcMMO.p, arrayList).run();
                }
            }
            finally {
                SQLDatabaseManager.this.massUpdateLock.unlock();
            }
        }
    }
}

