/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.player.UniqueDataType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.database.UUIDUpdateAsyncTask;
import com.gmail.nossr50.util.Misc;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.plugin.Plugin;

public final class FlatfileDatabaseManager
implements DatabaseManager {
    private final HashMap<PrimarySkillType, List<PlayerStat>> playerStatHash = new HashMap();
    private final List<PlayerStat> powerLevels = new ArrayList<PlayerStat>();
    private long lastUpdate = 0L;
    private final long UPDATE_WAIT_TIME = 600000L;
    private final File usersFile = new File(mcMMO.getUsersFilePath());
    private static final Object fileWritingLock = new Object();
    public static int USERNAME = 0;
    public static int SKILLS_MINING = 1;
    public static int EXP_MINING = 4;
    public static int SKILLS_WOODCUTTING = 5;
    public static int EXP_WOODCUTTING = 6;
    public static int SKILLS_REPAIR = 7;
    public static int SKILLS_UNARMED = 8;
    public static int SKILLS_HERBALISM = 9;
    public static int SKILLS_EXCAVATION = 10;
    public static int SKILLS_ARCHERY = 11;
    public static int SKILLS_SWORDS = 12;
    public static int SKILLS_AXES = 13;
    public static int SKILLS_ACROBATICS = 14;
    public static int EXP_REPAIR = 15;
    public static int EXP_UNARMED = 16;
    public static int EXP_HERBALISM = 17;
    public static int EXP_EXCAVATION = 18;
    public static int EXP_ARCHERY = 19;
    public static int EXP_SWORDS = 20;
    public static int EXP_AXES = 21;
    public static int EXP_ACROBATICS = 22;
    public static int SKILLS_TAMING = 24;
    public static int EXP_TAMING = 25;
    public static int COOLDOWN_BERSERK = 26;
    public static int COOLDOWN_GIGA_DRILL_BREAKER = 27;
    public static int COOLDOWN_TREE_FELLER = 28;
    public static int COOLDOWN_GREEN_TERRA = 29;
    public static int COOLDOWN_SERRATED_STRIKES = 30;
    public static int COOLDOWN_SKULL_SPLITTER = 31;
    public static int COOLDOWN_SUPER_BREAKER = 32;
    public static int SKILLS_FISHING = 34;
    public static int EXP_FISHING = 35;
    public static int COOLDOWN_BLAST_MINING = 36;
    public static int LAST_LOGIN = 37;
    public static int HEALTHBAR = 38;
    public static int SKILLS_ALCHEMY = 39;
    public static int EXP_ALCHEMY = 40;
    public static int UUID_INDEX = 41;
    public static int SCOREBOARD_TIPS = 42;
    public static int COOLDOWN_CHIMAERA_WING = 43;

    protected FlatfileDatabaseManager() {
        this.checkStructure();
        this.updateLeaderboards();
        if (mcMMO.getUpgradeManager().shouldUpgrade(UpgradeType.ADD_UUIDS)) {
            new UUIDUpdateAsyncTask(mcMMO.p, this.getStoredUsers()).runTaskAsynchronously((Plugin)mcMMO.p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgePowerlessUsers() {
        int n = 0;
        mcMMO.p.getLogger().info("Purging powerless users...");
        BufferedReader bufferedReader = null;
        OutputStreamWriter outputStreamWriter = null;
        String string = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(string));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string2.split(":");
                    Map<PrimarySkillType, Integer> map = this.getSkillMapFromLine(stringArray);
                    boolean bl = true;
                    for (int n2 : map.values()) {
                        if (n2 == 0) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) {
                        stringBuilder.append(string2).append("\r\n");
                        continue;
                    }
                    ++n;
                }
                outputStreamWriter = new FileWriter(string);
                outputStreamWriter.write(stringBuilder.toString());
            }
            catch (IOException iOException) {
                mcMMO.p.getLogger().severe("Exception while reading " + string + " (Are you sure you formatted it correctly?)" + iOException.toString());
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        mcMMO.p.getLogger().info("Purged " + n + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeOldUsers() {
        int n = 0;
        long l = System.currentTimeMillis();
        mcMMO.p.getLogger().info("Purging old users...");
        BufferedReader bufferedReader = null;
        OutputStreamWriter outputStreamWriter = null;
        String string = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(string));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = bufferedReader.readLine()) != null) {
                    Object object2;
                    Object[] objectArray = string2.split(":");
                    String string3 = objectArray[USERNAME];
                    long l2 = 0L;
                    boolean bl = false;
                    try {
                        l2 = Long.parseLong(objectArray[37]) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                    }
                    if (l2 == 0L) {
                        object2 = mcMMO.p.getServer().getOfflinePlayer(string3);
                        l2 = object2.getLastPlayed();
                        bl = true;
                    }
                    if (l - l2 > PURGE_TIME) {
                        ++n;
                        continue;
                    }
                    if (bl) {
                        objectArray[37] = Long.toString(l2);
                        object2 = StringUtils.join((Object[])objectArray, (String)":");
                        stringBuilder.append((String)object2).append("\r\n");
                        continue;
                    }
                    stringBuilder.append(string2).append("\r\n");
                }
                outputStreamWriter = new FileWriter(string);
                outputStreamWriter.write(stringBuilder.toString());
            }
            catch (IOException iOException) {
                mcMMO.p.getLogger().severe("Exception while reading " + string + " (Are you sure you formatted it correctly?)" + iOException.toString());
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        mcMMO.p.getLogger().info("Purged " + n + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(String string, UUID uUID) {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        OutputStreamWriter outputStreamWriter = null;
        String string2 = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String string3;
                bufferedReader = new BufferedReader(new FileReader(string2));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (!bl && string3.split(":")[USERNAME].equalsIgnoreCase(string)) {
                        mcMMO.p.getLogger().info("User found, removing...");
                        bl = true;
                        continue;
                    }
                    stringBuilder.append(string3).append("\r\n");
                }
                outputStreamWriter = new FileWriter(string2);
                outputStreamWriter.write(stringBuilder.toString());
            }
            catch (Exception exception) {
                mcMMO.p.getLogger().severe("Exception while reading " + string2 + " (Are you sure you formatted it correctly?)" + exception.toString());
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Misc.profileCleanup(string);
        return bl;
    }

    @Override
    public void cleanupUser(UUID uUID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveUser(PlayerProfile playerProfile) {
        String string = playerProfile.getPlayerName();
        UUID uUID = playerProfile.getUniqueId();
        BufferedReader bufferedReader = null;
        OutputStreamWriter outputStreamWriter = null;
        String string2 = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            boolean bl;
            try {
                String string3;
                bufferedReader = new BufferedReader(new FileReader(string2));
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                while ((string3 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string3.split(":");
                    if (!(uUID != null && stringArray[UUID_INDEX].equalsIgnoreCase(uUID.toString()) || stringArray[USERNAME].equalsIgnoreCase(string))) {
                        stringBuilder.append(string3).append("\r\n");
                        continue;
                    }
                    this.writeUserToLine(playerProfile, string, uUID, stringBuilder);
                    bl2 = true;
                }
                if (!bl2) {
                    this.writeUserToLine(playerProfile, string, uUID, stringBuilder);
                }
                outputStreamWriter = new FileWriter(string2);
                outputStreamWriter.write(stringBuilder.toString());
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                boolean bl3 = false;
                return bl3;
            }
            return bl;
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void writeUserToLine(PlayerProfile playerProfile, String string, UUID uUID, StringBuilder stringBuilder) {
        stringBuilder.append(string).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.MINING)).append(":");
        stringBuilder.append(":");
        stringBuilder.append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.MINING)).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.WOODCUTTING)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.WOODCUTTING)).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.REPAIR)).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.UNARMED)).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.HERBALISM)).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.EXCAVATION)).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.ARCHERY)).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.SWORDS)).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.AXES)).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.ACROBATICS)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.REPAIR)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.UNARMED)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.HERBALISM)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.EXCAVATION)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.ARCHERY)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.SWORDS)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.AXES)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.ACROBATICS)).append(":");
        stringBuilder.append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.TAMING)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.TAMING)).append(":");
        stringBuilder.append((int)playerProfile.getAbilityDATS(SuperAbilityType.BERSERK)).append(":");
        stringBuilder.append((int)playerProfile.getAbilityDATS(SuperAbilityType.GIGA_DRILL_BREAKER)).append(":");
        stringBuilder.append((int)playerProfile.getAbilityDATS(SuperAbilityType.TREE_FELLER)).append(":");
        stringBuilder.append((int)playerProfile.getAbilityDATS(SuperAbilityType.GREEN_TERRA)).append(":");
        stringBuilder.append((int)playerProfile.getAbilityDATS(SuperAbilityType.SERRATED_STRIKES)).append(":");
        stringBuilder.append((int)playerProfile.getAbilityDATS(SuperAbilityType.SKULL_SPLITTER)).append(":");
        stringBuilder.append((int)playerProfile.getAbilityDATS(SuperAbilityType.SUPER_BREAKER)).append(":");
        stringBuilder.append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.FISHING)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.FISHING)).append(":");
        stringBuilder.append((int)playerProfile.getAbilityDATS(SuperAbilityType.BLAST_MINING)).append(":");
        stringBuilder.append(System.currentTimeMillis() / 1000L).append(":");
        MobHealthbarType mobHealthbarType = playerProfile.getMobHealthbarType();
        stringBuilder.append(mobHealthbarType == null ? Config.getInstance().getMobHealthbarDefault().toString() : mobHealthbarType.toString()).append(":");
        stringBuilder.append(playerProfile.getSkillLevel(PrimarySkillType.ALCHEMY)).append(":");
        stringBuilder.append(playerProfile.getSkillXpLevel(PrimarySkillType.ALCHEMY)).append(":");
        stringBuilder.append(uUID != null ? uUID.toString() : "NULL").append(":");
        stringBuilder.append(playerProfile.getScoreboardTipsShown()).append(":");
        stringBuilder.append(playerProfile.getUniqueData(UniqueDataType.CHIMAERA_WING_DATS)).append(":");
        stringBuilder.append("\r\n");
    }

    @Override
    public List<PlayerStat> readLeaderboard(PrimarySkillType primarySkillType, int n, int n2) {
        this.updateLeaderboards();
        List<PlayerStat> list = primarySkillType == null ? this.powerLevels : this.playerStatHash.get((Object)primarySkillType);
        int n3 = (Math.max(n, 1) - 1) * n2;
        return list.subList(Math.min(n3, list.size()), Math.min(n3 + n2, list.size()));
    }

    @Override
    public Map<PrimarySkillType, Integer> readRank(String string) {
        this.updateLeaderboards();
        HashMap<PrimarySkillType, Integer> hashMap = new HashMap<PrimarySkillType, Integer>();
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            hashMap.put(primarySkillType, this.getPlayerRank(string, this.playerStatHash.get((Object)primarySkillType)));
        }
        hashMap.put(null, this.getPlayerRank(string, this.powerLevels));
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newUser(String string, UUID uUID) {
        BufferedWriter bufferedWriter = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(mcMMO.getUsersFilePath(), true));
                String string2 = AdvancedConfig.getInstance().getStartingLevel() + ":";
                bufferedWriter.append(string).append(":");
                bufferedWriter.append(string2);
                bufferedWriter.append(":");
                bufferedWriter.append(":");
                bufferedWriter.append("0:");
                bufferedWriter.append(string2);
                bufferedWriter.append("0:");
                bufferedWriter.append(string2);
                bufferedWriter.append(string2);
                bufferedWriter.append(string2);
                bufferedWriter.append(string2);
                bufferedWriter.append(string2);
                bufferedWriter.append(string2);
                bufferedWriter.append(string2);
                bufferedWriter.append(string2);
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append(":");
                bufferedWriter.append(string2);
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append(":");
                bufferedWriter.append(string2);
                bufferedWriter.append("0:");
                bufferedWriter.append("0:");
                bufferedWriter.append(String.valueOf(System.currentTimeMillis() / 1000L)).append(":");
                bufferedWriter.append(Config.getInstance().getMobHealthbarDefault().toString()).append(":");
                bufferedWriter.append(string2);
                bufferedWriter.append("0:");
                bufferedWriter.append(uUID != null ? uUID.toString() : "NULL").append(":");
                bufferedWriter.append("0:");
                bufferedWriter.newLine();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    @Deprecated
    public PlayerProfile loadPlayerProfile(String string, boolean bl) {
        return this.loadPlayerProfile(string, null, false);
    }

    @Override
    public PlayerProfile loadPlayerProfile(UUID uUID) {
        return this.loadPlayerProfile("", uUID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerProfile loadPlayerProfile(String var1_1, UUID var2_2, boolean var3_3) {
        var4_4 = null;
        var5_5 = mcMMO.getUsersFilePath();
        var6_6 = FlatfileDatabaseManager.fileWritingLock;
        synchronized (var6_6) {
            block27: {
                block29: {
                    block28: {
                        block26: {
                            try {
                                var4_4 = new BufferedReader(new FileReader(var5_5));
                                while ((var7_7 = var4_4.readLine()) != null) {
                                    var8_11 = var7_7.split(":");
                                    if (var8_11[FlatfileDatabaseManager.UUID_INDEX].equalsIgnoreCase("NULL") == false ? var2_2 != null && var8_11[FlatfileDatabaseManager.UUID_INDEX].equalsIgnoreCase(var2_2.toString()) == false || var2_2 == null && var8_11[FlatfileDatabaseManager.USERNAME].equalsIgnoreCase(var1_1) == false : var8_11[FlatfileDatabaseManager.USERNAME].equalsIgnoreCase(var1_1) == false) continue;
                                    if (!var8_11[FlatfileDatabaseManager.USERNAME].equalsIgnoreCase(var1_1)) {
                                        mcMMO.p.debug("Name change detected: " + var8_11[FlatfileDatabaseManager.USERNAME] + " => " + var1_1);
                                        var8_11[FlatfileDatabaseManager.USERNAME] = var1_1;
                                    }
                                    var9_12 = this.loadFromLine(var8_11);
                                    break block26;
                                }
                                if (!var3_3) break block27;
                                if (var2_2 == null) {
                                    this.newUser(var1_1, var2_2);
                                    var8_11 = new PlayerProfile(var1_1, true);
                                    break block28;
                                }
                                this.newUser(var1_1, var2_2);
                                var8_11 = new PlayerProfile(var1_1, var2_2, true);
                                break block29;
                            }
                            catch (Exception var7_9) {
                                var7_9.printStackTrace();
                                break block27;
                            }
                        }
                        return var9_12;
                    }
                    return var8_11;
                }
                return var8_11;
                finally {
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (IOException var7_10) {}
                    }
                }
            }
            ** if (var2_2 != null) goto lbl42
        }
lbl41:
        // 1 sources

        return new PlayerProfile(var1_1);
lbl42:
        // 1 sources

        return new PlayerProfile(var1_1, var2_2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertUsers(DatabaseManager databaseManager) {
        BufferedReader bufferedReader = null;
        String string = mcMMO.getUsersFilePath();
        int n = 0;
        long l = System.currentTimeMillis();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(string));
                while ((string2 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string2.split(":");
                    try {
                        databaseManager.saveUser(this.loadFromLine(stringArray));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Misc.printProgress(++n, 200, l);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUID(String string, UUID uUID) {
        boolean bl = false;
        int n = 0;
        BufferedReader bufferedReader = null;
        FileWriter fileWriter = null;
        String string2 = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String string3;
                bufferedReader = new BufferedReader(new FileReader(string2));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string3 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string3.split(":");
                    if (!bl && stringArray[USERNAME].equalsIgnoreCase(string)) {
                        if (stringArray.length < 42) {
                            mcMMO.p.getLogger().severe("Could not update UUID for " + string + "!");
                            mcMMO.p.getLogger().severe("Database entry is invalid.");
                            continue;
                        }
                        string3 = string3.replace(stringArray[UUID_INDEX], uUID.toString());
                        bl = true;
                    }
                    ++n;
                    stringBuilder.append(string3).append("\r\n");
                }
                fileWriter = new FileWriter(string2);
                fileWriter.write(stringBuilder.toString());
            }
            catch (Exception exception) {
                mcMMO.p.getLogger().severe("Exception while reading " + string2 + " (Are you sure you formatted it correctly?)" + exception.toString());
            }
            finally {
                mcMMO.p.getLogger().info(n + " entries written while saving UUID for " + string);
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUIDs(Map<String, UUID> map) {
        BufferedReader bufferedReader = null;
        OutputStreamWriter outputStreamWriter = null;
        String string = mcMMO.getUsersFilePath();
        int n = 0;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(string));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = bufferedReader.readLine()) != null) {
                    Object[] objectArray = string2.split(":");
                    if (!map.isEmpty() && map.containsKey(objectArray[USERNAME])) {
                        if (objectArray.length < 42) {
                            mcMMO.p.getLogger().severe("Could not update UUID for " + objectArray[USERNAME] + "!");
                            mcMMO.p.getLogger().severe("Database entry is invalid.");
                            continue;
                        }
                        objectArray[FlatfileDatabaseManager.UUID_INDEX] = map.remove(objectArray[USERNAME]).toString();
                        string2 = StringUtils.join((Object[])objectArray, (String)":") + ":";
                    }
                    ++n;
                    stringBuilder.append(string2).append("\r\n");
                }
                outputStreamWriter = new FileWriter(string);
                outputStreamWriter.write(stringBuilder.toString());
            }
            catch (Exception exception) {
                mcMMO.p.getLogger().severe("Exception while reading " + string + " (Are you sure you formatted it correctly?)" + exception.toString());
            }
            finally {
                mcMMO.p.getLogger().info(n + " entries written while saving UUID batch");
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStoredUsers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        String string = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(string));
                while ((string2 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string2.split(":");
                    arrayList.add(stringArray[USERNAME]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLeaderboards() {
        if (System.currentTimeMillis() < this.lastUpdate + 600000L) {
            return;
        }
        String string = mcMMO.getUsersFilePath();
        this.lastUpdate = System.currentTimeMillis();
        this.powerLevels.clear();
        ArrayList<PlayerStat> arrayList = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList2 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList3 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList4 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList5 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList6 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList7 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList8 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList9 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList10 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList11 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList12 = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> arrayList13 = new ArrayList<PlayerStat>();
        BufferedReader bufferedReader = null;
        String string2 = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String string3;
                bufferedReader = new BufferedReader(new FileReader(string));
                while ((string3 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string3.split(":");
                    string2 = stringArray[USERNAME];
                    int n = 0;
                    Map<PrimarySkillType, Integer> map = this.getSkillMapFromLine(stringArray);
                    n += this.putStat(arrayList5, string2, map.get((Object)PrimarySkillType.ACROBATICS));
                    n += this.putStat(arrayList13, string2, map.get((Object)PrimarySkillType.ALCHEMY));
                    n += this.putStat(arrayList9, string2, map.get((Object)PrimarySkillType.ARCHERY));
                    n += this.putStat(arrayList8, string2, map.get((Object)PrimarySkillType.AXES));
                    n += this.putStat(arrayList4, string2, map.get((Object)PrimarySkillType.EXCAVATION));
                    n += this.putStat(arrayList12, string2, map.get((Object)PrimarySkillType.FISHING));
                    n += this.putStat(arrayList3, string2, map.get((Object)PrimarySkillType.HERBALISM));
                    n += this.putStat(arrayList, string2, map.get((Object)PrimarySkillType.MINING));
                    n += this.putStat(arrayList6, string2, map.get((Object)PrimarySkillType.REPAIR));
                    n += this.putStat(arrayList7, string2, map.get((Object)PrimarySkillType.SWORDS));
                    n += this.putStat(arrayList11, string2, map.get((Object)PrimarySkillType.TAMING));
                    n += this.putStat(arrayList10, string2, map.get((Object)PrimarySkillType.UNARMED));
                    this.putStat(this.powerLevels, string2, n += this.putStat(arrayList2, string2, map.get((Object)PrimarySkillType.WOODCUTTING)));
                }
            }
            catch (Exception exception) {
                mcMMO.p.getLogger().severe("Exception while reading " + string + " during user " + string2 + " (Are you sure you formatted it correctly?) " + exception.toString());
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        object = new SkillComparator();
        Collections.sort(arrayList, object);
        Collections.sort(arrayList2, object);
        Collections.sort(arrayList6, object);
        Collections.sort(arrayList10, object);
        Collections.sort(arrayList3, object);
        Collections.sort(arrayList4, object);
        Collections.sort(arrayList9, object);
        Collections.sort(arrayList7, object);
        Collections.sort(arrayList8, object);
        Collections.sort(arrayList5, object);
        Collections.sort(arrayList11, object);
        Collections.sort(arrayList12, object);
        Collections.sort(arrayList13, object);
        Collections.sort(this.powerLevels, object);
        this.playerStatHash.put(PrimarySkillType.MINING, arrayList);
        this.playerStatHash.put(PrimarySkillType.WOODCUTTING, arrayList2);
        this.playerStatHash.put(PrimarySkillType.REPAIR, arrayList6);
        this.playerStatHash.put(PrimarySkillType.UNARMED, arrayList10);
        this.playerStatHash.put(PrimarySkillType.HERBALISM, arrayList3);
        this.playerStatHash.put(PrimarySkillType.EXCAVATION, arrayList4);
        this.playerStatHash.put(PrimarySkillType.ARCHERY, arrayList9);
        this.playerStatHash.put(PrimarySkillType.SWORDS, arrayList7);
        this.playerStatHash.put(PrimarySkillType.AXES, arrayList8);
        this.playerStatHash.put(PrimarySkillType.ACROBATICS, arrayList5);
        this.playerStatHash.put(PrimarySkillType.TAMING, arrayList11);
        this.playerStatHash.put(PrimarySkillType.FISHING, arrayList12);
        this.playerStatHash.put(PrimarySkillType.ALCHEMY, arrayList13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStructure() {
        if (this.usersFile.exists()) {
            BufferedReader bufferedReader = null;
            OutputStreamWriter outputStreamWriter = null;
            String string = mcMMO.getUsersFilePath();
            Object object = fileWritingLock;
            synchronized (object) {
                try {
                    String string2;
                    bufferedReader = new BufferedReader(new FileReader(string));
                    StringBuilder stringBuilder = new StringBuilder();
                    HashSet<String> hashSet = new HashSet<String>();
                    HashSet<String> hashSet2 = new HashSet<String>();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.isEmpty()) continue;
                        if (string2.charAt(string2.length() - 1) != ':') {
                            string2 = string2.concat(":");
                        }
                        boolean bl = false;
                        Object[] objectArray = string2.split(":");
                        if (!hashSet.add(objectArray[USERNAME])) {
                            objectArray[FlatfileDatabaseManager.USERNAME] = "_INVALID_OLD_USERNAME_'";
                            bl = true;
                            if (objectArray.length < UUID_INDEX + 1 || objectArray[UUID_INDEX].equals("NULL")) continue;
                        }
                        if (objectArray.length >= 42 && !objectArray[UUID_INDEX].isEmpty() && !objectArray[UUID_INDEX].equals("NULL") && !hashSet2.add(objectArray[UUID_INDEX])) continue;
                        if (objectArray.length < 33) {
                            mcMMO.p.getLogger().warning("Dropping malformed or before version 1.0 line from database - " + string2);
                            continue;
                        }
                        String string3 = null;
                        if (objectArray.length > 33 && !objectArray[33].isEmpty()) {
                            objectArray[33] = "";
                            if (string3 == null) {
                                string3 = "1.4.07";
                            }
                            bl = true;
                        }
                        if (Config.getInstance().getTruncateSkills()) {
                            for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
                                int n = this.getSkillIndex(primarySkillType);
                                if (n >= objectArray.length) continue;
                                int n2 = Config.getInstance().getLevelCap(primarySkillType);
                                if (Integer.valueOf(objectArray[n]) <= n2) continue;
                                mcMMO.p.getLogger().warning("Truncating " + primarySkillType.getName() + " to configured max level for player " + objectArray[USERNAME]);
                                objectArray[n] = n2 + "";
                                bl = true;
                            }
                        }
                        if (!bl && objectArray.length == 43) {
                            stringBuilder.append(string2).append("\r\n");
                            continue;
                        }
                        if (objectArray.length <= 33) {
                            objectArray = Arrays.copyOf(objectArray, objectArray.length + 1);
                            objectArray[objectArray.length - 1] = "";
                            string3 = "1.1.06";
                        }
                        if (objectArray.length <= 35) {
                            objectArray = Arrays.copyOf(objectArray, objectArray.length + 2);
                            objectArray[objectArray.length - 1] = "0";
                            objectArray[objectArray.length - 2] = "0";
                            if (string3 == null) {
                                string3 = "1.2.00";
                            }
                        }
                        if (objectArray.length <= 36) {
                            objectArray = Arrays.copyOf(objectArray, objectArray.length + 1);
                            objectArray[objectArray.length - 1] = "0";
                            if (string3 == null) {
                                string3 = "1.3.00";
                            }
                        }
                        if (objectArray.length <= 37) {
                            objectArray = Arrays.copyOf(objectArray, objectArray.length + 1);
                            objectArray[objectArray.length - 1] = "0";
                            if (string3 == null) {
                                string3 = "1.4.00";
                            }
                        }
                        if (objectArray.length <= 38) {
                            objectArray = Arrays.copyOf(objectArray, objectArray.length + 1);
                            objectArray[objectArray.length - 1] = Config.getInstance().getMobHealthbarDefault().toString();
                            if (string3 == null) {
                                string3 = "1.4.06";
                            }
                        }
                        if (objectArray.length <= 39) {
                            objectArray = Arrays.copyOf(objectArray, objectArray.length + 2);
                            objectArray[objectArray.length - 1] = "0";
                            objectArray[objectArray.length - 2] = "0";
                            if (string3 == null) {
                                string3 = "1.4.08";
                            }
                        }
                        if (objectArray.length <= 41) {
                            objectArray = Arrays.copyOf(objectArray, objectArray.length + 1);
                            objectArray[objectArray.length - 1] = "NULL";
                            if (string3 == null) {
                                string3 = "1.5.01";
                            }
                        }
                        if (objectArray.length <= 42) {
                            objectArray = Arrays.copyOf(objectArray, objectArray.length + 1);
                            objectArray[objectArray.length - 1] = "0";
                            if (string3 == null) {
                                string3 = "1.5.02";
                            }
                        }
                        boolean bl2 = false;
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i].isEmpty() && i != 2 && i != 3 && i != 23 && i != 33 && i != 41) {
                                bl2 = true;
                                objectArray[i] = i == 37 ? String.valueOf(System.currentTimeMillis() / 1000L) : (i == 38 ? Config.getInstance().getMobHealthbarDefault().toString() : "0");
                            }
                            if (com.gmail.nossr50.util.StringUtils.isInt(objectArray[i]) && i == 38) {
                                bl2 = true;
                                objectArray[i] = Config.getInstance().getMobHealthbarDefault().toString();
                            }
                            if (com.gmail.nossr50.util.StringUtils.isInt(objectArray[i]) || i == 0 || i == 2 || i == 3 || i == 23 || i == 33 || i == 38 || i == 41) continue;
                            bl2 = true;
                            objectArray[i] = "0";
                        }
                        if (bl2) {
                            mcMMO.p.debug("Updating corrupted database line for player " + objectArray[USERNAME]);
                        }
                        if (string3 != null) {
                            mcMMO.p.debug("Updating database line from before version " + string3 + " for player " + objectArray[USERNAME]);
                        }
                        bl |= bl2;
                        bl |= string3 != null;
                        if (Config.getInstance().getTruncateSkills()) {
                            Map<PrimarySkillType, Integer> map = this.getSkillMapFromLine((String[])objectArray);
                            for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
                                int n = Config.getInstance().getLevelCap(primarySkillType);
                                if (map.get((Object)primarySkillType) <= n) continue;
                                bl = true;
                            }
                        }
                        if (bl) {
                            string2 = StringUtils.join((Object[])objectArray, (String)":") + ":";
                        }
                        stringBuilder.append(string2).append("\r\n");
                    }
                    outputStreamWriter = new FileWriter(string);
                    outputStreamWriter.write(stringBuilder.toString());
                }
                catch (IOException iOException) {
                    mcMMO.p.getLogger().severe("Exception while reading " + string + " (Are you sure you formatted it correctly?)" + iOException.toString());
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_FISHING);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_BLAST_MINING_COOLDOWN);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_SQL_INDEXES);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_MOB_HEALTHBARS);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.DROP_SQL_PARTY_NAMES);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.DROP_SPOUT);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_ALCHEMY);
            return;
        }
        this.usersFile.getParentFile().mkdir();
        try {
            mcMMO.p.debug("Creating mcmmo.users file...");
            new File(mcMMO.getUsersFilePath()).createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Integer getPlayerRank(String string, List<PlayerStat> list) {
        if (list == null) {
            return null;
        }
        int n = 1;
        for (PlayerStat playerStat : list) {
            if (playerStat.name.equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return null;
    }

    private int putStat(List<PlayerStat> list, String string, int n) {
        list.add(new PlayerStat(string, n));
        return n;
    }

    private PlayerProfile loadFromLine(String[] stringArray) {
        int n;
        UUID uUID;
        MobHealthbarType mobHealthbarType;
        Map<PrimarySkillType, Integer> map = this.getSkillMapFromLine(stringArray);
        EnumMap<PrimarySkillType, Float> enumMap = new EnumMap<PrimarySkillType, Float>(PrimarySkillType.class);
        EnumMap<SuperAbilityType, Integer> enumMap2 = new EnumMap<SuperAbilityType, Integer>(SuperAbilityType.class);
        EnumMap<UniqueDataType, Integer> enumMap3 = new EnumMap<UniqueDataType, Integer>(UniqueDataType.class);
        enumMap.put(PrimarySkillType.TAMING, Float.valueOf(Integer.valueOf(stringArray[EXP_TAMING]).intValue()));
        enumMap.put(PrimarySkillType.MINING, Float.valueOf(Integer.valueOf(stringArray[EXP_MINING]).intValue()));
        enumMap.put(PrimarySkillType.REPAIR, Float.valueOf(Integer.valueOf(stringArray[EXP_REPAIR]).intValue()));
        enumMap.put(PrimarySkillType.WOODCUTTING, Float.valueOf(Integer.valueOf(stringArray[EXP_WOODCUTTING]).intValue()));
        enumMap.put(PrimarySkillType.UNARMED, Float.valueOf(Integer.valueOf(stringArray[EXP_UNARMED]).intValue()));
        enumMap.put(PrimarySkillType.HERBALISM, Float.valueOf(Integer.valueOf(stringArray[EXP_HERBALISM]).intValue()));
        enumMap.put(PrimarySkillType.EXCAVATION, Float.valueOf(Integer.valueOf(stringArray[EXP_EXCAVATION]).intValue()));
        enumMap.put(PrimarySkillType.ARCHERY, Float.valueOf(Integer.valueOf(stringArray[EXP_ARCHERY]).intValue()));
        enumMap.put(PrimarySkillType.SWORDS, Float.valueOf(Integer.valueOf(stringArray[EXP_SWORDS]).intValue()));
        enumMap.put(PrimarySkillType.AXES, Float.valueOf(Integer.valueOf(stringArray[EXP_AXES]).intValue()));
        enumMap.put(PrimarySkillType.ACROBATICS, Float.valueOf(Integer.valueOf(stringArray[EXP_ACROBATICS]).intValue()));
        enumMap.put(PrimarySkillType.FISHING, Float.valueOf(Integer.valueOf(stringArray[EXP_FISHING]).intValue()));
        enumMap.put(PrimarySkillType.ALCHEMY, Float.valueOf(Integer.valueOf(stringArray[EXP_ALCHEMY]).intValue()));
        enumMap2.put(SuperAbilityType.SUPER_BREAKER, Integer.valueOf(stringArray[COOLDOWN_SUPER_BREAKER]));
        enumMap2.put(SuperAbilityType.TREE_FELLER, Integer.valueOf(stringArray[COOLDOWN_TREE_FELLER]));
        enumMap2.put(SuperAbilityType.BERSERK, Integer.valueOf(stringArray[COOLDOWN_BERSERK]));
        enumMap2.put(SuperAbilityType.GREEN_TERRA, Integer.valueOf(stringArray[COOLDOWN_GREEN_TERRA]));
        enumMap2.put(SuperAbilityType.GIGA_DRILL_BREAKER, Integer.valueOf(stringArray[COOLDOWN_GIGA_DRILL_BREAKER]));
        enumMap2.put(SuperAbilityType.SERRATED_STRIKES, Integer.valueOf(stringArray[COOLDOWN_SERRATED_STRIKES]));
        enumMap2.put(SuperAbilityType.SKULL_SPLITTER, Integer.valueOf(stringArray[COOLDOWN_SKULL_SPLITTER]));
        enumMap2.put(SuperAbilityType.BLAST_MINING, Integer.valueOf(stringArray[COOLDOWN_BLAST_MINING]));
        try {
            mobHealthbarType = MobHealthbarType.valueOf(stringArray[HEALTHBAR]);
        }
        catch (Exception exception) {
            mobHealthbarType = Config.getInstance().getMobHealthbarDefault();
        }
        try {
            uUID = UUID.fromString(stringArray[UUID_INDEX]);
        }
        catch (Exception exception) {
            uUID = null;
        }
        try {
            n = Integer.valueOf(stringArray[SCOREBOARD_TIPS]);
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            enumMap3.put(UniqueDataType.CHIMAERA_WING_DATS, Integer.valueOf(stringArray[COOLDOWN_CHIMAERA_WING]));
        }
        catch (Exception exception) {
            enumMap3.put(UniqueDataType.CHIMAERA_WING_DATS, 0);
        }
        return new PlayerProfile(stringArray[USERNAME], uUID, map, enumMap, enumMap2, mobHealthbarType, n, enumMap3);
    }

    private Map<PrimarySkillType, Integer> getSkillMapFromLine(String[] stringArray) {
        EnumMap<PrimarySkillType, Integer> enumMap = new EnumMap<PrimarySkillType, Integer>(PrimarySkillType.class);
        enumMap.put(PrimarySkillType.TAMING, Integer.valueOf(stringArray[SKILLS_TAMING]));
        enumMap.put(PrimarySkillType.MINING, Integer.valueOf(stringArray[SKILLS_MINING]));
        enumMap.put(PrimarySkillType.REPAIR, Integer.valueOf(stringArray[SKILLS_REPAIR]));
        enumMap.put(PrimarySkillType.WOODCUTTING, Integer.valueOf(stringArray[SKILLS_WOODCUTTING]));
        enumMap.put(PrimarySkillType.UNARMED, Integer.valueOf(stringArray[SKILLS_UNARMED]));
        enumMap.put(PrimarySkillType.HERBALISM, Integer.valueOf(stringArray[SKILLS_HERBALISM]));
        enumMap.put(PrimarySkillType.EXCAVATION, Integer.valueOf(stringArray[SKILLS_EXCAVATION]));
        enumMap.put(PrimarySkillType.ARCHERY, Integer.valueOf(stringArray[SKILLS_ARCHERY]));
        enumMap.put(PrimarySkillType.SWORDS, Integer.valueOf(stringArray[SKILLS_SWORDS]));
        enumMap.put(PrimarySkillType.AXES, Integer.valueOf(stringArray[SKILLS_AXES]));
        enumMap.put(PrimarySkillType.ACROBATICS, Integer.valueOf(stringArray[SKILLS_ACROBATICS]));
        enumMap.put(PrimarySkillType.FISHING, Integer.valueOf(stringArray[SKILLS_FISHING]));
        enumMap.put(PrimarySkillType.ALCHEMY, Integer.valueOf(stringArray[SKILLS_ALCHEMY]));
        return enumMap;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.FLATFILE;
    }

    @Override
    public void onDisable() {
    }

    private int getSkillIndex(PrimarySkillType primarySkillType) {
        switch (primarySkillType) {
            case ACROBATICS: {
                return SKILLS_ACROBATICS;
            }
            case ALCHEMY: {
                return SKILLS_ALCHEMY;
            }
            case ARCHERY: {
                return SKILLS_ARCHERY;
            }
            case AXES: {
                return SKILLS_AXES;
            }
            case EXCAVATION: {
                return SKILLS_EXCAVATION;
            }
            case FISHING: {
                return SKILLS_FISHING;
            }
            case HERBALISM: {
                return SKILLS_HERBALISM;
            }
            case MINING: {
                return SKILLS_MINING;
            }
            case REPAIR: {
                return SKILLS_REPAIR;
            }
            case SWORDS: {
                return SKILLS_SWORDS;
            }
            case TAMING: {
                return SKILLS_TAMING;
            }
            case UNARMED: {
                return SKILLS_UNARMED;
            }
            case WOODCUTTING: {
                return SKILLS_WOODCUTTING;
            }
        }
        throw new RuntimeException("Primary Skills only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMobHealthSettings() {
        BufferedReader bufferedReader = null;
        OutputStreamWriter outputStreamWriter = null;
        String string = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(string));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.isEmpty()) continue;
                    Object[] objectArray = string2.split(":");
                    objectArray[FlatfileDatabaseManager.HEALTHBAR] = Config.getInstance().getMobHealthbarDefault().toString();
                    string2 = StringUtils.join((Object[])objectArray, (String)":") + ":";
                    stringBuilder.append(string2).append("\r\n");
                }
                outputStreamWriter = new FileWriter(string);
                outputStreamWriter.write(stringBuilder.toString());
            }
            catch (IOException iOException) {
                mcMMO.p.getLogger().severe("Exception while reading " + string + " (Are you sure you formatted it correctly?)" + iOException.toString());
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class SkillComparator
    implements Comparator<PlayerStat> {
        private SkillComparator() {
        }

        @Override
        public int compare(PlayerStat playerStat, PlayerStat playerStat2) {
            return playerStat2.statVal - playerStat.statVal;
        }
    }
}

