/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.treasure;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.treasure.EnchantmentTreasure;
import com.gmail.nossr50.datatypes.treasure.ExcavationTreasure;
import com.gmail.nossr50.datatypes.treasure.FishingTreasure;
import com.gmail.nossr50.datatypes.treasure.HylianTreasure;
import com.gmail.nossr50.datatypes.treasure.Rarity;
import com.gmail.nossr50.datatypes.treasure.ShakeTreasure;
import com.gmail.nossr50.util.EnchantmentUtils;
import com.gmail.nossr50.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class TreasureConfig
extends ConfigLoader {
    private static TreasureConfig instance;
    public HashMap<String, List<ExcavationTreasure>> excavationMap = new HashMap();
    public HashMap<EntityType, List<ShakeTreasure>> shakeMap = new HashMap();
    public HashMap<String, List<HylianTreasure>> hylianMap = new HashMap();
    public HashMap<Rarity, List<FishingTreasure>> fishingRewards = new HashMap();
    public HashMap<Rarity, List<EnchantmentTreasure>> fishingEnchantments = new HashMap();

    private TreasureConfig() {
        super("treasures.yml");
        this.loadKeys();
        this.validate();
    }

    public static TreasureConfig getInstance() {
        if (instance == null) {
            instance = new TreasureConfig();
        }
        return instance;
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.config.getConfigurationSection("Enchantment_Drop_Rates").getKeys(false)) {
            double d = 0.0;
            double d2 = 0.0;
            for (Rarity rarity : Rarity.values()) {
                double d3 = this.config.getDouble("Enchantment_Drop_Rates." + string + "." + rarity.toString());
                double d4 = this.config.getDouble("Item_Drop_Rates." + string + "." + rarity.toString());
                if ((d3 < 0.0 || d3 > 100.0) && rarity != Rarity.RECORD) {
                    arrayList.add("The enchant drop rate for " + string + " items that are " + rarity.toString() + "should be between 0.0 and 100.0!");
                }
                if (d4 < 0.0 || d4 > 100.0) {
                    arrayList.add("The item drop rate for " + string + " items that are " + rarity.toString() + "should be between 0.0 and 100.0!");
                }
                d += d3;
                d2 += d4;
            }
            if (d < 0.0 || d > 100.0) {
                arrayList.add("The total enchant drop rate for " + string + " should be between 0.0 and 100.0!");
            }
            if (!(d2 < 0.0) && !(d2 > 100.0)) continue;
            arrayList.add("The total item drop rate for " + string + " should be between 0.0 and 100.0!");
        }
        return this.noErrorsInConfig(arrayList);
    }

    @Override
    protected void loadKeys() {
        if (this.config.getConfigurationSection("Treasures") != null) {
            this.backup();
            return;
        }
        this.loadTreasures("Fishing");
        this.loadTreasures("Excavation");
        this.loadTreasures("Hylian_Luck");
        this.loadEnchantments();
        for (EntityType entityType : EntityType.values()) {
            if (!entityType.isAlive()) continue;
            this.loadTreasures("Shake." + entityType.toString());
        }
    }

    private void loadTreasures(String string) {
        boolean bl = string.equals("Fishing");
        boolean bl2 = string.contains("Shake");
        boolean bl3 = string.equals("Excavation");
        boolean bl4 = string.equals("Hylian_Luck");
        ConfigurationSection configurationSection = this.config.getConfigurationSection(string);
        if (configurationSection == null) {
            return;
        }
        for (Rarity stringArray : Rarity.values()) {
            if (this.fishingRewards.containsKey((Object)stringArray)) continue;
            this.fishingRewards.put(stringArray, new ArrayList());
        }
        for (String string2 : configurationSection.getKeys(false)) {
            Object object;
            Object object2;
            Object object3;
            short s;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = string2.split("[|]");
            String string3 = stringArray[0];
            if (string3.contains("INVENTORY")) {
                if (!this.shakeMap.containsKey(EntityType.PLAYER)) {
                    this.shakeMap.put(EntityType.PLAYER, new ArrayList());
                }
                this.shakeMap.get(EntityType.PLAYER).add(new ShakeTreasure(new ItemStack(Material.BEDROCK, 1, 0), 1, this.getInventoryStealDropChance(), this.getInventoryStealDropLevel()));
                continue;
            }
            Material material = Material.matchMaterial((String)string3);
            int n = this.config.getInt(string + "." + string2 + ".Amount");
            short s2 = s = stringArray.length == 2 ? Short.parseShort(stringArray[1]) : (short)this.config.getInt(string + "." + string2 + ".Data");
            if (material == null) {
                arrayList.add("Invalid material: " + string3);
            }
            if (n <= 0) {
                n = 1;
            }
            if (material != null && material.isBlock() && (s > 127 || s < -128)) {
                arrayList.add("Data of " + string2 + " is invalid! " + s);
            }
            int n2 = this.config.getInt(string + "." + string2 + ".XP");
            double d = this.config.getDouble(string + "." + string2 + ".Drop_Chance");
            int n3 = this.config.getInt(string + "." + string2 + ".Drop_Level");
            if (n2 < 0) {
                arrayList.add(string2 + " has an invalid XP value: " + n2);
            }
            if (d < 0.0) {
                arrayList.add(string2 + " has an invalid Drop_Chance: " + d);
            }
            if (n3 < 0) {
                arrayList.add(string2 + " has an invalid Drop_Level: " + n3);
            }
            Rarity rarity = null;
            if (bl && (rarity = Rarity.getRarity(this.config.getString(string + "." + string2 + ".Rarity"))) == null) {
                arrayList.add("Invalid Rarity for item: " + string2);
            }
            ItemStack itemStack = null;
            if (string3.contains("POTION")) {
                object3 = Material.matchMaterial((String)string3);
                if (object3 == null) {
                    arrayList.add("Potion format for Treasures.yml has changed");
                } else {
                    itemStack = new ItemStack(object3, n, s);
                    object2 = (PotionMeta)itemStack.getItemMeta();
                    object = null;
                    try {
                        object = PotionType.valueOf((String)this.config.getString(string + "." + string2 + ".PotionData.PotionType", "WATER"));
                    }
                    catch (IllegalArgumentException string5) {
                        arrayList.add("Invalid Potion_Type: " + this.config.getString(string + "." + string2 + ".PotionData.PotionType", "WATER"));
                    }
                    boolean string6 = this.config.getBoolean(string + "." + string2 + ".PotionData.Extended", false);
                    boolean bl5 = this.config.getBoolean(string + "." + string2 + ".PotionData.Upgraded", false);
                    object2.setBasePotionData(new PotionData((PotionType)object, string6, bl5));
                    if (this.config.contains(string + "." + string2 + ".Custom_Name")) {
                        object2.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(string + "." + string2 + ".Custom_Name")));
                    }
                    if (this.config.contains(string + "." + string2 + ".Lore")) {
                        Object object4 = new ArrayList();
                        for (String string4 : this.config.getStringList(string + "." + string2 + ".Lore")) {
                            object4.add(ChatColor.translateAlternateColorCodes((char)'&', (String)string4));
                        }
                        object2.setLore((List)object4);
                    }
                    itemStack.setItemMeta((ItemMeta)object2);
                }
            } else if (material != null) {
                itemStack = new ItemStack(material, n, s);
                if (this.config.contains(string + "." + string2 + ".Custom_Name")) {
                    object3 = itemStack.getItemMeta();
                    object3.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(string + "." + string2 + ".Custom_Name")));
                    itemStack.setItemMeta((ItemMeta)object3);
                }
                if (this.config.contains(string + "." + string2 + ".Lore")) {
                    object3 = itemStack.getItemMeta();
                    object2 = new ArrayList();
                    for (String string7 : this.config.getStringList(string + "." + string2 + ".Lore")) {
                        object2.add(ChatColor.translateAlternateColorCodes((char)'&', (String)string7));
                    }
                    object3.setLore((List)object2);
                    itemStack.setItemMeta((ItemMeta)object3);
                }
            }
            if (!this.noErrorsInConfig(arrayList)) continue;
            if (bl) {
                this.fishingRewards.get((Object)rarity).add(new FishingTreasure(itemStack, n2));
                continue;
            }
            if (bl2) {
                object3 = new ShakeTreasure(itemStack, n2, d, n3);
                object2 = EntityType.valueOf((String)string.substring(6));
                if (!this.shakeMap.containsKey(object2)) {
                    this.shakeMap.put((EntityType)object2, new ArrayList());
                }
                this.shakeMap.get(object2).add((ShakeTreasure)object3);
                continue;
            }
            if (bl3) {
                object3 = new ExcavationTreasure(itemStack, n2, d, n3);
                object2 = this.config.getStringList(string + "." + string2 + ".Drops_From");
                object = object2.iterator();
                while (object.hasNext()) {
                    String string5 = (String)object.next();
                    if (!this.excavationMap.containsKey(string5)) {
                        this.excavationMap.put(string5, new ArrayList());
                    }
                    this.excavationMap.get(string5).add((ExcavationTreasure)object3);
                }
                continue;
            }
            if (!bl4) continue;
            object3 = new HylianTreasure(itemStack, n2, d, n3);
            object2 = this.config.getStringList(string + "." + string2 + ".Drops_From");
            object = object2.iterator();
            while (object.hasNext()) {
                String string6 = (String)object.next();
                if (string6.equals("Bushes")) {
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.FERN), (HylianTreasure)object3);
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.TALL_GRASS), (HylianTreasure)object3);
                    for (Object object4 : Tag.SAPLINGS.getValues()) {
                        this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString((Material)object4), (HylianTreasure)object3);
                    }
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.DEAD_BUSH), (HylianTreasure)object3);
                    continue;
                }
                if (string6.equals("Flowers")) {
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.POPPY), (HylianTreasure)object3);
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.DANDELION), (HylianTreasure)object3);
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.BLUE_ORCHID), (HylianTreasure)object3);
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.ALLIUM), (HylianTreasure)object3);
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.AZURE_BLUET), (HylianTreasure)object3);
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.ORANGE_TULIP), (HylianTreasure)object3);
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.PINK_TULIP), (HylianTreasure)object3);
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.RED_TULIP), (HylianTreasure)object3);
                    this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString(Material.WHITE_TULIP), (HylianTreasure)object3);
                    continue;
                }
                if (string6.equals("Pots")) {
                    for (Object object4 : Tag.FLOWER_POTS.getValues()) {
                        this.AddHylianTreasure(StringUtils.getFriendlyConfigMaterialString((Material)object4), (HylianTreasure)object3);
                    }
                    continue;
                }
                this.AddHylianTreasure(string6, (HylianTreasure)object3);
            }
        }
    }

    private void AddHylianTreasure(String string, HylianTreasure hylianTreasure) {
        if (!this.hylianMap.containsKey(string)) {
            this.hylianMap.put(string, new ArrayList());
        }
        this.hylianMap.get(string).add(hylianTreasure);
    }

    private void loadEnchantments() {
        for (Rarity rarity : Rarity.values()) {
            ConfigurationSection configurationSection;
            if (rarity == Rarity.RECORD) continue;
            if (!this.fishingEnchantments.containsKey((Object)rarity)) {
                this.fishingEnchantments.put(rarity, new ArrayList());
            }
            if ((configurationSection = this.config.getConfigurationSection("Enchantments_Rarity." + rarity.toString())) == null) {
                return;
            }
            for (String string : configurationSection.getKeys(false)) {
                int n = this.config.getInt("Enchantments_Rarity." + rarity.toString() + "." + string);
                Enchantment enchantment = EnchantmentUtils.getByName(string);
                if (enchantment == null) {
                    plugin.getLogger().warning("Skipping invalid enchantment in treasures.yml: " + string);
                    continue;
                }
                this.fishingEnchantments.get((Object)rarity).add(new EnchantmentTreasure(enchantment, n));
            }
        }
    }

    public boolean getInventoryStealEnabled() {
        return this.config.contains("Shake.PLAYER.INVENTORY");
    }

    public boolean getInventoryStealStacks() {
        return this.config.getBoolean("Shake.PLAYER.INVENTORY.Whole_Stacks");
    }

    public double getInventoryStealDropChance() {
        return this.config.getDouble("Shake.PLAYER.INVENTORY.Drop_Chance");
    }

    public int getInventoryStealDropLevel() {
        return this.config.getInt("Shake.PLAYER.INVENTORY.Drop_Level");
    }

    public double getItemDropRate(int n, Rarity rarity) {
        return this.config.getDouble("Item_Drop_Rates.Tier_" + n + "." + rarity.toString());
    }

    public double getEnchantmentDropRate(int n, Rarity rarity) {
        return this.config.getDouble("Enchantment_Drop_Rates.Tier_" + n + "." + rarity.toString());
    }
}

