/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.skills.salvage;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.skills.ItemType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.skills.salvage.salvageables.Salvageable;
import com.gmail.nossr50.skills.salvage.salvageables.SalvageableFactory;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class SalvageConfig
extends ConfigLoader {
    private List<Salvageable> salvageables;

    public SalvageConfig(String string) {
        super(string);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.salvageables = new ArrayList<Salvageable>();
        ConfigurationSection configurationSection = this.config.getConfigurationSection("Salvageables");
        Set set = configurationSection.getKeys(false);
        for (String string : set) {
            int n;
            int n2;
            Material material;
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Material material2 = Material.matchMaterial((String)string);
            if (material2 == null) {
                arrayList.add("Invalid material: " + string);
            }
            MaterialType materialType = MaterialType.OTHER;
            String string2 = this.config.getString("Salvageables." + string + ".MaterialType", "OTHER");
            if (!this.config.contains("Salvageables." + string + ".MaterialType") && material2 != null) {
                object = new ItemStack(material2);
                if (ItemUtils.isWoodTool(object)) {
                    materialType = MaterialType.WOOD;
                } else if (ItemUtils.isStoneTool(object)) {
                    materialType = MaterialType.STONE;
                } else if (ItemUtils.isStringTool(object)) {
                    materialType = MaterialType.STRING;
                } else if (ItemUtils.isLeatherArmor(object)) {
                    materialType = MaterialType.LEATHER;
                } else if (ItemUtils.isIronArmor(object) || ItemUtils.isIronTool(object)) {
                    materialType = MaterialType.IRON;
                } else if (ItemUtils.isGoldArmor(object) || ItemUtils.isGoldTool(object)) {
                    materialType = MaterialType.GOLD;
                } else if (ItemUtils.isDiamondArmor(object) || ItemUtils.isDiamondTool(object)) {
                    materialType = MaterialType.DIAMOND;
                }
            } else {
                try {
                    materialType = MaterialType.valueOf(string2.replace(" ", "_").toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    arrayList.add(string + " has an invalid MaterialType of " + string2);
                }
            }
            object = this.config.getString("Salvageables." + string + ".SalvageMaterial");
            Material material3 = material = object == null ? materialType.getDefaultMaterial() : Material.matchMaterial((String)object);
            if (material == null) {
                arrayList.add(string + " has an invalid salvage material: " + (String)object);
            }
            short s = material2 != null ? material2.getMaxDurability() : (short)this.config.getInt("Salvageables." + string + ".MaximumDurability");
            ItemType itemType = ItemType.OTHER;
            String string3 = this.config.getString("Salvageables." + string + ".ItemType", "OTHER");
            if (!this.config.contains("Salvageables." + string + ".ItemType") && material2 != null) {
                ItemStack itemStack = new ItemStack(material2);
                if (ItemUtils.isMinecraftTool(itemStack)) {
                    itemType = ItemType.TOOL;
                } else if (ItemUtils.isArmor(itemStack)) {
                    itemType = ItemType.ARMOR;
                }
            } else {
                try {
                    itemType = ItemType.valueOf(string3.replace(" ", "_").toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    arrayList.add(string + " has an invalid ItemType of " + string3);
                }
            }
            int n3 = this.config.getInt("Salvageables." + string + ".MinimumLevel");
            double d = this.config.getDouble("Salvageables." + string + ".XpMultiplier", 1.0);
            if (n3 < 0) {
                arrayList.add(string + " has an invalid MinimumLevel of " + n3);
            }
            int n4 = n2 = material2 != null ? SkillUtils.getRepairAndSalvageQuantities(material2, material) : this.config.getInt("Salvageables." + string + ".MaximumQuantity", 2);
            if (n2 <= 0 && material2 != null) {
                n2 = this.config.getInt("Salvageables." + string + ".MaximumQuantity", 1);
            }
            if ((n = this.config.getInt("Salvageables." + string + ".MaximumQuantity", -1)) > 0) {
                n2 = n;
            }
            if (n2 <= 0) {
                arrayList.add("Maximum quantity of " + string + " must be greater than 0!");
            }
            if (!this.noErrorsInSalvageable(arrayList)) continue;
            Salvageable salvageable = SalvageableFactory.getSalvageable(material2, material, n3, n2, s, itemType, materialType, d);
            this.salvageables.add(salvageable);
        }
    }

    protected List<Salvageable> getLoadedSalvageables() {
        return this.salvageables == null ? new ArrayList() : this.salvageables;
    }

    private boolean noErrorsInSalvageable(List<String> list) {
        if (!list.isEmpty()) {
            plugin.getLogger().warning("Errors have been found in: " + this.fileName);
            plugin.getLogger().warning("The following issues were found:");
        }
        for (String string : list) {
            plugin.getLogger().warning(string);
        }
        return list.isEmpty();
    }
}

