/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.skills.repair;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.skills.ItemType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.skills.repair.repairables.RepairableFactory;
import com.gmail.nossr50.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class RepairConfig
extends ConfigLoader {
    private List<Repairable> repairables;

    public RepairConfig(String string) {
        super(string);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.repairables = new ArrayList<Repairable>();
        ConfigurationSection configurationSection = this.config.getConfigurationSection("Repairables");
        Set set = configurationSection.getKeys(false);
        for (String string : set) {
            int n;
            short s;
            Material material;
            Object object;
            if (this.config.contains("Repairables." + string + ".ItemId")) {
                this.backup();
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            Material material2 = Material.matchMaterial((String)string);
            if (material2 == null) {
                arrayList.add("Invalid material: " + string);
            }
            MaterialType materialType = MaterialType.OTHER;
            String string2 = this.config.getString("Repairables." + string + ".MaterialType", "OTHER");
            if (!this.config.contains("Repairables." + string + ".MaterialType") && material2 != null) {
                object = new ItemStack(material2);
                if (ItemUtils.isWoodTool(object)) {
                    materialType = MaterialType.WOOD;
                } else if (ItemUtils.isStoneTool(object)) {
                    materialType = MaterialType.STONE;
                } else if (ItemUtils.isStringTool(object)) {
                    materialType = MaterialType.STRING;
                } else if (ItemUtils.isLeatherArmor(object)) {
                    materialType = MaterialType.LEATHER;
                } else if (ItemUtils.isIronArmor(object) || ItemUtils.isIronTool(object)) {
                    materialType = MaterialType.IRON;
                } else if (ItemUtils.isGoldArmor(object) || ItemUtils.isGoldTool(object)) {
                    materialType = MaterialType.GOLD;
                } else if (ItemUtils.isDiamondArmor(object) || ItemUtils.isDiamondTool(object)) {
                    materialType = MaterialType.DIAMOND;
                }
            } else {
                try {
                    materialType = MaterialType.valueOf(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    arrayList.add(string + " has an invalid MaterialType of " + string2);
                }
            }
            object = this.config.getString("Repairables." + string + ".RepairMaterial");
            Material material3 = material = object == null ? materialType.getDefaultMaterial() : Material.matchMaterial((String)object);
            if (material == null) {
                arrayList.add(string + " has an invalid repair material: " + (String)object);
            }
            short s2 = s = material2 != null ? material2.getMaxDurability() : (short)this.config.getInt("Repairables." + string + ".MaximumDurability");
            if (s <= 0) {
                s = (short)this.config.getInt("Repairables." + string + ".MaximumDurability");
            }
            if (s <= 0) {
                arrayList.add("Maximum durability of " + string + " must be greater than 0!");
            }
            ItemType itemType = ItemType.OTHER;
            String string3 = this.config.getString("Repairables." + string + ".ItemType", "OTHER");
            if (!this.config.contains("Repairables." + string + ".ItemType") && material2 != null) {
                ItemStack itemStack = new ItemStack(material2);
                if (ItemUtils.isMinecraftTool(itemStack)) {
                    itemType = ItemType.TOOL;
                } else if (ItemUtils.isArmor(itemStack)) {
                    itemType = ItemType.ARMOR;
                }
            } else {
                try {
                    itemType = ItemType.valueOf(string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    arrayList.add(string + " has an invalid ItemType of " + string3);
                }
            }
            int n2 = this.config.getInt("Repairables." + string + ".MinimumLevel");
            double d = this.config.getDouble("Repairables." + string + ".XpMultiplier", 1.0);
            if (n2 < 0) {
                arrayList.add(string + " has an invalid MinimumLevel of " + n2);
            }
            if ((n = this.config.getInt("Repairables." + string + ".MinimumQuantity")) == 0) {
                n = -1;
            }
            if (!this.noErrorsInRepairable(arrayList)) continue;
            Repairable repairable = RepairableFactory.getRepairable(material2, material, null, n2, s, itemType, materialType, d, n);
            this.repairables.add(repairable);
        }
    }

    protected List<Repairable> getLoadedRepairables() {
        return this.repairables == null ? new ArrayList() : this.repairables;
    }

    private boolean noErrorsInRepairable(List<String> list) {
        for (String string : list) {
            plugin.getLogger().warning(string);
        }
        return list.isEmpty();
    }
}

