/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.skills.alchemy;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.skills.alchemy.AlchemyPotion;
import com.gmail.nossr50.mcMMO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class PotionConfig
extends ConfigLoader {
    private static PotionConfig instance;
    private List<ItemStack> concoctionsIngredientsTierOne = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierTwo = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierThree = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierFour = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierFive = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierSix = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierSeven = new ArrayList<ItemStack>();
    private List<ItemStack> concoctionsIngredientsTierEight = new ArrayList<ItemStack>();
    private Map<String, AlchemyPotion> potionMap = new HashMap<String, AlchemyPotion>();

    private PotionConfig() {
        super("potions.yml");
        this.loadKeys();
    }

    public static PotionConfig getInstance() {
        if (instance == null) {
            instance = new PotionConfig();
        }
        return instance;
    }

    @Override
    protected void loadKeys() {
        this.loadConcoctions();
        this.loadPotionMap();
    }

    private void loadConcoctions() {
        ConfigurationSection configurationSection = this.config.getConfigurationSection("Concoctions");
        this.loadConcoctionsTier(this.concoctionsIngredientsTierOne, configurationSection.getStringList("Tier_One_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierTwo, configurationSection.getStringList("Tier_Two_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierThree, configurationSection.getStringList("Tier_Three_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierFour, configurationSection.getStringList("Tier_Four_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierFive, configurationSection.getStringList("Tier_Five_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierSix, configurationSection.getStringList("Tier_Six_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierSeven, configurationSection.getStringList("Tier_Seven_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierEight, configurationSection.getStringList("Tier_Eight_Ingredients"));
        this.concoctionsIngredientsTierTwo.addAll(this.concoctionsIngredientsTierOne);
        this.concoctionsIngredientsTierThree.addAll(this.concoctionsIngredientsTierTwo);
        this.concoctionsIngredientsTierFour.addAll(this.concoctionsIngredientsTierThree);
        this.concoctionsIngredientsTierFive.addAll(this.concoctionsIngredientsTierFour);
        this.concoctionsIngredientsTierSix.addAll(this.concoctionsIngredientsTierFive);
        this.concoctionsIngredientsTierSeven.addAll(this.concoctionsIngredientsTierSix);
        this.concoctionsIngredientsTierEight.addAll(this.concoctionsIngredientsTierSeven);
    }

    private void loadConcoctionsTier(List<ItemStack> list, List<String> list2) {
        if (list2 != null && list2.size() > 0) {
            for (String string : list2) {
                ItemStack itemStack = this.loadIngredient(string);
                if (itemStack == null) continue;
                list.add(itemStack);
            }
        }
    }

    private void loadPotionMap() {
        ConfigurationSection configurationSection = this.config.getConfigurationSection("Potions");
        int n = 0;
        int n2 = 0;
        for (String string : configurationSection.getKeys(false)) {
            AlchemyPotion alchemyPotion = this.loadPotion(configurationSection.getConfigurationSection(string));
            if (alchemyPotion != null) {
                this.potionMap.put(string, alchemyPotion);
                ++n;
                continue;
            }
            ++n2;
        }
        mcMMO.p.debug("Loaded " + n + " Alchemy potions, skipped " + n2 + ".");
    }

    private AlchemyPotion loadPotion(ConfigurationSection configurationSection) {
        try {
            Object object4;
            Object object22;
            PotionData potionData;
            Object object3;
            String string = configurationSection.getString("Name");
            if (string != null) {
                string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
            }
            if (!configurationSection.contains("PotionData")) {
                short s = Short.parseShort(configurationSection.getName());
                object3 = Potion.fromDamage((int)s);
                potionData = new PotionData(object3.getType(), object3.hasExtendedDuration(), object3.getLevel() == 2);
            } else {
                ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("PotionData");
                potionData = new PotionData(PotionType.valueOf((String)configurationSection2.getString("PotionType", "WATER")), configurationSection2.getBoolean("Extended", false), configurationSection2.getBoolean("Upgraded", false));
            }
            Material material = Material.POTION;
            object3 = configurationSection.getString("Material", null);
            if (object3 != null) {
                material = Material.valueOf((String)object3);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (configurationSection.contains("Lore")) {
                for (Object object22 : configurationSection.getStringList("Lore")) {
                    arrayList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)object22));
                }
            }
            ArrayList arrayList2 = new ArrayList();
            if (configurationSection.contains("Effects")) {
                for (Object object4 : configurationSection.getStringList("Effects")) {
                    int n;
                    String[] stringArray = ((String)object4).split(" ");
                    Object object5 = stringArray.length > 0 ? PotionEffectType.getByName((String)stringArray[0]) : null;
                    int n2 = stringArray.length > 1 ? Integer.parseInt((String)stringArray[1]) : 0;
                    int n3 = n = stringArray.length > 2 ? Integer.parseInt((String)stringArray[2]) : 0;
                    if (object5 != null) {
                        arrayList2.add(new PotionEffect(object5, n, n2));
                        continue;
                    }
                    mcMMO.p.getLogger().warning("Failed to parse effect for potion " + string + ": " + (String)object4);
                }
            }
            object22 = null;
            object22 = configurationSection.contains("Color") ? Color.fromRGB((int)configurationSection.getInt("Color")) : this.generateColor(arrayList2);
            object4 = new HashMap();
            if (configurationSection.contains("Children")) {
                for (Object object5 : configurationSection.getConfigurationSection("Children").getKeys(false)) {
                    ItemStack itemStack = this.loadIngredient((String)object5);
                    if (itemStack != null) {
                        object4.put(itemStack, configurationSection.getConfigurationSection("Children").getString((String)object5));
                        continue;
                    }
                    mcMMO.p.getLogger().warning("Failed to parse child for potion " + string + ": " + (String)object5);
                }
            }
            return new AlchemyPotion(material, potionData, string, arrayList, arrayList2, (Color)object22, (Map<ItemStack, String>)object4);
        }
        catch (Exception exception) {
            mcMMO.p.getLogger().warning("Failed to load Alchemy potion: " + configurationSection.getName());
            return null;
        }
    }

    private ItemStack loadIngredient(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        Material material = Material.getMaterial((String)string);
        if (material != null) {
            return new ItemStack(material, 1);
        }
        return null;
    }

    public List<ItemStack> getIngredients(int n) {
        switch (n) {
            case 8: {
                return this.concoctionsIngredientsTierEight;
            }
            case 7: {
                return this.concoctionsIngredientsTierSeven;
            }
            case 6: {
                return this.concoctionsIngredientsTierSix;
            }
            case 5: {
                return this.concoctionsIngredientsTierFive;
            }
            case 4: {
                return this.concoctionsIngredientsTierFour;
            }
            case 3: {
                return this.concoctionsIngredientsTierThree;
            }
            case 2: {
                return this.concoctionsIngredientsTierTwo;
            }
        }
        return this.concoctionsIngredientsTierOne;
    }

    public boolean isValidPotion(ItemStack itemStack) {
        return this.getPotion(itemStack) != null;
    }

    public AlchemyPotion getPotion(String string) {
        return this.potionMap.get(string);
    }

    public AlchemyPotion getPotion(ItemStack itemStack) {
        for (AlchemyPotion alchemyPotion : this.potionMap.values()) {
            if (!alchemyPotion.isSimilar(itemStack)) continue;
            return alchemyPotion;
        }
        return null;
    }

    public Color generateColor(List<PotionEffect> list) {
        if (list != null && !list.isEmpty()) {
            ArrayList<Color> arrayList = new ArrayList<Color>();
            for (PotionEffect potionEffect : list) {
                if (potionEffect.getType().getColor() == null) continue;
                arrayList.add(potionEffect.getType().getColor());
            }
            if (!arrayList.isEmpty()) {
                if (arrayList.size() > 1) {
                    return this.calculateAverageColor(arrayList);
                }
                return (Color)arrayList.get(0);
            }
        }
        return null;
    }

    public Color calculateAverageColor(List<Color> list) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Color color : list) {
            n += color.getRed();
            n2 += color.getGreen();
            n3 += color.getBlue();
        }
        Color color = Color.fromRGB((int)(n / list.size()), (int)(n2 / list.size()), (int)(n3 / list.size()));
        return color;
    }
}

