/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.mods;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.mods.CustomTool;
import com.gmail.nossr50.datatypes.skills.ItemType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.skills.repair.repairables.RepairableFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class CustomToolConfig
extends ConfigLoader {
    private boolean needsUpdate = false;
    public List<Material> customAxes = new ArrayList<Material>();
    public List<Material> customBows = new ArrayList<Material>();
    public List<Material> customHoes = new ArrayList<Material>();
    public List<Material> customPickaxes = new ArrayList<Material>();
    public List<Material> customShovels = new ArrayList<Material>();
    public List<Material> customSwords = new ArrayList<Material>();
    public HashMap<Material, CustomTool> customToolMap = new HashMap();
    public List<Repairable> repairables = new ArrayList<Repairable>();

    protected CustomToolConfig(String string) {
        super("mods", string);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.loadTool("Axes", this.customAxes);
        this.loadTool("Bows", this.customBows);
        this.loadTool("Hoes", this.customHoes);
        this.loadTool("Pickaxes", this.customPickaxes);
        this.loadTool("Shovels", this.customShovels);
        this.loadTool("Swords", this.customSwords);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.backup();
        }
    }

    private void loadTool(String string, List<Material> list) {
        if (this.needsUpdate) {
            return;
        }
        ConfigurationSection configurationSection = this.config.getConfigurationSection(string);
        if (configurationSection == null) {
            return;
        }
        Set set = configurationSection.getKeys(false);
        for (String string2 : set) {
            if (this.config.contains(string + "." + string2 + "..ID")) {
                this.needsUpdate = true;
                return;
            }
            Material material = Material.matchMaterial((String)string2);
            if (material == null) {
                plugin.getLogger().warning("Invalid material name. This item will be skipped. - " + string2);
                continue;
            }
            boolean bl = this.config.getBoolean(string + "." + string2 + ".Repairable");
            Material material2 = Material.matchMaterial((String)this.config.getString(string + "." + string2 + ".Repair_Material", ""));
            if (bl && material2 == null) {
                plugin.getLogger().warning("Incomplete repair information. This item will be unrepairable. - " + string2);
                bl = false;
            }
            if (bl) {
                String string3 = this.config.getString(string + "." + string2 + ".Repair_Material_Pretty_Name");
                int n = this.config.getInt(string + "." + string2 + ".Repair_MinimumLevel", 0);
                double d = this.config.getDouble(string + "." + string2 + ".Repair_XpMultiplier", 1.0);
                short s = material.getMaxDurability();
                if (s == 0) {
                    s = (short)this.config.getInt(string + "." + string2 + ".Durability", 60);
                }
                this.repairables.add(RepairableFactory.getRepairable(material, material2, string3, n, s, ItemType.TOOL, MaterialType.OTHER, d));
            }
            double d = this.config.getDouble(string + "." + string2 + ".XP_Modifier", 1.0);
            boolean bl2 = this.config.getBoolean(string + "." + string2 + ".Ability_Enabled", true);
            int n = this.config.getInt(string + "." + string2 + ".Tier", 1);
            CustomTool customTool = new CustomTool(n, bl2, d);
            list.add(material);
            this.customToolMap.put(material, customTool);
        }
    }
}

