/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.mods;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.mods.CustomBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class CustomBlockConfig
extends ConfigLoader {
    private boolean needsUpdate = false;
    public List<Material> customExcavationBlocks = new ArrayList<Material>();
    public List<Material> customHerbalismBlocks = new ArrayList<Material>();
    public List<Material> customMiningBlocks = new ArrayList<Material>();
    public List<Material> customOres = new ArrayList<Material>();
    public List<Material> customLogs = new ArrayList<Material>();
    public List<Material> customLeaves = new ArrayList<Material>();
    public List<Material> customAbilityBlocks = new ArrayList<Material>();
    public HashMap<Material, CustomBlock> customBlockMap = new HashMap();

    protected CustomBlockConfig(String string) {
        super("mods", string);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.loadBlocks("Excavation", this.customExcavationBlocks);
        this.loadBlocks("Herbalism", this.customHerbalismBlocks);
        this.loadBlocks("Mining", this.customMiningBlocks);
        this.loadBlocks("Woodcutting", null);
        this.loadBlocks("Ability_Blocks", this.customAbilityBlocks);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.backup();
        }
    }

    private void loadBlocks(String string, List<Material> list) {
        if (this.needsUpdate) {
            return;
        }
        ConfigurationSection configurationSection = this.config.getConfigurationSection(string);
        if (configurationSection == null) {
            return;
        }
        Set set = configurationSection.getKeys(false);
        for (String string2 : set) {
            if (this.config.contains(string + "." + string2 + ".Drop_Item")) {
                this.needsUpdate = true;
                return;
            }
            String[] stringArray = string2.split("[|]");
            Material material = Material.matchMaterial((String)stringArray[0]);
            if (material == null) {
                plugin.getLogger().warning("Invalid material name. This item will be skipped. - " + stringArray[0]);
                continue;
            }
            if (list != null) {
                list.add(material);
            }
            if (string.equals("Ability_Blocks")) continue;
            int n = this.config.getInt(string + "." + string2 + ".XP_Gain");
            int n2 = 0;
            if (string.equals("Mining") && this.config.getBoolean(string + "." + string2 + ".Is_Ore")) {
                this.customOres.add(material);
                n2 = this.config.getInt(string + "." + string2 + ".Smelting_XP_Gain", n / 10);
            } else if (string.equals("Woodcutting")) {
                if (this.config.getBoolean(string + "." + string2 + ".Is_Log")) {
                    this.customLogs.add(material);
                } else {
                    this.customLeaves.add(material);
                    n = 0;
                }
            }
            this.customBlockMap.put(material, new CustomBlock(n, this.config.getBoolean(string + "." + string2 + ".Double_Drops_Enabled"), n2));
        }
    }
}

