/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.mods;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.skills.ItemType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.skills.repair.repairables.RepairableFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class CustomArmorConfig
extends ConfigLoader {
    private boolean needsUpdate = false;
    public List<Material> customBoots = new ArrayList<Material>();
    public List<Material> customChestplates = new ArrayList<Material>();
    public List<Material> customHelmets = new ArrayList<Material>();
    public List<Material> customLeggings = new ArrayList<Material>();
    public List<Repairable> repairables = new ArrayList<Repairable>();

    protected CustomArmorConfig(String string) {
        super("mods", string);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.loadArmor("Boots", this.customBoots);
        this.loadArmor("Chestplates", this.customChestplates);
        this.loadArmor("Helmets", this.customHelmets);
        this.loadArmor("Leggings", this.customLeggings);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.backup();
        }
    }

    private void loadArmor(String string, List<Material> list) {
        if (this.needsUpdate) {
            return;
        }
        ConfigurationSection configurationSection = this.config.getConfigurationSection(string);
        if (configurationSection == null) {
            return;
        }
        Set set = configurationSection.getKeys(false);
        for (String string2 : set) {
            if (this.config.contains(string + "." + string2 + "..ID")) {
                this.needsUpdate = true;
                return;
            }
            Material material = Material.matchMaterial((String)string2);
            if (material == null) {
                plugin.getLogger().warning("Invalid material name. This item will be skipped. - " + string2);
                continue;
            }
            boolean bl = this.config.getBoolean(string + "." + string2 + ".Repairable");
            Material material2 = Material.matchMaterial((String)this.config.getString(string + "." + string2 + ".Repair_Material", ""));
            if (bl && material2 == null) {
                plugin.getLogger().warning("Incomplete repair information. This item will be unrepairable. - " + string2);
                bl = false;
            }
            if (bl) {
                String string3 = this.config.getString(string + "." + string2 + ".Repair_Material_Pretty_Name");
                int n = this.config.getInt(string + "." + string2 + ".Repair_MinimumLevel", 0);
                double d = this.config.getDouble(string + "." + string2 + ".Repair_XpMultiplier", 1.0);
                short s = material.getMaxDurability();
                if (s == 0) {
                    s = (short)this.config.getInt(string + "." + string2 + ".Durability", 70);
                }
                this.repairables.add(RepairableFactory.getRepairable(material, material2, string3, n, s, ItemType.ARMOR, MaterialType.OTHER, d));
            }
            list.add(material);
        }
    }
}

