/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.experience;

import com.gmail.nossr50.config.AutoUpdateConfigLoader;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.alchemy.PotionStage;
import com.gmail.nossr50.util.StringUtils;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.EntityType;

public class ExperienceConfig
extends AutoUpdateConfigLoader {
    private static ExperienceConfig instance;

    private ExperienceConfig() {
        super("experience.yml");
        this.validate();
    }

    public static ExperienceConfig getInstance() {
        if (instance == null) {
            instance = new ExperienceConfig();
        }
        return instance;
    }

    @Override
    protected void loadKeys() {
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getMultiplier(FormulaType.EXPONENTIAL) <= 0.0) {
            arrayList.add("Experience_Formula.Exponential_Values.multiplier should be greater than 0!");
        }
        if (this.getMultiplier(FormulaType.LINEAR) <= 0.0) {
            arrayList.add("Experience_Formula.Linear_Values.multiplier should be greater than 0!");
        }
        if (this.getExponent(FormulaType.EXPONENTIAL) <= 0.0) {
            arrayList.add("Experience_Formula.Exponential_Values.exponent should be greater than 0!");
        }
        if (this.getExperienceGainsGlobalMultiplier() <= 0.0) {
            arrayList.add("Experience_Formula.Multiplier.Global should be greater than 0!");
        }
        if (this.getPlayerVersusPlayerXP() < 0.0) {
            arrayList.add("Experience_Formula.Multiplier.PVP should be at least 0!");
        }
        if (this.getSpawnedMobXpMultiplier() < 0.0) {
            arrayList.add("Experience_Formula.Mobspawners.Multiplier should be at least 0!");
        }
        if (this.getBredMobXpMultiplier() < 0.0) {
            arrayList.add("Experience_Formula.Breeding.Multiplier should be at least 0!");
        }
        if (this.getExpModifier() <= 0.0) {
            arrayList.add("Conversion.Exp_Modifier should be greater than 0!");
        }
        for (PotionStage potionStage : PotionStage.values()) {
            if (!(this.getPotionXP(potionStage) < 0.0)) continue;
            arrayList.add("Experience_Values.Alchemy.Potion_Stage_" + potionStage.toNumerical() + " should be at least 0!");
        }
        if (this.getArcheryDistanceMultiplier() < 0.0) {
            arrayList.add("Experience_Values.Archery.Distance_Multiplier should be at least 0!");
        }
        if (this.getAnimalsXP() < 0.0) {
            arrayList.add("Experience_Values.Combat.Multiplier.Animals should be at least 0!");
        }
        if (this.getDodgeXPModifier() < 0) {
            arrayList.add("Skills.Acrobatics.Dodge_XP_Modifier should be at least 0!");
        }
        if (this.getRollXPModifier() < 0) {
            arrayList.add("Skills.Acrobatics.Roll_XP_Modifier should be at least 0!");
        }
        if (this.getFallXPModifier() < 0) {
            arrayList.add("Skills.Acrobatics.Fall_XP_Modifier should be at least 0!");
        }
        if (this.getFishingShakeXP() <= 0) {
            arrayList.add("Experience_Values.Fishing.Shake should be greater than 0!");
        }
        if (this.getRepairXPBase() <= 0.0) {
            arrayList.add("Experience_Values.Repair.Base should be greater than 0!");
        }
        if (this.getTamingXP(EntityType.WOLF) <= 0) {
            arrayList.add("Experience_Values.Taming.Animal_Taming.Wolf should be greater than 0!");
        }
        if (this.getTamingXP(EntityType.OCELOT) <= 0) {
            arrayList.add("Experience_Values.Taming.Animal_Taming.Ocelot should be greater than 0!");
        }
        return this.noErrorsInConfig(arrayList);
    }

    public boolean isEarlyGameBoostEnabled() {
        return this.config.getBoolean("EarlyGameBoost.Enabled", true);
    }

    public boolean isEndermanEndermiteFarmingPrevented() {
        return this.config.getBoolean("ExploitFix.EndermanEndermiteFarms", true);
    }

    public boolean isPistonCheatingPrevented() {
        return this.config.getBoolean("ExploitFix.PistonCheating", true);
    }

    public boolean isPistonExploitPrevented() {
        return this.config.getBoolean("ExploitFix.Pistons", false);
    }

    public boolean allowUnsafeEnchantments() {
        return this.config.getBoolean("ExploitFix.UnsafeEnchantments", false);
    }

    public boolean isCOTWBreedingPrevented() {
        return this.config.getBoolean("ExploitFix.COTWBreeding", true);
    }

    public boolean isFishingExploitingPrevented() {
        return this.config.getBoolean("ExploitFix.Fishing", true);
    }

    public boolean isAcrobaticsExploitingPrevented() {
        return this.config.getBoolean("ExploitFix.Acrobatics", true);
    }

    public boolean isTreeFellerXPReduced() {
        return this.config.getBoolean("ExploitFix.TreeFellerReducedXP", true);
    }

    public FormulaType getFormulaType() {
        return FormulaType.getFormulaType(this.config.getString("Experience_Formula.Curve"));
    }

    public boolean getCumulativeCurveEnabled() {
        return this.config.getBoolean("Experience_Formula.Cumulative_Curve", false);
    }

    public double getMultiplier(FormulaType formulaType) {
        return this.config.getDouble("Experience_Formula." + StringUtils.getCapitalized(formulaType.toString()) + "_Values.multiplier");
    }

    public int getBase(FormulaType formulaType) {
        return this.config.getInt("Experience_Formula." + StringUtils.getCapitalized(formulaType.toString()) + "_Values.base");
    }

    public double getExponent(FormulaType formulaType) {
        return this.config.getDouble("Experience_Formula." + StringUtils.getCapitalized(formulaType.toString()) + "_Values.exponent");
    }

    public double getExperienceGainsGlobalMultiplier() {
        return this.config.getDouble("Experience_Formula.Multiplier.Global", 1.0);
    }

    public void setExperienceGainsGlobalMultiplier(double d) {
        this.config.set("Experience_Formula.Multiplier.Global", (Object)d);
    }

    public double getPlayerVersusPlayerXP() {
        return this.config.getDouble("Experience_Formula.Multiplier.PVP", 1.0);
    }

    public double getSpawnedMobXpMultiplier() {
        return this.config.getDouble("Experience_Formula.Mobspawners.Multiplier", 0.0);
    }

    public double getBredMobXpMultiplier() {
        return this.config.getDouble("Experience_Formula.Breeding.Multiplier", 1.0);
    }

    public double getFormulaSkillModifier(PrimarySkillType primarySkillType) {
        return this.config.getDouble("Experience_Formula.Modifier." + StringUtils.getCapitalized(primarySkillType.toString()));
    }

    public double getCustomXpPerkBoost() {
        return this.config.getDouble("Experience_Formula.Custom_XP_Perk.Boost", 1.25);
    }

    public float getDiminishedReturnsCap() {
        return (float)this.config.getDouble("Dimished_Returns.Guaranteed_Minimum_Percentage", 0.05);
    }

    public boolean getDiminishedReturnsEnabled() {
        return this.config.getBoolean("Diminished_Returns.Enabled", false);
    }

    public int getDiminishedReturnsThreshold(PrimarySkillType primarySkillType) {
        return this.config.getInt("Diminished_Returns.Threshold." + StringUtils.getCapitalized(primarySkillType.toString()), 20000);
    }

    public int getDiminishedReturnsTimeInterval() {
        return this.config.getInt("Diminished_Returns.Time_Interval", 10);
    }

    public double getExpModifier() {
        return this.config.getDouble("Conversion.Exp_Modifier", 1.0);
    }

    public boolean getExperienceGainsPlayerVersusPlayerEnabled() {
        return this.config.getBoolean("Experience_Values.PVP.Rewards", true);
    }

    public double getCombatXP(EntityType entityType) {
        return this.config.getDouble("Experience_Values.Combat.Multiplier." + StringUtils.getPrettyEntityTypeString(entityType).replace(" ", "_"));
    }

    public double getAnimalsXP(EntityType entityType) {
        return this.config.getDouble("Experience_Values.Combat.Multiplier." + StringUtils.getPrettyEntityTypeString(entityType).replace(" ", "_"), this.getAnimalsXP());
    }

    public double getAnimalsXP() {
        return this.config.getDouble("Experience_Values.Combat.Multiplier.Animals", 1.0);
    }

    public boolean hasCombatXP(EntityType entityType) {
        return this.config.contains("Experience_Values.Combat.Multiplier." + StringUtils.getPrettyEntityTypeString(entityType).replace(" ", "_"));
    }

    public int getXp(PrimarySkillType primarySkillType, Material material) {
        String string = "Experience_Values." + StringUtils.getCapitalized(primarySkillType.toString()) + ".";
        String string2 = string + StringUtils.getExplicitConfigMaterialString(material);
        if (this.config.contains(string2)) {
            return this.config.getInt(string2);
        }
        String string3 = string + StringUtils.getFriendlyConfigMaterialString(material);
        if (this.config.contains(string3)) {
            return this.config.getInt(string3);
        }
        String string4 = string + StringUtils.getWildcardConfigMaterialString(material);
        if (this.config.contains(string4)) {
            return this.config.getInt(string4);
        }
        return 0;
    }

    public int getXp(PrimarySkillType primarySkillType, BlockData blockData) {
        String string = "Experience_Values." + StringUtils.getCapitalized(primarySkillType.toString()) + ".";
        String string2 = string + StringUtils.getExplicitConfigBlockDataString(blockData);
        if (this.config.contains(string2)) {
            return this.config.getInt(string2);
        }
        String string3 = string + StringUtils.getFriendlyConfigBlockDataString(blockData);
        if (this.config.contains(string3)) {
            return this.config.getInt(string3);
        }
        String string4 = string + StringUtils.getWildcardConfigBlockDataString(blockData);
        if (this.config.contains(string4)) {
            return this.config.getInt(string4);
        }
        return 0;
    }

    public boolean doesBlockGiveSkillXP(PrimarySkillType primarySkillType, Material material) {
        String string = "Experience_Values." + StringUtils.getCapitalized(primarySkillType.toString()) + ".";
        String string2 = string + StringUtils.getExplicitConfigMaterialString(material);
        if (this.config.contains(string2)) {
            return true;
        }
        String string3 = string + StringUtils.getFriendlyConfigMaterialString(material);
        if (this.config.contains(string3)) {
            return true;
        }
        String string4 = string + StringUtils.getWildcardConfigMaterialString(material);
        return this.config.contains(string4);
    }

    public boolean doesBlockGiveSkillXP(PrimarySkillType primarySkillType, BlockData blockData) {
        String string = "Experience_Values." + StringUtils.getCapitalized(primarySkillType.toString()) + ".";
        String string2 = string + StringUtils.getExplicitConfigBlockDataString(blockData);
        if (this.config.contains(string2)) {
            return true;
        }
        String string3 = string + StringUtils.getFriendlyConfigBlockDataString(blockData);
        if (this.config.contains(string3)) {
            return true;
        }
        String string4 = string + StringUtils.getWildcardConfigBlockDataString(blockData);
        return this.config.contains(string4);
    }

    public boolean isPartyExperienceBarsEnabled() {
        return this.config.getBoolean("Experience_Bars.Update.Party", true);
    }

    public boolean isPassiveGainsExperienceBarsEnabled() {
        return this.config.getBoolean("Experience_Bars.Update.Passive", true);
    }

    public boolean getDoExperienceBarsAlwaysUpdateTitle() {
        return this.config.getBoolean("Experience_Bars.ThisMayCauseLag.AlwaysUpdateTitlesWhenXPIsGained.Enable", false) || this.getAddExtraDetails();
    }

    public boolean getAddExtraDetails() {
        return this.config.getBoolean("Experience_Bars.ThisMayCauseLag.AlwaysUpdateTitlesWhenXPIsGained.ExtraDetails", false);
    }

    public boolean isExperienceBarsEnabled() {
        return this.config.getBoolean("Experience_Bars.Enable", true);
    }

    public boolean isExperienceBarEnabled(PrimarySkillType primarySkillType) {
        return this.config.getBoolean("Experience_Bars." + StringUtils.getCapitalized(primarySkillType.toString()) + ".Enable", true);
    }

    public BarColor getExperienceBarColor(PrimarySkillType primarySkillType) {
        String string = this.config.getString("Experience_Bars." + StringUtils.getCapitalized(primarySkillType.toString()) + ".Color");
        for (BarColor barColor : BarColor.values()) {
            if (!barColor.toString().equalsIgnoreCase(string)) continue;
            return barColor;
        }
        return BarColor.WHITE;
    }

    public BarStyle getExperienceBarStyle(PrimarySkillType primarySkillType) {
        String string = this.config.getString("Experience_Bars." + StringUtils.getCapitalized(primarySkillType.toString()) + ".BarStyle");
        for (BarStyle barStyle : BarStyle.values()) {
            if (!barStyle.toString().equalsIgnoreCase(string)) continue;
            return barStyle;
        }
        return BarStyle.SOLID;
    }

    public int getDodgeXPModifier() {
        return this.config.getInt("Experience_Values.Acrobatics.Dodge", 120);
    }

    public int getRollXPModifier() {
        return this.config.getInt("Experience_Values.Acrobatics.Roll", 80);
    }

    public int getFallXPModifier() {
        return this.config.getInt("Experience_Values.Acrobatics.Fall", 120);
    }

    public double getFeatherFallXPModifier() {
        return this.config.getDouble("Experience_Values.Acrobatics.FeatherFall_Multiplier", 2.0);
    }

    public double getPotionXP(PotionStage potionStage) {
        return this.config.getDouble("Experience_Values.Alchemy.Potion_Stage_" + potionStage.toNumerical(), 10.0);
    }

    public double getArcheryDistanceMultiplier() {
        return this.config.getDouble("Experience_Values.Archery.Distance_Multiplier", 0.025);
    }

    public int getFishingShakeXP() {
        return this.config.getInt("Experience_Values.Fishing.Shake", 50);
    }

    public double getRepairXPBase() {
        return this.config.getDouble("Experience_Values.Repair.Base", 1000.0);
    }

    public double getRepairXP(MaterialType materialType) {
        return this.config.getDouble("Experience_Values.Repair." + StringUtils.getCapitalized(materialType.toString()));
    }

    public int getTamingXP(EntityType entityType) {
        return this.config.getInt("Experience_Values.Taming.Animal_Taming." + StringUtils.getPrettyEntityTypeString(entityType));
    }

    public boolean preventStoneLavaFarming() {
        return this.config.getBoolean("ExploitFix.LavaStoneAndCobbleFarming", true);
    }
}

