/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.mcMMO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.World;

public class WorldBlacklist {
    private static ArrayList<String> blacklist;
    private mcMMO plugin;
    private final String blackListFileName = "world_blacklist.txt";

    public WorldBlacklist(mcMMO mcMMO2) {
        this.plugin = mcMMO2;
        blacklist = new ArrayList();
        this.init();
    }

    public void init() {
        File file = new File(this.plugin.getDataFolder() + File.separator + "world_blacklist.txt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.loadBlacklist(file);
    }

    private void loadBlacklist(File file) {
        try {
            String string;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0 || blacklist.contains(string)) continue;
                blacklist.add(string);
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.plugin.getLogger().info(blacklist.size() + " entries in mcMMO World Blacklist");
    }

    public static boolean isWorldBlacklisted(World world) {
        for (String string : blacklist) {
            if (!world.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

