/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.config.AutoUpdateConfigLoader;
import com.gmail.nossr50.util.sounds.SoundType;

public class SoundConfig
extends AutoUpdateConfigLoader {
    private static SoundConfig instance;

    public SoundConfig() {
        super("sounds.yml");
        this.validate();
        instance = this;
    }

    @Override
    protected void loadKeys() {
    }

    public static SoundConfig getInstance() {
        if (instance == null) {
            return new SoundConfig();
        }
        return instance;
    }

    @Override
    protected boolean validateKeys() {
        for (SoundType soundType : SoundType.values()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.config.getDouble(stringBuilder.append("Sounds.").append(soundType.toString()).append(".Volume").toString()) < 0.0) {
                plugin.getLogger().info("[mcMMO] Sound volume cannot be below 0 for " + soundType.toString());
                return false;
            }
            if (soundType.usesCustomPitch()) continue;
            StringBuilder stringBuilder2 = new StringBuilder();
            if (!(this.config.getDouble(stringBuilder2.append("Sounds.").append(soundType.toString()).append(".Pitch").toString()) < 0.0)) continue;
            plugin.getLogger().info("[mcMMO] Sound pitch cannot be below 0 for " + soundType.toString());
            return false;
        }
        return true;
    }

    public float getMasterVolume() {
        return (float)this.config.getDouble("Sounds.MasterVolume", 1.0);
    }

    public float getVolume(SoundType soundType) {
        String string = "Sounds." + soundType.toString() + ".Volume";
        return (float)this.config.getDouble(string);
    }

    public float getPitch(SoundType soundType) {
        String string = "Sounds." + soundType.toString() + ".Pitch";
        return (float)this.config.getDouble(string);
    }

    public boolean getIsEnabled(SoundType soundType) {
        String string = "Sounds." + soundType.toString() + ".Enabled";
        return this.config.getBoolean(string, true);
    }
}

